/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.guidance;

import java.util.HashMap;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceProcessInterface;

public class SJcGuidanceHandle
implements SJcGuidanceHandleInterface {
    private SJcGuidanceProcessInterface system;
    private String venderID;
    private String langType;
    private HashMap guidanceList = null;
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger();

    @Override
    public void initialize(String venderID, String langType, SJcGuidanceProcessInterface system) {
        this.stdLogger.trace("Guidance", "SJcGuidanceHandle", "initialize", "start");
        this.system = system;
        this.venderID = venderID;
        this.langType = langType;
        this.guidanceList = system.getGuidanceList(venderID, langType);
        this.stdLogger.trace("Guidance", "SJcGuidanceHandle", "initialize", "end");
    }

    @Override
    public synchronized String getGuidance(String screenID, String partsID) {
        this.stdLogger.trace("Guidance", "SJcGuidanceHandle", "getGuidance", "start");
        String result = null;
        try {
            result = (String)this.guidanceList.get(screenID + "/" + partsID);
        }
        catch (ClassCastException e) {
            this.stdLogger.error("Guidance", "SJcGuidanceHandle", "getGuidance", "catchClassCastException");
        }
        if (result == null) {
            this.stdLogger.error("Guidance", "SJcGuidanceHandle", "getGuidance", "Not Found. - Key:" + screenID + "/" + partsID);
            result = "N/A";
        }
        this.stdLogger.trace("Guidance", "SJcGuidanceHandle", "getGuidance", "end");
        return result;
    }

    @Override
    public String getGuidance(String partsID) {
        this.stdLogger.trace("Guidance", "SJcGuidanceHandle", "getGuidanceList(common)", "start");
        String result = this.getGuidance("COMMON", partsID);
        this.stdLogger.trace("Guidance", "SJcGuidanceHandle", "getGuidanceList(common)", "end");
        return result;
    }

    @Override
    public HashMap getGuidanceList() {
        this.stdLogger.trace("Guidance", "SJcGuidanceHandle", "getGuidanceList", "start");
        this.stdLogger.trace("Guidance", "SJcGuidanceHandle", "getGuidanceList", "end");
        return this.guidanceList;
    }
}

