/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.flexbridge;

import flex.messaging.FlexContext;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import sanproject.sn2.base.session.SJbaseLoginEntry;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.exception.SJbaseSessionNotFoundException;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.SJcWordUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRequestDataObject;
import sanproject.sn2.flexbridge.SJflbException;
import sanproject.sn2.flexbridge.SJflbThread;

public class SJflbFlexBridge {
    public static String BRIDGE_ID = "MNG_BRIDGE_ID";
    private static String GLOBAL_ID = "SNB_GLOBAL_SESSION_ID";
    public static String SESSION_KIND = "SNB_SESSION_KIND";
    private static String POSEBASE_ID = "MNG_POSTBASE_ID";
    private static String POSTBASE_VALUE = "MNG_POSTBASE_VALUE";
    private static String MNG_BRIDGE_END_FLAG = "MNG_BRIDGE_END_FLAG";
    private static final String ERROR_STR = "ERROR";
    private static final String WARN_STR = "WARN";
    private static final String INFO_STR = "INFO";
    private static final String DEBUG_STR = "DEBUG";
    private static final String TRACE_STR = "TRACE";
    public static final int SNB_ALIVE = 0;
    public static final int SNB_START_INFO_4_CLIENT = 1;
    public static final int SNB_SET_USER_PROPERTY = 2;
    public static final int SNB_GET_USER_PROPERTY = 3;
    public static final int SNB_IS_ALLOW_RESOURCE = 4;
    public static final int SNB_GET_RESOURCE = 5;
    public static final int SNB_IS_WRITE_PERMISSION = 6;
    public static final int SNB_IS_READ_PERMISSION = 7;
    public static final int SNB_GET_ROLE_INFO = 8;
    public static final int SNB_GET_LANGAGE_TYPE = 9;
    public static final int SNB_GET_SESSION_ID = 10;
    public static final int SNB_GET_USER_ID = 11;
    public static final int SNB_GET_GROUP_ID = 12;
    public static final int SNB_GET_GUIDANCEMESSAGE = 13;
    public static final int SNB_GET_SYSTEM_PROPERTY = 14;
    private static final int THREAD_CHECK_TIME = 240000;
    private static final int THREAD_CHECK_INTERVAL = 5;
    private final SJcLoggerInterface FB_LOGGER = SJcLogUty.getLogger("SN_FlexBridge.log");

    public SJflbFlexBridge() {
        this.FB_LOGGER.debug("FlexBridge", "Create", "", "");
    }

    protected void finalize() throws Throwable {
        this.FB_LOGGER.debug("FlexBridge", "Destroy", "", "");
    }

    public SJctrRequestDataObject login(String sUser, String sPass, String langType, String loginType) throws SJcException {
        SJctrRequestDataObject result = null;
        try {
            this.FB_LOGGER.info("FlexBridge", "Login", "START", "UserName:" + sUser + " langType :" + langType);
            HttpServletRequest httpRequest = FlexContext.getHttpRequest();
            SJbaseUserSessionManager manager = this.getSessionManager();
            SJbaseLoginEntry loginEntry = new SJbaseLoginEntry();
            loginEntry.setHttpRequest(httpRequest);
            loginEntry.setLang(langType);
            loginEntry.setUserid(sUser);
            loginEntry.setPassword(sPass);
            loginEntry.setLoginType(loginType);
            SJbaseUserSessionInterface mUserSession = manager.login(loginEntry);
            this.setUserSession(mUserSession.getSessionID(), mUserSession);
            result = mUserSession.getStartInfo4Client();
            this.FB_LOGGER.info("FlexBridge", "Login", "SUCCESS_END", "UserName:" + sUser + " SessionID :" + mUserSession.getSessionID());
        }
        catch (SJcException ex) {
            this.FB_LOGGER.debug("FlexBridge", "Login", "MSG_END", "UserName:" + sUser);
            SJcException exR = ex;
            throw exR;
        }
        catch (Exception ex) {
            this.FB_LOGGER.info("FlexBridge", "Login", "FAILURE_END", "UserName:" + sUser, ex);
            SJflbException exR = new SJflbException();
            throw exR;
        }
        return result;
    }

    public void logoutSn(String globalID) {
        try {
            this.FB_LOGGER.info("FlexBridge", "Logout", "START", "SessionID :" + globalID);
            SJbaseUserSessionInterface mUserSession = this.getUserSession(globalID);
            mUserSession.logout();
            this.FB_LOGGER.info("FlexBridge", "Logout", "SUCCESS_END", "SessionID :" + globalID);
        }
        catch (SJcException e) {
            this.FB_LOGGER.debug("FlexBridge", "Logout", "MSG_END", "SessionID :" + globalID, e);
        }
        catch (Exception ex) {
            this.FB_LOGGER.info("FlexBridge", "Logout", "FAILURE_END", "SessionID :" + globalID, ex);
        }
    }

    public void putlog(String globalID, String log, String level) {
        try {
            int nLevel = 0;
            if (DEBUG_STR.equals(level)) {
                nLevel = 10000;
            } else if (ERROR_STR.equals(level)) {
                nLevel = 40000;
            } else if (INFO_STR.equals(level)) {
                nLevel = 20000;
            } else if (TRACE_STR.equals(level)) {
                nLevel = 5000;
            } else if (WARN_STR.equals(level)) {
                nLevel = 30000;
            }
            SJbaseUserSessionInterface mUserSession = this.getUserSession(globalID);
            mUserSession.putLog4Client(log, nLevel);
        }
        catch (SJcException e) {
            this.FB_LOGGER.info("FlexBridge", "putlog", "MSG_END", "SessionID :" + globalID + " NoSesLog :" + log);
        }
        catch (Exception ex) {
            this.FB_LOGGER.info("FlexBridge", "putlog", "FAILURE_END", "SessionID :" + globalID, ex);
        }
    }

    public SJctrRequestDataObject post(SJctrRequestDataObject dataObj) throws SJcException, InterruptedException {
        long startTime = System.currentTimeMillis();
        Boolean endCheck = false;
        SJctrRequestDataObject ret = new SJctrRequestDataObject();
        String o = null;
        o = (String)dataObj.getData(BRIDGE_ID);
        try {
            SJflbThread thread;
            this.FB_LOGGER.info("FlexBridge", "post", "START", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
            o = (String)dataObj.getData(BRIDGE_ID);
            String sessionID = (String)dataObj.getData(GLOBAL_ID);
            SJbaseUserSessionInterface mUserSession = this.getUserSession(sessionID);
            Map<String, SJflbThread> threadMap = this.getThreadMap(sessionID);
            if (threadMap == null) {
                this.FB_LOGGER.info("FlexBridge", "post", "MAP", "new threadMap dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                threadMap = new HashMap<String, SJflbThread>();
                this.setThreadMap(sessionID, threadMap);
            }
            if (threadMap.containsKey(o)) {
                this.FB_LOGGER.info("FlexBridge", "post", "THREAD", "get thread dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                thread = threadMap.get(o);
            } else {
                this.FB_LOGGER.info("FlexBridge", "post", "THREAD", "new thread dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                thread = new SJflbThread(mUserSession, dataObj);
                thread.start();
                threadMap.put(o, thread);
            }
            do {
                if ((endCheck = thread.endCheck()).booleanValue()) {
                    this.FB_LOGGER.info("FlexBridge", "post", "THREAD", "thread end check true dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                    ret = thread.getResult();
                    threadMap.remove(o);
                    break;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    this.FB_LOGGER.info("FlexBridge", "post", "SLEEP", "Wait interrupted.");
                }
            } while (System.currentTimeMillis() - startTime < 240000L);
            ret.setData(BRIDGE_ID, (Object)o);
            ret.setData(MNG_BRIDGE_END_FLAG, (Object)endCheck);
            this.FB_LOGGER.info("FlexBridge", "post", "SUCCESS_END", "ret :" + ret.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID) + " Thread end :" + endCheck);
        }
        catch (SJcException ex) {
            SJcException exR = ex;
            this.FB_LOGGER.debug("FlexBridge", "post", "MSG_END", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
            exR.setBridgeID(o);
            throw exR;
        }
        catch (Exception ex) {
            this.FB_LOGGER.info("FlexBridge", "post", "FAILURE_END", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID), ex);
            SJflbException exR = new SJflbException();
            exR.setBridgeID(o);
            throw exR;
        }
        this.setLastResponse((String)dataObj.getData(GLOBAL_ID), (SJctrDataObject)ret);
        return ret;
    }

    public SJctrDataObject postBaseBeforeLogin(SJctrDataObject dataObj) throws SJcException, InterruptedException {
        SJctrDataObject ret = new SJctrDataObject();
        this.FB_LOGGER.info("FlexBridge", "postBase", "START", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
        String o = (String)dataObj.getData(BRIDGE_ID);
        String loc = (String)dataObj.getData(POSTBASE_VALUE);
        ret.setData(BRIDGE_ID, o);
        try {
            String sessionID = (String)dataObj.getData(GLOBAL_ID);
            int key = (Integer)dataObj.getData(POSEBASE_ID);
            ret.setData(BRIDGE_ID, o);
            switch (key) {
                case 13: {
                    SJcGuidanceHandleInterface hGuid = SJcWordUty.getGuidanceInfo(loc);
                    SJcMessageHandleInterface hMsg = SJcWordUty.getMessageInfo(loc);
                    HashMap gd = hGuid.getGuidanceList();
                    HashMap ms = hMsg.getMessageList();
                    HashMap el = hMsg.getBehaviorList();
                    HashMap at = hMsg.getIconIDList();
                    HashMap ac = hMsg.getMeasuresMessageList();
                    SJctrDataObject target = new SJctrDataObject();
                    target.setData("GUIDANCE", gd);
                    target.setData("MESSAGE", ms);
                    target.setData("ERRORLEVEL", el);
                    target.setData("ATTRIBUTE", at);
                    target.setData("ACTION", ac);
                    ret.setData("COM_TARGET", target);
                    this.FB_LOGGER.info("FlexBridge", "SNB_GET_GUIDANCEMESSAGE", "CALL", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                    break;
                }
                default: {
                    this.FB_LOGGER.info("FlexBridge", "UNKNOWNPOST", "CALL", "key:" + key + " dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                }
            }
            this.FB_LOGGER.info("FlexBridge", "postBase", "SUCCESS_END", "ret :" + ret.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
        }
        catch (SJcException ex) {
            SJcException exR = ex;
            exR.setBridgeID(o);
            throw exR;
        }
        catch (Exception ex) {
            this.FB_LOGGER.info("FlexBridge", "postBase", "FAILURE_END", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID), ex);
            SJflbException exR = new SJflbException();
            exR.setBridgeID(o);
            throw exR;
        }
        return ret;
    }

    public SJctrDataObject postBase(SJctrDataObject dataObj) throws SJcException, InterruptedException {
        SJctrDataObject ret = new SJctrDataObject();
        this.FB_LOGGER.info("FlexBridge", "postBase", "START", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
        String o = (String)dataObj.getData(BRIDGE_ID);
        ret.setData(BRIDGE_ID, o);
        try {
            String sessionID = (String)dataObj.getData(GLOBAL_ID);
            SJbaseUserSessionInterface mUserSession = this.getUserSession(sessionID);
            int key = (Integer)dataObj.getData(POSEBASE_ID);
            ret.setData(BRIDGE_ID, o);
            switch (key) {
                case 0: {
                    this.FB_LOGGER.info("FlexBridge", "ALIVE", "RECEIVE", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                    mUserSession.alive();
                    break;
                }
                case 1: {
                    this.FB_LOGGER.info("FlexBridge", "START_INFO_4_CLIENT", "CALL", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                    ret = mUserSession.getStartInfo4Client();
                    break;
                }
                case 3: {
                    this.FB_LOGGER.info("FlexBridge", "GET_USER_PROPERTY", "CALL", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                    Object rtn = null;
                    ret.setData(POSTBASE_VALUE, rtn);
                    break;
                }
                case 14: {
                    this.FB_LOGGER.info("FlexBridge", "GET_SYSTEM_PROPERTY", "CALL", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                    SJctrDataObject datalist = (SJctrDataObject)dataObj.getData(POSTBASE_VALUE);
                    SJctrDataObject sysProp = new SJctrDataObject();
                    for (String sysKey : datalist.getDataMap().keySet()) {
                        String sysValue = SJcEnvUty.getProperty(sysKey, (String)datalist.getData(sysKey));
                        sysProp.setData(sysKey, sysValue);
                    }
                    ret.setData(POSTBASE_VALUE, sysProp);
                    break;
                }
                default: {
                    this.FB_LOGGER.info("FlexBridge", "UNKNOWNPOST", "CALL", "key:" + key + " dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
                }
            }
            this.FB_LOGGER.info("FlexBridge", "postBase", "SUCCESS_END", "ret :" + ret.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
        }
        catch (SJcException ex) {
            SJcException exR = ex;
            this.FB_LOGGER.debug("FlexBridge", "postBase", "MSG_END", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID));
            exR.setBridgeID(o);
            throw exR;
        }
        catch (Exception ex) {
            this.FB_LOGGER.info("FlexBridge", "postBase", "FAILURE_END", "dataObj:" + dataObj.getData(BRIDGE_ID) + " Session ID :" + dataObj.getData(GLOBAL_ID), ex);
            SJflbException exR = new SJflbException();
            exR.setBridgeID(o);
            throw exR;
        }
        return ret;
    }

    private SJbaseUserSessionInterface getUserSession(String globalID) throws SJcException {
        String sessionID = this.getUserSessionkey(globalID);
        HttpSession session = FlexContext.getHttpRequest().getSession(true);
        SJbaseUserSessionInterface userSession = (SJbaseUserSessionInterface)session.getAttribute(sessionID);
        if (userSession == null) {
            this.FB_LOGGER.info("FlexBridge", "getUserSession", "FAILURE", "Session ID :" + globalID);
            throw new SJbaseSessionNotFoundException();
        }
        return userSession;
    }

    private String getUserSessionkey(String globalID) {
        return this.getSessionManager().getUserSessionkey(globalID);
    }

    private SJbaseUserSessionManager getSessionManager() {
        return (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
    }

    private void setUserSession(String globalID, SJbaseUserSessionInterface userSession) {
        String sessionID = this.getUserSessionkey(globalID);
        HttpSession session = FlexContext.getHttpRequest().getSession(true);
        session.setAttribute(sessionID, (Object)userSession);
    }

    public SJctrRequestDataObject getResult(SJctrRequestDataObject dataObj) throws SJcException, InterruptedException {
        String bridgeID = (String)dataObj.getData(BRIDGE_ID);
        String globalID = (String)dataObj.getData(GLOBAL_ID);
        this.FB_LOGGER.info("FlexBridge", "getResult", "START", "BridgeID:" + bridgeID + " Session ID :" + globalID);
        SJctrDataObject response = this.getLastResponse(globalID, bridgeID);
        if (response == null) {
            SJcException e = new SJcException("201", "21", "107024");
            e.setBridgeID(bridgeID);
            throw e;
        }
        this.FB_LOGGER.info("FlexBridge", "getResult", "SUCCESS_END", "ret :" + response.getData(BRIDGE_ID) + " Session ID :" + globalID);
        return (SJctrRequestDataObject)response;
    }

    public SJctrDataObject getLastResponse(String globalID, String bridgeID) {
        HttpSession httpSession = FlexContext.getHttpRequest().getSession(false);
        if (httpSession == null) {
            this.FB_LOGGER.info("FlexBridge", "getLastResponse", "FAILURE", "BridgeID:" + bridgeID + " Session ID :" + globalID + " HttpSession is null.");
            return null;
        }
        SJctrDataObject response = (SJctrDataObject)httpSession.getAttribute(this.getSessionManager().getLastResponseKey(globalID));
        if (response == null) {
            this.FB_LOGGER.info("FlexBridge", "getLastResponse", "FAILURE", "BridgeID:" + bridgeID + " Session ID :" + globalID + " response is null.");
            return null;
        }
        String responseBridgeID = (String)response.getData(BRIDGE_ID);
        if (responseBridgeID == null || responseBridgeID.length() <= 0 || !responseBridgeID.equals(bridgeID)) {
            this.FB_LOGGER.info("FlexBridge", "getLastResponse", "FAILURE", "BridgeID:" + bridgeID + " Session ID :" + globalID + " BridgeID unmatch :" + responseBridgeID);
            return null;
        }
        return response;
    }

    public void setLastResponse(String globalID, SJctrDataObject response) {
        if (globalID == null || globalID.length() <= 0) {
            this.FB_LOGGER.info("FlexBridge", "setLastResponse", "FAILURE", "BridgeID:" + response.getData(BRIDGE_ID) + " Session ID :" + globalID + " Session ID is null.");
            return;
        }
        HttpSession httpSession = FlexContext.getHttpRequest().getSession(false);
        if (httpSession == null) {
            this.FB_LOGGER.info("FlexBridge", "setLastResponse", "FAILURE", "BridgeID:" + response.getData(BRIDGE_ID) + " Session ID :" + globalID + " HttpSession is null.");
            return;
        }
        httpSession.setAttribute(this.getSessionManager().getLastResponseKey(globalID), (Object)response);
    }

    private void setThreadMap(String globalID, Map<String, SJflbThread> threadMap) {
        HttpSession httpSession = FlexContext.getHttpRequest().getSession(false);
        if (httpSession == null) {
            this.FB_LOGGER.info("FlexBridge", "setThreadMap", "FAILURE", " Session ID :" + globalID + " HttpSession is null.");
            return;
        }
        httpSession.setAttribute(this.getSessionManager().getThreadMapKey(globalID), threadMap);
    }

    private Map<String, SJflbThread> getThreadMap(String globalID) {
        HttpSession httpSession = FlexContext.getHttpRequest().getSession(false);
        if (httpSession == null) {
            this.FB_LOGGER.info("FlexBridge", "getThreadMap", "FAILURE", " Session ID :" + globalID + " HttpSession is null.");
            return null;
        }
        return (Map)httpSession.getAttribute(this.getSessionManager().getThreadMapKey(globalID));
    }
}

