/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet;

import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.SJcSystemUty;

public class SJsvlDelUserSessionServlet
extends HttpServlet {
    private final String LOG_FUNCTION = "DelUserSession";
    private final String LOG_TITLE = ((Object)((Object)this)).getClass().getSimpleName();
    private final String ENCODE_UTF8 = "UTF-8";
    private final String KEY_GID = "GID";
    private final String LOGOUT_ALREADY = "Logout_Already";
    private final String LOGOUT_SUCCESS = "Logout_Success";
    private final String LOGOUT_FAILURE = "Logout_Failure";
    private SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doGet";
        this.STD_LOGGER.info("DelUserSession", this.LOG_TITLE, "doGet", "Start.");
        this.doPost(request, response);
        this.STD_LOGGER.info("DelUserSession", this.LOG_TITLE, "doGet", "End.");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doPost";
        this.STD_LOGGER.info("DelUserSession", this.LOG_TITLE, "doPost", "Start.");
        InetAddress ipAddress = InetAddress.getByName(request.getRemoteAddr());
        if (!SJcSystemUty.chkIP_Myself(ipAddress)) {
            response.sendError(403);
            return;
        }
        String logoutResult = null;
        request.setCharacterEncoding("UTF-8");
        String globalSessionId = request.getParameter("GID");
        if (globalSessionId == null) {
            this.STD_LOGGER.error("DelUserSession", this.LOG_TITLE, "doPost", "globalSessionId : " + globalSessionId);
            response.sendError(404);
            return;
        }
        SJbaseUserSessionManager sessionManager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getSingleton(SJbaseUserSessionManager.class);
        if (sessionManager == null) {
            logoutResult = "Logout_Failure";
        } else {
            SJbaseUserSessionInterface userSession = sessionManager.getUserSession(globalSessionId);
            if (userSession == null) {
                logoutResult = "Logout_Already";
            } else {
                try {
                    sessionManager.logout(globalSessionId);
                    logoutResult = "Logout_Success";
                }
                catch (SJcException e) {
                    this.STD_LOGGER.error("DelUserSession", this.LOG_TITLE, "doPost", "globalSessionId : " + globalSessionId, e);
                    logoutResult = "Logout_Failure";
                }
            }
        }
        response.setCharacterEncoding("UTF-8");
        response.getWriter().print(logoutResult);
        this.STD_LOGGER.info("DelUserSession", this.LOG_TITLE, "doPost", "End. -return : " + logoutResult);
    }
}

