/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.systemwakeup;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ListIterator;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import sanproject.sn2.base.SJbaseConst;
import sanproject.sn2.base.system.SJbaseStartupPluginItem;
import sanproject.sn2.base.system.SJbaseStartupPluginList;
import sanproject.sn2.base.system.inf.SJbasePluginInterface;
import sanproject.sn2.com.plugin.SJcPluginItem;
import sanproject.sn2.com.utility.Logger.inf.SJcCustomLoggerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.SJcSystemUty;
import sanproject.sn2.com.utility.tomcat.SJcTomcatOutputStream;

public class SJsvlWakeupServlet
extends HttpServlet
implements Servlet {
    private final String LOG_FUNCTION = "SystemStartup";
    private final String LOG_TITLE = ((Object)((Object)this)).getClass().getSimpleName();
    private final String FILENAME_STARTUP_FLG = "SNBase_Starting.dat";
    private final String FILENAME_RUNNING_FLG = "SNBase_Running.dat";
    static final long serialVersionUID = 1L;
    private SJbaseStartupPluginList startUpPluginList;
    private int lastStatus;
    private String pathStartupFlgFile = null;
    private String pathRunningFlgFile = null;
    private boolean loggerInitialized = false;
    private SJcLoggerInterface stdLogger;
    private static final String TOMCAT_LOG = "SN_Tomcat-stdout.log";

    public void init() throws ServletException {
        super.init();
        String LOG_SUBTITLE = "init";
        this.logInfo(this.LOG_TITLE, "init", "Start - InitMemory :" + SJcSystemUty.getInitMemory() + " MaxMemory :" + SJcSystemUty.getMaxMemory());
        this.resetEnvironment();
        this.checkLastStatus();
        this.createStartupFlgFile();
        System.setProperty("SN_LogPath", "");
        this.stdLogger = SJcLogUty.getLogger("SN_System.log");
        this.loggerInitialized = true;
        this.logInfo(this.LOG_TITLE, "init", "Log system is ready.");
        this.initializeTomcatLog();
        this.registStartupPlugins();
        this.startStartupPlugins();
        this.deleteStartupFlgFile();
        this.createRunningFlgFile();
        this.logInfo(this.LOG_TITLE, "init", "End.");
    }

    public void destroy() {
        String LOG_SUBTITLE = "destroy";
        this.logInfo(this.LOG_TITLE, "destroy", "Start. - InitMemory :" + SJcSystemUty.getInitMemory() + " MaxMemory :" + SJcSystemUty.getMaxMemory());
        this.finishStartupPlugins();
        this.loggerInitialized = false;
        this.deleteRunningFlgFile();
        if (this.isStartupFlgFileExists()) {
            this.deleteStartupFlgFile();
            this.logWarn(this.LOG_TITLE, "destroy", "StartupFile exists. deleted.");
        }
        this.logInfo(this.LOG_TITLE, "destroy", "End.");
        super.destroy();
    }

    private void checkLastStatus() {
        String LOG_SUBTITLE = "checkLastStatus";
        this.logInfo(this.LOG_TITLE, "checkLastStatus", "Start.");
        if (this.isStartupFlgFileExists() && this.isRunningFlgFileExists()) {
            this.logInfo(this.LOG_TITLE, "checkLastStatus", "Both StartupFile and RunningFile exist.");
            if (this.isStartupFileNewerThanRunningFile()) {
                this.logInfo(this.LOG_TITLE, "checkLastStatus", "StartupFile is newer than RunningFile.");
                this.lastStatus = 1;
            } else {
                this.logInfo(this.LOG_TITLE, "checkLastStatus", "RunningFile is newer than StartupFile");
                this.lastStatus = 2;
            }
        } else if (this.isStartupFlgFileExists()) {
            this.logInfo(this.LOG_TITLE, "checkLastStatus", "Only StartupFile exists.");
            this.lastStatus = 1;
        } else if (this.isRunningFlgFileExists()) {
            this.logInfo(this.LOG_TITLE, "checkLastStatus", "Only RunningFile exists.");
            this.lastStatus = 2;
        } else {
            this.logInfo(this.LOG_TITLE, "checkLastStatus", "Neither StartupFile nor RunningFile exist.");
            this.lastStatus = 0;
        }
        this.logInfo(this.LOG_TITLE, "checkLastStatus", "End. - lastStatus:" + this.lastStatus);
    }

    private void createStartupFlgFile() {
        String LOG_SUBTITLE = "createStartupFlgFile";
        this.logInfo(this.LOG_TITLE, "createStartupFlgFile", "Start.");
        if (!this.isStartupFlgFileExists()) {
            this.logInfo(this.LOG_TITLE, "createStartupFlgFile", "File does not exist. Create file.");
            this.createNewFile(this.getPathStartupFlgFile());
        } else {
            this.logWarn(this.LOG_TITLE, "createStartupFlgFile", "File already exists.");
        }
        this.logInfo(this.LOG_TITLE, "createStartupFlgFile", "End.");
    }

    private void deleteStartupFlgFile() {
        String LOG_SUBTITLE = "deleteStartupFlgFile";
        this.logTrace(this.LOG_TITLE, "deleteStartupFlgFile", "Start.");
        this.deleteFile(this.getPathStartupFlgFile());
        this.logTrace(this.LOG_TITLE, "deleteStartupFlgFile", "End.");
    }

    private void createRunningFlgFile() {
        String LOG_SUBTITLE = "createRunningFlgFile";
        this.logInfo(this.LOG_TITLE, "createRunningFlgFile", "Start.");
        if (!this.isRunningFlgFileExists()) {
            this.logInfo(this.LOG_TITLE, "createRunningFlgFile", "File does not exist. Create file.");
            this.createNewFile(this.getPathRunningFlgFile());
        } else {
            this.logWarn(this.LOG_TITLE, "createRunningFlgFile", "File already exists.");
        }
        this.logInfo(this.LOG_TITLE, "createRunningFlgFile", "End.");
    }

    private void deleteRunningFlgFile() {
        String LOG_SUBTITLE = "deleteRunningFlgFile";
        this.logTrace(this.LOG_TITLE, "deleteRunningFlgFile", "Start.");
        this.deleteFile(this.getPathRunningFlgFile());
        this.logTrace(this.LOG_TITLE, "deleteRunningFlgFile", "End.");
    }

    private void resetEnvironment() {
        String LOG_SUBTITLE = "resetEnvironment";
        this.logInfo(this.LOG_TITLE, "resetEnvironment", "Start.");
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String systemTmpPath = SJcFileUty.concatFolderPath(dataPath, SJbaseConst.SN_DIRECTORY_BASE_TMP_SYSTEM);
        String flagFilePath = SJcFileUty.setEndPathSeparator(SJcEnvUty.getProperty("SN_DataPath")) + "force_sn_service_reboot";
        File forceRebootFlagFile = new File(flagFilePath);
        this.pathStartupFlgFile = SJcFileUty.concatFolderPath(systemTmpPath, "SNBase_Starting.dat");
        this.pathRunningFlgFile = SJcFileUty.concatFolderPath(systemTmpPath, "SNBase_Running.dat");
        if (forceRebootFlagFile.exists()) {
            forceRebootFlagFile.delete();
            this.logInfo(this.LOG_TITLE, "resetEnvironment", "Force Reboot Flag delete complete!!");
        }
        this.logInfo(this.LOG_TITLE, "resetEnvironment", "End.");
    }

    private boolean registStartupPlugins() {
        String LOG_SUBTITLE = "registStartupPlugins";
        this.logInfo(this.LOG_TITLE, "registStartupPlugins", "Start.");
        boolean ret = false;
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String systemPath = SJcFileUty.concatFolderPath(dataPath, SJbaseConst.SN_DIRECTORY_BASE_SETTING_SYSTEM);
        String filePath = SJcFileUty.concatFolderPath(systemPath, "StartupPluginList.properties");
        this.startUpPluginList = new SJbaseStartupPluginList();
        ret = this.startUpPluginList.loadFile(filePath);
        this.logInfo(this.LOG_TITLE, "registStartupPlugins", "End. - return:" + ret);
        return ret;
    }

    private boolean startStartupPlugins() {
        String LOG_SUBTITLE = "startStartupPlugins";
        this.logInfo(this.LOG_TITLE, "startStartupPlugins", "Start.");
        boolean ret = false;
        ListIterator<SJcPluginItem> iterator = this.startUpPluginList.getPluginList().listIterator();
        while (iterator.hasNext()) {
            SJbaseStartupPluginItem item = null;
            try {
                item = (SJbaseStartupPluginItem)iterator.next();
            }
            catch (ClassCastException cce) {
                this.logError(this.LOG_TITLE, "startStartupPlugins", "Item class is invald.");
                cce.printStackTrace();
                continue;
            }
            Class<?> clazz = null;
            String className = item.getClassName();
            if (null == className) {
                this.logError(this.LOG_TITLE, "startStartupPlugins", "Class name is invald.");
                continue;
            }
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                this.logError(this.LOG_TITLE, "startStartupPlugins", "Plugin class is not found. - class:" + className);
                cnfe.printStackTrace();
                continue;
            }
            SJbasePluginInterface plugin = null;
            try {
                plugin = (SJbasePluginInterface)SJcSingletonManagerUty.getInstance(clazz);
            }
            catch (ClassCastException cce) {
                this.logError(this.LOG_TITLE, "startStartupPlugins", "Plugin class is invalid. - class:" + clazz);
                cce.printStackTrace();
                continue;
            }
            this.logTrace(this.LOG_TITLE, "startStartupPlugins", "Plugin created. - class:" + clazz);
            item.setInstance(plugin);
            item.getInstance().initialize(this.lastStatus);
            this.logTrace(this.LOG_TITLE, "startStartupPlugins", "Plugin initialize published.");
        }
        ret = true;
        this.logInfo(this.LOG_TITLE, "startStartupPlugins", "End. - return:" + ret);
        return ret;
    }

    private boolean finishStartupPlugins() {
        String LOG_SUBTITLE = "finishSystems";
        this.logInfo(this.LOG_TITLE, "finishSystems", "Start.");
        boolean ret = false;
        ListIterator<SJcPluginItem> iterator = this.startUpPluginList.getPluginList().listIterator(this.startUpPluginList.getPluginList().size());
        while (iterator.hasPrevious()) {
            SJbaseStartupPluginItem item = null;
            try {
                item = (SJbaseStartupPluginItem)iterator.previous();
            }
            catch (ClassCastException cce) {
                this.logError(this.LOG_TITLE, "finishSystems", "Item class is invald.");
                cce.printStackTrace();
                continue;
            }
            SJbasePluginInterface plugin = item.getInstance();
            if (null == plugin) continue;
            plugin.finish();
            this.logTrace(this.LOG_TITLE, "finishSystems", "Plugin finish published.");
        }
        ret = true;
        this.logInfo(this.LOG_TITLE, "finishSystems", "End. - return:" + ret);
        return ret;
    }

    private boolean isStartupFlgFileExists() {
        boolean ret = this.isFileExists(this.pathStartupFlgFile);
        return ret;
    }

    private boolean isRunningFlgFileExists() {
        boolean ret = this.isFileExists(this.pathRunningFlgFile);
        return ret;
    }

    private boolean isStartupFileNewerThanRunningFile() {
        boolean ret = false;
        if (this.isStartupFlgFileExists() && this.isRunningFlgFileExists()) {
            File fileStartup = new File(this.pathStartupFlgFile);
            File fileRunning = new File(this.pathRunningFlgFile);
            if (fileStartup.lastModified() > fileRunning.lastModified()) {
                ret = true;
            }
        }
        return ret;
    }

    private String getPathStartupFlgFile() {
        if (null == this.pathStartupFlgFile) {
            // empty if block
        }
        return this.pathStartupFlgFile;
    }

    private String getPathRunningFlgFile() {
        if (null == this.pathRunningFlgFile) {
            // empty if block
        }
        return this.pathRunningFlgFile;
    }

    private boolean isFileExists(String path) {
        File f = new File(path);
        boolean ret = f.exists();
        return ret;
    }

    private boolean createNewFile(String path) {
        boolean ret = true;
        File f = new File(path);
        try {
            if (!this.isFileExists(f.getParent())) {
                File dir = new File(f.getParent());
                ret = dir.mkdirs();
            }
            if (ret) {
                ret = f.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private boolean deleteFile(String path) {
        boolean ret = true;
        if (this.isFileExists(path)) {
            File f = new File(path);
            ret = f.delete();
        }
        return ret;
    }

    public void logTrace(String title, String subtitle, String detail) {
        if (this.loggerInitialized) {
            this.stdLogger.trace("SystemStartup", title, subtitle, detail);
        } else {
            System.out.println("[TRACE][SystemStartup][" + title + "][" + subtitle + "][" + detail + "]");
        }
    }

    public void logDebug(String title, String subtitle, String detail) {
        if (this.loggerInitialized) {
            this.stdLogger.debug("SystemStartup", title, subtitle, detail);
        } else {
            System.out.println("[DEBUG][SystemStartup][" + title + "][" + subtitle + "][" + detail + "]");
        }
    }

    public void logInfo(String title, String subtitle, String detail) {
        if (this.loggerInitialized) {
            this.stdLogger.info("SystemStartup", title, subtitle, detail);
        } else {
            System.out.println("[INFO][SystemStartup][" + title + "][" + subtitle + "][" + detail + "]");
        }
    }

    public void logWarn(String title, String subtitle, String detail) {
        if (this.loggerInitialized) {
            this.stdLogger.warn("SystemStartup", title, subtitle, detail);
        } else {
            System.out.println("[WARN][SystemStartup][" + title + "][" + subtitle + "][" + detail + "]");
        }
    }

    public void logError(String title, String subtitle, String detail) {
        if (this.loggerInitialized) {
            this.stdLogger.error("SystemStartup", title, subtitle, detail);
        } else {
            System.out.println("[ERROR][SystemStartup][" + title + "][" + subtitle + "][" + detail + "]");
        }
    }

    private void initializeTomcatLog() {
        SJcCustomLoggerInterface loggerTomcat = SJcLogUty.getLogger(TOMCAT_LOG);
        SJcTomcatOutputStream os = new SJcTomcatOutputStream(loggerTomcat);
        PrintStream ps = new PrintStream(os);
        System.setOut(ps);
        System.setErr(ps);
    }
}

