/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.webapi;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import sanproject.session.client.exception.SJsessionAuthenticationException;
import sanproject.sn2.base.authentication.def.SJbaseHcsAuthorizationType;
import sanproject.sn2.base.session.SJbaseLoginEntry;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.exception.SJbaseSessionInitRequestSystemException;
import sanproject.sn2.base.session.exception.SJbaseSessionMemoryOverException;
import sanproject.sn2.base.session.exception.SJbaseSessionNumOverException;
import sanproject.sn2.base.session.exception.SJbaseSessionTomcatNumOverException;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.generated.svp.APIInfo;
import sanproject.sn2.generated.svp.EchoCommand;
import sanproject.sn2.generated.svp.Login;
import sanproject.sn2.generated.svp.ObjectFactory;
import sanproject.sn2.generated.svp.RAIDSVPServerMessage;
import sanproject.sn2.generated.svp.Response;
import sanproject.sn2.generated.svp.ResultList;
import sanproject.sn2.servlet.webapi.SJsvlHCSBaseServlet;
import sanproject.sn2.servlet.webapi.SJsvlHCSServletUty;
import sanproject.sn2.servlet.webapi.def.SJsvlErrorCode;
import sanproject.sn2.servlet.webapi.def.SJsvlHcsCommandStatus;
import sanproject.sn2.servlet.webapi.exception.SJsvlWebApiException;

public class SJsvlLogin
extends SJsvlHCSBaseServlet {
    private static final long serialVersionUID = 0L;
    private static final String API_VERSION = "1.0";
    private static final String COMMAND_NAME = "Login";
    private static final String USER_INFO_KEY_USER = "user";
    private static final String USER_INFO_KEY_PASS = "pass";
    private static final int NOT_FOUND_DELIMITER_INDEX = -1;
    private static final String ENCODE = "UTF-8";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doPost";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "doPost", "Start.");
        try {
            response.setContentType("text/xml");
            this.login(request, response);
        }
        catch (SJsvlWebApiException wapiex) {
            SJsvlHCSServletUty.setErrorResponseBody(response, API_VERSION, COMMAND_NAME, wapiex);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "doPost", "End.");
    }

    private void login(HttpServletRequest request, HttpServletResponse response) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "login";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "login", "Start.");
        String user = null;
        String pass = null;
        try {
            Map<String, Object> userInfo = this.getUserInfo(request);
            user = (String)userInfo.get(USER_INFO_KEY_USER);
            pass = (String)userInfo.get(USER_INFO_KEY_PASS);
            SJbaseLoginEntry loginEntry = new SJbaseLoginEntry();
            loginEntry.setUserid(user);
            loginEntry.setPassword(pass);
            loginEntry.setLoginType("NOR");
            loginEntry.setLang("EN");
            loginEntry.setHttpRequest(request);
            SJbaseUserSessionManager sessionManager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getSingleton(SJbaseUserSessionManager.class);
            if (null == sessionManager) {
                STD_LOGGER.error("WebApi", this.LOG_TITLE, "login", SJsvlErrorCode.SESSION_MANAGER_NOTFOUND.name() + " - user:" + user);
                throw new SJsvlWebApiException(SJsvlErrorCode.SESSION_MANAGER_NOTFOUND);
            }
            SJbaseUserSessionInterface session = sessionManager.login(loginEntry);
            SJsvlHCSServletUty.setResponseBody(response, this.createResponseMessage(session.getSessionID(), SJsvlHcsCommandStatus.COMPLETED));
            STD_LOGGER.info("WebApi", this.LOG_TITLE, "login", "login succeed. -user:" + session.getUserName() + " -GlobalSessionID:" + session.getSessionID());
        }
        catch (SJsvlWebApiException waex) {
            throw waex;
        }
        catch (SJsessionAuthenticationException saex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "login", SJsvlErrorCode.LOGIN_ERROR.name() + " - user:" + user, saex);
            throw new SJsvlWebApiException(SJsvlErrorCode.LOGIN_ERROR);
        }
        catch (SJbaseSessionInitRequestSystemException ssirex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "login", SJsvlErrorCode.SYSTEM_NOT_READY.name() + " - user:" + user, ssirex);
            throw new SJsvlWebApiException(SJsvlErrorCode.SJSVL_OK, SJsvlHcsCommandStatus.NOT_READY, ssirex);
        }
        catch (SJbaseSessionNumOverException snex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "login", SJsvlErrorCode.SESSION_TOMCAT_NUM_OVER_LIMIT.name() + " - user:" + user, snex);
            throw new SJsvlWebApiException(SJsvlErrorCode.SJSVL_OK, SJsvlHcsCommandStatus.LOGIN_NUM_LIMIT_OVER, snex);
        }
        catch (SJbaseSessionTomcatNumOverException stnoex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "login", SJsvlErrorCode.SESSION_NUM_OVER_LIMIT.name() + " - user:" + user, stnoex);
            throw new SJsvlWebApiException(SJsvlErrorCode.SJSVL_OK, SJsvlHcsCommandStatus.LOGIN_NUM_LIMIT_OVER, stnoex);
        }
        catch (SJbaseSessionMemoryOverException smoex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "login", SJsvlErrorCode.OUT_OF_MEMORY_ERROR.name() + " - user:" + user, smoex);
            throw new SJsvlWebApiException(SJsvlErrorCode.SJSVL_OK, SJsvlHcsCommandStatus.OUT_OF_MEMORY, smoex);
        }
        catch (Exception ex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "login", SJsvlErrorCode.UNKNOWN_ERROR.name() + " - user:" + user, ex);
            throw new SJsvlWebApiException(SJsvlErrorCode.UNKNOWN_ERROR);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "login", "End.");
    }

    private Map<String, Object> getUserInfo(HttpServletRequest request) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "getUserInfo";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "getUserInfo", "Start.");
        HashMap<String, Object> result = null;
        try {
            result = new HashMap<String, Object>();
            String base64String = SJsvlHCSServletUty.getAuthorization(request, SJbaseHcsAuthorizationType.BASIC);
            if (null == base64String) {
                STD_LOGGER.error("WebApi", this.LOG_TITLE, "getUserInfo", SJsvlErrorCode.MSG_HDR_AUTHORIZATION_NOTFOUND.name());
                throw new SJsvlWebApiException(SJsvlErrorCode.MSG_HDR_AUTHORIZATION_NOTFOUND);
            }
            byte[] decodeArray = Base64.decodeBase64((byte[])base64String.getBytes(ENCODE));
            if (null == decodeArray) {
                STD_LOGGER.error("WebApi", this.LOG_TITLE, "getUserInfo", SJsvlErrorCode.MSG_HDR_AUTHORIZATION_DECODE_NULL.name());
                throw new SJsvlWebApiException(SJsvlErrorCode.MSG_HDR_AUTHORIZATION_DECODE_NULL);
            }
            String decodeString = new String(decodeArray, ENCODE);
            int delimiterIndex = decodeString.indexOf(":");
            if (delimiterIndex == -1) {
                STD_LOGGER.error("WebApi", this.LOG_TITLE, "getUserInfo", SJsvlErrorCode.MSG_HDR_AUTHORIZATION_FORMAT_INCORRECT_ERROR.name());
                throw new SJsvlWebApiException(SJsvlErrorCode.MSG_HDR_AUTHORIZATION_FORMAT_INCORRECT_ERROR);
            }
            String userID = decodeString.substring(0, delimiterIndex);
            String password = decodeString.substring(delimiterIndex + 1, decodeString.length());
            String userID_URLDecode = URLDecoder.decode(userID, ENCODE);
            String password_URLDecode = URLDecoder.decode(password, ENCODE);
            result.put(USER_INFO_KEY_USER, userID_URLDecode);
            result.put(USER_INFO_KEY_PASS, password_URLDecode);
        }
        catch (SJsvlWebApiException waex) {
            throw waex;
        }
        catch (Exception ex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "getUserInfo", SJsvlErrorCode.USER_INFO_GET_ERROR.name(), ex);
            throw new SJsvlWebApiException(SJsvlErrorCode.USER_INFO_GET_ERROR);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "getUserInfo", "End.");
        return result;
    }

    private RAIDSVPServerMessage createResponseMessage(String sessionId, SJsvlHcsCommandStatus commandResult) {
        String LOG_SUBTITLE = "createResponseMessage";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "createResponseMessage", "Start.");
        RAIDSVPServerMessage serverMessage = null;
        ObjectFactory factory = new ObjectFactory();
        serverMessage = factory.createRAIDSVPServerMessage();
        APIInfo apiinfo = factory.createAPIInfo();
        apiinfo.setVersion(API_VERSION);
        Response response = factory.createResponse();
        EchoCommand command = factory.createEchoCommand();
        command.setName(COMMAND_NAME);
        command.setStatus(commandResult.getStatus());
        command.setResult("");
        command.setResultsource("");
        command.setMessageid("");
        ResultList resultList = factory.createResultList();
        Login login = factory.createLogin();
        login.setSession(sessionId);
        resultList.setLogin(login);
        response.setEchoCommand(command);
        response.setResultList(resultList);
        serverMessage.setAPIInfo(apiinfo);
        serverMessage.setResponse(response);
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "createResponseMessage", "End.");
        return serverMessage;
    }
}

