/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.services.http;

import flex.management.BaseControl;
import flex.management.runtime.messaging.DestinationControl;
import flex.management.runtime.messaging.services.http.HTTPProxyDestinationControlMBean;
import flex.messaging.Destination;
import flex.messaging.services.http.HTTPProxyDestination;
import java.util.Date;

public class HTTPProxyDestinationControl
extends DestinationControl
implements HTTPProxyDestinationControlMBean {
    private static final String TYPE = "HTTPProxyDestination";
    private int invokeSOAPCount = 0;
    private Date lastInvokeSOAPTimestamp;
    private long invokeSOAPStart;
    private int invokeHTTPCount = 0;
    private Date lastInvokeHTTPTimestamp;
    private long invokeHTTPStart = this.invokeSOAPStart = System.currentTimeMillis();

    public HTTPProxyDestinationControl(HTTPProxyDestination destination, BaseControl parent) {
        super((Destination)destination, parent);
    }

    protected void onRegistrationComplete() {
        super.onRegistrationComplete();
        String name = this.getObjectName().getCanonicalName();
        String[] pollablePerInterval = new String[]{"InvokeHTTPCount", "InvokeSOAPCount"};
        String[] pollableGeneral = new String[]{"InvokeHTTPFrequency", "InvokeSOAPFrequency"};
        String[] destinationGeneral = new String[]{"LastInvokeHTTPTimestamp", "LastInvokeSOAPTimestamp"};
        this.getRegistrar().registerObjects(new int[]{151, 50}, name, pollablePerInterval);
        this.getRegistrar().registerObjects(151, name, pollableGeneral);
        this.getRegistrar().registerObjects(150, name, destinationGeneral);
    }

    @Override
    public Integer getInvokeSOAPCount() {
        return new Integer(this.invokeSOAPCount);
    }

    @Override
    public void resetInvokeSOAPCount() {
        this.invokeSOAPStart = System.currentTimeMillis();
        this.invokeSOAPCount = 0;
        this.lastInvokeSOAPTimestamp = null;
    }

    public void incrementInvokeSOAPCount() {
        ++this.invokeSOAPCount;
        this.lastInvokeSOAPTimestamp = new Date();
    }

    @Override
    public Date getLastInvokeSOAPTimestamp() {
        return this.lastInvokeSOAPTimestamp;
    }

    @Override
    public Double getInvokeSOAPFrequency() {
        if (this.invokeSOAPCount > 0) {
            double runtime = this.differenceInMinutes(this.invokeSOAPStart, System.currentTimeMillis());
            return new Double((double)this.invokeSOAPCount / runtime);
        }
        return new Double(0.0);
    }

    @Override
    public Integer getInvokeHTTPCount() {
        return new Integer(this.invokeHTTPCount);
    }

    @Override
    public void resetInvokeHTTPCount() {
        this.invokeHTTPStart = System.currentTimeMillis();
        this.invokeHTTPCount = 0;
        this.lastInvokeHTTPTimestamp = null;
    }

    public void incrementInvokeHTTPCount() {
        ++this.invokeHTTPCount;
        this.lastInvokeHTTPTimestamp = new Date();
    }

    @Override
    public Date getLastInvokeHTTPTimestamp() {
        return this.lastInvokeHTTPTimestamp;
    }

    @Override
    public Double getInvokeHTTPFrequency() {
        if (this.invokeHTTPCount > 0) {
            double runtime = this.differenceInMinutes(this.invokeHTTPStart, System.currentTimeMillis());
            return new Double((double)this.invokeHTTPCount / runtime);
        }
        return new Double(0.0);
    }

    public String getType() {
        return TYPE;
    }
}

