@ECHO OFF

REM  RAID600                               
REM  Log pickup batch file for FICON DATA MIGRATION TOOL
REM                 Copy right. 2008  Hitachi. Ltd. 
REM
REM History  :Version    :DATE        : Coder        : Patch No
REM RAID 600 
REM          :01-00      :2008.06.09  : T.Nagura     : -
REM
REM Document
REM  Log pickup for FICON DATA MIGRATION TOOL to specified directory.
REM  For Windows XP with SP1(a) ONLY.
REM

REM Step 1   Confirm target directory(drive letter of removable media).
REM Step 2   Input this batch file location and target directory to [Run..] of [Start] menu.
REM          example: C:\DKC200\MP\PC\FICON_Data_Migration_GetLog.bat G:\
REM Step 3   push [OK] button for Run dialog window.
REM

REM --------------------------------------------------------------------------


REM Global define
SET TARGETDIR=%1
SET USERLOG0=C:\DKC200\MP\PC\FICON_Data_Migration_usr.log
SET USERLOG1=C:\DKC200\MP\PC\FICON_Data_Migration_usr_01.log
SET USERLOG2=C:\DKC200\MP\PC\FICON_Data_Migration_usr_02.log
SET USERLOG3=C:\DKC200\MP\PC\FICON_Data_Migration_usr_03.log
SET USERLOG4=C:\DKC200\MP\PC\FICON_Data_Migration_usr_04.log
SET TRCLOG0=C:\DKC200\MP\PC\FICON_Data_Migration_dbg.log
SET TRCLOG1=C:\DKC200\MP\PC\FICON_Data_Migration_dbg_01.log
SET TRCLOG2=C:\DKC200\MP\PC\FICON_Data_Migration_dbg_02.log
SET TRCLOG3=C:\DKC200\MP\PC\FICON_Data_Migration_dbg_03.log
SET TRCLOG4=C:\DKC200\MP\PC\FICON_Data_Migration_dbg_04.log

REM Target directory parameter check
IF "%TARGETDIR%"=="" (GOTO NOEXISTDIR)

REM Target directory exist check
IF NOT EXIST %TARGETDIR% (GOTO NOEXISTDIR)

REM Drive letter D: check
ECHO %TARGETDIR% | FINDSTR /B /I "D:"
IF "%ERRORLEVEL%"=="0" goto NOPERMITDIR

REM User log copy
IF EXIST %USERLOG0% ( copy %USERLOG0% %TARGETDIR% ) else ( ECHO %USERLOG0% DOES NOT EXIST. )
IF EXIST %USERLOG1% ( copy %USERLOG1% %TARGETDIR% ) else ( ECHO %USERLOG1% DOES NOT EXIST. )
IF EXIST %USERLOG2% ( copy %USERLOG2% %TARGETDIR% ) else ( ECHO %USERLOG2% DOES NOT EXIST. )
IF EXIST %USERLOG3% ( copy %USERLOG3% %TARGETDIR% ) else ( ECHO %USERLOG3% DOES NOT EXIST. )
IF EXIST %USERLOG4% ( copy %USERLOG4% %TARGETDIR% ) else ( ECHO %USERLOG4% DOES NOT EXIST. )

REM Trace log copy
IF EXIST %TRCLOG0% ( copy %TRCLOG0% %TARGETDIR% ) else ( ECHO %TRCLOG0% DOES NOT EXIST. )
IF EXIST %TRCLOG1% ( copy %TRCLOG1% %TARGETDIR% ) else ( ECHO %TRCLOG1% DOES NOT EXIST. )
IF EXIST %TRCLOG2% ( copy %TRCLOG2% %TARGETDIR% ) else ( ECHO %TRCLOG2% DOES NOT EXIST. )
IF EXIST %TRCLOG3% ( copy %TRCLOG3% %TARGETDIR% ) else ( ECHO %TRCLOG3% DOES NOT EXIST. )
IF EXIST %TRCLOG4% ( copy %TRCLOG4% %TARGETDIR% ) else ( ECHO %TRCLOG4% DOES NOT EXIST. )

GOTO COMPLETE

REM No specified target drectory error
:NOEXISTDIR
ECHO ERROR:NO SPECIFIED TARGET DIRECTORY.
ECHO       PLEASE CONFIRM TARGET DIRECTORY(drive letter of removable media).
PAUSE
GOTO EXIT

REM No exist target drectory error
:NOEXISTDIR
ECHO ERROR:NO EXIST TARGET DIRECTORY.
ECHO       PLEASE CONFIRM TARGET DIRECTORY(drive letter of removable media).
PAUSE
GOTO EXIT

REM No permit directory error
:NOPERMITDIR
ECHO ERROR:SPECIFIED TARGET DIRECTORY IS NO PERMIT.
ECHO       PLEASE CONFIRM TARGET DIRECTORY(drive letter of removable media).
PAUSE
GOTO EXIT

REM complete
:COMPLETE
ECHO LOG FILE COPY WAS COMPLETE.
PAUSE
GOTO EXIT

:EXIT