<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:lxslt="http://xml.apache.org/xslt" xmlns:redirect="http://xml.apache.org/xalan/redirect" extension-element-prefixes="redirect">
	<xsl:param name="outputdir"/>
	<xsl:param name="pCompany"/>
	<xsl:output method="html" indent="no"/>
	<!-- apply templates to reach CLASS elements -->
	<xsl:template match="/|CIM|DECLARATION|DECLGROUP|VALUE.OBJECT">
		<html>
			<head>
				<link rel="stylesheet" type="text/css" href="mof.css"/>
				<title>CIM Schema</title>
			</head>
			<body bgcolor="White">
				<xsl:variable name="indexfile">
					<xsl:value-of select="$outputdir"/>//index.html</xsl:variable>
				<redirect:write file="{$indexfile}">
					<html>
						<frameset cols="32,68">
							<frameset rows="34,66">
								<frame name="schemaframe" src="schema.html" marginwidth="10" marginheight="10" scrolling="auto" frameborder="1"/>
								<frame name="allclassesframe" src="allclasses.html" scrolling="Auto" marginwidth="10" marginheight="10"/>
							</frameset>
							<frame name="classdetail" src="classdetail.html" marginwidth="10" marginheight="10" scrolling="auto" frameborder="1"/>
						</frameset>
					</html>
				</redirect:write>
				<xsl:variable name="allclassfile">
					<xsl:value-of select="$outputdir"/>//allclasses.html</xsl:variable>
				<redirect:write file="{$allclassfile}">
					<html>
						<head>
							<title>All Classes</title>
						</head>
						<body bgcolor="White">
							<H2>All Classes</H2>
							<BR/>
							<xsl:for-each select="CLASSES/CLASS">
								<xsl:sort select="@NAME"/>
								<a href="{@NAME}.html" target="classdetail">
									<xsl:value-of select="@NAME"/>
								</a>
								<BR/>
							</xsl:for-each>
							<H3>
								<A NAME="associations"/>Associations</H3>
							<BR/>
							<xsl:for-each select="CLASSES/CLASS[@ASSOCIATION]">
								<xsl:sort select="@NAME"/>
								<a href="{@NAME}.html" target="classdetail">
									<xsl:value-of select="@NAME"/>
								</a>
								<BR/>
							</xsl:for-each>
						</body>
					</html>
				</redirect:write>
				<xsl:variable name="classdetail">
					<xsl:value-of select="$outputdir"/>//classdetail.html</xsl:variable>
				<redirect:write file="{$classdetail}">
					<html>
						<head>
							<title>All Classes</title>
						</head>
						<body bgcolor="White">
							<H2><xsl:value-of select="$pCompany"/></H2>
							<h3>CIM Class Detail</h3>
						</body>
					</html>
				</redirect:write>
				<xsl:variable name="schemafile">
					<xsl:value-of select="$outputdir"/>//schema.html</xsl:variable>
				<redirect:write file="{$schemafile}">
					<html>
						<head>
							<title><xsl:value-of select="$pCompany"/></title>
						</head>
						<body bgcolor="White">
							<H1><xsl:value-of select="$pCompany"/></H1>
							<a href="allclasses.html" target="allclassesframe">All Classes</a>
							<BR/>
							<a href="allclasses.html#associations" target="allclassesframe">Association Classes</a>
						</body>
					</html>
				</redirect:write>
				<xsl:apply-templates/>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
