/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.AttributeRequest;
import ch.ethz.iks.slp.impl.AuthenticationBlock;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

class AttributeReply
extends ReplyMessage {
    List attributes;
    AuthenticationBlock[] authBlocks;

    AttributeReply(AttributeRequest req, List attList) {
        this.funcID = (byte)7;
        this.errorCode = 0;
        this.attributes = attList;
        this.locale = req.locale;
        this.xid = req.xid;
        this.address = req.address;
        this.port = req.port;
        this.authBlocks = new AuthenticationBlock[0];
    }

    AttributeReply(DataInputStream input) throws IOException, ServiceLocationException {
        this.errorCode = input.readShort();
        this.attributes = this.attributeStringToListLiberal(input.readUTF());
        this.authBlocks = AuthenticationBlock.parse(input);
        if (SLPCore.CONFIG.getSecurityEnabled() && !this.verify()) {
            throw new ServiceLocationException(7, "Authentication failed for " + this.toString());
        }
    }

    @Override
    protected void writeTo(DataOutputStream out) throws IOException {
        out.writeShort(this.errorCode);
        out.writeUTF(AttributeReply.listToString(this.attributes, ","));
        out.write(this.authBlocks.length);
        for (int i = 0; i < this.authBlocks.length; ++i) {
            this.authBlocks[i].write(out);
        }
    }

    @Override
    protected int getSize() {
        int len = this.getHeaderSize() + 4 + AttributeReply.listToString(this.attributes, ",").length() + 1;
        for (int i = 0; i < this.authBlocks.length; ++i) {
            len += this.authBlocks[i].getLength();
        }
        return len;
    }

    @Override
    List getResult() {
        return this.attributes;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(", errorCode " + this.errorCode);
        buffer.append(", attrCount " + this.attributes.size());
        buffer.append(", attributes " + this.attributes);
        return buffer.toString();
    }

    void sign(String spiStr) throws ServiceLocationException {
        List spiList = AttributeReply.stringToList(spiStr, ",");
        this.authBlocks = new AuthenticationBlock[spiList.size()];
        for (int k = 0; k < spiList.size(); ++k) {
            int timestamp = SLPUtils.getTimestamp();
            String spi = (String)spiList.get(k);
            byte[] data = this.getAuthData(spi, timestamp);
            this.authBlocks[k] = new AuthenticationBlock(2, spi, timestamp, data, null);
        }
    }

    boolean verify() throws ServiceLocationException {
        for (int i = 0; i < this.authBlocks.length; ++i) {
            if (!this.authBlocks[i].verify(this.getAuthData(this.authBlocks[i].getSPI(), this.authBlocks[i].getTimestamp()))) continue;
            return true;
        }
        return false;
    }

    private byte[] getAuthData(String spiStr, int timestamp) throws ServiceLocationException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(spiStr);
            dos.writeUTF(AttributeReply.listToString(this.attributes, ","));
            dos.writeInt(timestamp);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new ServiceLocationException(20, ioe.getMessage());
        }
    }
}

