/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.AttributeReply;
import ch.ethz.iks.slp.impl.AttributeRequest;
import ch.ethz.iks.slp.impl.DAAdvertisement;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPDaemon;
import ch.ethz.iks.slp.impl.SLPMessage;
import ch.ethz.iks.slp.impl.SLPUtils;
import ch.ethz.iks.slp.impl.Service;
import ch.ethz.iks.slp.impl.ServiceAcknowledgement;
import ch.ethz.iks.slp.impl.ServiceDeregistration;
import ch.ethz.iks.slp.impl.ServiceRegistration;
import ch.ethz.iks.slp.impl.ServiceReply;
import ch.ethz.iks.slp.impl.ServiceRequest;
import ch.ethz.iks.slp.impl.ServiceTypeReply;
import ch.ethz.iks.slp.impl.ServiceTypeRequest;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class SLPDaemonImpl
implements SLPDaemon {
    private final Map registeredServices = new HashMap();
    private final SortedMap serviceDisposalQueue = new TreeMap();
    private TcpServerThread tcpThread = new TcpServerThread();
    private ServiceDisposalThread disposalThread = new ServiceDisposalThread();
    private boolean running = true;

    public SLPDaemonImpl() throws Exception {
        SLPCore.platform.logDebug("jSLP daemon starting ...");
    }

    @Override
    public void shutdown() {
        this.running = false;
        if (null != this.tcpThread) {
            this.tcpThread.interrupt();
            try {
                this.tcpThread.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (null != this.disposalThread) {
            this.disposalThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(ServiceRegistration reg) {
        Service service = new Service(reg);
        for (String scope : reg.scopeList) {
            scope = scope.toLowerCase();
            Map map = this.registeredServices;
            synchronized (map) {
                SLPUtils.addValue(this.registeredServices, scope, service);
            }
            if (reg.url.getLifetime() > -1) {
                map = this.serviceDisposalQueue;
                synchronized (map) {
                    long next = System.currentTimeMillis() + (long)(reg.url.getLifetime() * 1000);
                    ArrayList keys = new ArrayList(this.serviceDisposalQueue.keySet());
                    for (Object key : keys) {
                        if (!this.serviceDisposalQueue.get(key).equals(reg.url)) continue;
                        this.serviceDisposalQueue.remove(key);
                    }
                    this.serviceDisposalQueue.put(new Long(next), reg.url);
                    this.serviceDisposalQueue.notifyAll();
                }
            }
            SLPCore.platform.logTraceReg("REGISTERED " + reg.url);
            List daList = (List)SLPCore.dAs.get(scope);
            if ((daList == null || daList.isEmpty()) && !SLPCore.noDiscovery) {
                try {
                    SLPCore.daLookup(Arrays.asList(scope));
                    Map next = SLPCore.dAs;
                    synchronized (next) {
                        try {
                            SLPCore.dAs.wait(SLPCore.CONFIG.getWaitTime());
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    daList = (List)SLPCore.dAs.get(scope);
                }
                catch (ServiceLocationException sle) {
                    SLPCore.platform.logError(sle.getMessage(), sle.fillInStackTrace());
                }
            }
            if (daList == null || daList.isEmpty()) continue;
            String[] dAs = daList.toArray(new String[daList.size()]);
            ServiceRegistration announcement = new ServiceRegistration(reg.url, reg.serviceType, reg.scopeList, reg.attList, reg.locale);
            announcement.authBlocks = reg.authBlocks;
            for (int i = 0; i < dAs.length; ++i) {
                try {
                    this.announceService(dAs[i], announcement);
                    SLPCore.platform.logTraceReg("ANNOUNCED " + announcement.url + " to " + dAs[i]);
                    continue;
                }
                catch (ServiceLocationException e) {
                    SLPUtils.removeValueFromAll(SLPCore.dAs, dAs[i]);
                    SLPCore.dASPIs.remove(dAs[i]);
                    SLPCore.platform.logError(e.getMessage(), e.fillInStackTrace());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterService(ServiceDeregistration dereg) throws ServiceLocationException {
        String[] scopes = this.registeredServices.keySet().toArray(new String[this.registeredServices.size()]);
        block5: for (int i = 0; i < scopes.length; ++i) {
            List tmp = (List)this.registeredServices.get(scopes[i]);
            Service[] services = tmp.toArray(new Service[tmp.size()]);
            for (int j = 0; j < services.length; ++j) {
                if (!dereg.url.matches(services[j].url)) continue;
                List daList = (List)SLPCore.dAs.get(scopes[i].toLowerCase());
                if (daList != null) {
                    Iterator daIter = daList.iterator();
                    while (daIter.hasNext()) {
                        try {
                            String dA = (String)daIter.next();
                            dereg.address = InetAddress.getByName(dA);
                            dereg.port = 427;
                            dereg.xid = SLPCore.nextXid();
                            if (SLPCore.CONFIG.getSecurityEnabled()) {
                                List spiList = (List)SLPCore.dASPIs.get(dA);
                                dereg.sign(spiList);
                            }
                            ReplyMessage reply = SLPCore.sendMessage(dereg, true);
                            if (reply.errorCode == 0) continue;
                            throw new ServiceLocationException((short)reply.errorCode, "Error during deregistration: " + reply.errorCode);
                        }
                        catch (UnknownHostException uhe) {
                            throw new ServiceLocationException(19, uhe.getMessage());
                        }
                    }
                }
                Map map = this.registeredServices;
                synchronized (map) {
                    SLPUtils.removeValue(this.registeredServices, scopes[i], services[j]);
                    continue block5;
                }
            }
        }
    }

    @Override
    public ReplyMessage handleMessage(SLPMessage msg) throws ServiceLocationException {
        if (msg == null) {
            return null;
        }
        String via = msg.tcp ? " (tcp)" : " (udp)";
        SLPCore.platform.logTraceMessage("RECEIVED (" + msg.address + ":" + msg.port + ") " + msg.toString() + via);
        ReplyMessage reply = null;
        switch (msg.funcID) {
            case 1: {
                ServiceRequest req = (ServiceRequest)msg;
                ArrayList<ServiceURL> results = new ArrayList<ServiceURL>();
                for (String scope : req.scopeList) {
                    List services = (List)this.registeredServices.get(scope.toLowerCase());
                    if (services == null) continue;
                    for (Service service : services) {
                        if (!service.url.getServiceType().matches(req.serviceType)) continue;
                        if (req.predicate == null) {
                            results.add(service.url);
                            continue;
                        }
                        if (!req.predicate.match(service.attributes)) continue;
                        results.add(service.url);
                    }
                }
                if (results.size() == 0 && req.multicast) {
                    return null;
                }
                reply = new ServiceReply(req, results);
                if (SLPCore.CONFIG.getSecurityEnabled()) {
                    ((ServiceReply)reply).sign(req.spi);
                }
                return reply;
            }
            case 6: {
                AttributeRequest attreq = (AttributeRequest)msg;
                ArrayList attResult = new ArrayList();
                for (String scope : attreq.scopeList) {
                    Serializable reqService;
                    List services = (List)this.registeredServices.get(scope.toLowerCase());
                    if (services == null) continue;
                    boolean fullurl = false;
                    if (attreq.url.indexOf("//") == -1) {
                        reqService = new ServiceType(attreq.url);
                    } else {
                        fullurl = true;
                        reqService = new ServiceURL(attreq.url, 0);
                    }
                    if (!attreq.spi.equals("") && (!fullurl || !attreq.tagList.isEmpty())) continue;
                    for (Service service : services) {
                        if (!service.url.matches(reqService)) continue;
                        attResult.addAll(SLPUtils.findMatches(attreq.tagList, service.attributes));
                    }
                }
                reply = new AttributeReply(attreq, attResult);
                if (SLPCore.CONFIG.getSecurityEnabled()) {
                    ((AttributeReply)reply).sign(attreq.spi);
                }
                return reply;
            }
            case 9: {
                ServiceTypeRequest streq = (ServiceTypeRequest)msg;
                ArrayList<ServiceType> result = new ArrayList<ServiceType>();
                for (String scope : streq.scopeList) {
                    List services = (List)this.registeredServices.get(scope.toLowerCase());
                    if (services == null) continue;
                    for (Service service : services) {
                        ServiceType type = service.url.getServiceType();
                        if (!streq.namingAuthority.equals("*") && !streq.namingAuthority.equals("") && !type.getNamingAuthority().equals(streq.namingAuthority) || result.contains(type)) continue;
                        result.add(type);
                    }
                }
                reply = new ServiceTypeReply(streq, result);
                return reply;
            }
            case 3: {
                this.registerService((ServiceRegistration)msg);
                reply = new ServiceAcknowledgement(msg, 0);
                return reply;
            }
            case 4: {
                this.deregisterService((ServiceDeregistration)msg);
                reply = new ServiceAcknowledgement(msg, 0);
                return reply;
            }
            case 5: {
                ReplyMessage rep = (ReplyMessage)msg;
                if (rep.errorCode != 0) {
                    SLPCore.platform.logWarning(msg.address + " replied with error code " + rep.errorCode + " (" + rep + ")");
                }
                return null;
            }
        }
        throw new ServiceLocationException(16, "The message type " + SLPMessage.getType(msg.funcID) + " is not implemented");
    }

    @Override
    public void newDaDiscovered(DAAdvertisement advert) {
        for (String scope : advert.scopeList) {
            List services = (List)this.registeredServices.get(scope.toLowerCase());
            if (services == null) continue;
            Iterator serviceIter = services.iterator();
            while (serviceIter.hasNext()) {
                try {
                    Service service = (Service)serviceIter.next();
                    ServiceRegistration reg = new ServiceRegistration(service.url, service.url.getServiceType(), Arrays.asList(scope), SLPUtils.dictToAttrList(service.attributes), SLPCore.DEFAULT_LOCALE);
                    SLPCore.platform.logDebug("Registering " + service.url + " with new DA " + advert.url);
                    this.announceService(advert.url, reg);
                }
                catch (ServiceLocationException e) {
                    SLPCore.platform.logError(e.getMessage(), e.fillInStackTrace());
                }
            }
        }
    }

    private void announceService(String dAAddress, ServiceRegistration reg) throws ServiceLocationException {
        try {
            reg.address = InetAddress.getByName(dAAddress);
            reg.port = 427;
            reg.xid = SLPCore.nextXid();
            if (SLPCore.CONFIG.getSecurityEnabled()) {
                List spiList = (List)SLPCore.dASPIs.get(dAAddress);
                reg.sign(spiList);
            }
            this.handleMessage(SLPCore.sendMessage(reg, true));
        }
        catch (UnknownHostException e) {
            SLPCore.platform.logError("Service announcement to " + dAAddress + " failed. ", e.fillInStackTrace());
        }
    }

    private boolean isRunning() {
        return this.running;
    }

    private final class ServiceDisposalThread
    extends Thread {
        private ServiceDisposalThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (SLPDaemonImpl.this.isRunning()) {
                    SortedMap sortedMap = SLPDaemonImpl.this.serviceDisposalQueue;
                    synchronized (sortedMap) {
                        if (SLPDaemonImpl.this.serviceDisposalQueue.isEmpty()) {
                            SLPCore.platform.logDebug("ServiceDisposalThread sleeping ...");
                            SLPDaemonImpl.this.serviceDisposalQueue.wait();
                        } else {
                            long waitTime;
                            Long nextActivity;
                            while (!SLPDaemonImpl.this.serviceDisposalQueue.isEmpty() && (nextActivity = (Long)SLPDaemonImpl.this.serviceDisposalQueue.firstKey()) <= System.currentTimeMillis()) {
                                ServiceURL service = (ServiceURL)SLPDaemonImpl.this.serviceDisposalQueue.get(nextActivity);
                                ServiceDeregistration dereg = new ServiceDeregistration(service, null, null, SLPCore.DEFAULT_LOCALE);
                                try {
                                    SLPDaemonImpl.this.deregisterService(dereg);
                                }
                                catch (ServiceLocationException sle) {
                                    SLPCore.platform.logError(sle.getMessage(), sle.fillInStackTrace());
                                }
                                SLPCore.platform.logTraceReg("disposed service " + service);
                                SLPDaemonImpl.this.serviceDisposalQueue.remove(nextActivity);
                            }
                            if (!SLPDaemonImpl.this.serviceDisposalQueue.isEmpty() && (waitTime = (nextActivity = (Long)SLPDaemonImpl.this.serviceDisposalQueue.firstKey()) - System.currentTimeMillis()) > 0L) {
                                SLPCore.platform.logDebug("sleeping for " + waitTime / 1000L + " seconds.");
                                SLPDaemonImpl.this.serviceDisposalQueue.wait(waitTime);
                            }
                        }
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private final class TcpServerThread
    extends Thread {
        private final ServerSocket socket = new ServerSocket(SLPCore.SLP_PORT, -1, SLPCore.getMyIP());

        private TcpServerThread() throws IOException {
            this.start();
        }

        @Override
        public void run() {
            while (SLPDaemonImpl.this.isRunning()) {
                try {
                    Socket con = this.socket.accept();
                    DataInputStream in = new DataInputStream(new BufferedInputStream(con.getInputStream()));
                    SLPMessage msg = SLPMessage.parse(con.getInetAddress(), con.getPort(), in, true);
                    ReplyMessage reply = SLPDaemonImpl.this.handleMessage(msg);
                    if (reply != null) {
                        SLPCore.platform.logTraceMessage("SEND REPLY (" + reply.address + ":" + reply.port + ") " + reply);
                        DataOutputStream out = new DataOutputStream(con.getOutputStream());
                        out.write(reply.getBytes());
                        out.close();
                    }
                    in.close();
                    con.close();
                }
                catch (Exception ioe) {
                    SLPCore.platform.logError("Exception in TCP receiver thread", ioe);
                }
            }
        }
    }
}

