/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.logging.FailSafeLog;
import com.ws.utilities.WSIStandardMessages;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.AuthService;
import com.ws.wbem.jserver.CIMRepository;
import com.ws.wbem.jserver.DaemonThreadFactory;
import com.ws.wbem.jserver.JServerEventService;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerRepositoryAdapterFactory;
import com.ws.wbem.jserver.JServerSecurityAdapterFactory;
import com.ws.wbem.jserver.JServerServices;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.JServerTrace;
import com.ws.wbem.jserver.OperationIteratorType;
import com.ws.wbem.jserver.ProtocolParsers;
import com.ws.wbem.jserver.ProviderAdapterFactory;
import com.ws.wbem.jserver.ProviderClient;
import com.ws.wbem.jserver.PullOperations;
import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.jserver.WBEMServerAuthentication;
import com.ws.wbem.jserver.embed.RequestHandler;
import com.ws.wbem.jserver.utils.WBEMExecutor;
import com.ws.wbem.query.WBEMQuery;
import com.ws.wbem.query.WBEMQueryLanguageFactory;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMObjectPath;
import javax.cim.CIMParameter;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.EnumerateResponse;
import javax.wbem.provider.IndicationProvider;
import javax.wbem.provider.Provider;
import javax.wbem.provider.PullAssociatorProvider;
import javax.wbem.provider.PullInstanceProvider;

class JServer
implements WBEMServer {
    private static final String CQN_OUT = "OUT";
    private static final String TRACE1_INITIALIZE_SERVICES_COMPLETED = "Initialize Services Completed.";
    private static final String TRACE_PROVIDER_CALL = "Calling {0} for {1}";
    private static final String TRACE_PROVIDER_RETURN = "{0} for {1} returned.";
    private static final int DEFAULT_ITERATOR_TIMEOUT = 30;
    private static CIMRepository mRepository;
    private AuthService mSecurityService;
    private final Logger mLogger;
    private final ProviderClient mProviderClient;
    private final ProviderAdapterFactory mProvFactory;
    private JServerServices mServices;
    private final PullOperations mPullOperations;
    private final ExecutorService mExecutor;
    private URLClassLoader dynClassLoader;
    private final int mMaxObjectForNonPull;

    public JServer(JServerProperties props) throws Exception {
        this(JServerProperties.getPropertiesDirectory(), JServerProperties.getRepositoryDirectory(), JServerProperties.getMaxNumberRequestThreads());
        ProtocolParsers pp;
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl.getClass().isAssignableFrom(URLClassLoader.class)) {
            this.dynClassLoader = (URLClassLoader)cl;
        }
        this.initializeServices();
        if (JServerSettings.isEmbedded() && null != (pp = new ProtocolParsers())) {
            ProtocolParsers.Parser[] parsers = pp.getParsers();
            if (parsers.length < 1) {
                this.mServices.close();
                this.mServices = null;
                this.mSecurityService.close();
                this.mSecurityService = null;
                throw new Exception("No embedded protocol parsers found");
            }
            for (ProtocolParsers.Parser parser : parsers) {
                RequestHandler handler = parser.getRequestHandler(this);
                JServerSettings.getEmbeddedData().setParser(handler.getHandlerName(), handler);
            }
        }
    }

    protected JServer(String propDir, String repDir, String pThreads) throws Exception {
        JServerTrace.initTrace();
        this.mLogger = Logger.getLogger("com.ws.wbem.jserver");
        String numThreadsStr = JServerProperties.getMaxNumberRequestThreads();
        int numThreads = Integer.parseInt(null != numThreadsStr ? numThreadsStr : "100");
        try {
            int temp = Integer.parseInt(pThreads);
            if (temp > numThreads) {
                numThreads = temp;
            }
        }
        catch (NumberFormatException nfe) {
            LogRecord record = new LogRecord(Level.WARNING, "Unable to parse number of request threads {0}, defaulting to {1}");
            record.setParameters(new Object[]{pThreads, "100"});
            record.setThrown(nfe);
            this.mLogger.log(record);
        }
        this.mExecutor = new ThreadPoolExecutor(1, numThreads, 20L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.getProviderThreadFactory());
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this.mMaxObjectForNonPull = JServerProperties.getMaxObjectsPerNonPullRequest();
        this.mProviderClient = new ProviderClient(this);
        this.mPullOperations = new PullOperations();
        this.initializeRepository(propDir, repDir);
        this.mProvFactory = new ProviderAdapterFactory(this.mProviderClient);
    }

    @Override
    public CloseableIterator<CIMClass> associatorClasses(CIMObjectPath target, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            CloseableIterator<CIMClass> response;
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.ASSOCIATORCLASSES);
            CloseableIterator<CIMClass> closeableIterator = response = this.intassociatorClasses(target, assocClass, resultClass, role, resultRole, includeQualifiers);
            return closeableIterator;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.ASSOCIATORCLASSES);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.ASSOCIATORCLASSES);
            if (e.getCause() instanceof WBEMException) {
                throw (WBEMException)e.getCause();
            }
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.ASSOCIATORCLASSES, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public CloseableIterator<CIMInstance> associatorInstances(CIMObjectPath target, String assocClass, String resultClass, String role, String resultRole, String[] propertyList, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            CloseableIterator<CIMInstance> response;
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.ASSOCIATORS);
            CloseableIterator<CIMInstance> closeableIterator = response = this.intassociatorInstances(target, assocClass, resultClass, role, resultRole, propertyList);
            return closeableIterator;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.ASSOCIATORS);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.ASSOCIATORS);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.ASSOCIATORS, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public EnumerateResponse<CIMInstance> associators(CIMObjectPath target, String assocClass, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            EnumerateResponse<CIMInstance> response;
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.OPENASSOCIATORS);
            EnumerateResponse<CIMInstance> enumerateResponse = response = this.intassociators(target, assocClass, resultClass, role, resultRole, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.OPENASSOCIATORS);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.OPENASSOCIATORS);
            if (e.getCause() instanceof WBEMException) {
                throw (WBEMException)e.getCause();
            }
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.OPENASSOCIATORS, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    private String authenticateThenAuthorize(WBEMServerAuthentication auth, CIMObjectPath target, WBEMOperation operation) throws WBEMException {
        this.mProviderClient.setThreadData(null, null);
        String sessionID = this.mSecurityService.authenticate(auth.getSubject(), auth.getHost());
        this.mSecurityService.authorizeRequest(auth.getSubject(), operation.getName(), sessionID, target);
        this.mProviderClient.setThreadData(auth.getUserName(), sessionID);
        return sessionID;
    }

    private void checkMemory(CIMObjectPath target, WBEMOperation operation, String classmethodname) throws WBEMException {
        String TRACE_MEM_CHECK = "Check Memory called";
        String TRACE_MEM_FREE = "FREE MEMORY {0}";
        String TRACE_MEM_TOTAL = "TOTAL MEMORY {0}";
        String TRACE_MEM_MAX = "MAX ALLOCATABLE MEMORY {0}";
        long MEMORY_THRESH = 1000000L;
        Runtime rt = Runtime.getRuntime();
        this.mLogger.fine("Check Memory called");
        this.mLogger.log(Level.FINE, "FREE MEMORY {0}", rt.freeMemory());
        this.mLogger.log(Level.FINE, "TOTAL MEMORY {0}", rt.totalMemory());
        this.mLogger.log(Level.FINE, "MAX ALLOCATABLE MEMORY {0}", rt.maxMemory());
        if (rt.freeMemory() < 1000000L) {
            rt.gc();
            if (rt.freeMemory() < 1000000L) {
                this.mLogger.fine("Check Memory called");
                this.mLogger.log(Level.FINE, "FREE MEMORY {0}", rt.freeMemory());
                this.mLogger.log(Level.FINE, "TOTAL MEMORY {0}", rt.totalMemory());
                this.mLogger.log(Level.FINE, "MAX ALLOCATABLE MEMORY {0}", rt.maxMemory());
                if ((double)rt.totalMemory() * 1.1 >= (double)rt.maxMemory()) {
                    throw WBEMOperationErrors.getWBEMServerExceedsLimitsException((CIMObjectPath)target, (WBEMOperation)operation, (String)classmethodname);
                }
            }
        }
    }

    protected void close() {
        if (this.mLogger != null) {
            this.mLogger.info("Shutdown called!");
        }
        if (this.mServices != null) {
            this.mServices.close();
            this.mServices = null;
        }
        try {
            if (this.mLogger != null) {
                this.mLogger.info("Call close on all providers");
            }
            this.mProvFactory.shutdown();
        }
        catch (Exception e) {
            this.mLogger.log(Level.SEVERE, "Exception shutting down provider factories", e);
        }
        try {
            if (this.mLogger != null) {
                this.mLogger.info("Shutting down the log service");
            }
            JServerTrace.close();
        }
        catch (Exception e) {
            FailSafeLog.failSafe((Throwable)e);
        }
        try {
            if (null != mRepository) {
                mRepository.shutdown();
            }
        }
        catch (Exception e) {
            FailSafeLog.failSafe((Throwable)e);
        }
        if (null != this.mSecurityService) {
            this.mSecurityService.close();
        }
        if (null != this.mExecutor) {
            this.mExecutor.shutdownNow();
        }
        try {
            if (null != this.dynClassLoader) {
                this.dynClassLoader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dynClassLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEnumeration(CIMObjectPath target, String pEnumerationContext, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.CLOSEENUMERATION);
            this.intCloseEnumeration(target, pEnumerationContext);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createClass(CIMClass cc, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, cc.getObjectPath(), WBEMOperation.CREATECLASS);
            this.checkMemory(cc.getObjectPath(), WBEMOperation.CREATECLASS, null);
            this.intCreateClass(cc);
            this.mSecurityService.sessionCompleted(sessionID);
        }
        catch (Throwable throwable) {
            this.mSecurityService.sessionCompleted(sessionID);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CIMObjectPath createInstance(CIMInstance ci, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            CIMObjectPath responsePath;
            sessionID = this.authenticateThenAuthorize(auth, ci.getObjectPath(), WBEMOperation.CREATEINSTANCE);
            this.checkMemory(ci.getObjectPath(), WBEMOperation.CREATEINSTANCE, null);
            CIMObjectPath cIMObjectPath = responsePath = this.intCreateInstance(ci);
            this.mSecurityService.sessionCompleted(sessionID);
            return cIMObjectPath;
        }
        catch (Throwable throwable) {
            this.mSecurityService.sessionCompleted(sessionID);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createQualifierType(CIMQualifierType<?> qt, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, qt.getObjectPath(), WBEMOperation.CREATEQUALIFIERTYPE);
            this.checkMemory(qt.getObjectPath(), WBEMOperation.CREATEQUALIFIERTYPE, null);
            this.intSetQualifierType(qt);
            this.mSecurityService.sessionCompleted(sessionID);
        }
        catch (Throwable throwable) {
            this.mSecurityService.sessionCompleted(sessionID);
            throw throwable;
        }
    }

    private CIMObjectPath csInstance(CIMInstance ci, boolean set, String[] propertyList, boolean checkForProvider) throws WBEMException {
        try {
            CIMClass cc = null;
            CIMObjectPath path = ci.getObjectPath();
            cc = this.intgetClass(path, false, true);
            PullInstanceProvider newIP = null;
            try {
                newIP = this.mProvFactory.getPullInstanceProvider(ci.getObjectPath(), cc);
            }
            catch (WBEMException we) {
                newIP = null;
            }
            if (null != newIP) {
                if (this.mLogger.isLoggable(Level.INFO)) {
                    this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.MODIFYINSTANCE, cc.getName()});
                }
                if (set) {
                    newIP.modifyInstance(ci, propertyList);
                    return null;
                }
                CIMObjectPath op = newIP.createInstance(ci);
                if (this.mLogger.isLoggable(Level.INFO)) {
                    this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.MODIFYINSTANCE, cc.getName()});
                }
                return op;
            }
            Object[] o = new Object[]{cc.getName()};
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_PROVIDER_NOT_REGISTERED", (Object[])o), (WBEMOperation)(set ? WBEMOperation.MODIFYINSTANCE : WBEMOperation.CREATEINSTANCE), null);
        }
        catch (WBEMException e) {
            this.logException(e, set ? WBEMOperation.MODIFYINSTANCE : WBEMOperation.CREATEINSTANCE);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, set ? WBEMOperation.MODIFYINSTANCE : WBEMOperation.CREATEINSTANCE);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (Throwable)this.getUnderlyingCause(e), (WBEMOperation)(set ? WBEMOperation.MODIFYINSTANCE : WBEMOperation.CREATEINSTANCE), null);
        }
    }

    @Override
    public void deleteClass(CIMObjectPath target, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.DELETECLASS);
            this.intdeleteClass(target);
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.DELETECLASS);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.DELETECLASS);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.DELETECLASS, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public void deleteInstance(CIMObjectPath target, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.DELETEINSTANCE);
            this.intdeleteInstance(target);
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.DELETEINSTANCE);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.DELETEINSTANCE);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.DELETEINSTANCE, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public void deleteQualifierType(CIMObjectPath target, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.DELETEQUALIFIERTYPE);
            this.checkMemory(target, WBEMOperation.DELETEQUALIFIERTYPE, null);
            this.intdeleteQualifierType(target);
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.DELETEQUALIFIERTYPE);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.DELETEQUALIFIERTYPE);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.DELETEQUALIFIERTYPE, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public void deliverEvent(CIMInstance ci, CIMInstance[] indicationSubscriptions) {
        JServerEventService[] eventServices;
        this.mLogger.info("deliverEvent Called");
        for (JServerEventService eventService : eventServices = this.mServices.getEventServices()) {
            try {
                eventService.deliverEvent(ci, indicationSubscriptions);
            }
            catch (Throwable e) {
                this.mLogger.log(Level.WARNING, "Caught exception from EventService.deliverEvent", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIterator<CIMClass> enumerateClasses(CIMObjectPath target, boolean deep, boolean localOnly, boolean includeQualifiers, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.ENUMERATECLASSES);
            CloseableIterator<CIMClass> closeableIterator = this.intenumClass(target, deep, localOnly, includeQualifiers);
            return closeableIterator;
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public EnumerateResponse<CIMInstance> enumerateInstances(CIMObjectPath target, boolean deep, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            EnumerateResponse<CIMInstance> response;
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.OPENENUMERATEINSTANCES);
            EnumerateResponse<CIMInstance> enumerateResponse = response = this.intenumInstances(target, deep, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.OPENENUMERATEINSTANCES);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.OPENENUMERATEINSTANCES);
            if (e.getCause() instanceof WBEMException) {
                throw (WBEMException)e.getCause();
            }
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath target, boolean deep, String[] propertyList, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.ENUMERATEINSTANCES);
            CloseableIterator<CIMInstance> closeableIterator = this.intenumInstances(target, deep, propertyList);
            return closeableIterator;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.ENUMERATEINSTANCES);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.ENUMERATEINSTANCES);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES, (String)auth.getHost());
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public CloseableIterator<CIMQualifierType<?>> enumQualifierTypes(CIMObjectPath target, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.ENUMERATEQUALIFIERTYPES);
            CloseableIterator<CIMQualifierType<?>> closeableIterator = this.intenumQualifierTypes(target);
            return closeableIterator;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.ENUMERATEQUALIFIERTYPES);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.ENUMERATEQUALIFIERTYPES);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.ENUMERATEQUALIFIERTYPES, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public CloseableIterator<CIMInstance> execQuery(CIMObjectPath target, String query, String ql, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.EXECUTEQUERY);
            CloseableIterator<CIMInstance> closeableIterator = this.intexecQuery(target, query, ql);
            return closeableIterator;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.EXECUTEQUERY);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.EXECUTEQUERY);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.EXECUTEQUERY, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public EnumerateResponse<CIMInstance> execQueryInstances(CIMObjectPath target, String filterQuery, String filterQueryLanguage, boolean returnQueryResultClass, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects, CIMClass queryResultClass, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.OPENQUERYINSTANCES);
            EnumerateResponse<CIMInstance> enumerateResponse = this.intExecQueryInstances(target, filterQueryLanguage, filterQuery, returnQueryResultClass, timeout, continueOnError, maxObjects, queryResultClass);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.OPENQUERYINSTANCES);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.OPENQUERYINSTANCES);
            if (e.getCause() instanceof WBEMException) {
                throw (WBEMException)e.getCause();
            }
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.OPENQUERYINSTANCES, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CIMClass getClass(CIMObjectPath target, boolean localOnly, boolean includeQualifiers, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.GETCLASS);
            CIMClass cc = this.intgetClass(target, localOnly, includeQualifiers);
            this.mSecurityService.sessionCompleted(sessionID);
            CIMClass cIMClass = cc;
            return cIMClass;
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public IndicationProvider getIndicationProvider(CIMObjectPath pClass) throws WBEMException {
        CIMClass cc = this.intgetClass(pClass, false, true);
        return this.mProvFactory.getCIMIndicationProvider(cc);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath target, String[] propertyList, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.GETINSTANCE);
            CIMInstance ci = this.intgetInstance(target, propertyList);
            if (ci == null) {
                throw WBEMOperationErrors.getClassNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.GETINSTANCE, null);
            }
            CIMInstance cIMInstance = ci;
            return cIMInstance;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.GETINSTANCE);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.GETINSTANCE);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.GETINSTANCE, (String)auth.getHost());
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumerateResponse<CIMInstance> getInstances(CIMObjectPath op, String pEnumerationContext, UnsignedInteger32 maxObjects, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, op, WBEMOperation.PULLINSTANCES);
            EnumerateResponse<CIMInstance> enumerateResponse = this.intGetInstances(op, pEnumerationContext, maxObjects);
            return enumerateResponse;
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumerateResponse<CIMInstance> getInstancesWithPath(CIMObjectPath op, String pEnumerationContext, UnsignedInteger32 maxObjects, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, op, WBEMOperation.PULLINSTANCESWITHPATH);
            EnumerateResponse<CIMInstance> enumerateResponse = this.intGetInstancesWithPath(op, pEnumerationContext, maxObjects);
            return enumerateResponse;
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    private ThreadFactory getProviderThreadFactory() {
        ThreadFactory ret = null;
        String tfClz = JServerProperties.getProviderThreadFactory();
        if (null != tfClz) {
            try {
                Class<?> tf = Class.forName(tfClz);
                ret = (ThreadFactory)tf.newInstance();
            }
            catch (Throwable e) {
                this.mLogger.log(Level.SEVERE, "Error loading custom ThreadFactory for providers, using default", e);
                ret = null;
            }
        }
        if (null == ret) {
            ret = new DaemonThreadFactory();
        }
        return ret;
    }

    @Override
    public CIMQualifierType<?> getQualifierType(CIMObjectPath target, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.GETQUALIFIERTYPE);
            CIMQualifierType<?> cIMQualifierType = this.intgetQualifierType(target);
            return cIMQualifierType;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.GETQUALIFIERTYPE);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.GETQUALIFIERTYPE);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.GETQUALIFIERTYPE, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    private Throwable getUnderlyingCause(Throwable e) {
        Throwable t = e;
        while (null != t.getCause() && !((t = t.getCause()) instanceof WBEMException)) {
        }
        return t;
    }

    private void initializeRepository(String propDir, String dir) throws Exception {
        try {
            mRepository = JServerRepositoryAdapterFactory.getAdapter(JServerProperties.getRepositoryAdapter());
            mRepository.init(dir, this.mProviderClient);
        }
        catch (Exception e) {
            FailSafeLog.failSafe((String)WSIStandardMessages.getMessage((String)"ERROR_CIMOM_REPOSITORY_INIT", null), (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
    }

    private void initializeServices() throws Exception {
        this.mLogger.info("Starting J WBEM Server...");
        this.mSecurityService = JServerSecurityAdapterFactory.getAdapter(JServerProperties.getSecurityPlugin());
        this.mSecurityService.initialize(this.mProviderClient);
        this.mServices = new JServerServices();
        this.mServices.initialize(this, this.mProviderClient, this.mLogger);
        this.mLogger.info(TRACE1_INITIALIZE_SERVICES_COMPLETED);
    }

    protected CloseableIterator<CIMClass> intassociatorClasses(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers) throws WBEMException {
        try {
            this.intgetClass(objectName, false, false);
        }
        catch (WBEMException e) {
            if (e.getID() == 3) {
                throw e;
            }
            List fv = Collections.emptyList();
            return new CloseableAddableIterator(fv);
        }
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.ASSOCIATORCLASSES, assocClass});
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "Parameters passed to {0}, Role: {1}, ResultRole: {2}, ResultClass: {3}", new Object[]{WBEMOperation.ASSOCIATORCLASSES, role, resultRole, resultClass});
            }
        }
        CloseableIterator<CIMClass> ret = mRepository.associatorClasses(objectName, assocClass, resultClass, role, resultRole, includeQualifiers);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.ASSOCIATORCLASSES, assocClass});
        }
        return ret;
    }

    protected CloseableIterator<CIMInstance> intassociatorInstances(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, String[] propertyList) throws WBEMException {
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, this.mMaxObjectForNonPull);
        ProcessOldStyleProviderRequest worker = new ProcessOldStyleProviderRequest((CloseableAddableIterator<CIMInstance>)caIterator, objectName, assocClass, resultClass, role, resultRole, propertyList);
        this.mExecutor.execute(worker);
        return caIterator;
    }

    protected EnumerateResponse<CIMInstance> intassociators(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        if (continueOnError) {
            throw WBEMOperationErrors.getContinuationOnErrorNotSupportedException((CIMObjectPath)objectName, (WBEMOperation)WBEMOperation.OPENASSOCIATORS, null);
        }
        this.validateTimeout(timeout, objectName, WBEMOperation.OPENASSOCIATORS);
        if (null == objectName || objectName.getKeys() == null || objectName.getKeys().length == 0) {
            return new EnumerateResponse(null, null, true);
        }
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L);
        ArrayList<Callable<Boolean>> callList = new ArrayList<Callable<Boolean>>();
        CloseableIterator<CIMClass> v = mRepository.referenceClasses(objectName, assocClass, role, resultClass, true);
        while (v.hasNext()) {
            CIMClass cc = (CIMClass)v.next();
            CIMObjectPath tempOp = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), cc.getName(), null);
            PullAssociatorProvider newAP = null;
            try {
                newAP = this.mProvFactory.getPullAssociatorProvider(cc.getObjectPath(), cc);
            }
            catch (WBEMException we) {
                this.logException(we, WBEMOperation.OPENASSOCIATORS);
                newAP = null;
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cc.getObjectPath(), (Throwable)we, (WBEMOperation)WBEMOperation.OPENASSOCIATORS, null);
            }
            if (null == newAP) continue;
            callList.add(new AssociatorsThread(tempOp, objectName, resultClass, role, resultRole, propertyList, filterQueryLanguage, filterQuery, continueOnError, (Provider)newAP, (CloseableAddableIterator<CIMInstance>)caIterator));
        }
        this.processCallList(objectName, callList, caIterator, WBEMOperation.OPENASSOCIATORS);
        return this.mPullOperations.openInstanceWithPathEnumeration((CloseableIterator<CIMInstance>)caIterator, maxObjects, null != timeout ? timeout : new UnsignedInteger32(30L));
    }

    protected void intCloseEnumeration(CIMObjectPath target, String pEnumerationContext) throws WBEMException {
        this.mPullOperations.closeEnumeration(target, pEnumerationContext);
    }

    void intCreateClass(CIMClass cc) throws WBEMException {
        try {
            mRepository.createClass(cc);
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.CREATECLASS);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.CREATECLASS);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cc.getObjectPath(), (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.CREATECLASS, null);
        }
    }

    protected CIMObjectPath intCreateInstance(CIMInstance ci) throws WBEMException {
        return this.csInstance(ci, false, null, true);
    }

    void intdeleteClass(CIMObjectPath inpath) throws WBEMException {
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.DELETECLASS, inpath.getObjectName()});
        }
        mRepository.deleteClass(inpath);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.DELETECLASS, inpath.getObjectName()});
        }
    }

    void intdeleteInstance(CIMObjectPath target) throws WBEMException {
        PullInstanceProvider newIP = null;
        try {
            newIP = this.mProvFactory.getPullInstanceProvider(target, null);
        }
        catch (WBEMException we) {
            this.logException(we, WBEMOperation.DELETEINSTANCE);
            newIP = null;
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)we, (WBEMOperation)WBEMOperation.DELETEINSTANCE, null);
        }
        if (null != newIP) {
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.DELETEINSTANCE, target.getObjectName()});
            }
            newIP.deleteInstance(target);
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.DELETEINSTANCE, target.getObjectName()});
            }
            return;
        }
        Object[] o = new Object[]{target.getObjectName()};
        throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)WSIStandardMessages.getMessage((String)"ERROR_PROVIDER_NOT_REGISTERED", (Object[])o), (WBEMOperation)WBEMOperation.DELETEINSTANCE, null);
    }

    protected void intdeleteQualifierType(CIMObjectPath target) throws WBEMException {
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.DELETEQUALIFIERTYPE, target.getObjectName()});
        }
        mRepository.deleteQualifierType(target);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.DELETEQUALIFIERTYPE, target.getObjectName()});
        }
    }

    protected CloseableIterator<CIMClass> intenumClass(CIMObjectPath inpath, boolean deep, boolean lo, boolean iq) throws WBEMException {
        this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.ENUMERATECLASSES, inpath.getObjectName()});
        CloseableIterator<CIMClass> ret = mRepository.enumerateClasses(inpath, deep, lo, iq);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.ENUMERATECLASSES, inpath.getObjectName()});
        }
        return ret;
    }

    protected CloseableIterator<CIMInstance> intenumInstances(CIMObjectPath target, boolean deep, String[] propertyList) throws WBEMException {
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, this.mMaxObjectForNonPull);
        ProcessOldStyleProviderRequest worker = new ProcessOldStyleProviderRequest((CloseableAddableIterator<CIMInstance>)caIterator, target, deep, propertyList);
        this.mExecutor.execute(worker);
        return caIterator;
    }

    protected EnumerateResponse<CIMInstance> intenumInstances(CIMObjectPath target, boolean deep, String[] pl, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        if (continueOnError) {
            throw WBEMOperationErrors.getContinuationOnErrorNotSupportedException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, null);
        }
        this.validateTimeout(timeout, target, WBEMOperation.ENUMERATEINSTANCES);
        ArrayList<String> propList = new ArrayList<String>();
        if (!deep) {
            CIMClassProperty[] ccPropArray;
            CIMClass cc = this.intgetClass(target, false, false);
            for (CIMClassProperty element : ccPropArray = cc.getProperties()) {
                propList.add(element.getName());
            }
        }
        String[] props = new String[propList.size()];
        propList.toArray(props);
        CloseableIterator<CIMClass> iClasses = this.intenumClass(target, true, false, true);
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, maxObjects.intValue());
        ArrayList<Callable<Boolean>> callList = new ArrayList<Callable<Boolean>>();
        int i = 0;
        while (i == 0 || iClasses.hasNext()) {
            CIMObjectPath op = null;
            if (i == 0) {
                op = target;
                ++i;
            } else {
                CIMClass clazz = (CIMClass)iClasses.next();
                op = clazz.getObjectPath();
            }
            PullInstanceProvider newAP = null;
            try {
                newAP = this.mProvFactory.getPullInstanceProvider(op, null);
            }
            catch (WBEMException we) {
                this.logException(we, WBEMOperation.ENUMERATEINSTANCES);
                newAP = null;
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)op, (Throwable)we, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES, null);
            }
            if (null == newAP) continue;
            callList.add(new EnumerateInstancesThread(op, deep, pl, props, filterQueryLanguage, filterQuery, continueOnError, (Provider)newAP, (CloseableAddableIterator<CIMInstance>)caIterator));
        }
        this.processCallList(target, callList, caIterator, WBEMOperation.ENUMERATEINSTANCES);
        return this.mPullOperations.openInstanceWithPathEnumeration((CloseableIterator<CIMInstance>)caIterator, maxObjects, null != timeout ? timeout : new UnsignedInteger32(30L));
    }

    protected CloseableIterator<CIMQualifierType<?>> intenumQualifierTypes(CIMObjectPath path) throws WBEMException {
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.ENUMERATEQUALIFIERTYPES, path.getObjectName()});
        }
        CloseableIterator<CIMQualifierType<?>> ret = mRepository.enumerateQualifierTypes(path);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.ENUMERATEQUALIFIERTYPES, path.getObjectName()});
        }
        return ret;
    }

    protected CloseableIterator<CIMInstance> intexecQuery(CIMObjectPath targetPath, String query, String ql) throws WBEMException {
        WBEMQuery wq = null;
        try {
            wq = WBEMQueryLanguageFactory.getQuery((String)ql);
        }
        catch (Exception e) {
            this.logException(e, WBEMOperation.EXECUTEQUERY);
            throw WBEMOperationErrors.getUnknownQueryLanguageException((CIMObjectPath)targetPath, (String)ql, null, (WBEMOperation)WBEMOperation.EXECUTEQUERY);
        }
        if (!wq.initialize(query)) {
            throw WBEMOperationErrors.getInvalidQueryException((CIMObjectPath)targetPath, (String)ql, (String)query, (WBEMOperation)WBEMOperation.EXECUTEQUERY, null);
        }
        targetPath = new CIMObjectPath(targetPath.getScheme(), targetPath.getHost(), targetPath.getPort(), targetPath.getNamespace(), wq.getFromClassName(), null);
        ArrayList fv = new ArrayList();
        Iterator providerInstances = null;
        CloseableIterator<CIMClass> iClasses = this.intenumClass(targetPath, true, false, true);
        boolean first = true;
        while (iClasses.hasNext() || first) {
            CIMObjectPath op = null;
            if (first) {
                op = targetPath;
                first = false;
            } else {
                CIMClass clazz = (CIMClass)iClasses.next();
                op = clazz.getObjectPath();
                op = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), targetPath.getKeys());
            }
            PullInstanceProvider newIP = null;
            try {
                newIP = this.mProvFactory.getPullInstanceProvider(op, null);
            }
            catch (WBEMException we) {
                this.logException(we, WBEMOperation.EXECUTEQUERY);
                newIP = null;
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)op, (Throwable)we, (WBEMOperation)WBEMOperation.EXECUTEQUERY, null);
            }
            if (null != newIP) {
                if (this.mLogger.isLoggable(Level.INFO)) {
                    this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.EXECUTEQUERY, op.getObjectName()});
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.log(Level.FINE, "Parameters passed to {0}: ObjectPath: {1}, Query: {2}, QueryLanguage: {3}", new Object[]{WBEMOperation.EXECUTEQUERY, op, query, ql});
                    }
                }
                providerInstances = newIP.execQuery(op, query, ql);
                if (this.mLogger.isLoggable(Level.INFO)) {
                    this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.EXECUTEQUERY, op.getObjectName()});
                }
            }
            if (null == providerInstances) continue;
            while (providerInstances.hasNext()) {
                fv.add(providerInstances.next());
            }
        }
        return new CloseableAddableIterator(fv);
    }

    public EnumerateResponse<CIMInstance> intExecQueryInstances(CIMObjectPath path, String filterQueryLanguage, String filterQuery, boolean returnQueryResultClass, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects, CIMClass queryResultClass) throws WBEMException {
        throw WBEMOperationErrors.getOperationNotSupportedByWBEMServerException((CIMObjectPath)path, (WBEMOperation)WBEMOperation.OPENQUERYINSTANCES, null);
    }

    protected CIMClass intgetClass(CIMObjectPath objectName, boolean localOnly, boolean includeQualifiers) throws WBEMException {
        CIMClass ret;
        try {
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.GETCLASS, objectName.getObjectName()});
            }
            ret = mRepository.getClass(objectName, localOnly, includeQualifiers);
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.GETCLASS, objectName.getObjectName()});
            }
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.GETCLASS);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.GETCLASS);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)objectName, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.GETCLASS, null);
        }
        return ret;
    }

    protected CIMInstance intgetInstance(CIMObjectPath objectName, String[] pl) throws WBEMException {
        PullInstanceProvider newIP = null;
        try {
            newIP = this.mProvFactory.getPullInstanceProvider(objectName, null);
        }
        catch (WBEMException we) {
            newIP = null;
        }
        if (null != newIP) {
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.GETINSTANCE, objectName.getObjectName()});
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "Parameters passed to {0}: ObjectPath: {1}, PropertyList: {2}", new Object[]{WBEMOperation.GETINSTANCE, objectName.getObjectName(), Arrays.toString(pl)});
                }
            }
            CIMInstance i = newIP.getInstance(objectName, pl);
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.GETINSTANCE, objectName.getObjectName()});
            }
            return i;
        }
        Object[] o = new Object[]{objectName.getObjectName()};
        throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)objectName, (String)WSIStandardMessages.getMessage((String)"ERROR_PROVIDER_NOT_REGISTERED", (Object[])o), (WBEMOperation)WBEMOperation.GETINSTANCE, null);
    }

    public EnumerateResponse<CIMInstance> intGetInstances(CIMObjectPath op, String pEnumerationContext, UnsignedInteger32 maxObjects) throws WBEMException {
        return this.mPullOperations.getMaxObjects(op, pEnumerationContext, maxObjects, OperationIteratorType.INSTANCE);
    }

    public EnumerateResponse<CIMInstance> intGetInstancesWithPath(CIMObjectPath op, String pEnumerationContext, UnsignedInteger32 maxObjects) throws WBEMException {
        return this.mPullOperations.getMaxObjects(op, pEnumerationContext, maxObjects, OperationIteratorType.INSTANCEWITHPATH);
    }

    protected CIMQualifierType<?> intgetQualifierType(CIMObjectPath objectName) throws WBEMException {
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.GETQUALIFIERTYPE, objectName.getObjectName()});
        }
        CIMQualifierType<?> ret = mRepository.getQualifierType(objectName);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.GETQUALIFIERTYPE, objectName.getObjectName()});
        }
        return ret;
    }

    Object intinvokeMethod(CIMObjectPath target, String methodName, CIMArgument<?>[] inArgs, ArrayList<CIMArgument<?>> outArgs) throws WBEMException {
        try {
            CIMParameter[] cpArray;
            int trenner;
            String MethodName;
            if (null == target || null == target.getObjectName()) {
                throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.INVOKEMETHOD, (String)methodName);
            }
            CIMClass cc = this.intgetClass(target, false, true);
            CIMMethod me = cc.getMethod(MethodName = methodName.substring((trenner = methodName.indexOf(".")) + 1, methodName.length()));
            if (me == null) {
                throw WBEMOperationErrors.getNoSuchMethodException((CIMObjectPath)target, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
            }
            int numOutParams = 0;
            for (CIMParameter element : cpArray = me.getParameters()) {
                if (!this.isTrueQual(element.getQualifier(CQN_OUT))) continue;
                ++numOutParams;
            }
            CIMArgument[] outParamArray = new CIMArgument[numOutParams];
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.INVOKEMETHOD, cc.getName()});
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "Parameters passed to {0}: Method: {1}, IN Arguments: {2}", new Object[]{WBEMOperation.INVOKEMETHOD, methodName, Arrays.toString(inArgs)});
                }
            }
            PullInstanceProvider mp = null;
            try {
                mp = this.mProvFactory.getPullInstanceProvider(target, cc);
            }
            catch (WBEMException e) {
                this.logException(e, WBEMOperation.INVOKEMETHOD);
                WBEMException t = e;
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(t), (WBEMOperation)WBEMOperation.INVOKEMETHOD, null);
            }
            Object result = mp.invokeMethod(target, methodName, inArgs, outParamArray);
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.INVOKEMETHOD, cc.getName()});
            }
            for (CIMArgument element : outParamArray) {
                outArgs.add(element);
            }
            return result;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.INVOKEMETHOD);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.INVOKEMETHOD);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.INVOKEMETHOD, null);
        }
    }

    protected void intModifyClass(CIMClass cc) throws WBEMException {
        try {
            CIMClass icc = this.intgetClass(cc.getObjectPath(), false, true);
            icc = icc.filterProperties(true, true);
            CloseableIterator<CIMClass> iClasses = this.intenumClass(cc.getObjectPath(), true, false, false);
            if (!iClasses.hasNext()) {
                throw WBEMOperationErrors.getClassHasSubClassesException((CIMObjectPath)cc.getObjectPath(), (WBEMOperation)WBEMOperation.MODIFYCLASS, null);
            }
            CloseableIterator ciArray = mRepository.enumerateInstances(cc.getObjectPath(), new String[0], null, null, false);
            if (ciArray.hasNext()) {
                throw WBEMOperationErrors.getClassHasInstancesException((CIMObjectPath)cc.getObjectPath(), (WBEMOperation)WBEMOperation.MODIFYCLASS, null);
            }
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.MODIFYCLASS, cc.getName()});
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "Parameters for {0}: New Class: {1}", new Object[]{WBEMOperation.MODIFYCLASS, cc});
                }
            }
            mRepository.modifyClass(icc);
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.MODIFYCLASS, cc.getName()});
            }
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.MODIFYCLASS);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.MODIFYCLASS);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cc.getObjectPath(), (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.MODIFYCLASS, null);
        }
    }

    protected void intModifyInstance(CIMInstance ci, String[] propertyList, boolean checkForProvider) throws WBEMException {
        this.csInstance(ci, true, propertyList, checkForProvider);
    }

    protected CloseableIterator<CIMClass> intreferenceClasses(CIMObjectPath objectName, String assocClass, String role, boolean includeQualifiers) throws WBEMException {
        try {
            this.intgetClass(objectName, false, false);
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.REFERENCECLASSES);
            if (3 == e.getID()) {
                throw e;
            }
            return new CloseableAddableIterator(Collections.emptyList());
        }
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.REFERENCECLASSES, objectName.getObjectName()});
        }
        CloseableIterator<CIMClass> ret = mRepository.referenceClasses(objectName, assocClass, role, "", includeQualifiers);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.REFERENCECLASSES, objectName.getObjectName()});
        }
        return ret;
    }

    protected CloseableIterator<CIMInstance> intreferenceInstances(CIMObjectPath objectName, String assocClass, String role, String[] propertyList) throws WBEMException {
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, this.mMaxObjectForNonPull);
        ProcessOldStyleProviderRequest worker = new ProcessOldStyleProviderRequest((CloseableAddableIterator<CIMInstance>)caIterator, objectName, assocClass, role, propertyList);
        this.mExecutor.execute(worker);
        return caIterator;
    }

    protected EnumerateResponse<CIMInstance> intreferences(CIMObjectPath target, String assocClass, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        if (continueOnError) {
            throw WBEMOperationErrors.getContinuationOnErrorNotSupportedException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.OPENREFERENCES, null);
        }
        this.validateTimeout(timeout, target, WBEMOperation.OPENREFERENCES);
        if (null == target || target.getKeys() == null || target.getKeys().length == 0) {
            throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.OPENREFERENCES, null);
        }
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L);
        ArrayList<Callable<Boolean>> callList = new ArrayList<Callable<Boolean>>();
        CloseableIterator<CIMClass> i = mRepository.referenceClasses(target, assocClass, role, "", true);
        while (i.hasNext()) {
            CIMClass cc = (CIMClass)i.next();
            PullAssociatorProvider newAP = null;
            try {
                newAP = this.mProvFactory.getPullAssociatorProvider(cc.getObjectPath(), null);
            }
            catch (WBEMException we) {
                newAP = null;
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cc.getObjectPath(), (Throwable)we, (WBEMOperation)WBEMOperation.OPENREFERENCES, null);
            }
            if (null == newAP) continue;
            callList.add(new ReferencesThread(cc.getObjectPath(), target, role, propertyList, filterQueryLanguage, filterQuery, continueOnError, (Provider)newAP, (CloseableAddableIterator<CIMInstance>)caIterator));
        }
        this.processCallList(target, callList, caIterator, WBEMOperation.OPENREFERENCES);
        return this.mPullOperations.openInstanceWithPathEnumeration((CloseableIterator<CIMInstance>)caIterator, maxObjects, null != timeout ? timeout : new UnsignedInteger32(30L));
    }

    protected void intSetQualifierType(CIMQualifierType<?> qt) throws WBEMException {
        CIMQualifierType<?> qType = null;
        try {
            qType = mRepository.getQualifierType(qt.getObjectPath());
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.CREATEQUALIFIERTYPE);
            if (e.getID() == 6) {
                if (this.mLogger.isLoggable(Level.INFO)) {
                    this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.CREATEQUALIFIERTYPE, qt.getName()});
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.log(Level.FINE, "Parameters passed to {0}, Qualifier: {1}", new Object[]{WBEMOperation.CREATEQUALIFIERTYPE, qt});
                    }
                }
                mRepository.createQualifierType(qt);
                if (this.mLogger.isLoggable(Level.INFO)) {
                    this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.CREATEQUALIFIERTYPE, qt.getName()});
                }
                return;
            }
            throw e;
        }
        if (qType != null && !qType.equals(qt)) {
            mRepository.modifyQualifierType(qt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeMethod(CIMObjectPath target, String methodName, CIMArgument<?>[] inArgs, ArrayList<CIMArgument<?>> outArgs, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            Object ret;
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.INVOKEMETHOD);
            Object object = ret = this.intinvokeMethod(target, methodName, inArgs, outArgs);
            return object;
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    private boolean isTrueQual(CIMQualifier<?> cq) {
        if (cq == null) {
            return false;
        }
        Object o = cq.getValue();
        return o == null || o.equals(Boolean.TRUE);
    }

    private void logException(Throwable e, WBEMOperation operation) {
        this.mLogger.log(Level.SEVERE, "Received exception when executing " + operation.getName(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyClass(CIMClass cc, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, cc.getObjectPath(), WBEMOperation.MODIFYCLASS);
            this.checkMemory(cc.getObjectPath(), WBEMOperation.MODIFYCLASS, null);
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.MODIFYCLASS, cc.getName()});
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "Parameters passed to {0}: ObjectPath: {1}, Class: {2}", new Object[]{WBEMOperation.MODIFYCLASS, cc.getObjectPath(), cc});
                }
            }
            this.intModifyClass(cc);
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.MODIFYCLASS, cc.getName()});
            }
            this.mSecurityService.sessionCompleted(sessionID);
        }
        catch (Throwable throwable) {
            this.mSecurityService.sessionCompleted(sessionID);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyInstance(CIMInstance ci, String[] propertyList, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, ci.getObjectPath(), WBEMOperation.MODIFYINSTANCE);
            this.checkMemory(ci.getObjectPath(), WBEMOperation.MODIFYINSTANCE, null);
            this.intModifyInstance(ci, propertyList, true);
            this.mSecurityService.sessionCompleted(sessionID);
        }
        catch (Throwable throwable) {
            this.mSecurityService.sessionCompleted(sessionID);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyQualifierType(CIMQualifierType<?> qt, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, qt.getObjectPath(), WBEMOperation.MODIFYQUALIFIERTYPE);
            this.checkMemory(qt.getObjectPath(), WBEMOperation.MODIFYQUALIFIERTYPE, null);
            this.intSetQualifierType(qt);
            this.mSecurityService.sessionCompleted(sessionID);
        }
        catch (Throwable throwable) {
            this.mSecurityService.sessionCompleted(sessionID);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCallList(CIMObjectPath target, ArrayList<Callable<Boolean>> callList, CloseableAddableIterator<?> caIterator, WBEMOperation operation) {
        boolean closeIter = true;
        try {
            if (callList.size() > 0) {
                this.mExecutor.execute(new WBEMExecutor(this.mExecutor, callList, caIterator));
                closeIter = false;
            }
        }
        finally {
            if (closeIter) {
                caIterator.done();
            }
        }
    }

    @Override
    public CloseableIterator<CIMClass> referenceClasses(CIMObjectPath target, String resultClass, String role, boolean includeQualifiers, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.REFERENCECLASSES);
            CloseableIterator<CIMClass> closeableIterator = this.intreferenceClasses(target, resultClass, role, includeQualifiers);
            return closeableIterator;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.REFERENCECLASSES);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.REFERENCECLASSES);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.REFERENCECLASSES, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public CloseableIterator<CIMInstance> referenceInstances(CIMObjectPath target, String resultClass, String role, String[] propertyList, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.REFERENCES);
            CloseableIterator<CIMInstance> closeableIterator = this.intreferenceInstances(target, resultClass, role, propertyList);
            return closeableIterator;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.REFERENCES);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.REFERENCES);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.REFERENCES, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    @Override
    public EnumerateResponse<CIMInstance> references(CIMObjectPath target, String resultClass, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects, WBEMServerAuthentication auth) throws WBEMException {
        String sessionID = null;
        try {
            sessionID = this.authenticateThenAuthorize(auth, target, WBEMOperation.OPENREFERENCES);
            EnumerateResponse<CIMInstance> enumerateResponse = this.intreferences(target, resultClass, role, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            this.logException(e, WBEMOperation.OPENREFERENCES);
            throw e;
        }
        catch (Throwable e) {
            this.logException(e, WBEMOperation.OPENREFERENCES);
            if (e.getCause() instanceof WBEMException) {
                throw (WBEMException)e.getCause();
            }
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)this.getUnderlyingCause(e), (WBEMOperation)WBEMOperation.OPENREFERENCES, null);
        }
        finally {
            this.mSecurityService.sessionCompleted(sessionID);
        }
    }

    private void validateTimeout(UnsignedInteger32 timeout, CIMObjectPath target, WBEMOperation operation) throws WBEMException {
        long time = 30L;
        if (null != timeout) {
            time = timeout.longValue();
        }
        boolean MIN_TIMEOUT = true;
        int MAX_TIMEOUT = 60;
        if (time < 1L || time > 60L) {
            throw WBEMOperationErrors.getInvalidTimeoutException((CIMObjectPath)target, (long)time, (WBEMOperation)operation, null);
        }
    }

    private class ShutdownHook
    extends Thread {
        ShutdownHook() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (null != JServer.this.mServices) {
                if (null != JServer.this.mLogger) {
                    JServer.this.mLogger.info("Shutdown hook called");
                }
                JServer.this.close();
            }
        }
    }

    private class ReferencesThread
    extends EnumerateThread {
        private final CIMObjectPath mAssocName;
        private final String mRole;
        private final String[] mPropertyList;
        private final CloseableAddableIterator<CIMInstance> mCAIterator;

        public ReferencesThread(CIMObjectPath pAssocName, CIMObjectPath pOP, String pRole, String[] pPropertyList, String pFilterQueryLanguage, String pFilterQuery, boolean pContinueOnError, Provider pProv, CloseableAddableIterator<CIMInstance> pCAIterator) {
            super(pOP, pProv, pFilterQueryLanguage, pFilterQuery, pContinueOnError);
            this.mRole = pRole;
            this.mPropertyList = pPropertyList;
            this.mAssocName = pAssocName;
            this.mCAIterator = pCAIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            JServer.this.mProviderClient.setThreadData(this.mUserName, this.mSessionID);
            Thread thread = Thread.currentThread();
            String tgName = thread.getThreadGroup().getName();
            thread.setName(tgName + ":" + "ReferencesThread - " + this.mOP.getObjectName());
            try {
                CloseableIterator iter = null;
                if (JServer.this.mLogger.isLoggable(Level.INFO)) {
                    JServer.this.mLogger.log(Level.INFO, JServer.TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.OPENREFERENCES, this.mAssocName.getObjectName()});
                    if (JServer.this.mLogger.isLoggable(Level.FINE)) {
                        JServer.this.mLogger.log(Level.FINE, "Parameters passed to {0}, Role: {2}, ", new Object[]{WBEMOperation.OPENREFERENCES, this.mRole});
                    }
                }
                iter = ((PullAssociatorProvider)this.mProvider).references(this.mAssocName, this.mOP, this.mRole, this.mPropertyList, this.mFilterQueryLanguage, this.mFilterQuery, this.mContinueOnError);
                if (JServer.this.mLogger.isLoggable(Level.INFO)) {
                    JServer.this.mLogger.log(Level.INFO, JServer.TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.OPENREFERENCES, this.mAssocName.getObjectName()});
                }
                while (null != iter && iter.hasNext()) {
                    if (this.mCAIterator.isClosed()) {
                        iter.close();
                        Boolean bl = true;
                        return bl;
                    }
                    this.mCAIterator.add(iter.next());
                }
            }
            catch (WBEMException we) {
                this.mCAIterator.setException(we);
                if (!this.mContinueOnError) {
                    this.mCAIterator.close();
                }
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    if (!((t = t.getCause()) instanceof WBEMException)) continue;
                    this.mCAIterator.setException((WBEMException)t);
                    break;
                }
                if (null == this.mCAIterator.getWBEMException()) {
                    this.mCAIterator.setException(new WBEMException(1, t.getMessage(), null, t));
                }
                if (!this.mContinueOnError) {
                    this.mCAIterator.close();
                }
            }
            finally {
                thread.setName(tgName + ":" + "ReferencesThread - idle");
                JServer.this.mProviderClient.setThreadData(null, null);
            }
            return new Boolean(true);
        }
    }

    private class ProcessOldStyleProviderRequest
    implements Runnable {
        private final String userName;
        private final CloseableAddableIterator<CIMInstance> caIterator;
        private final CIMObjectPath requestObjectPath;
        private final boolean deep;
        private final String[] propertyList;
        private final String resultClass;
        private final String role;
        private final String resultRole;
        private final String assocClass;
        private final char operation;
        private final String sessionID;

        public ProcessOldStyleProviderRequest(char opType, CloseableAddableIterator<CIMInstance> caIterator, CIMObjectPath target, boolean deep, String[] propertyList, String assocClass, String resultClass, String role, String resultRole) {
            this.operation = opType;
            this.caIterator = caIterator;
            this.requestObjectPath = target;
            this.deep = deep;
            this.propertyList = propertyList;
            this.assocClass = assocClass;
            this.resultClass = resultClass;
            this.role = role;
            this.resultRole = resultRole;
            this.userName = JServer.this.mProviderClient.getProperty("javax.wbem.provider.Principal");
            this.sessionID = JServer.this.mProviderClient.getProperty("javax.wbem.provider.SessionID");
        }

        public ProcessOldStyleProviderRequest(CloseableAddableIterator<CIMInstance> caIterator, CIMObjectPath target, boolean deep, String[] propertyList) {
            this('\u0001', caIterator, target, deep, propertyList, null, null, null, null);
        }

        public ProcessOldStyleProviderRequest(CloseableAddableIterator<CIMInstance> caIterator, CIMObjectPath target, String assocClass, String resultClass, String role, String resultRole, String[] propertyList) {
            this('\u0002', caIterator, target, true, propertyList, assocClass, resultClass, role, resultRole);
        }

        public ProcessOldStyleProviderRequest(CloseableAddableIterator<CIMInstance> caIterator, CIMObjectPath target, String assocClass, String role, String[] propertyList) {
            this('\u0003', caIterator, target, true, propertyList, assocClass, null, role, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JServer.this.mProviderClient.setThreadData(this.userName, this.sessionID);
            Thread thread = Thread.currentThread();
            StringBuilder tgName = new StringBuilder(thread.getThreadGroup().getName());
            tgName = tgName.append(':');
            tgName = tgName.append('(');
            tgName = tgName.append(this.requestObjectPath.getObjectName());
            tgName = tgName.append(')');
            thread.setName(tgName.toString());
            UnsignedInteger32 maxObjects = new UnsignedInteger32((long)JServer.this.mMaxObjectForNonPull);
            try {
                EnumerateResponse<CIMInstance> response = '\u0001' == this.operation ? JServer.this.intenumInstances(this.requestObjectPath, this.deep, this.propertyList, null, null, null, false, maxObjects) : ('\u0002' == this.operation ? JServer.this.intassociators(this.requestObjectPath, this.assocClass, this.resultClass, this.role, this.resultRole, this.propertyList, null, null, null, false, maxObjects) : JServer.this.intreferences(this.requestObjectPath, this.assocClass, this.role, this.propertyList, null, null, null, false, maxObjects));
                boolean gotFirst = false;
                while (!gotFirst || !response.isEnd()) {
                    if (gotFirst) {
                        response = JServer.this.intGetInstancesWithPath(this.requestObjectPath, response.getContext(), maxObjects);
                    } else {
                        gotFirst = true;
                    }
                    CloseableIterator iter = response.getResponses();
                    while (null != iter && iter.hasNext()) {
                        this.caIterator.add(iter.next());
                    }
                }
                this.caIterator.done();
            }
            catch (WBEMException e) {
                this.caIterator.setException(e);
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    if (!((t = t.getCause()) instanceof WBEMException)) continue;
                    this.caIterator.setException((WBEMException)t);
                    break;
                }
                if (null == this.caIterator.getWBEMException()) {
                    this.caIterator.setException(new WBEMException(1, t.getMessage(), null, t));
                }
            }
            finally {
                this.caIterator.done();
                thread.setName(tgName.append("- idle").toString());
                JServer.this.mProviderClient.setThreadData(null, null);
            }
        }
    }

    private abstract class EnumerateThread
    implements Callable<Boolean> {
        protected CIMObjectPath mOP;
        protected String mFilterQueryLanguage;
        protected String mFilterQuery;
        protected boolean mContinueOnError;
        protected Provider mProvider;
        protected final String mUserName;
        protected final String mSessionID;

        public EnumerateThread(CIMObjectPath pOP, Provider pProvider, String pFilterQueryLanguage, String pFilterQuery, boolean pContinueOnError) {
            this.mOP = pOP;
            this.mProvider = pProvider;
            this.mFilterQueryLanguage = pFilterQueryLanguage;
            this.mFilterQuery = pFilterQuery;
            this.mContinueOnError = pContinueOnError;
            this.mUserName = JServer.this.mProviderClient.getProperty("javax.wbem.provider.Principal");
            this.mSessionID = JServer.this.mProviderClient.getProperty("javax.wbem.provider.SessionID");
        }
    }

    private class EnumerateInstancesThread
    extends EnumerateThread {
        protected boolean mDeep;
        protected String[] mPropertyList;
        protected String[] mDeepPropertyList;
        private final CloseableAddableIterator<CIMInstance> mCAIterator;

        public EnumerateInstancesThread(CIMObjectPath pOP, boolean pDeep, String[] pPropertyList, String[] pDeepPropertyList, String pFilterQueryLanguage, String pFilterQuery, boolean pContinueOnError, Provider pProv, CloseableAddableIterator<CIMInstance> pCAIterator) {
            super(pOP, pProv, pFilterQueryLanguage, pFilterQuery, pContinueOnError);
            this.mDeep = pDeep;
            this.mPropertyList = pPropertyList;
            this.mDeepPropertyList = pDeepPropertyList;
            this.mCAIterator = pCAIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            JServer.this.mProviderClient.setThreadData(this.mUserName, this.mSessionID);
            Thread thread = Thread.currentThread();
            String tgName = thread.getThreadGroup().getName();
            thread.setName(tgName + ":" + "EnumerateInstancesThread - " + this.mOP.getObjectName());
            try {
                CloseableIterator iter = null;
                if (JServer.this.mLogger.isLoggable(Level.INFO)) {
                    JServer.this.mLogger.log(Level.INFO, JServer.TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.ENUMERATEINSTANCES, this.mOP.getObjectName()});
                    if (JServer.this.mLogger.isLoggable(Level.FINE)) {
                        JServer.this.mLogger.log(Level.FINE, "Parameters passed to {0}, PropertyList: {1}, ", new Object[]{WBEMOperation.ENUMERATEINSTANCES, this.mPropertyList});
                    }
                }
                iter = ((PullInstanceProvider)this.mProvider).enumerateInstances(this.mOP, this.mPropertyList, this.mFilterQueryLanguage, this.mFilterQuery, this.mContinueOnError);
                if (JServer.this.mLogger.isLoggable(Level.INFO)) {
                    JServer.this.mLogger.log(Level.INFO, JServer.TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.ENUMERATEINSTANCES, this.mOP.getObjectName()});
                }
                while (null != iter && iter.hasNext()) {
                    if (this.mCAIterator.isClosed()) {
                        iter.close();
                        Boolean bl = true;
                        return bl;
                    }
                    CIMInstance ci = (CIMInstance)iter.next();
                    if (this.mDeep) {
                        this.mCAIterator.add((Object)ci);
                        continue;
                    }
                    this.mCAIterator.add((Object)ci.filterProperties(this.mDeepPropertyList));
                }
            }
            catch (WBEMException we) {
                this.mCAIterator.setException(we);
                if (!this.mContinueOnError) {
                    this.mCAIterator.close();
                }
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    if (!((t = t.getCause()) instanceof WBEMException)) continue;
                    this.mCAIterator.setException((WBEMException)t);
                    break;
                }
                if (null == this.mCAIterator.getWBEMException()) {
                    this.mCAIterator.setException(new WBEMException(1, t.getMessage(), null, t));
                }
                if (!this.mContinueOnError) {
                    this.mCAIterator.close();
                }
            }
            finally {
                thread.setName(tgName + ":" + "EnumerateInstancesThread - idle");
                JServer.this.mProviderClient.setThreadData(null, null);
            }
            return new Boolean(true);
        }
    }

    private class AssociatorsThread
    extends EnumerateThread {
        private final CIMObjectPath mAssocName;
        private final String mResultClass;
        private final String mRole;
        private final String mResultRole;
        private final String[] mPropertyList;
        private final CloseableAddableIterator<CIMInstance> mCAIterator;

        public AssociatorsThread(CIMObjectPath pAssocName, CIMObjectPath pOP, String pResultClass, String pRole, String pResultRole, String[] pPropertyList, String pFilterQueryLanguage, String pFilterQuery, boolean pContinueOnError, Provider pProv, CloseableAddableIterator<CIMInstance> pCAIterator) {
            super(pOP, pProv, pFilterQueryLanguage, pFilterQuery, pContinueOnError);
            this.mResultClass = pResultClass;
            this.mRole = pRole;
            this.mResultRole = pResultRole;
            this.mPropertyList = pPropertyList;
            this.mAssocName = pAssocName;
            this.mCAIterator = pCAIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            JServer.this.mProviderClient.setThreadData(this.mUserName, this.mSessionID);
            Thread thread = Thread.currentThread();
            String tgName = thread.getThreadGroup().getName();
            thread.setName(tgName + ":" + "AssociatorsThread - " + this.mOP.getObjectName());
            try {
                CloseableIterator iter = null;
                if (JServer.this.mLogger.isLoggable(Level.INFO)) {
                    JServer.this.mLogger.log(Level.INFO, JServer.TRACE_PROVIDER_CALL, new Object[]{WBEMOperation.OPENASSOCIATORS, this.mAssocName.getObjectName()});
                    if (JServer.this.mLogger.isLoggable(Level.FINE)) {
                        JServer.this.mLogger.log(Level.FINE, "Parameters passed to {0}, Role: {1}, ResultRole: {2}, ResultClass: {3}, PropertyList: {4}", new Object[]{WBEMOperation.OPENASSOCIATORS, this.mRole, this.mResultRole, this.mResultClass, Arrays.toString(this.mPropertyList)});
                    }
                }
                iter = ((PullAssociatorProvider)this.mProvider).associators(this.mAssocName, this.mOP, this.mResultClass, this.mRole, this.mResultRole, this.mPropertyList, this.mFilterQueryLanguage, this.mFilterQuery, this.mContinueOnError);
                if (JServer.this.mLogger.isLoggable(Level.INFO)) {
                    JServer.this.mLogger.log(Level.INFO, JServer.TRACE_PROVIDER_RETURN, new Object[]{WBEMOperation.OPENASSOCIATORS, this.mAssocName.getObjectName()});
                }
                while (null != iter && iter.hasNext()) {
                    if (this.mCAIterator.isClosed()) {
                        iter.close();
                        Boolean bl = true;
                        return bl;
                    }
                    this.mCAIterator.add(iter.next());
                }
            }
            catch (WBEMException we) {
                this.mCAIterator.setException(we);
                if (!this.mContinueOnError) {
                    this.mCAIterator.close();
                }
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    if (!((t = t.getCause()) instanceof WBEMException)) continue;
                    this.mCAIterator.setException((WBEMException)t);
                    break;
                }
                if (null == this.mCAIterator.getWBEMException()) {
                    this.mCAIterator.setException(new WBEMException(1, t.getMessage(), null, t));
                }
                if (!this.mContinueOnError) {
                    this.mCAIterator.close();
                }
            }
            finally {
                thread.setName(tgName + ":" + "AssociatorsThread - idle");
                JServer.this.mProviderClient.setThreadData(null, null);
            }
            return new Boolean(true);
        }
    }
}

