/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.security.auth.Subject;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public final class WBEMServerAuthentication
extends Authenticator {
    private final Subject mSubject;
    private final String mClientHost;
    private final String mScheme;
    private final Locale[] mLocales;
    private final String mServerHost;
    private final String mPort;

    public WBEMServerAuthentication(Subject subject, Locale[] locales, String clientHost) {
        this(subject, locales, clientHost, null, null, null);
    }

    public WBEMServerAuthentication(Subject subject, Locale[] locales, String clientHost, String scheme, String serverHost, String port) {
        this.mSubject = subject;
        this.mLocales = locales;
        this.mClientHost = clientHost;
        this.mScheme = null == scheme ? "" : scheme;
        this.mServerHost = null == serverHost ? "" : serverHost;
        this.mPort = port;
        Authenticator.setDefault(this);
    }

    public char[] getCredential() {
        Set<PasswordCredential> sPC = this.mSubject.getPrivateCredentials(PasswordCredential.class);
        Iterator<PasswordCredential> iSP = sPC.iterator();
        PasswordCredential pcI = null;
        while (iSP.hasNext()) {
            pcI = iSP.next();
        }
        return null != pcI ? pcI.getUserPassword() : null;
    }

    public String getHost() {
        return this.mClientHost;
    }

    public Locale[] getLocales() {
        return this.mLocales;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.getUserName(), this.getCredential());
    }

    public String getPort() {
        return this.mPort;
    }

    public String getScheme() {
        return this.mScheme;
    }

    public String getServerHost() {
        return this.mServerHost;
    }

    public Subject getSubject() {
        return this.mSubject;
    }

    public String getUserName() {
        Set<UserPrincipal> sUP = this.mSubject.getPrincipals(UserPrincipal.class);
        Iterator<UserPrincipal> iUP = sUP.iterator();
        UserPrincipal upI = null;
        while (iUP.hasNext()) {
            upI = iUP.next();
        }
        return null != upI ? upI.getName() : null;
    }
}

