/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.common;

import com.ws.wbem.jserver.JServerProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;

public class CommonProviderUtils {
    protected static Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private static final String CPN_SYSTEMNAME = "SystemName";
    protected static final String UNKNOWN = "unknown";

    public static CIMInstance cleanAssociationSystemName(CIMInstance pInst) {
        CIMProperty[] keys;
        CIMInstance ret = pInst;
        if (pInst != null && (keys = pInst.getKeys()) != null && keys.length == 2 && keys[0] != null && keys[1] != null) {
            CIMObjectPath op = pInst.getObjectPath();
            CIMObjectPath ref1 = CommonProviderUtils.cleanSystemName((CIMObjectPath)keys[0].getValue());
            CIMObjectPath ref2 = CommonProviderUtils.cleanSystemName((CIMObjectPath)keys[1].getValue());
            CIMProperty[] newKeys = new CIMProperty[]{new CIMProperty(keys[0].getName(), keys[0].getDataType(), (Object)ref1, keys[0].isKey()), new CIMProperty(keys[1].getName(), keys[1].getDataType(), (Object)ref2, keys[1].isKey())};
            ret = pInst.deriveInstance(newKeys);
            if (op != null) {
                ret = ret.deriveInstance(new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), newKeys));
            }
        }
        return ret;
    }

    public static CIMInstance cleanSystemName(CIMInstance pInst) {
        return CommonProviderUtils.modifyStringPropertyValue(pInst, CPN_SYSTEMNAME, UNKNOWN);
    }

    public static CIMObjectPath cleanSystemName(CIMObjectPath pOP) {
        return CommonProviderUtils.modifyStringPropertyValue(pOP, CPN_SYSTEMNAME, UNKNOWN);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized String getWBEMServerName() {
        String NAME = "WBEMServer.Name";
        String nameValue = UUID.randomUUID().toString();
        String dir = JServerProperties.getRepositoryDirectory();
        Properties p = new Properties();
        String fileName = dir + File.separatorChar + "provider.properties";
        File f = new File(fileName);
        if (f.exists()) {
            try {
                p.load(new FileInputStream(fileName));
                nameValue = p.getProperty("WBEMServer.Name");
                if (null != nameValue) return nameValue;
            }
            catch (Exception e) {
                mLogger.log(Level.WARNING, "Received exception when trying to load Provider.properties file");
            }
            return nameValue;
        }
        nameValue = UUID.randomUUID().toString();
        p.setProperty("WBEMServer.Name", nameValue);
        try {
            p.store(new FileOutputStream(fileName), null);
            return nameValue;
        }
        catch (Exception e) {
            mLogger.log(Level.WARNING, "Received exception when trying to store Provider.properties file");
        }
        {
            // empty if block
        }
        return nameValue;
    }

    public static CIMInstance modifyStringPropertyValue(CIMInstance pInst, String pPropName, String pPropValue) {
        CIMInstance ret = pInst;
        if (pInst != null) {
            CIMProperty[] props = pInst.getProperties();
            CIMProperty[] newProps = new CIMProperty[props.length];
            for (int i = 0; i < props.length; ++i) {
                CIMProperty prop = props[i];
                newProps[i] = null != prop && pPropName.equals(prop.getName()) ? new CIMProperty(pPropName, CIMDataType.STRING_T, (Object)pPropValue, prop.isKey()) : prop;
            }
            CIMObjectPath newOP = CommonProviderUtils.modifyStringPropertyValue(pInst.getObjectPath(), pPropName, pPropValue);
            ret = new CIMInstance(newOP, newProps);
        }
        return ret;
    }

    public static CIMObjectPath modifyStringPropertyValue(CIMObjectPath pOP, String pPropName, String pPropValue) {
        CIMObjectPath ret = pOP;
        if (pOP != null && pOP.getKeys() != null) {
            CIMProperty[] keys = pOP.getKeys();
            CIMProperty[] newKeys = new CIMProperty[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                CIMProperty key = keys[i];
                newKeys[i] = null != key && pPropName.equals(key.getName()) ? new CIMProperty(pPropName, CIMDataType.STRING_T, (Object)pPropValue, true) : key;
            }
            ret = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), pOP.getObjectName(), newKeys);
        }
        return ret;
    }

    public static CIMInstance fixSystemName(CIMInstance pInst) {
        return CommonProviderUtils.modifyStringPropertyValue(pInst, CPN_SYSTEMNAME, JServerProperties.getServerHost());
    }

    public static CIMObjectPath fixSystemName(CIMObjectPath pOP) {
        return CommonProviderUtils.modifyStringPropertyValue(pOP, CPN_SYSTEMNAME, JServerProperties.getServerHost());
    }
}

