/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.dmtf.wbemserver;

import com.ws.utilities.CipherUtilities;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;

public abstract class ProtocolServiceSettingsDataProvider
extends BaseInstanceProvider {
    private static final UnsignedInteger16 CAV_REQUESTEDSTATE_RESET = new UnsignedInteger16(11);
    private static final long ERR_UNSPECIFIED_ERROR = 1L;
    private static final long ERR_INVALID_PARAMETER = 2L;
    private static final long ERR_NO_CIPHERS = 3L;
    private static final long ERR_EMPTY_CIPHERS = 4L;
    private static final long ERR_INVALID_CIPHERS = 5L;

    public static CIMInstance fixSettingDataInstance(BaseInstanceProvider baseProvider, CIMInstance pInstSettingData, String[] propertyList) {
        CIMInstance ret = pInstSettingData;
        if (null != ret && (null == propertyList || propertyList.length > 0)) {
            HashSet<String> propNameSet = new HashSet<String>();
            if (null != propertyList) {
                for (String propName : propertyList) {
                    propNameSet.add(propName.toLowerCase());
                }
            }
            String[] supportedCiphers = null;
            String[] defaultCiphers = null;
            try {
                supportedCiphers = CipherUtilities.getSupportedJavaCiphers();
                defaultCiphers = CipherUtilities.getDefaultJavaCiphers();
            }
            catch (WBEMException we) {
                Throwable t = we.getCause();
                mLogger.log(Level.SEVERE, "Could not get supported or default cipher suites", null == t ? we : t);
                return ret;
            }
            ArrayList<CIMProperty> newProps = new ArrayList<CIMProperty>();
            if (null == propertyList || propNameSet.contains("SupportedCipherSuites".toLowerCase())) {
                newProps.add(new CIMProperty("SupportedCipherSuites", CIMDataType.STRING_ARRAY_T, (Object)supportedCiphers, false));
            }
            if (null == propertyList || propNameSet.contains("DefaultCipherSuites".toLowerCase())) {
                newProps.add(new CIMProperty("DefaultCipherSuites", CIMDataType.STRING_ARRAY_T, (Object)defaultCiphers, false));
            }
            if ((null == propertyList || propNameSet.contains("EnabledCipherSuites".toLowerCase())) && null == ret.getPropertyValue("EnabledCipherSuites")) {
                newProps.add(new CIMProperty("EnabledCipherSuites", CIMDataType.STRING_ARRAY_T, (Object)defaultCiphers, false));
            }
            ret = baseProvider.deriveInstance(pInstSettingData, newProps.toArray(new CIMProperty[newProps.size()]));
        }
        return ret;
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        ArrayList<CIMInstance> l = new ArrayList<CIMInstance>();
        CloseableIterator i = mInternalProvider.enumerateInstances(op, propertyList, filterQueryLanguage, filterQuery, continueOnError);
        while (i.hasNext()) {
            CIMInstance ci = (CIMInstance)i.next();
            ci = ProtocolServiceSettingsDataProvider.fixSettingDataInstance(this, ci, propertyList);
            l.add(this.cleanInstance(op, ci));
        }
        return new CloseableAddableIterator(l);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        CIMInstance instSettingData = mInternalProvider.getInstance(op, propertyList);
        instSettingData = ProtocolServiceSettingsDataProvider.fixSettingDataInstance(this, instSettingData, propertyList);
        return this.cleanInstance(op, instSettingData);
    }

    protected CIMObjectPath getProtocolService(CIMObjectPath opSettingData) {
        CIMObjectPath opProtocolService = null;
        try {
            CloseableIterator iter = mHandle.associatorInstances(opSettingData, null, null, null, null, null);
            if (iter.hasNext()) {
                opProtocolService = ((CIMInstance)iter.next()).getObjectPath();
            }
        }
        catch (WBEMException we) {
            mLogger.log(Level.SEVERE, "Caught exception trying to find ProtocolService that is associated to SettingData instance {0}", opSettingData);
        }
        return opProtocolService;
    }

    @Override
    public Object invokeMethod(CIMObjectPath op, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        long ret = 0L;
        if ("SetEnabledCipherSuites".equals(methodName)) {
            String[] ciphers = null;
            boolean foundCipherArg = false;
            for (CIMArgument<?> arg : inArgs) {
                if ("CipherSuites".equals(arg.getName())) {
                    foundCipherArg = true;
                    ciphers = (String[])arg.getValue();
                    String invalidCiphers = CipherUtilities.validateCiphers((String[])ciphers);
                    if (null == invalidCiphers) continue;
                    mLogger.log(Level.SEVERE, "Invalid Cipher values passed to SetEnabledCipherSuites: {0}", invalidCiphers);
                    ret = 5L;
                    continue;
                }
                mLogger.log(Level.SEVERE, "There was an invalid parameter passed to SetEnabledCipherSuites: {0}", arg.getName());
                ret = 2L;
            }
            if (ret == 0L) {
                if (!foundCipherArg) {
                    ret = 3L;
                    mLogger.log(Level.SEVERE, "Method argument \"{0}\" was missing from call to SetEnabledCipherSuites", "CipherSuites");
                } else if (ret == 0L && null != ciphers && ciphers.length == 0) {
                    ret = 4L;
                    mLogger.severe("Empty Cipher list passed to SetEnabledCipherSuites method");
                } else {
                    CloseableIterator iter = mInternalProvider.enumerateInstances(op, null, null, null, false);
                    if (iter.hasNext()) {
                        CIMInstance instSettings = (CIMInstance)iter.next();
                        CIMProperty[] newProps = new CIMProperty[]{new CIMProperty("EnabledCipherSuites", CIMDataType.STRING_ARRAY_T, (Object)ciphers, false)};
                        CIMInstance derivedInstance = this.deriveInstance(instSettings, newProps);
                        mInternalProvider.modifyInstance(derivedInstance, new String[]{"EnabledCipherSuites"});
                        CIMObjectPath opProtocolService = this.getProtocolService(op);
                        if (null == opProtocolService) {
                            mLogger.severe("Could not find instance of ProtocolService that is associated to the SettingData instance:" + op + ".  Cannot restart it using new " + "Cipher Suites");
                        } else {
                            this.resetProtocolService(opProtocolService);
                        }
                    } else {
                        ret = 1L;
                        mLogger.log(Level.SEVERE, "Could not find instance of Settings Class: {0}", op);
                    }
                }
            }
        } else {
            throw new WBEMException(17, methodName);
        }
        return new UnsignedInteger32(ret);
    }

    private void resetProtocolService(final CIMObjectPath opProtocolService) {
        Runnable psRestarter = new Runnable(){

            @Override
            public void run() {
                try {
                    CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("RequestedState", CIMDataType.UINT16_T, (Object)CAV_REQUESTEDSTATE_RESET)};
                    Thread.sleep(1000L);
                    mHandle.invokeMethod(opProtocolService, "RequestStateChange", inArgs, new CIMArgument[1]);
                    mLogger.log(Level.FINE, "Enabled Cipher suites modified, Resetting ProtocolAdapter: {0}", opProtocolService);
                }
                catch (Throwable e) {
                    mLogger.log(Level.SEVERE, "Caught exception trying to restart ProtocolService: " + opProtocolService, e);
                }
            }
        };
        Thread t = new Thread(psRestarter);
        t.setDaemon(true);
        t.setName("resetProtocolService");
        t.start();
    }
}

