/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.services;

import com.ws.wbem.jserver.ClientProtocolAdapter;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.jserver.embed.EndPoint;
import com.ws.wbem.jserver.embed.Protocol;
import com.ws.wbem.jserver.profiles.common.EnabledDefault;
import com.ws.wbem.jserver.profiles.common.EnabledState;
import com.ws.wbem.jserver.profiles.common.ProtocolIFType;
import com.ws.wbem.jserver.profiles.common.WSBaseProvider;
import com.ws.wbem.jserver.profiles.dmtf.wbemserver.TCPProtocolEndpointProvider;
import com.ws.wbem.jserver.services.JServerEndpointHTTP;
import com.ws.wbem.jserver.services.ProtocolServiceService;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class JServerProtocol
extends WSBaseProvider
implements Protocol {
    private boolean mDefaultEnabled;
    private final ArrayList<JServerEndpointHTTP> mEndpoints = new ArrayList();
    private final String mProtocol;
    private final ClientProtocolAdapter mAdapter;

    public JServerProtocol(String protocol, boolean defaultEnabled, ProviderHandle handle, WBEMServer server, ClientProtocolAdapter protocolAdapter) throws WBEMException {
        this.mAdapter = protocolAdapter;
        this.mProtocol = protocol;
        this.mDefaultEnabled = defaultEnabled;
        this.initialize(handle);
    }

    public void addEndpoint(JServerEndpointHTTP endpoint) throws WBEMException {
        if (null != endpoint) {
            this.mEndpoints.add(endpoint);
        }
    }

    @Override
    public void close() {
        EndPoint[] endPts = this.getEndPoints();
        if (null != endPts) {
            Logger logger = Logger.getLogger("com.ws.wbem.jserver");
            for (EndPoint endPt : endPts) {
                if (null == endPt) continue;
                try {
                    logger.log(Level.INFO, "Stopping end point {0}", endPt);
                    this.stopEndpoint(endPt.getPort());
                }
                catch (Throwable t) {
                    LogRecord rec = new LogRecord(Level.WARNING, "Stopping end point {0} failed");
                    rec.setParameters(new Object[]{endPt});
                    rec.setThrown(t);
                    logger.log(rec);
                }
            }
        }
    }

    public boolean getEnabledDefault() {
        return this.mDefaultEnabled;
    }

    public EndPoint[] getEndPoints() {
        return this.mEndpoints.toArray(new EndPoint[this.mEndpoints.size()]);
    }

    private JServerEndpointHTTP getJServerEndpoint(int port) {
        JServerEndpointHTTP ret = null;
        for (JServerEndpointHTTP jserverEndpoint : this.mEndpoints) {
            if (jserverEndpoint.getPort() != port) continue;
            ret = jserverEndpoint;
            break;
        }
        return ret;
    }

    public String getProtocolName() {
        return this.mProtocol;
    }

    public void removeEndpoint(EndPoint endpoint) throws WBEMException {
        if (null != endpoint) {
            this.stopEndpoint(endpoint.getPort());
            if (!this.mEndpoints.remove(endpoint)) {
                mLogger.log(Level.WARNING, "Could not remove endpoint {0} from protocol {1}");
                throw new WBEMException(6);
            }
            CIMObjectPath op = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), "", null);
            CIMObjectPath opEndpoint = TCPProtocolEndpointProvider.generateTCPProtocolEndpointObjectPath(op, this.mProtocol, endpoint.getName());
            mInternalProvider.deleteInstance(this.cleanSystemName(opEndpoint));
        }
    }

    public void setEnabledDefault(boolean enabled) throws WBEMException {
        EnabledDefault oldEnabledDefault;
        EnabledDefault newEnabledDefault = EnabledDefault.getEnabledDefault(enabled);
        CIMObjectPath op = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), "", null);
        CIMInstance instProtocolService = ProtocolServiceService.getService().getProtocolServiceInstance(op, this);
        UnsignedInteger16 cpvEnabledDefault = (UnsignedInteger16)instProtocolService.getPropertyValue("EnabledDefault");
        EnabledDefault enabledDefault = oldEnabledDefault = null != cpvEnabledDefault ? EnabledDefault.getEnabledDefault(cpvEnabledDefault.intValue()) : EnabledDefault.Enabled;
        if (null == oldEnabledDefault || newEnabledDefault != oldEnabledDefault) {
            CIMProperty[] newProps = new CIMProperty[]{new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(newEnabledDefault.getValue()))};
            instProtocolService = instProtocolService.deriveInstance(newProps);
            mInternalProvider.modifyInstance(instProtocolService, new String[]{"EnabledDefault"});
            this.mDefaultEnabled = enabled;
        }
    }

    public EndPoint startEndpoint(int port, String scheme, InetAddress boundedAddress) throws WBEMException {
        JServerEndpointHTTP endpoint = this.getJServerEndpoint(port);
        if (null != endpoint) {
            if (null == endpoint.getBoundToAddress() && null != boundedAddress || null != endpoint.getBoundToAddress() && !endpoint.getBoundToAddress().equals(boundedAddress)) {
                endpoint.resetEndpoint(port, boundedAddress);
            } else {
                endpoint.startEndpoint();
            }
        } else {
            String name = TCPProtocolEndpointProvider.generateNameValue(this.mProtocol, scheme);
            endpoint = new JServerEndpointHTTP(this.mAdapter, name, port, ProtocolIFType.getProtocolIFType(scheme), this.mAdapter.getProtocolName(), boundedAddress, true, mHandle);
            endpoint.startEndpoint();
            CIMObjectPath op = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), "", null);
            CIMInstance instEndpoint = this.cleanSystemName(TCPProtocolEndpointProvider.generateTCPProtocolEndpointInstance(op, this, endpoint, EnabledState.Disabled));
            mInternalProvider.createInstance(instEndpoint);
            this.mEndpoints.add(endpoint);
        }
        return endpoint;
    }

    public void stopEndpoint(int port) {
        JServerEndpointHTTP jserverEndpoint = this.getJServerEndpoint(port);
        if (null != jserverEndpoint) {
            jserverEndpoint.stopEndpoint();
        }
    }
}

