/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.util;

import com.hitachi.sanproject.util.SanInputStreamThread;
import com.hitachi.sanproject.util.SanProcessUtility;
import com.hitachi.sanproject.util.SanProperties;
import com.hitachi.sanproject.util.SanStatus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SanProcess {
    public static final int STATUS_STOPPED = 0;
    public static final int STATUS_READY = 1;
    public static final int STATUS_INITIALIZING = 2;
    public static final int STATUS_STOPPING = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_WARNING = 5;
    public static final String OSS_DIR = ".." + File.separator + ".." + File.separator + ".." + File.separator + "oss";
    public static final String FILENAME_STOPFORCIBLY = "cnf" + File.separator + "stopForcibly";
    public static final String FILENAME_SETTING_PROPERTIES = "cnf" + File.separator + "setting.properties";
    public static final String FILENAME_SETTING_PROPERTIES_DEFAULT = "cnf" + File.separator + "default" + File.separator + "setting.properties";
    public static final String KEY_COMMAND_JAVA = "com.hitachi.sanproject.command.java";
    public static final String KEY_COMMAND_CLASS = "com.hitachi.sanproject.command.class";
    public static final String KEY_COMMAND_CLASSPATH = "com.hitachi.sanproject.command.cp";
    public static final String KEY_COMMAND_PROCESS_PARAM = "com.hitachi.sanproject.command.param";
    public static final String KEY_PROCESS_STARTUP = "com.hitachi.sanproject.process.startup";
    public static final String KEY_PROCESS_UPGRADING = "com.hitachi.sanproject.process.upgrading";
    public static final String KEY_SECURITY_POLICY = "java.security.policy";
    public static final String FORMAT_DKC_DIRNAME = "%04d00%06d";
    public static final String FORMAT_SUBPROCESS_NAME = "%04d00%06d.%s";
    public static final String KEY_STORAGE_DKCID = "com.hitachi.sanproject.storage.dkcid";
    public static final String KEY_STORAGE_MODEL = "com.hitachi.sanproject.storage.model";
    public static final String KEY_STORAGE_SERIALNUMBER = "com.hitachi.sanproject.storage.serialnumber";
    public static final String KEY_SOFTWARE_VERSION = "com.hitachi.sanproject.software.version";
    public static final String KEY_CONFIG_VERSION = "com.hitachi.sanproject.config.version";
    protected ProcessBuilder processBuilder;
    protected Process process;
    protected SanInputStreamThread in;
    protected SanInputStreamThread err_in;
    protected SanProperties settingProperties;
    protected SanProperties dkcProperties;
    protected String processDirName;
    protected String dkcId;
    protected int status;

    public SanProcess(SanProperties sanProperties) {
        this.dkcProperties = sanProperties;
        this.processBuilder = new ProcessBuilder(new String[0]);
        this.status = 0;
    }

    public boolean setSubProcessDir(File file, String string) {
        this.processDirName = string;
        String string2 = String.format("%s%s%s", file.getPath(), File.separator, string);
        File file2 = new File(string2);
        this.processBuilder.directory(file2);
        this.settingProperties = SanProcess.readSettingProperties(file2);
        if (this.settingProperties == null) {
            return false;
        }
        String[] stringArray = file.getPath().split("\\\\");
        this.dkcId = stringArray[stringArray.length - 1];
        this.processBuilder.command(SanProcess.getCommand(this.settingProperties, this.dkcId));
        return true;
    }

    protected static SanProperties readSettingProperties(File file) {
        File file2 = new File(String.format("%s%s%s", file.getPath(), File.separator, FILENAME_SETTING_PROPERTIES_DEFAULT));
        File file3 = new File(String.format("%s%s%s", file.getPath(), File.separator, FILENAME_SETTING_PROPERTIES));
        SanProperties sanProperties = null;
        if (file2.exists()) {
            sanProperties = new SanProperties(file2);
        }
        if (file3.exists()) {
            SanProperties sanProperties2 = new SanProperties(file3);
            if (sanProperties != null) {
                sanProperties.setProperty(KEY_PROCESS_STARTUP, sanProperties2.getProperty(KEY_PROCESS_STARTUP));
                sanProperties.setProperty(KEY_PROCESS_UPGRADING, sanProperties2.getProperty(KEY_PROCESS_UPGRADING));
                sanProperties.setFile(file3);
                sanProperties.writeProperties();
            } else {
                sanProperties = sanProperties2;
            }
        } else if (sanProperties != null) {
            sanProperties.setFile(file3);
            sanProperties.writeProperties();
        } else {
            return null;
        }
        return sanProperties;
    }

    protected static List<String> getCommand(SanProperties sanProperties, String string) {
        String string2 = sanProperties.getProperty(KEY_COMMAND_JAVA);
        String string3 = sanProperties.getProperty(KEY_COMMAND_CLASSPATH);
        String string4 = sanProperties.getProperty(KEY_COMMAND_CLASS);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%2$s%1$s%3$s%1$sbin%1$sjava", File.separator, OSS_DIR, string2));
        int n = 1;
        while (sanProperties.getProperty(KEY_COMMAND_PROCESS_PARAM + n) != null) {
            arrayList.add(sanProperties.getProperty(KEY_COMMAND_PROCESS_PARAM + n));
            ++n;
        }
        arrayList.add("-cp");
        arrayList.add(string3.replace(';', File.pathSeparatorChar));
        arrayList.add(string4);
        arrayList.add(string);
        return arrayList;
    }

    public String name() {
        try {
            int n = Integer.parseInt(this.dkcProperties.getProperty(KEY_STORAGE_MODEL));
            int n2 = Integer.parseInt(this.dkcProperties.getProperty(KEY_STORAGE_SERIALNUMBER));
            return SanProcess.createName(n, n2, this.processDirName);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String createDkcDirName(int n, int n2) {
        return String.format(FORMAT_DKC_DIRNAME, n, n2);
    }

    public String dkcId() {
        return this.dkcId;
    }

    public static String createName(int n, int n2, String string) {
        return String.format(FORMAT_SUBPROCESS_NAME, n, n2, string);
    }

    public static String getSerialNumberFromName(String string) {
        try {
            return string.substring(6, 12);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public SanProperties getSettingProperties() {
        return this.settingProperties;
    }

    public SanProperties getDkcProperties() {
        return this.dkcProperties;
    }

    public List<String> command() {
        return this.processBuilder.command();
    }

    public File directory() {
        return this.processBuilder.directory();
    }

    public void start() throws IOException {
        this.process = this.processBuilder.start();
        if (this.process == null) {
            return;
        }
        this.in = new SanInputStreamThread(this.process.getInputStream());
        this.err_in = new SanInputStreamThread(this.process.getErrorStream());
        this.in.start();
        this.err_in.start();
    }

    public void destroy() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void stopTraceLog() throws InterruptedException {
        this.in.stopReading();
        this.err_in.stopReading();
        this.in.join();
        this.err_in.join();
    }

    public String getInputStreamLog() {
        if (this.in != null) {
            return this.in.toString();
        }
        return "";
    }

    public String getErrorStreamLog() {
        if (this.err_in != null) {
            return this.err_in.toString();
        }
        return "";
    }

    public boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    public int exitValue() {
        if (this.process != null) {
            return this.process.exitValue();
        }
        return 0;
    }

    public int getStatus() {
        int n = 0;
        n = SanProcessUtility.isStatusBatSupport(this.directory().getParent(), this.processDirName) ? SanStatus.getRMIStatusCodeFromStatusCode(SanProcessUtility.getStatusCodeFromStatusBat(this.directory().getPath())) : this.status;
        return n;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public boolean isStopForcibly() {
        File file = this.directory();
        File file2 = new File(String.format("%s%s%s", file.getPath(), File.separator, FILENAME_STOPFORCIBLY));
        return file2.exists();
    }

    public void deleteStopForciblyFile() {
        File file = this.directory();
        File file2 = new File(String.format("%s%s%s", file.getPath(), File.separator, FILENAME_STOPFORCIBLY));
        if (file2.exists()) {
            file2.delete();
        }
    }
}

