/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.data;

import com.hitachi.sanproject.data.SanAttrs;
import com.hitachi.sanproject.data.SanClass;
import com.hitachi.sanproject.data.SanDataErrorCode;
import com.hitachi.sanproject.data.SanDataException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class SanClassImpl
implements SanClass,
Serializable {
    private static final long serialVersionUID = -7597536272474276018L;
    protected SanClass parentClass;
    protected int index;
    protected ArrayList<String> memberKeyList;
    protected ArrayList<SanAttrs> memberAttrsList;
    protected ArrayList<SanClassImpl> memberClassList;

    protected SanClassImpl() {
    }

    protected SanClassImpl(SanClass sanClass, int n) {
        this.parentClass = sanClass;
        this.index = n;
    }

    protected SanClassImpl clone() {
        SanClassImpl sanClassImpl = new SanClassImpl();
        sanClassImpl.parentClass = this.parentClass;
        sanClassImpl.index = this.index;
        sanClassImpl.memberKeyList = this.memberKeyList;
        sanClassImpl.memberAttrsList = this.memberAttrsList;
        sanClassImpl.memberClassList = this.memberClassList;
        return sanClassImpl;
    }

    protected SanClassImpl newMemberClass(String string, String string2) throws SanDataException {
        SanClassImpl sanClassImpl = null;
        if (this.memberKeyList == null) {
            this.memberKeyList = new ArrayList();
            this.memberAttrsList = new ArrayList();
            this.memberClassList = new ArrayList();
        }
        this.memberKeyList.add(string);
        this.memberAttrsList.add(new SanAttrs(string2));
        sanClassImpl = new SanClassImpl(this, this.memberKeyList.indexOf(string));
        this.memberClassList.add(sanClassImpl);
        return sanClassImpl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.key().hashCode();
        n = 31 * n + this.attrs().hashCode();
        n = 31 * n + this.memberClassList.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SanClassImpl)) {
            return false;
        }
        SanClassImpl sanClassImpl = (SanClassImpl)object;
        if (!this.key().equals(sanClassImpl.key())) {
            return false;
        }
        if (!this.attrs().equals(sanClassImpl.attrs())) {
            return false;
        }
        return this.memberClassList.equals(sanClassImpl.memberClassList);
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public String key() {
        String string = null;
        SanClass sanClass = this.parentClass();
        if (sanClass != null) {
            string = sanClass instanceof SanClassImpl ? ((SanClassImpl)sanClass).memberKeyList.get(this.index) : sanClass.key();
        }
        return string;
    }

    @Override
    public String type() {
        String string = null;
        SanClass sanClass = this.parentClass();
        if (sanClass != null) {
            string = sanClass instanceof SanClassImpl ? ((SanClassImpl)sanClass).memberAttrsList.get(this.index).type() : sanClass.type();
        }
        return string;
    }

    @Override
    public SanAttrs attrs() {
        SanAttrs sanAttrs = null;
        SanClass sanClass = this.parentClass();
        if (sanClass != null) {
            sanAttrs = sanClass instanceof SanClassImpl ? ((SanClassImpl)sanClass).memberAttrsList.get(this.index) : sanClass.attrs();
        }
        return sanAttrs;
    }

    @Override
    public Object attr(String string) throws SanDataException {
        Object object = null;
        SanClass sanClass = this.parentClass();
        if (sanClass != null) {
            if (sanClass instanceof SanClassImpl) {
                SanAttrs sanAttrs = ((SanClassImpl)sanClass).memberAttrsList.get(this.index);
                object = sanAttrs.get(string);
            } else {
                object = sanClass.attr(string);
            }
        }
        return object;
    }

    @Override
    public SanClass parentClass() {
        return this.parentClass;
    }

    protected void connectParentClassNode(ArrayList<String> arrayList) {
        if (this.type().equals("Data")) {
            arrayList.add(this.key());
        } else if (this.type().equals("Object")) {
            arrayList.add(this.key());
        } else if (this.type().equals("List")) {
            arrayList.add(this.key() + "[]");
        } else {
            arrayList.add("");
        }
        SanClass sanClass = this.parentClass();
        if (sanClass != null && sanClass instanceof SanClassImpl) {
            ((SanClassImpl)sanClass).connectParentClassNode(arrayList);
        }
    }

    @Override
    public String path() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.connectParentClassNode(arrayList);
        StringBuilder stringBuilder = null;
        ListIterator<String> listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(256);
            } else {
                stringBuilder.append(".");
            }
            String string = listIterator.previous();
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public int memberIndex(String string) throws SanDataException {
        int n = this.memberKeyList.indexOf(string);
        if (n == -1) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_MEMBER_KEY, String.format("key=%s.%s", this.path(), string));
        }
        return n;
    }

    @Override
    public SanClass memberClass(int n) {
        return this.memberClassList.get(n);
    }

    @Override
    public SanClass memberClass(String string) throws SanDataException {
        return this.memberClass(this.memberIndex(string));
    }

    @Override
    public int numberOfMembers() {
        if (this.memberKeyList == null) {
            return 0;
        }
        return this.memberKeyList.size();
    }

    @Override
    public List<String> memberKeyList() {
        if (this.memberKeyList == null) {
            return Collections.emptyList();
        }
        return (List)this.memberKeyList.clone();
    }

    @Override
    public List<SanClass> memberClassList() {
        if (this.memberClassList == null) {
            return Collections.emptyList();
        }
        return (List)this.memberClassList.clone();
    }

    protected void optimizeMemoryUsage() {
        if (this.memberKeyList != null) {
            this.memberKeyList.trimToSize();
            this.memberAttrsList.trimToSize();
            this.memberClassList.trimToSize();
            for (SanClassImpl sanClassImpl : this.memberClassList) {
                sanClassImpl.optimizeMemoryUsage();
            }
        }
    }

    protected SanClassImpl clone(SanClass sanClass, int n) {
        SanClassImpl sanClassImpl = new SanClassImpl(sanClass, n);
        if (this.memberKeyList != null) {
            int n2 = this.numberOfMembers();
            sanClassImpl.memberKeyList = new ArrayList(n2);
            sanClassImpl.memberAttrsList = new ArrayList(n2);
            sanClassImpl.memberClassList = new ArrayList(n2);
            for (int i = 0; i < n2; ++i) {
                sanClassImpl.memberKeyList.add(this.memberKeyList.get(i));
                sanClassImpl.memberAttrsList.add(this.memberAttrsList.get(i));
                sanClassImpl.memberClassList.add(this.memberClassList.get(i).clone(sanClassImpl, i));
            }
        }
        return sanClassImpl;
    }
}

