/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.data;

import com.hitachi.sanproject.data.SanDataException;

public enum SanDataErrorCode {
    UNKNOWN_ERROR(-1, "Unknown error occurred : "),
    NORMAL_END(0, "Normal end"),
    INVALID_DATA_FILE(0, "Invalid dataFile : "),
    INVALID_MEMBER_KEY(2, "Invalid memberKey : "),
    INVALID_ATTR_KEY(2, "Invalid attrKey : "),
    UNSUPPORTED_TYPE(2, "Unsupported Type : "),
    INVALID_TYPE(2, "Invalid Type : "),
    INVALID_VALUE_FORMAT(2, "Invalid value format : "),
    VALUE_OUT_OF_RANGE(2, "Value out of range : "),
    INVALID_VALUE(2, "Invalid value : "),
    LIST_SIZE_OUT_OF_BOUNDS(2, "List size out of bounds : ");

    private int code;
    private String message;

    private SanDataErrorCode(int n2, String string2) {
        this.code = n2;
        this.message = string2;
    }

    public static SanDataException newException(SanDataErrorCode sanDataErrorCode) {
        return new SanDataException(String.format("%s", sanDataErrorCode.message), sanDataErrorCode.code);
    }

    public static SanDataException newException(SanDataErrorCode sanDataErrorCode, String string) {
        return new SanDataException(String.format("%s%s", sanDataErrorCode.message, string), sanDataErrorCode.code);
    }

    public static SanDataException newException(SanDataErrorCode sanDataErrorCode, Throwable throwable) {
        return new SanDataException(String.format("%s%s", sanDataErrorCode.message), throwable, sanDataErrorCode.code);
    }

    public static SanDataException newException(SanDataErrorCode sanDataErrorCode, String string, Throwable throwable) {
        return new SanDataException(String.format("%s%s", sanDataErrorCode.message, string), throwable, sanDataErrorCode.code);
    }
}

