/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.HashMap;
import sanproject.sn2.base.authentication.SJbaseAuthConst;
import sanproject.sn2.base.authentication.inf.SJbaseAuthenticationModulePluginInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.SJcStringUty;

public class SJbaseAuthenticetionSVP
implements SJbaseAuthenticationModulePluginInterface {
    private final String LOG_FUNCTION = "SJbaseAuthenticetionSVP";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private final String NAME_SVPLOGIN = "DKCMaintenance";
    private static String szMsg;
    private String m_szUserName = null;
    private String m_SessionID = null;
    private String m_RDPAddr = null;
    private String[] m_szGroupName = null;
    private String m_szPassword = null;
    private boolean[] m_AuthMap = null;
    private boolean[] m_ResourceGroupMap = null;
    private boolean m_isAllRSG = false;
    private final int SUCCESS_DATA_SIZE_USERNAME = 1025;
    private final int SUCCESS_DATA_SIZE_PASSWORD = 1025;
    private final int SUCCESS_DATA_SIZE_GSID = 65;
    private final int SUCCESS_DATA_SIZE_CLIENT_IP = 257;
    private final int SUCCESS_DATA_SIZE_CONNECT_ID = 4;
    private final int SUCCESS_DATA_SIZE_CONNECT = 4;
    private final int SUCCESS_DATA_SIZE_RDP_CONNECT_CNT = 4;
    private final int SUCCESS_DATA_SIZE_DUMMY1 = 4;
    private final int SUCCESS_DATA_SIZE_AUTHMAP = 41;
    private final int SUCCESS_DATA_SIZE_DUMMY2 = 3;
    private final int SUCCESS_DATA_SIZE_RSGMAP = 128;
    private final int SUCCESS_DATA_OFS_USERNAME = 0;
    private final int SUCCESS_DATA_OFS_PASSWORD = 1025;
    private final int SUCCESS_DATA_OFS_GSID = 2050;
    private final int SUCCESS_DATA_OFS_CLIENT_IP = 2115;
    private final int SUCCESS_DATA_OFS_CONNECT_ID = 2372;
    private final int SUCCESS_DATA_OFS_CONNECT = 2376;
    private final int SUCCESS_DATA_OFS_RDP_CONNECT_CNT = 2380;
    private final int SUCCESS_DATA_OFS_DUMMY1 = 2384;
    private final int SUCCESS_DATA_OFS_AUTHMAP = 2388;
    private final int SUCCESS_DATA_OFS_DUMMY2 = 2429;
    private final int SUCCESS_DATA_OFS_RSGMAP = 2432;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int authentication(String szUserName, String szPassword) {
        String LOG_SUBTITLE = "authentication";
        int iRet = 6;
        try {
            szMsg = "<" + szUserName + ">Start.";
            SJcLogUty.getLogger().info("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            if (!szUserName.equals("DKCMaintenance")) {
                iRet = 7;
                szMsg = "unMacth Pattern.";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
                int n = iRet;
                return n;
            }
            File file = new File(SJbaseAuthConst.FILE_SVPCRED);
            FileInputStream is = new FileInputStream(file);
            InputStreamReader in = new InputStreamReader((InputStream)is, "UTF-8");
            char[] name = new char[1025];
            char[] pass = new char[1025];
            char[] gsid = new char[65];
            char[] addr = new char[257];
            if (in.read(name) == -1) {
                szMsg = "Read Error.";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
                throw new SJcException();
            }
            if (in.read(pass) == -1) {
                szMsg = "Read Error.";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
                throw new SJcException();
            }
            if (in.read(gsid) == -1) {
                szMsg = "Read Error.";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
                throw new SJcException();
            }
            if (in.read(addr) == -1) {
                szMsg = "Read Error.";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
                throw new SJcException();
            }
            int skipSize = 16;
            if (in.skip(skipSize) != (long)skipSize) {
                szMsg = "Read Error.";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
                throw new SJcException();
            }
            char[] auth = new char[41];
            if (in.read(auth) == -1) {
                szMsg = "Read Error.";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
                throw new SJcException();
            }
            String szAuth = SJbaseAuthenticetionSVP.charToStr(auth);
            szMsg = "szAuth:<" + szAuth + ">";
            SJcLogUty.getLogger().debug("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            boolean[] AuthMap = new boolean[160];
            for (int i = 0; i < 160; ++i) {
                AuthMap[i] = SJcAccountChkUty.checkBit(szAuth, i);
            }
            in.close();
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            byte[] rsg = new byte[128];
            raf.seek(2432L);
            if (raf.read(rsg) == -1) {
                szMsg = "Read Error.";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
                throw new SJcException();
            }
            szMsg = "rsg:<" + SJcStringUty.byteToHexString(rsg) + ">";
            SJcLogUty.getLogger().debug("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            boolean[] ResourceGroupMap = new boolean[1024];
            boolean isAllRSG = true;
            for (int i = 0; i < 1024; ++i) {
                int targetBit;
                int targetByte = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? i / 32 * 4 - i / 8 % 4 + 3 : i / 8;
                if ((rsg[targetByte] & (targetBit = 128 >>> i % 8)) != 0) {
                    ResourceGroupMap[i] = true;
                    continue;
                }
                ResourceGroupMap[i] = false;
                isAllRSG = false;
            }
            raf.close();
            String encname = SJbaseAuthenticetionSVP.charToStr(name);
            String szgsid = SJbaseAuthenticetionSVP.charToStr(gsid);
            String szAddr = SJbaseAuthenticetionSVP.charToStr(addr);
            String encpass = SJbaseAuthenticetionSVP.charToStr(pass);
            szMsg = "encname:<" + encname + ">";
            SJcLogUty.getLogger().info("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            szMsg = "szgsid:<" + szgsid + ">";
            SJcLogUty.getLogger().info("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            szMsg = "szAddr:<" + szAddr + ">";
            SJcLogUty.getLogger().info("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            szMsg = "encpass:<" + encpass + ">";
            SJcLogUty.getLogger().info("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            szMsg = "AuthMap:<" + SJbaseAuthenticetionSVP.boolToStr(AuthMap) + ">";
            SJcLogUty.getLogger().info("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            szMsg = "ResourceGroupMap:<" + SJbaseAuthenticetionSVP.boolToStr(ResourceGroupMap) + ">";
            SJcLogUty.getLogger().info("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            szMsg = "isAllRSG:<" + isAllRSG + ">";
            SJcLogUty.getLogger().info("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            if (szPassword.equals(szgsid)) {
                String szpass;
                String szname;
                iRet = 0;
                byte[] bname = SJbaseAuthenticetionSVP.StrToByte(encname);
                this.m_szUserName = szname = SJcSecureUty.decryptString(bname);
                this.m_SessionID = szgsid;
                this.m_RDPAddr = szAddr;
                byte[] bpass = SJbaseAuthenticetionSVP.StrToByte(encpass);
                this.m_szPassword = szpass = SJcSecureUty.decryptString(bpass);
                this.m_AuthMap = AuthMap;
                this.m_ResourceGroupMap = ResourceGroupMap;
                this.m_isAllRSG = isAllRSG;
            } else {
                iRet = 6;
                szMsg = "<" + szgsid + ">not matching GlobalSessionID.";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
            }
        }
        catch (FileNotFoundException e) {
            iRet = 6;
            szMsg = "<" + szUserName + ">not Found SVP auth Data.";
            SJcLogUty.getLogger().warn("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
        }
        catch (Exception e) {
            iRet = 11;
            szMsg = "<" + szUserName + ">";
            SJcLogUty.getLogger().error("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg, e);
        }
        finally {
            szMsg = "<" + szUserName + ">End. - status:" + iRet;
            SJcLogUty.getLogger().info("SJbaseAuthenticetionSVP", this.LOG_TITLE, "authentication", szMsg);
        }
        return iRet;
    }

    @Override
    public String getUserName() {
        return this.m_szUserName;
    }

    @Override
    public String[] getGroupID() {
        return this.m_szGroupName;
    }

    @Override
    public String getSessionID() {
        return this.m_SessionID;
    }

    @Override
    public String getAuthSystemName(String szSystem) {
        return szSystem;
    }

    @Override
    public HashMap<String, Object> getAuthObject() {
        HashMap<String, Object> hmap = new HashMap<String, Object>();
        hmap.put("RDPIPAddr", this.m_RDPAddr);
        return hmap;
    }

    private static String charToStr(char[] data) {
        StringBuffer sb = new StringBuffer();
        int cnt = data.length;
        for (int i = 0; i < cnt && data[i] != '\u0000'; ++i) {
            sb.append(data[i]);
        }
        return sb.toString();
    }

    private static String boolToStr(boolean[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if (data[i]) {
                sb.append("1");
                continue;
            }
            sb.append("0");
        }
        return sb.toString();
    }

    private static byte[] StrToByte(String data) {
        byte[] bytes = new byte[data.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(data.substring(i * 2, (i + 1) * 2), 16);
        }
        return bytes;
    }

    @Override
    public String[] getRoleID() {
        return null;
    }

    @Override
    public boolean[] getResourceGrpMap() {
        return this.m_ResourceGroupMap;
    }

    @Override
    public boolean isAllRSG() {
        return this.m_isAllRSG;
    }

    @Override
    public boolean[] getRoleMap() {
        return this.m_AuthMap;
    }

    @Override
    public String getPassword() {
        return this.m_szPassword;
    }
}

