/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import sanproject.sn2.base.property.SJbaseSystemPropertiesConst;
import sanproject.sn2.base.system.inf.SJbasePluginInterface;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseSystemPropertiesManager
implements SJbasePluginInterface,
SJcConst,
SJbaseSystemPropertiesConst {
    private final String LOG_FUNCTION = "SystemPropertiesManager";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private SJcLoggerInterface STDLOGGER = SJcLogUty.getLogger();
    private static final int RETRY_POLLING = 100;
    private static final int RETRY_NUM = 3;

    @Override
    public void initialize(int status) {
        String LOG_SUBTITLE = "initialize";
        this.STDLOGGER.info("SystemPropertiesManager", this.LOG_TITLE, "initialize", "Start. - status:" + status);
        Properties localProps = new Properties();
        for (int i = 0; i < SN_SYSTEM_INITLIST.length; ++i) {
            String key = SN_SYSTEM_INITLIST[i][0];
            String value = SN_SYSTEM_INITLIST[i][1];
            localProps.setProperty(key, value);
        }
        Properties envProps = this.readPropertiesFromEnv("SN_EnvFile", "SN2_Startup.properties");
        this.setProperties(localProps, envProps);
        Properties envVProps = this.readPropertiesFromEnv("SN_EnvFileV", "SN2_StartupV.properties");
        this.setProperties(localProps, envVProps);
        Enumeration<?> keys = localProps.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (System.getProperty(key) != null) continue;
            String value = localProps.getProperty(key);
            System.setProperty(key, value);
        }
        this.STDLOGGER.info("SystemPropertiesManager", this.LOG_TITLE, "initialize", "End.");
    }

    private void setProperties(Properties destProps, Properties srcProps) {
        String LOG_SUBTITLE = "setProperties";
        this.STDLOGGER.trace("SystemPropertiesManager", this.LOG_TITLE, "setProperties", "Start.");
        Enumeration<?> keys = srcProps.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = srcProps.getProperty(key);
            destProps.setProperty(key, value);
        }
        this.STDLOGGER.trace("SystemPropertiesManager", this.LOG_TITLE, "setProperties", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readPropertiesFromEnv(String env, String defFilename) {
        String LOG_SUBTITLE = "readPropertiesFromEnv";
        this.STDLOGGER.trace("SystemPropertiesManager", this.LOG_TITLE, "readPropertiesFromEnv", "Start. - env:" + env);
        String filepath = System.getProperty(env);
        if (null == filepath) {
            this.STDLOGGER.warn("SystemPropertiesManager", this.LOG_TITLE, "readPropertiesFromEnv", env + ":Environment not set.");
        } else if (!this.isFileExists(filepath)) {
            filepath = null;
            this.STDLOGGER.warn("SystemPropertiesManager", this.LOG_TITLE, "readPropertiesFromEnv", env + ":File not found. - file:" + filepath);
        }
        if (null == filepath) {
            String dataPath = SJcFileUty.concatFolderPath(System.getProperty("SN_DataPath"), "data");
            String propDirPath = SJcFileUty.concatFolderPath(dataPath, SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_PROPERTIES);
            filepath = SJcFileUty.concatFolderPath(propDirPath, defFilename);
        }
        Properties props = new Properties();
        FileInputStream inStream = null;
        int retry_count = 0;
        while (retry_count <= 3) {
            try {
                if (!this.isFileExists(filepath)) {
                    this.STDLOGGER.warn("SystemPropertiesManager", this.LOG_TITLE, "readPropertiesFromEnv", env + ":File not exists. -file:" + filepath);
                    break;
                }
                if (retry_count > 0) {
                    try {
                        SJbaseSystemPropertiesManager e = this;
                        synchronized (e) {
                            this.wait(100L);
                        }
                    }
                    catch (InterruptedException ie) {
                        this.STDLOGGER.warn("SystemPropertiesManager", this.LOG_TITLE, "readPropertiesFromEnv", "InterruptedException.", ie);
                    }
                }
                inStream = new FileInputStream(filepath);
                props.load(inStream);
                break;
            }
            catch (FileNotFoundException fnfe) {
                this.STDLOGGER.error("SystemPropertiesManager", this.LOG_TITLE, "readPropertiesFromEnv", "FileNotFoundException occured.", fnfe);
                ++retry_count;
            }
            catch (IOException ioe) {
                this.STDLOGGER.error("SystemPropertiesManager", this.LOG_TITLE, "readPropertiesFromEnv", "IOException occured." + props.toString(), ioe);
                ++retry_count;
            }
            finally {
                if (null == inStream) continue;
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    this.STDLOGGER.error("SystemPropertiesManager", this.LOG_TITLE, "readPropertiesFromEnv", "Failed to inStream close.", e);
                }
            }
        }
        this.STDLOGGER.trace("SystemPropertiesManager", this.LOG_TITLE, "readPropertiesFromEnv", "End. - return:" + props);
        return props;
    }

    private boolean isFileExists(String path) {
        File file = new File(path);
        return file.exists() && file.isFile();
    }

    @Override
    public void finish() {
        String LOG_SUBTITLE = "finish";
        this.STDLOGGER.info("SystemPropertiesManager", this.LOG_TITLE, "finish", "Start.");
        this.STDLOGGER.info("SystemPropertiesManager", this.LOG_TITLE, "finish", "End.");
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isEnable() {
        return true;
    }
}

