/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.security.exception.SJcSecureUtyDecryptException;
import sanproject.sn2.com.utility.security.exception.SJcSecureUtyException;
import sanproject.sn2.com.utility.security.exception.SJcSecureUtyInvalidAlgorithmParameterException;
import sanproject.sn2.com.utility.security.exception.SJcSecureUtyParameterException;

public class SJcSecureUty {
    private static final String LOG_FUNCTION = "Secure";
    private static final String LOG_TITLE = "SJcSecureUty";
    private static final String SECRET_KEY = "ZXJvdHN5ZWtvbm5v";

    private static byte[] getAlgorithmParameterSizeBinaly(int data) {
        byte[] apSize = new byte[]{(byte)(data >>> 24 & 0xFF), (byte)(data >>> 16 & 0xFF), (byte)(data >>> 8 & 0xFF), (byte)(data & 0xFF)};
        return apSize;
    }

    private static int getAlgorithmParameterSizeInteger(byte[] data) {
        int paramSize = 0;
        return paramSize |= data[0] << 24 & 0xFF000000 | data[1] << 16 & 0xFF0000 | data[2] << 8 & 0xFF00 | data[3] & 0xFF;
    }

    private static String byteToStr(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int cnt = data.length;
        for (int i = 0; i < cnt; ++i) {
            sb.append(Integer.toHexString(data[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(data[i] & 0xF));
        }
        return sb.toString();
    }

    public static byte[] encryptByte(byte[] byteData) throws SJcException {
        String LOG_SUBTYTLE = "encryptByte";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "encryptByte", "start");
        if (byteData == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "encryptByte", "Parameter is null");
            throw new SJcSecureUtyParameterException("107000");
        }
        byte[] ret = SJcSecureUty.encryptByteNoLog(byteData);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "encryptByte", "end");
        return ret;
    }

    public static byte[] encryptByteNoLog(byte[] byteData) throws SJcException {
        try {
            return SJcSecureUty.encryptByteNoLog(byteData, SECRET_KEY.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new SJcSecureUtyException(e, "107001");
        }
    }

    public static byte[] encryptByteNoLog(byte[] byteData, byte[] pass) throws SJcException {
        if (byteData == null) {
            throw new SJcSecureUtyParameterException("107000");
        }
        byte[] ret = null;
        try {
            SecretKeySpec key = new SecretKeySpec(pass, "AES");
            Cipher c = Cipher.getInstance("AES/CFB8/PKCS5Padding");
            c.init(1, key);
            byte[] algorithmParam = c.getParameters().getEncoded();
            byte[] contents = c.doFinal(byteData);
            byte[] paramSize = SJcSecureUty.getAlgorithmParameterSizeBinaly(algorithmParam.length);
            ret = new byte[paramSize.length + algorithmParam.length + contents.length];
            System.arraycopy(paramSize, 0, ret, 0, paramSize.length);
            System.arraycopy(algorithmParam, 0, ret, paramSize.length, algorithmParam.length);
            System.arraycopy(contents, 0, ret, paramSize.length + algorithmParam.length, contents.length);
        }
        catch (Exception e) {
            throw new SJcSecureUtyException(e, "107001");
        }
        return ret;
    }

    public static byte[] encryptString(String str) throws SJcException {
        String LOG_SUBTYTLE = "encryptString";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "encryptString", "start");
        if (str == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "encryptString", "Parameter is null");
            throw new SJcSecureUtyParameterException("107000");
        }
        byte[] ret = null;
        try {
            ret = SJcSecureUty.encryptByte(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SJcSecureUtyException(e, "107002");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "encryptString", "end");
        return ret;
    }

    public static byte[] decryptByte(byte[] encryptedData) throws SJcException {
        try {
            return SJcSecureUty.decryptByte(encryptedData, SECRET_KEY.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SJcSecureUtyException(e, "107004");
        }
    }

    public static byte[] decryptByte(byte[] encryptedData, byte[] pass) throws SJcException {
        AlgorithmParameters param;
        Cipher c;
        String LOG_SUBTYTLE = "decryptByte";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "decryptByte", "start");
        if (encryptedData == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptByte", "Parameter is null");
            throw new SJcSecureUtyParameterException("107000");
        }
        if (encryptedData.length < 4) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptByte", "Parameter length: " + encryptedData.length);
            throw new SJcSecureUtyParameterException("107003");
        }
        byte[] ret = null;
        byte[] paramSizeByte = new byte[4];
        System.arraycopy(encryptedData, 0, paramSizeByte, 0, 4);
        int paramSize = SJcSecureUty.getAlgorithmParameterSizeInteger(paramSizeByte);
        if (0 > paramSize || paramSize > encryptedData.length - 4) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptByte", "Algorishm parameter length is " + paramSize);
            throw new SJcSecureUtyInvalidAlgorithmParameterException("107006");
        }
        SecretKeySpec key = new SecretKeySpec(pass, "AES");
        try {
            c = Cipher.getInstance("AES/CFB8/PKCS5Padding");
        }
        catch (Exception e) {
            throw new SJcSecureUtyException(e, "107005");
        }
        byte[] algorithmParam = new byte[paramSize];
        System.arraycopy(encryptedData, 4, algorithmParam, 0, paramSize);
        try {
            param = AlgorithmParameters.getInstance("AES");
            param.init(algorithmParam);
        }
        catch (Exception e) {
            throw new SJcSecureUtyInvalidAlgorithmParameterException(e, "107006");
        }
        byte[] encData = new byte[encryptedData.length - (4 + paramSize)];
        System.arraycopy(encryptedData, 4 + paramSize, encData, 0, encryptedData.length - (4 + paramSize));
        try {
            c.init(2, (Key)key, param);
            ret = c.doFinal(encData);
        }
        catch (Exception e) {
            throw new SJcSecureUtyDecryptException(e, "107008");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "decryptByte", "end");
        return ret;
    }

    public static String decryptString(byte[] encryptedData) throws SJcException {
        String ret;
        String LOG_SUBTYTLE = "decryptString";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "decryptString", "start");
        if (encryptedData == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptString", "Parameter is null");
            throw new SJcSecureUtyParameterException("107000");
        }
        if (encryptedData.length < 4) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptString", "Parameter length: " + encryptedData.length);
            throw new SJcSecureUtyParameterException("107007");
        }
        try {
            ret = new String(SJcSecureUty.decryptByte(encryptedData), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SJcSecureUtyException(e, "107002");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "decryptString", "end");
        return ret;
    }

    public static byte[] getHashValueByte(byte[] byteData) throws SJcException {
        MessageDigest md;
        String LOG_SUBTYTLE = "getHashValueByte";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueByte", "start");
        if (byteData == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHashValueByte", "Parameter is null");
            throw new SJcSecureUtyParameterException("107000");
        }
        byte[] ret = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (Exception e) {
            throw new SJcSecureUtyException(e, "107010");
        }
        md.reset();
        md.update(byteData);
        ret = md.digest();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueByte", "end");
        return ret;
    }

    public static String getHashValueByteHex(byte[] byteData) throws SJcException {
        String LOG_SUBTYTLE = "getHashValueByteHex";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueByteHex", "start");
        if (byteData == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHashValueByteHex", "Parameter is null");
            throw new SJcSecureUtyParameterException("107000");
        }
        String ret = SJcSecureUty.byteToStr(SJcSecureUty.getHashValueByte(byteData));
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueByteHex", "end");
        return ret;
    }

    public static byte[] getHashValueString(String str) throws SJcException {
        String LOG_SUBTYTLE = "getHashValueString";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueString", "start");
        if (str == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHashValueString", "Parameter is null");
            throw new SJcSecureUtyParameterException("107000");
        }
        byte[] ret = null;
        try {
            ret = SJcSecureUty.getHashValueByte(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SJcSecureUtyException(e, "107009");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueString", "end");
        return ret;
    }

    public static String getHashValueStringHex(String str) throws SJcException {
        String LOG_SUBTYTLE = "getHashValueStringHex";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueStringHex", "start");
        if (str == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHashValueStringHex", "Parameter is null");
            throw new SJcSecureUtyParameterException("107000");
        }
        String ret = SJcSecureUty.byteToStr(SJcSecureUty.getHashValueString(str));
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueStringHex", "end");
        return ret;
    }

    public static byte[] encryptSerialize(Serializable obj) throws SJcException {
        String LOG_SUBTYTLE = "encryptSerialize";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "encryptSerialize", "start");
        byte[] secureBytes = null;
        ObjectOutputStream out = null;
        if (obj == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "encryptSerialize", "Parameter is null");
            throw new SJcSecureUtyParameterException("107000");
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bos);
            out.writeObject(obj);
            byte[] bytes = bos.toByteArray();
            secureBytes = SJcSecureUty.encryptByte(bytes);
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "encryptSerialize", "encrypt error.", ex);
            throw new SJcSecureUtyException(ex, "107001");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "encryptSerialize", "ObjectOutputStream close error.", ex);
                }
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "encryptSerialize", "end");
        return secureBytes;
    }

    public static Object decryptDeserialize(byte[] secureByte) throws SJcException {
        String LOG_SUBTYTLE = "decryptDeserialize";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "decryptDeserialize", "start");
        Object ret = null;
        ObjectInputStream in = null;
        if (secureByte == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptDeserialize", "Parameter is null.");
            throw new SJcSecureUtyParameterException("107000");
        }
        try {
            byte[] pureByte = SJcSecureUty.decryptByte(secureByte);
            in = new ObjectInputStream(new ByteArrayInputStream(pureByte));
            ret = in.readObject();
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptDeserialize", "decrypt error.", ex);
            throw new SJcSecureUtyException(ex, "107008");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {
                    STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "decryptDeserialize", "ObjectInputStream close error.", ex);
                }
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "decryptDeserialize", "end");
        return ret;
    }

    public static String byteToStrEx(byte[] data) {
        return SJcSecureUty.byteToStr(data);
    }

    public static String encryptStrToStr(String plainText) throws SJcException {
        String encText = null;
        String LOG_SUBTYTLE = "encryptStrToStr";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "encryptStrToStr", "start");
        byte[] encByte = SJcSecureUty.encryptString(plainText);
        encText = SJcSecureUty.byteToStr(encByte);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "encryptStrToStr", "end");
        return encText;
    }

    public static String decryptStrToStr(String encText) throws SJcException {
        String plainText = null;
        String LOG_SUBTYTLE = "decryptStrToStr";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "decryptStrToStr", "start");
        if (encText == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptStrToStr", "Parameter is null.");
            throw new SJcSecureUtyParameterException("107000");
        }
        if (encText.length() % 2 != 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptStrToStr", "Parameter size error. length = " + encText.length());
            throw new SJcSecureUtyParameterException("107000");
        }
        byte[] encByte = SJcSecureUty.hexStrToByte(encText);
        plainText = SJcSecureUty.decryptString(encByte);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "decryptStrToStr", "end");
        return plainText;
    }

    private static byte[] hexStrToByte(String hexStr) throws SJcException {
        int loopSize = hexStr.length() / 2;
        byte[] encByte = new byte[loopSize];
        for (int i = 0; i < loopSize; ++i) {
            String byteStr = hexStr.substring(i * 2, (i + 1) * 2);
            try {
                encByte[i] = (byte)Integer.parseInt(byteStr, 16);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new SJcSecureUtyException(ex, "107008");
            }
        }
        return encByte;
    }
}

