/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.account;

import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.BitSet;
import java.util.HashMap;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.account.SJcAccountFileManage;
import sanproject.sn2.com.utility.account.SJcRmiAccess;
import sanproject.sn2.com.utility.account.SJcRoleInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundRoleException;

public class SJcAccountFileRoleInfo
extends SJcAccountFileManage {
    private int m_iMaxCount = SJcEnvUty.getProperty2int("SN_ACCOUNT_MAX_ROLE", 256);

    public SJcAccountFileRoleInfo() {
        super("RoleInfo");
    }

    public SJcRoleInfoContainer[] getRoleInfoData(String[] szRoleName) throws Exception {
        SJcRoleInfoContainer[] clsRole = new SJcRoleInfoContainer[szRoleName.length];
        for (int i = 0; i < szRoleName.length; ++i) {
            try {
                SJcAccountChkUty.chkRoleName(szRoleName[i]);
                SJcRoleInfoContainer clsData = (SJcRoleInfoContainer)super.getObject(szRoleName[i]);
                if (clsData == null) {
                    throw new SJcNotFoundRoleException();
                }
                clsRole[i] = clsData;
                continue;
            }
            catch (SJcException e) {
                clsRole[i] = null;
            }
        }
        return clsRole;
    }

    @Override
    public void read() throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(true, "ACCreadAllRoles", 0L);
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
        HashMap<String, Object> roleMap = new HashMap<String, Object>();
        SanList resRoles = response.getList("Roles");
        for (int i = 0; i < resRoles.size(); ++i) {
            SanObject resRole = resRoles.getObj(i);
            SJcRoleInfoContainer roleInfo = new SJcRoleInfoContainer();
            String name = resRole.getString("Name");
            roleInfo.setRoleName(new String(name));
            BitSet bitSetAuth = resRole.getBitSet("AuthBitmap");
            StringBuffer strBufAuth = new StringBuffer();
            int byteAuth = 0;
            for (int j = 0; j < 160; ++j) {
                if (j < bitSetAuth.length() && bitSetAuth.get(j)) {
                    byteAuth |= 1 << 3 - j % 4;
                }
                if (j % 4 != 3) continue;
                strBufAuth.append(Integer.toHexString(byteAuth));
                byteAuth = 0;
            }
            roleInfo.setBitmap(strBufAuth.toString());
            boolean builtin = resRole.getBoolean("Builtin");
            roleInfo.setType(builtin ? "0" : "1");
            roleMap.put(name, roleInfo);
        }
        this.setMap(roleMap);
    }
}

