/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.connector.SJmoGetDirect;

public class SJctrModelDataProxy {
    private Map<String, List<?>> cacheDataMap;
    private LinkedHashSet<String> rscUtilClsSet;
    private SJmoGetAgent getAgent;
    private Map<SJctrGetDirectWrapper, List<?>> modelDataMap;

    public SJctrModelDataProxy(SJmoGetAgent agent) {
        if (agent == null) {
            throw new IllegalArgumentException();
        }
        this.getAgent = agent;
        this.modelDataMap = new HashMap();
        this.rscUtilClsSet = new LinkedHashSet();
    }

    public List<?> getCache(Class<?> key) {
        return this.getCache(key.getName());
    }

    public List<?> getCache(String key) {
        return this.cacheDataMap.get(key);
    }

    public Map<String, List<?>> getCacheMap() {
        return this.cacheDataMap;
    }

    public List<String> getRscUtilClsList() {
        ArrayList<String> ret = new ArrayList<String>(this.rscUtilClsSet);
        return ret;
    }

    public Map<SJctrGetDirectWrapper, List<?>> getDataInf(Collection<SJctrGetDirectWrapper> set) throws SJcException {
        this.modelDataMap.clear();
        ArrayList<SJctrGetDirectWrapper> inputList = new ArrayList<SJctrGetDirectWrapper>(set.size());
        for (SJctrGetDirectWrapper wrapper : set) {
            if (!wrapper.isCacheMode()) {
                inputList.add(wrapper);
                continue;
            }
            List<?> getList = this.getCacheData(wrapper);
            if (getList == null) {
                inputList.add(wrapper);
                continue;
            }
            this.setModelDataMap(wrapper, getList);
        }
        List<List<?>> outputList = this.getModelData(inputList);
        if (inputList.size() != outputList.size()) {
            SJctrLogUty.info("ModelDataProxy", "getDataInf", "illegal size:in=" + inputList.size() + ",out=" + outputList.size());
            throw new SJcException();
        }
        for (int i = 0; i < inputList.size(); ++i) {
            SJctrGetDirectWrapper wrapper = (SJctrGetDirectWrapper)inputList.get(i);
            List<?> getList = outputList.get(i);
            if (wrapper.isCacheMode()) {
                this.setCacheData(wrapper, getList);
            }
            this.setModelDataMap(wrapper, getList);
        }
        return this.getModelDataMap();
    }

    public void setDataInf(Map<SJctrGetDirectWrapper, List<?>> map) throws SJcException {
        for (SJctrGetDirectWrapper wrapper : map.keySet()) {
            List<?> getList = map.get(wrapper);
            if (!wrapper.isCacheMode()) continue;
            this.setCacheData(wrapper, getList);
        }
    }

    public Map<SJctrGetDirectWrapper, List<?>> getModelDataMap() {
        return Collections.unmodifiableMap(this.modelDataMap);
    }

    public void putCache(Class<?> key, List<?> list) {
        this.putCache(key.getName(), list);
    }

    public void putCache(String key, List<?> list) {
        List<?> unmodList = Collections.unmodifiableList(list);
        this.cacheDataMap.put(key, unmodList);
    }

    public void setCacheMap(Map<String, List<?>> cache) {
        this.cacheDataMap = cache;
    }

    private List<?> getCacheData(SJctrGetDirectWrapper wrapper) {
        List<?> getList;
        ArrayList retList = null;
        if (this.cacheDataMap != null && (getList = this.cacheDataMap.get(wrapper.getCacheKey())) != null) {
            retList = new ArrayList(getList.size());
            retList.addAll(getList);
        }
        return retList;
    }

    private List<List<?>> getModelData(List<SJctrGetDirectWrapper> list) throws SJcException {
        ArrayList<SJmoGetDirect> inputList = new ArrayList<SJmoGetDirect>(list.size());
        for (SJctrGetDirectWrapper wrapper : list) {
            inputList.add(wrapper.getDirect());
        }
        ArrayList outputList = null;
        outputList = inputList.size() != 0 ? this.getAgent.getDataInf(inputList) : new ArrayList(0);
        return outputList;
    }

    private void setCacheData(SJctrGetDirectWrapper wrapper, List<?> getList) {
        if (this.cacheDataMap != null) {
            String key = wrapper.getCacheKey();
            this.cacheDataMap.put(key, getList);
            if (wrapper.isRscUtil()) {
                this.rscUtilClsSet.add(key);
            }
        }
    }

    private void setModelDataMap(SJctrGetDirectWrapper wrapper, List<?> getList) {
        List<?> unmodList = Collections.unmodifiableList(getList);
        this.modelDataMap.put(wrapper, unmodList);
    }
}

