/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.common.Robj_interface_AuditUserInfo;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrModelDataProxy;
import sanproject.sn2.controller.com.SJctrProgressManager;
import sanproject.sn2.controller.com.SJctrProgressUtility;
import sanproject.sn2.controller.com.SJctrQueueController;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.modelrc.util.SJmoRscUtil;

public class SJctrTask
implements SJctrProgressManager {
    private final String mClassName;
    static final int ERR_TASK_ABORTED = 109015;
    static final int ERR_REENTER_TASK = 208001;
    static final int ERR_TASK_RESOUECE_DIFF = 207005;
    private BitSet mRgidSet = null;
    private static final int ST_TYPE_MASK = 65280;
    private static final int ST_TYPE_PRE = 0;
    private static final int ST_TYPE_EXEC = 256;
    private static final int ST_TYPE_END = 512;
    public static final int ST_STANDBY = 0;
    public static final int ST_WAIT = 1;
    public static final int ST_SUSPENDED = 2;
    public static final int ST_ACTIVE = 256;
    public static final int ST_ABORTING = 257;
    public static final int ST_MONITOR = 258;
    public static final int ST_COMPLETED = 512;
    public static final int ST_FAILED = 513;
    public static final int ST_ABORTED = 514;
    public static final int ST_DELETED = 515;
    int mStatus = 0;
    private SJctrProgressUtility progressUtil;
    private static final int DEFAULT_LEAD_TIME = 0;
    private static final int[][][] STATUS_TABLE = new int[][][]{new int[][]{{0}, {1, 513, 515}}, new int[][]{{1}, {2, 256, 513, 515}}, new int[][]{{2}, {1, 513, 515}}, new int[][]{{256}, {257, 258, 512, 513, 514}}, new int[][]{{257}, {258, 512, 513, 514}}, new int[][]{{258}, {257, 512, 513, 514}}, new int[][]{{512}, {515}}, new int[][]{{513}, {515}}, new int[][]{{514}, {515}}, new int[][]{{515}, new int[0]}};
    String mId = "";
    String mName = "";
    String mType = "";
    String mTypeEn = "";
    String mUserId = "";
    Robj_interface_AuditUserInfo mUserInfo;
    String mPass = "";
    boolean mAllRSGFlg = false;
    public static final long LOCK_ID_INVALID = -1L;
    long mLockId = -1L;
    private int SSO_OPT_DEF;
    private int mSsoOpt = this.SSO_OPT_DEF = 0;
    long mWizardStartTime;
    long mSubmitTime;
    long mApplyStartTime;
    long mApplyEndTime;
    long mLeadTime;
    int mProgress;
    public static final int APPLY_ABORTABLE = 1;
    public static final int APPLY_ASYNC = 2;
    public static final int APPLY_REQUEST = 4;
    public static final int APPLY_SHRINK = 8;
    public static final int APPLY_DELDRD = 16;
    int mGeneralBehavior = 0;
    List<Integer> mApplyBehavior = new ArrayList<Integer>();
    public static final int APPLY_STARTED = 256;
    public static final int APPLY_FINISHED = 512;
    public static final int MONITOR_STARTED = 65536;
    public static final int MONITOR_FINISHED = 131072;
    List<Integer> mApplyPhase = new ArrayList<Integer>();
    public static final int IFID_RMIAP = 0;
    public static final int IFID_SVP = 1;
    int mInterfaceId = 0;
    List<String> mActionType = null;
    List<String> mActionTypeEn = new ArrayList<String>();
    List<SJctrGuidance> mActionGuidance = new ArrayList<SJctrGuidance>();
    SJctrNestedListDataObject mCrumbTrail = null;
    List<Object> mApplyResultList = null;
    List<Boolean> mApplyResultFlgList = null;
    boolean mProtection = false;
    ArrayList<SJctrApplyController> mApplyData = null;
    LinkedHashMap<String, Map<String, List<?>>> mConfirmData = null;
    List<List<ArrayList<? extends SJmoModelData_Base>>> mResourceDiff;
    ArrayList<String> mRelateData = null;
    List<Integer> mApplyLeadTime = null;
    List<Integer> mModelLeadTime = null;
    List<Integer> mApplyProgress = null;
    List<Integer> mModelProgress = null;
    int mApplyIndex = -1;
    SJctrError mError;
    List<SJctrError> mApplyError = null;
    public static final int MAX_LENGTH_TASKNAME = 32;
    private static final SimpleDateFormat TASKNAME_FORMAT = new SimpleDateFormat("yyMMdd");
    private static final Pattern patternTaskName = Pattern.compile("[^\\\\/:,;*?\"<>|]{1,32}");
    public static final int ERR_INVALID_TASK_NAME = 105489;
    private static final int SUPPORT_APPLY_ASYNC = 1;
    private static final int SUPPORT_COMP_REQUEST = 256;
    private static final int SUPPORT_DKC_LOCK = 512;
    private static final int SUPPORT_ACTNAME_JPN = 768;
    private static final int SUPPORT_RESUME_TASK = 1024;
    private static final int SUPPORT_RESOURCE_LOCK = 1280;
    private static final int SUPPORT_SYSTEM_LOCK = 1281;
    private static final int SUPPORT_SSO_OPT = 1536;
    private int mTaskVersionUID = 1536;
    private static final String KEY_TASK_VERSION = "KEY_TASK_VERSION";
    private static final String KEY_TASK_STATUS = "KEY_TASK_STATUS";
    private static final String KEY_TASK_ID = "KEY_TASK_ID";
    private static final String KEY_TASK_NAME = "KEY_TASK_NAME";
    private static final String KEY_TASK_TYPE = "KEY_TASK_TYPE";
    private static final String KEY_TASK_USER = "KEY_TASK_USER";
    private static final String KEY_TASK_USER_INFO = "KEY_TASK_USER_INFO";
    private static final String KEY_TASK_WIZARD_START = "KEY_TASK_WIZARD_START";
    private static final String KEY_TASK_SUBMIT = "KEY_TASK_SUBMIT";
    private static final String KEY_TASK_APPLY_START = "KEY_TASK_APPLY_START";
    private static final String KEY_TASK_APPLY_END = "KEY_TASK_APPLY_END";
    private static final String KEY_TASK_LEAD_TIME = "KEY_TASK_LEAD_TIME";
    private static final String KEY_TASK_PROGRESS = "KEY_TASK_PROGRESS";
    private static final String KEY_TASK_ABORTABLE = "KEY_TASK_ABORTABLE";
    private static final String KEY_TASK_RELATE = "KEY_TASK_RELATE";
    private static final String KEY_TASK_ACT_TYPE = "KEY_TASK_ACT_TYPE";
    private static final String KEY_TASK_CRUMBTRAIL = "KEY_TASK_CRUMBTRAIL";
    private static final String KEY_TASK_APPLY_RESULT_FLG = "KEY_TASK_APPLY_RESULT_FLG";
    private static final String KEY_TASK_PROTECTION = "KEY_TASK_PROTECTION";
    private static final String KEY_TASK_APPLY_LEAD_TIME = "KEY_TASK_APPLY_LEAD_TIME";
    private static final String KEY_TASK_MODEL_REFRESH_TIME = "KEY_TASK_MODEL_REFRESH_TIME";
    private static final String KEY_TASK_APPLY_PROGRESS = "KEY_TASK_APPLY_PROGRESS";
    private static final String KEY_TASK_MODEL_REFRESH_PROGRESS = "KEY_TASK_MODEL_REFRESH_PROGRESS";
    private static final String KEY_TASK_APPLY_INDEX = "KEY_TASK_APPLY_INDEX";
    private static final String KEY_TASK_ERROR = "KEY_TASK_ERROR";
    private static final String KEY_TASK_APPLY_ERROR = "KEY_TASK_APPLY_ERROR";
    private static final String KEY_TASK_ASYNC = "KEY_TASK_ASYNC";
    private static final String KEY_TASK_GENERAL_BEHAVIOR = "KEY_TASK_GENERAL_BEHAVIOR";
    private static final String KEY_TASK_APPLY_BEHAVIOR = "KEY_TASK_APPLY_BEHAVIOR";
    private static final String KEY_TASK_APPLY_PHASE = "KEY_TASK_APPLY_PHASE";
    private static final String KEY_TASK_RGID_SET = "KEY_TASK_RGID_SET";
    private static final String KEY_TASK_INTERFACE_ID = "KEY_TASK_INTERFACE_ID";
    private static final String KEY_TASK_TYPE_EN = "KEY_TASK_TYPE_EN";
    private static final String KEY_TASK_ACT_TYPE_EN = "KEY_TASK_ACT_TYPE_EN";
    private static final String KEY_TASK_ACT_TYPE_GUIDE = "KEY_TASK_ACT_TYPE_GUIDE";
    private static final String KEY_TASK_RESOURCE_DIFF = "KEY_TASK_RESOURCE_DIFF";
    private static final String KEY_TASK_PASSWORD = "KEY_TASK_PASSWORD";
    private static final String KEY_TASK_RESOURCE_LOCK_ID = "KEY_TASK_RESOURCE_LOCK_ID";
    private static final String KEY_TASK_ALLRSGFLG = "KEY_TASK_ALLRSGFLG";
    private static final String KEY_TASK_SSO_OPT = "KEY_TASK_SSO_OPT";

    public int getStatus() {
        return this.mStatus;
    }

    public boolean isPreExecute() {
        return (this.mStatus & 0xFF00) == 0;
    }

    public boolean isExecute() {
        return (this.mStatus & 0xFF00) == 256;
    }

    public boolean isFinish() {
        return (this.mStatus & 0xFF00) == 512;
    }

    public static int[] getChangeStatusList(int status) {
        int[] ret = null;
        for (int[][] list : STATUS_TABLE) {
            int key = list[0][0];
            if (key != status) continue;
            ret = list[1];
            break;
        }
        return ret;
    }

    public int canChangeStatus(int status) {
        int ret = -1;
        int[] changeList = SJctrTask.getChangeStatusList(this.getStatus());
        if (changeList != null) {
            for (int st : changeList) {
                if (status != st) continue;
                ret = 0;
                break;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeStatus(int status) {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            int stCurrent = this.getStatus();
            SJctrLogUty.trace(this.mClassName, "changeStatus", "(0x" + SJctrComUtility.toHexString(stCurrent, 4, true) + ") to (0x" + SJctrComUtility.toHexString(status, 4, true) + ")");
            int ret = this.canChangeStatus(status);
            if (ret == 0) {
                this.mStatus = status;
                if (status == 513 || status == 514) {
                    this.setProtection(true);
                }
                SJctrLogUty.trace(this.mClassName, "changeStatus", "success");
            } else {
                SJctrLogUty.trace(this.mClassName, "changeStatus", "faild");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    public int getSsoOpt() {
        return this.mSsoOpt;
    }

    public void setssoOpt(int option) {
        this.mSsoOpt = option;
    }

    public SJctrTask() {
        this.mClassName = this.getClass().getSimpleName();
        this.mError = new SJctrError(201, 22, -1);
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        if (name != null && name.length() > 32) {
            name = name.substring(0, 32);
        }
        this.mName = name;
    }

    public String getType() {
        return this.mType;
    }

    public String getTypeEn() {
        return this.mTypeEn;
    }

    public static String createDefaultTaskName(String taskName) {
        StringBuilder buf = new StringBuilder(32);
        buf.append(TASKNAME_FORMAT.format(new Date()));
        buf.append("-");
        buf.append(taskName.replace(" ", ""));
        String defTaskName = "";
        defTaskName = buf.length() > 32 ? buf.substring(0, 32) : buf.toString();
        return defTaskName;
    }

    public void checkTaskName() {
        Matcher matcherTaskName = patternTaskName.matcher(this.getName());
        if (!matcherTaskName.matches()) {
            SJctrError err = new SJctrError(201, 22, 105489);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    public void setType(String type) {
        this.mType = type;
    }

    public void setTypeEn(String typeEn) {
        this.mTypeEn = typeEn;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
    }

    public Robj_interface_AuditUserInfo getUserInfo() {
        return this.mUserInfo;
    }

    public void setUserInfo(Robj_interface_AuditUserInfo userInfo) {
        this.mUserInfo = userInfo;
    }

    public long getWizardStartTime() {
        return this.mWizardStartTime;
    }

    public void setWizardStartTime(long wizardStartTime) {
        this.mWizardStartTime = wizardStartTime;
    }

    public long getSubmitTime() {
        return this.mSubmitTime;
    }

    public void setSubmitTime(long submitTime) {
        this.mSubmitTime = submitTime;
    }

    public long getApplyStartTime() {
        return this.mApplyStartTime;
    }

    public void setApplyStartTime(long applyStartTime) {
        this.mApplyStartTime = applyStartTime;
    }

    public long getApplyEndTime() {
        return this.mApplyEndTime;
    }

    public void setApplyEndTime(long applyEndTime) {
        this.mApplyEndTime = applyEndTime;
    }

    public long getLeadTime() {
        return this.mLeadTime;
    }

    public void setLeadTime(long leadTime) {
        this.mLeadTime = leadTime;
    }

    public List<String> getActionType() {
        return this.mActionType;
    }

    public List<String> getActionTypeEn() {
        return this.mActionTypeEn;
    }

    public List<SJctrGuidance> getActionGuidance() {
        return this.mActionGuidance;
    }

    public void addActionType(String type) {
        if (this.mActionType == null) {
            this.mActionType = new ArrayList<String>();
        }
        this.mActionType.add(type);
    }

    public void addActionTypeEn(String typeEn) {
        if (this.mActionTypeEn == null) {
            this.mActionTypeEn = new ArrayList<String>();
        }
        this.mActionTypeEn.add(typeEn);
    }

    public void addActionGuidance(SJctrGuidance typeGuide) {
        if (this.mActionGuidance == null) {
            this.mActionGuidance = new ArrayList<SJctrGuidance>();
        }
        this.mActionGuidance.add(typeGuide);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SJctrError> getActionError() {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (this.mRelateData == null || this.mApplyError == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new ArrayList<SJctrError>();
            }
            String oldConfirm = null;
            SJctrError oldError = null;
            ArrayList<SJctrError> actionErrorList = new ArrayList<SJctrError>(this.mRelateData.size());
            for (int i = 0; i < this.mRelateData.size(); ++i) {
                String key = this.mRelateData.get(i);
                SJctrError applyError = this.mApplyError.get(i);
                if (!key.equals(oldConfirm)) {
                    actionErrorList.add(applyError);
                    oldConfirm = key;
                    oldError = applyError;
                    continue;
                }
                if (oldError.getError() != 0) continue;
                actionErrorList.set(actionErrorList.size() - 1, applyError);
                oldError = applyError;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return actionErrorList;
        }
    }

    public SJctrNestedListDataObject getCrumbTrail() {
        return this.mCrumbTrail;
    }

    public void setCrumbTrail(SJctrNestedListDataObject crumbTrail) {
        this.mCrumbTrail = crumbTrail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Object>> getApplyResult() {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            List applyResultList;
            ArrayList<List<Object>> ret = new ArrayList<List<Object>>(0);
            if (this.mRelateData == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ret;
            }
            if (this.mApplyResultList == null) {
                SJctrQueueController queueCtr = SJctrQueueController.getInstance();
                try {
                    Serializable ser = queueCtr.getTaskResultData(this);
                    applyResultList = (List)((Object)ser);
                }
                catch (Exception e) {
                    SJctrLogUty.info(this.mClassName, "getApplyResult", "load ResultData Fail : ", e);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return ret;
                }
            } else {
                applyResultList = this.mApplyResultList;
            }
            if (applyResultList == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ret;
            }
            String oldConfirm = null;
            ArrayList<List<Object>> confirmResultList = new ArrayList<List<Object>>(this.mRelateData.size());
            ArrayList confirmResult = null;
            for (int i = 0; i < this.mRelateData.size(); ++i) {
                String key = this.mRelateData.get(i);
                if (!key.equals(oldConfirm)) {
                    confirmResult = new ArrayList(applyResultList.size());
                    confirmResultList.add(confirmResult);
                    oldConfirm = key;
                }
                if (i >= applyResultList.size()) continue;
                Object result = applyResultList.get(i);
                if (result == null) {
                    result = new ArrayList(0);
                }
                confirmResult.add(result);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return confirmResultList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getApplyResult(int index) {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (this.mApplyResultList == null) {
                SJctrLogUty.info(this.mClassName, "getApplyResult", "Logical Error has occured. mApplyResultList not found.");
                SJctrError err = new SJctrError(201, 22, 106004);
                SJcException exp = err.createException();
                throw exp;
            }
            if (index < 0 || this.mApplyResultList.size() <= index) {
                SJctrLogUty.info(this.mClassName, "getApplyResult", "Logical Error has occured. positon = " + index);
                SJctrError err = new SJctrError(201, 22, 106004);
                SJcException exp = err.createException();
                throw exp;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mApplyResultList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setApplyResult(int index, Object resultObject) {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (this.mApplyResultList == null) {
                SJctrLogUty.info(this.mClassName, "setApplyResult", "Logical Error has occured. mApplyResultList not found.");
                SJctrError err = new SJctrError(201, 22, 106004);
                SJcException exp = err.createException();
                throw exp;
            }
            if (index < 0 || this.mApplyResultList.size() <= index) {
                SJctrLogUty.info(this.mClassName, "setApplyResult", "Logical Error has occured. positon = " + index);
                SJctrError err = new SJctrError(201, 22, 106004);
                SJcException exp = err.createException();
                throw exp;
            }
            this.mApplyResultList.set(index, resultObject);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Boolean> hasDetailActionResult() {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (this.mRelateData == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new ArrayList<Boolean>();
            }
            String oldConfirm = null;
            Boolean oldFlg = null;
            ArrayList<Boolean> actionResultFlgList = new ArrayList<Boolean>(this.mRelateData.size());
            for (int i = 0; i < this.mRelateData.size(); ++i) {
                Boolean applyResultFlg = this.mApplyError == null || this.mApplyError.size() <= i ? Boolean.FALSE : (this.mApplyError.get(i).getError() == 0 ? Boolean.FALSE : (this.mApplyResultFlgList == null || this.mApplyResultFlgList.size() <= i ? Boolean.FALSE : this.mApplyResultFlgList.get(i)));
                String key = this.mRelateData.get(i);
                if (!key.equals(oldConfirm)) {
                    actionResultFlgList.add(applyResultFlg);
                    oldConfirm = key;
                    oldFlg = applyResultFlg;
                    continue;
                }
                if (!Boolean.FALSE.equals(oldFlg)) continue;
                actionResultFlgList.set(actionResultFlgList.size() - 1, applyResultFlg);
                oldFlg = applyResultFlg;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return actionResultFlgList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setApplyResultFlgList(int index, boolean applyResultFlg) {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (this.mApplyResultFlgList == null) {
                SJctrLogUty.info(this.mClassName, "setApplyResultFlgList", "Logical Error has occured. mApplyResultList not found.");
                SJctrError err = new SJctrError(201, 22, 106004);
                SJcException exp = err.createException();
                throw exp;
            }
            if (index < 0 || this.mApplyResultFlgList.size() <= index) {
                SJctrLogUty.info(this.mClassName, "setApplyResultFlgList", "Logical Error has occured. positon = " + index);
                SJctrError err = new SJctrError(201, 22, 106004);
                SJcException exp = err.createException();
                throw exp;
            }
            this.mApplyResultFlgList.set(index, applyResultFlg);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public boolean isProtection() {
        return this.mProtection;
    }

    public void setProtection(boolean protection) {
        this.mProtection = protection;
    }

    protected LinkedHashMap<String, Map<String, List<?>>> getConfirmData() {
        return this.mConfirmData;
    }

    public SJctrError getError() {
        return this.mError;
    }

    public void setError(SJctrError error) {
        this.mError = error;
    }

    public List<SJctrError> getApplyError() {
        return this.mApplyError;
    }

    public int getInterfaceId() {
        return this.mInterfaceId;
    }

    public void setInterfaceId(int interfaceId) {
        this.mInterfaceId = interfaceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SJctrRelatedDispDataObject> getConfirmDC(SJctrDataController dc) throws Exception {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            Serializable ser;
            SJctrUserController userCtr = dc.getOwner();
            LinkedHashMap<String, Map<String, List<?>>> confirmData = this.mConfirmData;
            if (confirmData == null && (confirmData = this.importDataToConfirmData(ser = SJctrQueueController.getInstance().getTaskConfirmData(this))) == null) {
                SJctrLogUty.info(this.mClassName, "getConfirmDC", "confirmFile is Null");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new ArrayList<SJctrRelatedDispDataObject>();
            }
            SJctrModelDataProxy proxy = dc.getProxy();
            ArrayList<SJctrRelatedDispDataObject> result = new ArrayList<SJctrRelatedDispDataObject>(confirmData.size());
            try {
                for (Map.Entry<String, Map<String, List<?>>> entry : confirmData.entrySet()) {
                    String className = entry.getKey();
                    Map<String, List<?>> confirmDCData = entry.getValue();
                    Class<?> cls = Class.forName(className);
                    SJctrRelatedDispDataObject relatedDisp = userCtr.createRelatedDispData(cls);
                    result.add(relatedDisp);
                    SJctrConfirmDataController confirmDataController = (SJctrConfirmDataController)userCtr.getDataController(relatedDisp);
                    confirmDataController.setProxy(proxy);
                    confirmDataController.setConfirmData(confirmDCData);
                    confirmDataController.notifyRestoreFromTasks(this);
                }
            }
            catch (Exception e) {
                for (SJctrRelatedDispDataObject rel : result) {
                    userCtr.removeRelatedDispData(rel.uId());
                }
                throw e;
            }
            return result;
        }
    }

    public void add(SJctrApplyController apply, SJctrConfirmDataController confirmDataController) {
        String key;
        if (this.getStatus() != 0) {
            return;
        }
        if (this.mApplyData == null) {
            this.mApplyData = new ArrayList();
        }
        apply.setPosition(this.mApplyData.size());
        this.mApplyData.add(apply);
        this.mApplyPhase.add(new Integer(0));
        if (this.mConfirmData == null) {
            this.mConfirmData = new LinkedHashMap();
        }
        if (!this.mConfirmData.containsKey(key = confirmDataController.getClass().getName())) {
            Map confirmDCData = confirmDataController.getComConfirmData();
            this.mConfirmData.put(key, confirmDCData);
            this.setResourceDiff(confirmDataController);
        }
        if (this.mRelateData == null) {
            this.mRelateData = new ArrayList();
        }
        this.mRelateData.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int execute(SJdsSupplierAgent agent) {
        int i;
        SJctrQueueController queue = SJctrQueueController.getInstance();
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        // MONITORENTER : sanproject.sn2.controller.com.SJctrQueueController.class
        SJctrLogUty.info(this.mClassName, "execute", "start");
        long sTime = System.currentTimeMillis();
        if (this.changeStatus(256) != 0) {
            SJctrLogUty.info(this.mClassName, "execute", "invalid status (0x" + SJctrComUtility.toHexString(this.getStatus(), 4, true) + ")");
            // MONITOREXIT : clazz
            return this.mStatus;
        }
        this.setApplyStartTime(System.currentTimeMillis());
        try {
            queue.saveTaskControlData(this);
        }
        catch (Exception e) {
            SJctrLogUty.warn(this.mClassName, "execute", "save Control Data fail = ", e);
        }
        try {
            queue.saveTaskDump(this);
        }
        catch (Exception e) {
            SJctrLogUty.warn(this.mClassName, "execute", "save DumpData Fail : ", e);
        }
        ArrayList<SJctrApplyController> applyData = this.mApplyData;
        if (applyData == null) {
            try {
                queue.loadTaskApplyData(this);
            }
            catch (Exception e1) {
                SJctrError error = SJctrError.parseError(e1);
                this.setError(error);
                SJctrLogUty.warn(this.mClassName, "execute", "load ApplyData Fail : ", e1);
                // MONITOREXIT : clazz
                return 513;
            }
        }
        this.mApplyProgress = new ArrayList<Integer>(this.mApplyData.size());
        this.mApplyError = new ArrayList<SJctrError>(this.mApplyData.size());
        for (i = 0; i < this.mApplyData.size(); ++i) {
            this.mApplyProgress.add(0);
            this.mApplyError.add(new SJctrError(201, 22, -1));
        }
        this.mModelProgress = new ArrayList<Integer>(this.mModelLeadTime.size());
        for (i = 0; i < this.mModelLeadTime.size(); ++i) {
            this.mModelProgress.add(0);
        }
        // MONITOREXIT : clazz
        int bufStatus = 512;
        SJctrLogUty.info(this.mClassName, "execute", "apply count = " + this.mApplyData.size());
        for (SJctrApplyController apply : this.mApplyData) {
            block34: {
                Class<SJctrQueueController> clazz2 = SJctrQueueController.class;
                // MONITORENTER : sanproject.sn2.controller.com.SJctrQueueController.class
                if (bufStatus != 512) {
                    // MONITOREXIT : clazz2
                    break;
                }
                ++this.mApplyIndex;
                if (this.getStatus() == 257) {
                    bufStatus = 514;
                    // MONITOREXIT : clazz2
                    continue;
                }
                int applyPhase = this.mApplyPhase.get(this.mApplyIndex);
                this.mApplyPhase.set(this.mApplyIndex, applyPhase |= 0x100);
                String applyName = apply.getClass().getSimpleName();
                SJctrLogUty.info(this.mClassName, "execute", "apply start : " + applyName);
                // MONITOREXIT : clazz2
                apply.setTask(this);
                apply.initApply();
                apply.applyStart(agent);
                apply.setTask(null);
                clazz2 = SJctrQueueController.class;
                // MONITORENTER : sanproject.sn2.controller.com.SJctrQueueController.class
                try {
                    this.setResultData(apply);
                }
                catch (Exception e) {
                    SJctrError resultError = SJctrError.parseError(e);
                    int applyEc = apply.getError().getError();
                    SJctrLogUty.warn(this.mClassName, "execute", "setResultData exception occured!! EC = " + applyEc);
                    if (applyEc != 0 && applyEc != -1) break block34;
                    apply.setError(resultError);
                }
            }
            int leadTime = SJmoModelMgr.getModelMgr().getLeadTime();
            this.progressUtil = new SJctrProgressUtility(leadTime);
            int progress = this.getProgress();
            SJctrError error = apply.getError();
            this.mApplyError.set(this.mApplyIndex, error);
            int applyPhase = this.mApplyPhase.get(this.mApplyIndex);
            this.mApplyPhase.set(this.mApplyIndex, applyPhase |= 0x200);
            int erc = error.getError();
            switch (erc) {
                case 0: {
                    break;
                }
                case -1: {
                    bufStatus = 514;
                    break;
                }
                default: {
                    bufStatus = 513;
                }
            }
            SJctrLogUty.info(this.mClassName, "execute", "apply end : status = 0x" + SJctrComUtility.toHexString(bufStatus, 4, true));
            SJctrLogUty.info(this.mClassName, "execute", "apply " + (this.mApplyIndex + 1) + " / " + this.mApplyData.size() + " : " + progress + "%");
            try {
                queue.saveTaskControlData(this);
            }
            catch (Exception e) {
                SJctrLogUty.warn(this.mClassName, "execute", "save Control Data fail = ", e);
            }
            try {
                queue.saveTaskResultData(this);
            }
            catch (Exception e) {
                SJctrLogUty.warn(this.mClassName, "execute", "save Result Data fail = ", e);
            }
        }
        Class<SJctrQueueController> i$ = SJctrQueueController.class;
        // MONITORENTER : sanproject.sn2.controller.com.SJctrQueueController.class
        this.mError = this.mApplyData.size() > 0 ? this.mApplyError.get(this.mApplyIndex) : new SJctrError(201, 22, 0);
        for (int i2 = this.mApplyIndex + 1; i2 < this.mApplyData.size(); ++i2) {
            this.mApplyError.set(i2, this.mApplyData.get(i2).getError());
        }
        SJctrLogUty.info(this.mClassName, "execute", "all apply end");
        SJctrLogUty.trace(this.mClassName, "execute", "apply time(ms) = " + (System.currentTimeMillis() - sTime));
        this.mApplyIndex = this.mApplyData.size();
        // MONITOREXIT : i$
        SJctrLogUty.info(this.mClassName, "execute", "refreshModel start");
        try {
            agent.refreshModel();
        }
        catch (Exception e) {
            SJctrLogUty.warn(this.mClassName, "execute", "refreshModel fail : ", e);
        }
        SJctrLogUty.info(this.mClassName, "execute", "refreshModel end");
        queue.releaseResourceDiff(this, 0);
        this.getProgress();
        SJctrLogUty.info(this.mClassName, "execute", "end");
        SJctrLogUty.trace(this.mClassName, "execute", "time(ms) = " + (System.currentTimeMillis() - sTime));
        return bufStatus;
    }

    private void setResultData(SJctrApplyController apply) {
        boolean resultFlg = apply.hasApplyResult();
        List<List<SJctrError>> resultObject = null;
        if (resultFlg) {
            resultObject = apply.getResultDataEx();
        }
        if (this.mApplyResultList == null) {
            this.mApplyResultList = new ArrayList<Object>();
        }
        this.mApplyResultList.add(resultObject);
        if (this.mApplyResultFlgList == null) {
            this.mApplyResultFlgList = new ArrayList<Boolean>();
        }
        this.mApplyResultFlgList.add(resultFlg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    int monitorBackground(SJdsSupplierAgent agent, int resultStatus) {
        SJctrLogUty.info(this.mClassName, "monitorBackground", "start. Task status(Not decided yet) = " + resultStatus);
        boolean stopflg = false;
        SJctrQueueController queue = SJctrQueueController.getInstance();
        for (int applyCnt = 0; applyCnt < this.mApplyData.size(); ++applyCnt) {
            int applyPhase;
            Class<SJctrQueueController> clazz;
            block18: {
                SJctrApplyController apply = this.mApplyData.get(applyCnt);
                if (!apply.isAsync() || !apply.isNeedMonitorBackground()) continue;
                SJctrLogUty.info(this.mClassName, "monitorBackground", "Start. AC = " + apply.getClass().getSimpleName());
                clazz = SJctrQueueController.class;
                // MONITORENTER : sanproject.sn2.controller.com.SJctrQueueController.class
                applyPhase = this.mApplyPhase.get(applyCnt);
                this.mApplyPhase.set(applyCnt, applyPhase |= 0x10000);
                // MONITOREXIT : clazz
                try {
                    apply.setTask(this);
                    SJctrError bgRet = apply.monitorBackground();
                    apply.setTask(null);
                    switch (bgRet.getError()) {
                        case 0: {
                            SJctrLogUty.info(this.mClassName, "monitorBackground", "Normal end. AC = " + apply.getClass().getSimpleName());
                            break;
                        }
                        case -1: {
                            SJctrLogUty.warn(this.mClassName, "monitorBackground", "Pause monitor. AC = " + apply.getClass().getSimpleName());
                            stopflg = true;
                            break;
                        }
                        default: {
                            SJctrLogUty.warn(this.mClassName, "monitorBackground", "Error end!!  FuncID=" + bgRet.getFunc() + " ModuleID=" + bgRet.getModule() + " MsgID=" + bgRet.getError() + " AC=" + apply.getClass().getSimpleName());
                            resultStatus = 513;
                            Class<SJctrQueueController> clazz2 = SJctrQueueController.class;
                            // MONITORENTER : sanproject.sn2.controller.com.SJctrQueueController.class
                            this.mApplyError.set(applyCnt, bgRet);
                            if (this.mError.getError() == 0) {
                                this.mError = bgRet;
                            }
                            // MONITOREXIT : clazz2
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    resultStatus = 513;
                    SJctrLogUty.info(this.mClassName, "monitorBackground", "exception", ex);
                    SJctrError error = SJctrError.parseError(ex);
                    this.mApplyError.set(applyCnt, error);
                    if (this.mError.getError() != 0) break block18;
                    this.mError = error;
                }
            }
            clazz = SJctrQueueController.class;
            // MONITORENTER : sanproject.sn2.controller.com.SJctrQueueController.class
            applyPhase = this.mApplyPhase.get(applyCnt);
            this.mApplyPhase.set(applyCnt, applyPhase |= 0x20000);
            // MONITOREXIT : clazz
        }
        if (!stopflg) {
            SJctrLogUty.info(this.mClassName, "monitorBackground", "refreshModel start");
            try {
                ++this.mApplyIndex;
                int leadTime = SJmoModelMgr.getModelMgr().getLeadTime();
                this.progressUtil = new SJctrProgressUtility(leadTime);
                agent.refreshModel();
            }
            catch (Exception e) {
                SJctrLogUty.warn(this.mClassName, "monitorBackground", "refreshModel fail : ", e);
            }
            SJctrLogUty.info(this.mClassName, "monitorBackground", "refreshModel end");
            queue.releaseResourceDiff(0);
            this.getProgress();
        } else {
            resultStatus = 258;
        }
        SJctrLogUty.info(this.mClassName, "monitorBackground", "end. Task status(Not decided yet) = " + resultStatus);
        return resultStatus;
    }

    void stopTaskExec() {
        this.changeStatus(257);
        for (SJctrApplyController apply : this.mApplyData) {
            if (!apply.isAsync()) continue;
            apply.pauseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTaskEnd(int status) {
        try {
            SJctrQueueController queue = SJctrQueueController.getInstance();
            queue.copyConfirmDataFile(this);
        }
        catch (Exception e) {
            SJctrLogUty.warn(this.mClassName, "setTaskEnd", "copy Confirm File failed = ", e);
        }
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            int chgRet = this.changeStatus(status);
            if (chgRet == 0) {
                this.setApplyEndTime(System.currentTimeMillis());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<?>> changeApplyListToActionList(List<?> applyList) {
        ArrayList retList = new ArrayList();
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (this.mRelateData != null && this.mRelateData.size() == applyList.size()) {
                String oldConfirm = null;
                ArrayList nestApplyList = new ArrayList();
                for (int i = 0; i < this.mRelateData.size(); ++i) {
                    String key = this.mRelateData.get(i);
                    if (!key.equals(oldConfirm)) {
                        nestApplyList = new ArrayList();
                        oldConfirm = key;
                        retList.add(nestApplyList);
                    }
                    Object element = applyList.get(i);
                    nestApplyList.add(element);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return retList;
        }
    }

    public void initBehavior() {
        this.mGeneralBehavior = 0;
        if (this.mApplyData != null) {
            for (SJctrApplyController apply : this.mApplyData) {
                int behavior = 0;
                if (apply.isAbortable()) {
                    behavior |= 1;
                }
                if (apply.isAsync()) {
                    behavior |= 2;
                }
                if (apply.isRequestOnly()) {
                    behavior |= 4;
                }
                if (apply.isShrink()) {
                    behavior |= 8;
                }
                if (apply.isDelDRD()) {
                    behavior |= 0x10;
                }
                this.mApplyBehavior.add(behavior);
                this.mGeneralBehavior |= behavior;
            }
        } else {
            SJctrLogUty.warn(this.mClassName, "initBehavior", "Apply Data not found!! Can't make behavior.");
        }
    }

    public int getGeneralBehavior() {
        return this.mGeneralBehavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getApplyBehavior() {
        ArrayList<Integer> actionBehavList = new ArrayList<Integer>();
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            List<List<?>> releteActionApply = this.changeApplyListToActionList(this.mApplyBehavior);
            for (List<?> applyOneActList : releteActionApply) {
                if (applyOneActList == null) {
                    SJctrLogUty.warn(this.mClassName, "getApplyBehavior", "applyOneActList is invalid.");
                    applyOneActList = new ArrayList();
                }
                int actionBehavior = 0;
                Iterator<?> i$ = applyOneActList.iterator();
                while (i$.hasNext()) {
                    int behavior = (Integer)i$.next();
                    actionBehavior |= behavior;
                }
                actionBehavList.add(actionBehavior);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return actionBehavList;
        }
    }

    public static final boolean checkBehavior(int targetBehavior, int checkBitmap) {
        boolean ret = false;
        if ((targetBehavior & checkBitmap) == checkBitmap) {
            return true;
        }
        return ret;
    }

    public boolean isAbortable() {
        return SJctrTask.checkBehavior(this.mGeneralBehavior, 1);
    }

    public boolean isAsync() {
        return SJctrTask.checkBehavior(this.mGeneralBehavior, 2);
    }

    public boolean isRequestOnly() {
        return SJctrTask.checkBehavior(this.mGeneralBehavior, 4);
    }

    public boolean isShrink() {
        return SJctrTask.checkBehavior(this.mGeneralBehavior, 8);
    }

    public boolean isDelDRD() {
        return SJctrTask.checkBehavior(this.mGeneralBehavior, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getApplyPhase() {
        ArrayList<Integer> actionPhaseList = new ArrayList<Integer>();
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            List<List<?>> releteActionApply = this.changeApplyListToActionList(this.mApplyPhase);
            for (List<Integer> list : releteActionApply) {
                int actionPhase = this.getActionPhase(list);
                actionPhaseList.add(actionPhase);
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return actionPhaseList;
        }
    }

    private int getActionPhase(List<Integer> applyOneActList) {
        if (applyOneActList == null || applyOneActList.size() == 0) {
            SJctrLogUty.warn(this.mClassName, "getActionPhase", "applyOneActList is invalid.");
            return 0;
        }
        int applyStartPhase = 0;
        int applyEndPhase = 512;
        int monitorEndPhase = 131072;
        for (int phase : applyOneActList) {
            applyStartPhase |= phase & 0x100;
            applyEndPhase &= phase & 0x200;
            if ((phase & 0x10000) != 65536) continue;
            applyStartPhase |= 0x10000;
            if ((phase & 0x20000) == 131072) {
                monitorEndPhase &= monitorEndPhase;
                continue;
            }
            monitorEndPhase = 0;
        }
        int actionPhase = 0;
        actionPhase = applyStartPhase | applyEndPhase;
        if ((applyStartPhase & 0x10000) == 65536) {
            actionPhase |= monitorEndPhase;
        }
        return actionPhase;
    }

    public static final boolean checkPhase(int targetPhase, int checkPhase) {
        boolean ret = false;
        if ((targetPhase & checkPhase) != 0) {
            return true;
        }
        return ret;
    }

    public void abort(Robj_interface_AuditUserInfo userInfo, SJdsSupplierAgent supplier) {
        SJctrLogUty.info(this.mClassName, "abort", "start. (Task ID = " + this.mId + ")");
        if (this.isAbortable()) {
            try {
                ArrayList<SJctrApplyController> applyData = this.mApplyData;
                if (applyData != null) {
                    for (SJctrApplyController apply : applyData) {
                        SJctrLogUty.info(this.mClassName, "abort", "abort apply start.");
                        apply.setTask(this);
                        apply.abortStart(supplier);
                        apply.setTask(null);
                        SJctrLogUty.info(this.mClassName, "abort", "abort apply finish.");
                    }
                }
            }
            catch (SJcException ex) {
                SJctrLogUty.warn(this.mClassName, "abort", "abort apply abnormal end!!", ex);
                throw ex;
            }
        }
        SJctrLogUty.info(this.mClassName, "abort", "finish. (Task ID = " + this.mId + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProgress() {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            ArrayList<SJctrApplyController> applyData = this.mApplyData;
            int applyIndex = this.mApplyIndex;
            if (this.isExecute() && applyIndex >= 0 && applyData != null) {
                int progress;
                for (int forwardIndex = 0; forwardIndex <= applyIndex; ++forwardIndex) {
                    if (forwardIndex >= applyData.size() || this.mApplyProgress.get(forwardIndex) == 100) continue;
                    progress = applyData.get(forwardIndex).getProgress();
                    progress = progress >= 0 ? progress : 0;
                    progress = progress <= 100 ? progress : 100;
                    this.mApplyProgress.set(forwardIndex, progress);
                }
                int refreshIndex = applyIndex - applyData.size();
                if (refreshIndex >= 0 && this.mModelProgress.get(refreshIndex) < 100) {
                    if (this.progressUtil == null) {
                        this.progressUtil = new SJctrProgressUtility(0);
                    }
                    progress = (progress = this.progressUtil.getProgress()) >= 0 ? progress : 0;
                    progress = progress <= 100 ? progress : 100;
                    this.mModelProgress.set(refreshIndex, progress);
                }
                long totalTime = 0L;
                for (int i = 0; i < this.mApplyProgress.size(); ++i) {
                    totalTime += (long)(this.mApplyLeadTime.get(i) * this.mApplyProgress.get(i));
                }
                for (int refreshPhase = 0; refreshPhase < this.mModelLeadTime.size(); ++refreshPhase) {
                    totalTime += (long)(this.mModelLeadTime.get(refreshPhase) * this.mModelProgress.get(refreshPhase));
                }
                this.mProgress = (int)(totalTime / this.mLeadTime);
                SJctrLogUty.info(this.mClassName, "getProgress", "calculation completed. Now progress phase = " + applyIndex + " / " + (this.mApplyProgress.size() + this.mModelLeadTime.size()) + ", Progress = " + totalTime + " / " + this.mLeadTime * 100L);
            }
            this.mProgress = this.mProgress >= 0 ? this.mProgress : 0;
            this.mProgress = this.mProgress <= 100 ? this.mProgress : 100;
            this.mProgress = this.mProgress == 100 && !this.isFinish() ? 99 : this.mProgress;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mProgress;
        }
    }

    @Override
    public long initLeadTime() {
        ArrayList<SJctrApplyController> applyData = this.mApplyData;
        if (applyData != null) {
            long leadTimeTotal = 0L;
            ArrayList<Integer> applyLeadTime = new ArrayList<Integer>(applyData.size());
            for (int i = 0; i < applyData.size(); ++i) {
                SJctrApplyController apply = applyData.get(i);
                int leadTime = apply.getLeadTime();
                leadTime = leadTime > 0 ? leadTime : 1;
                applyLeadTime.add(leadTime);
                leadTimeTotal += (long)leadTime;
            }
            this.mApplyLeadTime = applyLeadTime;
            int refreshTime = this.initModelRefreshLeadTime();
            this.mLeadTime = leadTimeTotal += (long)refreshTime;
        }
        this.mLeadTime = this.mLeadTime > 0L ? this.mLeadTime : 1L;
        return this.mLeadTime;
    }

    private int initModelRefreshLeadTime() {
        int totalModelRefreshTime = 0;
        int modelLeadTime = SJmoModelMgr.getModelMgr().getLeadTime();
        modelLeadTime = modelLeadTime > 0 ? modelLeadTime : 1;
        this.mModelLeadTime = new ArrayList<Integer>();
        this.mModelLeadTime.add(modelLeadTime);
        totalModelRefreshTime += modelLeadTime;
        if (SJctrTask.checkBehavior(this.mGeneralBehavior, 2)) {
            this.mModelLeadTime.add(modelLeadTime);
            totalModelRefreshTime += modelLeadTime;
        }
        return totalModelRefreshTime;
    }

    void importControlData(Serializable ser) throws Exception {
        Map map = (Map)((Object)ser);
        this.mTaskVersionUID = map.containsKey(KEY_TASK_VERSION) ? (Integer)map.get(KEY_TASK_VERSION) : 0;
        this.mStatus = (Integer)map.get(KEY_TASK_STATUS);
        this.mId = (String)map.get(KEY_TASK_ID);
        this.mName = (String)map.get(KEY_TASK_NAME);
        this.mType = (String)map.get(KEY_TASK_TYPE);
        this.mUserId = (String)map.get(KEY_TASK_USER);
        this.mUserInfo = (Robj_interface_AuditUserInfo)map.get(KEY_TASK_USER_INFO);
        this.mWizardStartTime = (Long)map.get(KEY_TASK_WIZARD_START);
        this.mSubmitTime = (Long)map.get(KEY_TASK_SUBMIT);
        this.mApplyStartTime = (Long)map.get(KEY_TASK_APPLY_START);
        this.mApplyEndTime = (Long)map.get(KEY_TASK_APPLY_END);
        this.mLeadTime = (Long)map.get(KEY_TASK_LEAD_TIME);
        this.mProgress = (Integer)map.get(KEY_TASK_PROGRESS);
        this.mRelateData = (ArrayList)map.get(KEY_TASK_RELATE);
        this.mActionType = (List)map.get(KEY_TASK_ACT_TYPE);
        this.mCrumbTrail = (SJctrNestedListDataObject)map.get(KEY_TASK_CRUMBTRAIL);
        this.mApplyResultFlgList = (List)map.get(KEY_TASK_APPLY_RESULT_FLG);
        this.mProtection = (Boolean)map.get(KEY_TASK_PROTECTION);
        this.mApplyLeadTime = (List)map.get(KEY_TASK_APPLY_LEAD_TIME);
        this.mApplyProgress = (List)map.get(KEY_TASK_APPLY_PROGRESS);
        this.mApplyIndex = (Integer)map.get(KEY_TASK_APPLY_INDEX);
        this.mError = (SJctrError)map.get(KEY_TASK_ERROR);
        this.mApplyError = (List)map.get(KEY_TASK_APPLY_ERROR);
        if (this.mTaskVersionUID >= 1) {
            this.mModelLeadTime = (List)map.get(KEY_TASK_MODEL_REFRESH_TIME);
            this.mModelProgress = (List)map.get(KEY_TASK_MODEL_REFRESH_PROGRESS);
        }
        if (this.mTaskVersionUID >= 256) {
            this.mGeneralBehavior = (Integer)map.get(KEY_TASK_GENERAL_BEHAVIOR);
            this.mApplyBehavior = (List)map.get(KEY_TASK_APPLY_BEHAVIOR);
            this.mApplyPhase = (List)map.get(KEY_TASK_APPLY_PHASE);
        }
        if (this.mTaskVersionUID >= 512) {
            this.mRgidSet = (BitSet)map.get(KEY_TASK_RGID_SET);
            this.mInterfaceId = (Integer)map.get(KEY_TASK_INTERFACE_ID);
        }
        if (this.mTaskVersionUID >= 768) {
            this.mTypeEn = (String)map.get(KEY_TASK_TYPE_EN);
            this.mActionTypeEn = (List)map.get(KEY_TASK_ACT_TYPE_EN);
            Serializable serActionGuidance = (Serializable)map.get(KEY_TASK_ACT_TYPE_GUIDE);
            this.restoreGuidanceList(serActionGuidance);
        }
        if (this.mTaskVersionUID >= 1024) {
            this.mResourceDiff = (List)map.get(KEY_TASK_RESOURCE_DIFF);
        }
        if (this.mTaskVersionUID >= 1280) {
            this.mPass = (String)map.get(KEY_TASK_PASSWORD);
            this.mLockId = (Long)map.get(KEY_TASK_RESOURCE_LOCK_ID);
        }
        if (this.mTaskVersionUID >= 1281) {
            this.mAllRSGFlg = (Boolean)map.get(KEY_TASK_ALLRSGFLG);
        }
        if (this.mTaskVersionUID >= 1536) {
            this.mSsoOpt = (Integer)map.get(KEY_TASK_SSO_OPT);
        }
    }

    Serializable exportControlData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_TASK_VERSION, this.mTaskVersionUID);
        map.put(KEY_TASK_STATUS, this.mStatus);
        map.put(KEY_TASK_ID, this.mId);
        map.put(KEY_TASK_NAME, this.mName);
        map.put(KEY_TASK_TYPE, this.mType);
        map.put(KEY_TASK_USER, this.mUserId);
        map.put(KEY_TASK_USER_INFO, (Serializable)((Object)this.mUserInfo));
        map.put(KEY_TASK_WIZARD_START, this.mWizardStartTime);
        map.put(KEY_TASK_SUBMIT, this.mSubmitTime);
        map.put(KEY_TASK_APPLY_START, this.mApplyStartTime);
        map.put(KEY_TASK_APPLY_END, this.mApplyEndTime);
        map.put(KEY_TASK_LEAD_TIME, this.mLeadTime);
        map.put(KEY_TASK_PROGRESS, this.mProgress);
        map.put(KEY_TASK_RELATE, this.mRelateData);
        map.put(KEY_TASK_ACT_TYPE, (Serializable)((Object)this.mActionType));
        map.put(KEY_TASK_CRUMBTRAIL, this.mCrumbTrail);
        map.put(KEY_TASK_APPLY_RESULT_FLG, (Serializable)((Object)this.mApplyResultFlgList));
        map.put(KEY_TASK_PROTECTION, this.mProtection);
        map.put(KEY_TASK_APPLY_LEAD_TIME, (Serializable)((Object)this.mApplyLeadTime));
        map.put(KEY_TASK_MODEL_REFRESH_TIME, (Serializable)((Object)this.mModelLeadTime));
        map.put(KEY_TASK_APPLY_PROGRESS, (Serializable)((Object)this.mApplyProgress));
        map.put(KEY_TASK_MODEL_REFRESH_PROGRESS, (Serializable)((Object)this.mModelProgress));
        map.put(KEY_TASK_APPLY_INDEX, this.mApplyIndex);
        map.put(KEY_TASK_ERROR, this.mError);
        map.put(KEY_TASK_APPLY_ERROR, (Serializable)((Object)this.mApplyError));
        boolean abortable = SJctrTask.checkBehavior(this.mGeneralBehavior, 1);
        boolean async = SJctrTask.checkBehavior(this.mGeneralBehavior, 2);
        map.put(KEY_TASK_ABORTABLE, abortable);
        map.put(KEY_TASK_ASYNC, async);
        map.put(KEY_TASK_GENERAL_BEHAVIOR, this.mGeneralBehavior);
        map.put(KEY_TASK_APPLY_BEHAVIOR, (Serializable)((Object)this.mApplyBehavior));
        map.put(KEY_TASK_APPLY_PHASE, (Serializable)((Object)this.mApplyPhase));
        map.put(KEY_TASK_RGID_SET, this.mRgidSet);
        map.put(KEY_TASK_INTERFACE_ID, this.mInterfaceId);
        map.put(KEY_TASK_TYPE_EN, this.mTypeEn);
        map.put(KEY_TASK_ACT_TYPE_EN, (Serializable)((Object)this.mActionTypeEn));
        Serializable serActionGuidance = this.toSerializeGuidanceList();
        map.put(KEY_TASK_ACT_TYPE_GUIDE, serActionGuidance);
        map.put(KEY_TASK_RESOURCE_DIFF, (Serializable)((Object)this.mResourceDiff));
        map.put(KEY_TASK_PASSWORD, this.mPass);
        map.put(KEY_TASK_RESOURCE_LOCK_ID, this.mLockId);
        map.put(KEY_TASK_ALLRSGFLG, this.mAllRSGFlg);
        map.put(KEY_TASK_SSO_OPT, this.mSsoOpt);
        return map;
    }

    public boolean isRestartableTask() {
        boolean ret = true;
        ret = this.mTaskVersionUID >= 1024;
        return ret;
    }

    private void restoreGuidanceList(Serializable ser) {
        List list = (List)((Object)ser);
        for (Serializable guideSer : list) {
            SJctrGuidance guide = SJctrGuidance.getInstance(guideSer);
            this.mActionGuidance.add(guide);
        }
    }

    private Serializable toSerializeGuidanceList() {
        ArrayList<Serializable> retList = new ArrayList<Serializable>(this.mActionGuidance.size());
        for (SJctrGuidance guide : this.mActionGuidance) {
            Serializable ser = guide.getSerializeData();
            retList.add(ser);
        }
        return retList;
    }

    void importApplyData(Serializable ser) throws Exception {
        this.mApplyData = (ArrayList)ser;
    }

    Serializable exportApplyData() {
        return this.mApplyData;
    }

    void importConfirmData(Serializable ser) throws Exception {
        this.mConfirmData = this.importDataToConfirmData(ser);
    }

    LinkedHashMap<String, Map<String, List<?>>> importDataToConfirmData(Serializable ser) throws Exception {
        LinkedHashMap confirmData = null;
        confirmData = (LinkedHashMap)ser;
        return confirmData;
    }

    Serializable exportConfirmData() {
        return this.mConfirmData;
    }

    Serializable exportApplyResult() {
        return (Serializable)((Object)this.mApplyResultList);
    }

    void destroyApplyData() {
        this.mApplyData = null;
    }

    void destroyResourceDiff() {
        this.mResourceDiff = null;
    }

    void destroyConfirmData() {
        this.mConfirmData = null;
    }

    void destroyResultData() {
        this.mApplyResultList = null;
    }

    public List<List<ArrayList<? extends SJmoModelData_Base>>> getResourceDiff() {
        return this.mResourceDiff;
    }

    void setResourceDiff(SJctrConfirmDataController confirmDataController) {
        List resourceList;
        if (this.mResourceDiff == null) {
            this.mResourceDiff = new ArrayList<List<ArrayList<? extends SJmoModelData_Base>>>();
        }
        if ((resourceList = confirmDataController.getRscUtil()) != null && resourceList.size() > 0) {
            for (SJmoRscUtil resorceUtil : resourceList) {
                List diffList = resorceUtil.getRsvData();
                this.mResourceDiff.add(diffList);
            }
        }
    }

    boolean toRemainFailed() {
        boolean ret = true;
        int retCode = this.changeStatus(513);
        if (retCode != 0) {
            SJctrLogUty.error(this.mClassName, "toRemainFailed", "Cannot Change Task Status to Failed !! ");
            ret = false;
        }
        if (this.mError.getError() == -1) {
            this.mError.setFunc(201);
            this.mError.setModule(22);
            this.mError.setError(109015);
        }
        return ret;
    }

    public void setResourceGroupId(BitSet rgidSet) {
        this.mRgidSet = rgidSet;
    }

    public BitSet getResourceGroupIdSet() {
        return this.mRgidSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMonitorable() {
        boolean ret = false;
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (this.mApplyData != null) {
                int i = 0;
                for (i = 0; i < this.mApplyData.size(); ++i) {
                    int behavior = this.mApplyBehavior.get(i);
                    int phase = this.mApplyPhase.get(i);
                    if (!SJctrTask.checkBehavior(behavior, 2) || !SJctrTask.checkPhase(phase, 512)) continue;
                    ret = true;
                    break;
                }
                if (ret) {
                    this.changeStatus(258);
                    this.setmError();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    private void setmError() {
        for (SJctrError appErr : this.mApplyError) {
            int err = appErr.getError();
            if (err == 0) continue;
            this.mError = appErr;
            break;
        }
    }

    public void setUnitSelect(Class<?> key, String unit) {
        if (key == null) {
            return;
        }
        if (unit == null) {
            return;
        }
        Map<String, List<?>> confirmData = this.mConfirmData.get(key.getName());
        String unitKey = SJctrConfirmDataController.getConfirmUnitKey(key);
        if (confirmData != null && confirmData.containsKey(unitKey)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(unit);
            confirmData.put(unitKey, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsUnExecuteApply() {
        boolean ret = false;
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            List<SJctrError> errList = this.getActionError();
            int errIndex = -1;
            for (int i = 0; i < errList.size(); ++i) {
                int err = errList.get(i).getError();
                if (err == 0) continue;
                errIndex = i;
                break;
            }
            if (errIndex == -1) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            List<List<?>> actionPhaseList = this.changeApplyListToActionList(this.mApplyPhase);
            if (actionPhaseList.size() == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            List<?> applyPhaseList = actionPhaseList.get(errIndex);
            for (Integer applyPhase : applyPhaseList) {
                if (applyPhase != 0) continue;
                ret = true;
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    String getPassword() {
        return SJcSecureUty.decryptStrToStr(this.mPass);
    }

    void setPassword(String password) {
        this.mPass = SJcSecureUty.encryptStrToStr(password);
    }

    public long getLockId() {
        return this.mLockId;
    }

    public void setLockId(long lockId) {
        this.mLockId = lockId;
    }

    public boolean getAllRSGFlg() {
        return this.mAllRSGFlg;
    }

    public void setAllRSGFlg(boolean allRSGFlg) {
        this.mAllRSGFlg = allRSGFlg;
    }
}

