/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageExchanger;
import sanproject.sn2.controller.com.SJctrQueueController;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierException;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;

public class SJctrWorkerThread
extends Thread {
    private static final int SN_TASK_MODIFY_POLING = 60;
    private static final int TASK_MODIFY_POLING = SJcEnvUty.getProperty2int("SN_TASK_MODIFY_POLING", 60) * 1000;
    SJctrQueueController mQueueCtr;
    SJdsSupplierAgent mAgent = null;
    boolean mWaitingWorkerThread;
    private final String mClassName = this.getClass().getSimpleName();
    private static final int SUPPLIER_AGENT_WAIT_TIME = 5000;

    public SJctrWorkerThread(SJctrQueueController queueCtr) {
        super("WorkerThread");
        this.mQueueCtr = queueCtr;
        while (this.mQueueCtr.isActive()) {
            this.mAgent = SJdsSupplierMgr.getSupplierMgr().getAgent();
            if (this.mAgent != null) break;
            SJctrLogUty.trace(this.mClassName, "constructor", "getSupplierAgent fail");
            try {
                SJctrWorkerThread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        SJctrLogUty.info(this.mClassName, "run", "start");
        while (true) {
            SJctrTask task = null;
            boolean isRegularBackup = false;
            boolean isDKCLockUnRetry = true;
            try {
                long lLockId;
                task = this.mQueueCtr.takeTask(this);
                if (task == null) break;
                if (task.getActionTypeEn().toString().matches(".*Regular Backup.*")) {
                    isRegularBackup = true;
                }
                long lockId = task.getLockId();
                if (isRegularBackup) {
                    lLockId = this.setDkcLockForRegularBackup(task);
                    isDKCLockUnRetry = false;
                } else {
                    lLockId = this.setDkcLock(task);
                }
                if (lockId != lLockId) {
                    try {
                        this.mQueueCtr.saveTaskControlData(task);
                    }
                    catch (Exception e) {
                        SJctrLogUty.info(this.mClassName, "saveTaskControlData", "faild taskId:" + task.getId());
                    }
                }
                if (lLockId == -1L || !this.lock(task)) continue;
                int status = task.execute(this.mAgent);
                this.unlock(task);
                this.releaseDkcLock(task);
                this.mQueueCtr.wakeUpWorkerThread();
                if (task.isExecute()) {
                    Class<SJctrQueueController> clazz = SJctrQueueController.class;
                    // MONITORENTER : sanproject.sn2.controller.com.SJctrQueueController.class
                    task.setTaskEnd(status);
                    this.mQueueCtr.toHistory(task);
                    // MONITOREXIT : clazz
                }
                task = null;
            }
            catch (Exception ex) {
                if (isRegularBackup) {
                    if (isDKCLockUnRetry) {
                        try {
                            int status = task.execute(this.mAgent);
                            if (!task.isExecute()) continue;
                            Class<SJctrQueueController> clazz = SJctrQueueController.class;
                            // MONITORENTER : sanproject.sn2.controller.com.SJctrQueueController.class
                            task.setTaskEnd(status);
                            this.mQueueCtr.toHistory(task);
                            // MONITOREXIT : clazz
                            task = null;
                        }
                        catch (SJcException ex2) {
                            this.afterException(task, ex2);
                        }
                        continue;
                    }
                    this.afterException(task, ex);
                    continue;
                }
                this.afterException(task, ex);
            }
        }
        this.unlock(null);
        this.mAgent = null;
        this.mQueueCtr = null;
        SJctrLogUty.info(this.mClassName, "run", "end");
    }

    long setDkcLock(SJctrTask task) {
        try {
            this.mQueueCtr.setDkcLock(task);
        }
        catch (SJcException e) {
            SJctrLogUty.info(this.mClassName, "setDkcLock", "failed taskId:" + task.getId());
        }
        long lockId = task.getLockId();
        if (lockId == -1L) {
            try {
                this.mQueueCtr.setDkcLock(task);
            }
            catch (SJdsSupplierException se) {
                SJctrLogUty.info(this.mClassName, "setDkcLock", "failed UserId:" + task.getUserId().toString());
                boolean retry = SJctrQueueController.checkErrorCodeRetrySetDkcLock(se.getErrorCode());
                if (!retry) {
                    SJcException ex = SJctrMessageExchanger.exchange((SJcException)((Object)se));
                    SJctrWorkerThread.afterExceptionTaskFailed(task, this.mQueueCtr, ex);
                }
            }
            catch (SJcException e) {
                SJctrLogUty.info(this.mClassName, "setDkcLock", "failed UserId:" + task.getUserId().toString());
                SJcException ex = SJctrMessageExchanger.exchange(e);
                SJctrWorkerThread.afterExceptionTaskFailed(task, this.mQueueCtr, ex);
            }
        }
        return lockId;
    }

    long setDkcLockForRegularBackup(SJctrTask task) {
        try {
            this.mQueueCtr.setDkcLock(task);
        }
        catch (SJcException e) {
            SJctrLogUty.info(this.mClassName, "setDkcLockForRegularBackup", "failed taskId:" + task.getId());
        }
        long lockId = task.getLockId();
        if (lockId == -1L) {
            try {
                this.mQueueCtr.setDkcLock(task);
            }
            catch (SJdsSupplierException se) {
                SJctrLogUty.info(this.mClassName, "setDkcLockForRegularBackup", "failed UserId:" + task.getUserId().toString());
                boolean retry = SJctrQueueController.checkErrorCodeRetrySetDkcLock(se.getErrorCode());
                if (!retry) {
                    SJcException ex = SJctrMessageExchanger.exchange((SJcException)((Object)se));
                    throw ex;
                }
            }
            catch (SJcException e) {
                SJctrLogUty.info(this.mClassName, "setDkcLockForRegularBackup", "failed UserId:" + task.getUserId().toString());
                SJcException ex = SJctrMessageExchanger.exchange(e);
                throw ex;
            }
        }
        return lockId;
    }

    void releaseDkcLock(SJctrTask task) {
        try {
            this.mQueueCtr.releaseDkcLock(task);
        }
        catch (SJcException e) {
            SJctrLogUty.info(this.mClassName, "releaseDkcLock", "failed taskId:" + task.getId());
        }
    }

    boolean lock(SJctrTask task) {
        boolean ret = false;
        while (task.getStatus() == 1 && this.mQueueCtr.isActive()) {
            try {
                if (this.mQueueCtr.setApplyLock()) {
                    ret = true;
                    break;
                }
            }
            catch (Exception ex) {
                SJctrLogUty.warn(this.mClassName, "lock", "fail", ex);
            }
            try {
                SJctrWorkerThread.sleep(TASK_MODIFY_POLING);
            }
            catch (InterruptedException interruptedException) {}
        }
        return ret;
    }

    void unlock(SJctrTask task) {
        try {
            this.mQueueCtr.releaseApplyLock();
        }
        catch (Exception ex) {
            SJctrLogUty.warn(this.mClassName, "unlock", "fail", ex);
        }
        if (task != null && task.isExecute()) {
            this.mQueueCtr.releaseDkcLock(task);
        }
    }

    void afterException(SJctrTask task, Exception ex) {
        try {
            SJctrLogUty.warn(this.mClassName, "run", "unknown error", ex);
            this.unlock(task);
            SJctrWorkerThread.afterExceptionTaskFailed(task, this.mQueueCtr, ex);
        }
        catch (Exception moveEx) {
            SJctrLogUty.warn(this.mClassName, "run", "move error", moveEx);
        }
    }

    static void afterExceptionTaskFailed(SJctrTask task, SJctrQueueController queueCtr, Exception ex) {
        if (task != null) {
            switch (task.getError().getError()) {
                case -1: 
                case 0: {
                    SJctrError error = SJctrError.parseError(ex);
                    task.setError(error);
                }
            }
            if (task.changeStatus(513) == 0) {
                queueCtr.toHistory(task);
            }
        }
    }

    protected SJctrTask getTask(List<SJctrTask> queuingTaskList) {
        SJctrTask ret = null;
        for (SJctrTask task : queuingTaskList) {
            if (task.getStatus() != 1) continue;
            if (SJctrTask.checkBehavior(task.mGeneralBehavior, 2)) break;
            ret = task;
            SJctrLogUty.info(this.mClassName, "getTask", "return = " + ret.getId());
            break;
        }
        return ret;
    }
}

