/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;

public class SJctrBasicUsableCapFromPgDetailColumn
extends SJctrCapacityColumn
implements SJctrGuidIdDefinition {
    public SJctrBasicUsableCapFromPgDetailColumn(String key) {
        super(key);
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetVdevDetail.class);
        return list;
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("PHYSICAL_CAPA"));
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrPGDetail pgDetail;
        String ret = "-";
        if (0 < dataList.size() && (pgDetail = (SJctrPGDetail)dataList.get(0)).getBVirtSupport()) {
            String select = this.getUnitSelect();
            SJctrCapacityUtility.UNIT unit = select.length() == 0 ? (this.hasOpenVolume ? SJctrCapacityUtility.UNIT.GB : SJctrCapacityUtility.UNIT.CYL) : SJctrCapacityUtility.UNIT.valueOf(select);
            SJctrCapacityUtility util = this.getTable().getComUtility().getCapacityUtility();
            StringBuilder buf = new StringBuilder(util.toString(pgDetail.getScBasicUsableCapacity(), unit, pgDetail.getBaseEmulationType()));
            buf.append(" ");
            buf.append(util.getUnitString(unit));
            ret = buf.toString();
        }
        return ret;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        SJctrPGDetail pg = (SJctrPGDetail)this.getPrimaryKeyObject(dat);
        int emuType = pg.getBaseEmulationType();
        long block = this.getNumber(dat);
        SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
        long cylinder = capaUtil.toCylValue(block, emuType);
        return cylinder;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long rtn = 0L;
        SJctrPGDetail pg = (SJctrPGDetail)this.getPrimaryKeyObject(dat);
        if (pg.getBVirtSupport()) {
            rtn = pg.getScBasicUsableCapacity();
        }
        return rtn;
    }

    @Override
    public boolean hasMainframeVolume(Map<Class<?>, List<?>> basicData) {
        List<?> list = basicData.get(SJmoGetPgDetail.class);
        SJctrComCVSUtility uty = this.getTable().getComUtility().getCVSUtility();
        for (SJmoPgDetail PGDetail : list) {
            String strEmu = uty.getEmulationTypeName(PGDetail.getBaseEmulationType());
            this.hasMainframeVolume |= uty.isMainframe(strEmu);
            if (!this.hasMainframeVolume) continue;
            break;
        }
        return this.hasMainframeVolume;
    }

    @Override
    public boolean hasOpenVolume(Map<Class<?>, List<?>> basicData) {
        List<?> list = basicData.get(SJmoGetPgDetail.class);
        SJctrComCVSUtility uty = this.getTable().getComUtility().getCVSUtility();
        for (SJmoPgDetail PGDetail : list) {
            String strEmu = uty.getEmulationTypeName(PGDetail.getBaseEmulationType());
            this.hasOpenVolume |= uty.isOpen(strEmu);
            if (!this.hasOpenVolume) continue;
            break;
        }
        return this.hasOpenVolume;
    }
}

