/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrHostGroupNameColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;

public class SJctrHGNameColumnFromPortLunTableKey
extends SJctrHostGroupNameColumnFromPortHostGroupTableKey {
    public SJctrHGNameColumnFromPortLunTableKey(String key) {
        super(key);
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object data = null;
        SJctrPortLunTableKey ptLunInfo = (SJctrPortLunTableKey)index;
        List<?> ptHgList = modelData.get(SJmoGetPortHostGroupInfo.class);
        List<?> ptITList = modelData.get(SJmoGetPortIscsiTargetInfo.class);
        int portIdx = -1;
        if (ptHgList != null && ptHgList.size() > 0) {
            portIdx = Collections.binarySearch(ptHgList, ptLunInfo.getPortLunInfo());
        }
        if (portIdx >= 0) {
            ArrayList hgList = ((SJmoPortHostGroupInfo)ptHgList.get(portIdx)).getAlPortHostGroup();
            SJmoHostGroupIndex hgKey = new SJmoHostGroupIndex();
            hgKey.setSPort(ptLunInfo.getPortLunInfo().getSPort());
            hgKey.setSHostGroup(ptLunInfo.getPortLunDetail().getSHostGroup());
            Collections.sort(hgList);
            int hgIdx = Collections.binarySearch(hgList, hgKey);
            if (hgIdx >= 0) {
                data = hgList.get(hgIdx);
            }
        } else {
            if (ptITList != null && ptITList.size() > 0) {
                portIdx = Collections.binarySearch(ptITList, ptLunInfo.getPortLunInfo());
            }
            if (portIdx >= 0) {
                ArrayList itList = ((SJmoPortIscsiTargetInfo)ptITList.get(portIdx)).getAlPortIscsiTarget();
                SJmoIscsiTargetIndex itKey = new SJmoIscsiTargetIndex();
                itKey.setSPort(ptLunInfo.getPortLunInfo().getSPort());
                itKey.setSIscsiTarget(ptLunInfo.getPortLunDetail().getSHostGroup());
                Collections.sort(itList);
                int hgIdx = Collections.binarySearch(itList, itKey);
                if (hgIdx >= 0) {
                    data = itList.get(hgIdx);
                }
            }
        }
        list.add(data);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrPortUtility util = this.getTable().getComUtility().getPortUtility();
        String strRet = "?";
        if (dataList.get(0) instanceof SJmoHostGroupInfo) {
            SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)dataList.get(0);
            strRet = util.toHostGroupNameDisplay(hgInfo);
        } else if (dataList.get(0) instanceof SJmoIscsiTargetInfo) {
            SJmoIscsiTargetInfo itInfo = (SJmoIscsiTargetInfo)dataList.get(0);
            strRet = util.toIscsiTargetAliasDisplay(itInfo);
        }
        return strRet;
    }
}

