/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.column.SJctrVSSLdevIdColumnFromPortLunTableKey;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;

public class SJctrVSSSsidColumnFromPortLunTableKey
extends SJctrVSSLdevIdColumnFromPortLunTableKey {
    protected Map<String, SJmoHUVMVirtualLdev> numberMap = null;
    public static final String GUID_SSID = "SSID";

    public SJctrVSSSsidColumnFromPortLunTableKey(String key) {
        super(key);
        this.setPartsId(GUID_SSID);
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String getInputFormat() {
        return "^([0-9A-Fa-f]{1,4})$";
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoHUVMVirtualLdev vLdev = null;
        String ret = "?";
        if (dataList != null && dataList.size() > 0) {
            vLdev = (SJmoHUVMVirtualLdev)dataList.get(0);
            if (this.numberMap == null) {
                this.numberMap = new HashMap<String, SJmoHUVMVirtualLdev>(this.getTable().getRowCount());
            }
            SJctrRsgUtility rsgUtil = this.getTable().getComUtility().getRsgUtility();
            ret = rsgUtil.toDispStringVssSsid(vLdev);
            this.numberMap.put(ret, vLdev);
        }
        return ret;
    }

    @Override
    public long getNumber(Map<String, Object> data) {
        SJmoHUVMVirtualLdev vLdev = null;
        String strNum = this.getString(data);
        if (strNum.length() != 0) {
            vLdev = this.numberMap.get(strNum);
        }
        if (vLdev == null) {
            return -2L;
        }
        if (vLdev.getSVInfflag() == 0) {
            return -3L;
        }
        return vLdev.getIVSsid();
    }
}

