/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.iscsi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.column.SJctrPortSecuritySwitchColumnFromPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;

public class SJctrPortSecurityColumnFromIscsiTargetInfo
extends SJctrPortSecuritySwitchColumnFromPortDetail {
    public SJctrPortSecurityColumnFromIscsiTargetInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("PORT_SEC"));
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        SJmoPortIndex targetPort = new SJmoPortIndex();
        targetPort.setSPort(this.getTargetPortId(index));
        List<?> portDtlList = modelData.get(SJmoGetPortDetail.class);
        int portIndex = Collections.binarySearch(portDtlList, targetPort);
        if (portIndex >= 0) {
            SJmoPortDetail portDtl = (SJmoPortDetail)portDtlList.get(portIndex);
            retList.add(portDtl);
            retList.add(index);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (dataList.size() == 2) {
            SJctrIscsiUtility iscsiUtil = this.getTable().getComUtility().getIscsiUtility();
            SJmoPortDetail portDetail = (SJmoPortDetail)dataList.get(0);
            SJmoIscsiTargetInfo targetInfo = (SJmoIscsiTargetInfo)dataList.get(1);
            ret = iscsiUtil.getSecurityString(portDetail, (SJmoIscsiTargetIndex)targetInfo);
        }
        return ret;
    }

    protected short getTargetPortId(Object rowInfo) {
        SJmoIscsiTargetInfo iscsiInfo = (SJmoIscsiTargetInfo)rowInfo;
        short sPort = iscsiInfo.getSPort();
        return sPort;
    }
}

