/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;

public class SJctrRemoteLunIdColumnFromHaPairVolInfo
extends SJctrColumn {
    private boolean bDecDisplay = false;

    public SJctrRemoteLunIdColumnFromHaPairVolInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("LUN_ID"));
        SJctrUserController uc = this.getTable().getDataController().getOwner();
        this.bDecDisplay = SJctrHaUtility.isLunDec(uc.getUserSession());
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String getInputFormat() {
        return this.bDecDisplay ? "^\\d{1,19}$" : "^([0-9A-Fa-f]{1,4})$";
    }

    @Override
    public long getNumber(Map<String, Object> dat) {
        SJmoHAPairVolInfo tblData = (SJmoHAPairVolInfo)this.getPrimaryKeyObject(dat);
        long number = -1L;
        if (tblData != null) {
            number = tblData.getPairLU().getILUN();
        }
        return number;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoHAPairVolInfo haPairInfo = (SJmoHAPairVolInfo)dataList.get(0);
        SJctrHaUtility haUtil = this.getTable().getComUtility().getHaUtility();
        return haUtil.getLunIdString(haPairInfo, this.bDecDisplay);
    }
}

