/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoClprInfo;

public class SJctrClprColumnFromExdVolumeInfo
extends SJctrColumn {
    public SJctrClprColumnFromExdVolumeInfo(String key) {
        super(key);
        this.setPartsId("CLPR");
    }

    @Override
    public int getSortType() {
        return 2;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdVolumeInfoMgr.class);
        list.add(SJmoGetClprInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoClprInfo> list = new ArrayList<SJmoClprInfo>();
        SJmoClprInfo clprInfo = null;
        SJmoExdVolumeInfo exdVol = (SJmoExdVolumeInfo)index;
        short clpr = exdVol.getRmiExdVolumeInfo().getSCLPR();
        SJmoClprIndex clprIndex = new SJmoClprIndex();
        clprIndex.setSClpr(clpr);
        List<?> clprInfoList = modelData.get(SJmoGetClprInfo.class);
        int search = Collections.binarySearch(clprInfoList, clprIndex);
        if (search >= 0) {
            clprInfo = (SJmoClprInfo)clprInfoList.get(search);
            list.add(clprInfo);
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoClprInfo clprInfo = (SJmoClprInfo)dataList.get(0);
        SJctrLdevUtility util = this.getTable().getComUtility().getLdevUtility();
        return util.toClprDisplay(clprInfo);
    }
}

