/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDDiscoveryDevice;
import sanproject.serverux.dataimpl.EXDLogicalPath_Fiber;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;

public class SJctrHighestPriorityLUNColumnFromRmiExdDiscoveryDevice
extends SJctrColumn {
    protected Map<String, Integer> numberMap = null;

    public SJctrHighestPriorityLUNColumnFromRmiExdDiscoveryDevice(String key) {
        super(key);
        this.setPartsId("LUN_HIGHEST_PRIORITY");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        EXDDiscoveryDevice discoveryDev = (EXDDiscoveryDevice)dataList.get(0);
        EXDLogicalPath_Fiber logicalPath = (EXDLogicalPath_Fiber)discoveryDev.getLogicalPath();
        int lun = logicalPath.getLun();
        String strLun = SJctrComUtility.toHexString(lun, 4, true);
        if (this.numberMap == null) {
            this.numberMap = new HashMap<String, Integer>(this.getTable().getRowCount());
        }
        this.numberMap.put(strLun, lun);
        return strLun;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public String getInputFormat() {
        return "^([0-9A-Fa-f]{1,4})$";
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        String strNum = this.getString(dat);
        if (!strNum.equals("?")) {
            num = this.numberMap.get(strNum);
        }
        return num;
    }
}

