/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.vpm;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.controller.com.column.vpm.SJctrClprColumDiffInterface;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.system.SJmoClprInfo;

public class SJctrCacheResidentCapacityColumnFromClprInfo
extends SJctrCapacityColumn
implements SJctrClprColumDiffInterface {
    private List<SJmoClprInfo> diffClprList;

    public SJctrCacheResidentCapacityColumnFromClprInfo(String key) {
        super(key);
        this.setScreenId("VPM");
        this.setPartsId("RESIDENT");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrVpmUtility.KEY_CLASS_CLPR_INFO);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoClprInfo> retList = new ArrayList<SJmoClprInfo>();
        if (index instanceof SJmoClprInfo) {
            retList.add((SJmoClprInfo)index);
        }
        if (this.diffClprList == null) {
            List<?> getModelList = modelData.get(KEY_CLASS_DIFF_CLPR_INFO_LIST);
            this.diffClprList = getModelList != null && getModelList.size() != 0 ? getModelList : Collections.emptyList();
        }
        return retList;
    }

    @Override
    public int getFilterType() {
        return 4;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long lRet = -1L;
        SJctrCapacityUtility capUtil = this.getTable().getComUtility().getCapacityUtility();
        Object objKey = this.getPrimaryKeyObject(dat);
        if (objKey != null && objKey instanceof SJmoClprInfo) {
            SJmoClprInfo clprInfo = (SJmoClprInfo)objKey;
            if (!this.diffClprList.isEmpty()) {
                int iSearch = Collections.binarySearch(this.diffClprList, (Object)clprInfo);
                if (iSearch >= 0) {
                    SJmoClprInfo diffClprInfo = this.diffClprList.get(iSearch);
                    lRet = capUtil.valueOf((long)diffClprInfo.getIDCRCapacity(), SJctrCapacityUtility.UNIT.MB);
                }
            } else {
                lRet = capUtil.valueOf((long)clprInfo.getIDCRCapacity(), SJctrCapacityUtility.UNIT.MB);
            }
        }
        return lRet;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRet = null;
        if (dataList != null && dataList.size() != 0 && dataList.get(0) instanceof SJmoClprInfo) {
            SJmoClprInfo clprInfo = (SJmoClprInfo)dataList.get(0);
            String select = this.getUnitSelect();
            SJctrCapacityUtility.UNIT unit = select.length() == 0 ? SJctrCapacityUtility.UNIT.GB : SJctrCapacityUtility.UNIT.valueOf(select);
            SJctrCapacityUtility capUtil = this.getTable().getComUtility().getCapacityUtility();
            long lResidentCache = capUtil.valueOf((long)clprInfo.getIDCRCapacity(), SJctrCapacityUtility.UNIT.MB);
            strRet = capUtil.toString(lResidentCache, unit) + " " + capUtil.getUnitString(unit);
            if (!this.diffClprList.isEmpty()) {
                int iSearch = Collections.binarySearch(this.diffClprList, (Object)clprInfo);
                if (iSearch >= 0) {
                    SJmoClprInfo diffClprInfo = this.diffClprList.get(iSearch);
                    long lDiffResidentCache = capUtil.valueOf((long)diffClprInfo.getIDCRCapacity(), SJctrCapacityUtility.UNIT.MB);
                    String strDiff = capUtil.toString(lDiffResidentCache, unit) + " " + capUtil.getUnitString(unit);
                    strRet = SJctrVpmUtility.toDiffParamDisplay(strRet, strDiff);
                } else {
                    SJctrLogUty.warn("SJctrCacheResidentCapacityColumnFromClprInfo", "toDispString", "Search failure for CLPR. CLPRID" + clprInfo.getSClpr());
                    strRet = null;
                }
            }
        }
        if (strRet == null) {
            strRet = "?";
        }
        return strRet;
    }
}

