/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrAuthorize;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrMainteRoleUtility;
import sanproject.sn2.controller.com.model.SJctrMenuDataModel;
import sanproject.sn2.controller.com.model.SJctrNestedListDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.node.SJctrMenuNodeData;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;
import sanproject.sn2.controller.topwindow.base.SJctrTopMenuModel;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;

public class SJctrActionMenuModel
extends SJctrMenuDataModel {
    public static final String KEY_ACTION = "COM_ACTKEY";
    public static final String KEY_TOOLTIP = "COM_TYPE";
    public static final String KEY_SEL_TYPE = "COM_SEL_TYPE";
    public static final String KEY_NODE_TYPE = "type";
    public static final String NON_ACTION = "";
    public static final int TOOLTIP_NOTING = 0;
    public static final int TOOLTIP_TARGET = 1;
    public static final int TOOLTIP_AUTHORITY = 2;
    public static final int TOOLTIP_PP = 4;
    public static final int SEL_TYPE_UNCONDITIONAL = 0;
    public static final int SEL_TYPE_MULTI = 1;
    public static final int SEL_TYPE_SINGLE = 2;
    public static final int NODE_TYPE_NORMAL = 0;
    public static final int NODE_TYPE_SEPARATOR = 1;
    public static final int NODE_TYPE_LAUNCH = 2;
    public static final String SEPARATOR = "separator";
    public static final Object[] LAUNCH_DATA = new Object[]{null, null, "LAUNCH_DATA", null, null, null, null, null, null, null, null, "", null, 2, null};

    public void addItem(SJctrComUtility util, String[] action, int selType) {
        String name = action[0];
        String label = util.getGuidance(action[1], action[2]);
        String actKey = action[0];
        HashMap<String, Object> item = this.createItem(name, label, actKey);
        Item.setSelectType(item, selType);
        this.addItem(item);
    }

    public HashMap<String, Object> createItem(String name, String label, String actionKey) {
        HashMap<String, Object> item = this.createItem(name, label);
        item.put(KEY_ACTION, actionKey);
        return item;
    }

    public HashMap<String, Object> createItem(String name, String label, String actionKey, int iconId) {
        HashMap<String, Object> item = this.createItem(name, label, iconId);
        item.put(KEY_ACTION, actionKey);
        return item;
    }

    @Override
    public HashMap<String, Object> createItem(SJctrNodeData nodeData, Object ... args) {
        SJctrAuthorize authorize = nodeData.getAuthorize();
        if (!this.chkAdaptiveOpt(nodeData)) {
            this.getLogUty().putlog("createItem", "chkAdaptiveOpt NG:" + nodeData.getLogicalPath() + ",Opt = " + nodeData.getNodeAdaptiveOpt());
            return null;
        }
        if (!authorize.chkResource()) {
            this.getLogUty().putlog("createItem", "chkResource NG:" + nodeData.getLogicalPath());
            return null;
        }
        HashMap<String, Object> item = super.createItem(nodeData, args);
        SJctrMenuNodeData menuData = (SJctrMenuNodeData)nodeData;
        Item.setActionKey(item, menuData.getActionKey());
        Item.setSelectType(item, menuData.getSelType());
        Item.setNodeType(item, menuData.getNodeType());
        this.chkItem(item, nodeData);
        if (menuData.getNodeType() == 2) {
            this.addLaunchMenuItem();
            item = null;
        }
        return item;
    }

    public boolean chkItem(Map<String, Object> item, SJctrNodeData nodeData) {
        String name = Item.getName(item);
        SJctrAuthorize authorize = nodeData.getAuthorize();
        boolean enableFlg = true;
        int toolTip = 0;
        if (!authorize.chkRole()) {
            this.getLogUty().putlog("chkItem", "chkRole NG:" + name);
            enableFlg = false;
            toolTip |= 2;
        }
        if (!authorize.chkPP()) {
            this.getLogUty().putlog("chkItem", "chkPP NG:" + name);
            enableFlg = false;
            toolTip |= 4;
        }
        SJctrMainteRoleUtility roleUtil = new SJctrMainteRoleUtility();
        try {
            roleUtil.setContainer(nodeData.getDataModel().getDataController().getOwner().getAuthorizeContainer());
            if (roleUtil.isMainteRole() == 1) {
                String actionKey = Item.getActionKey(item);
                if (!actionKey.equals(NON_ACTION) && (enableFlg = roleUtil.chkMenuUse(actionKey))) {
                    toolTip = 0;
                }
            } else if (roleUtil.isMainteRole() == 2) {
                enableFlg = false;
            }
        }
        catch (Exception e) {
            this.getLogUty().putlog("createItem", "chkMenuUse NG:" + nodeData.getLogicalPath());
            enableFlg = false;
        }
        Item.setEnable(item, enableFlg);
        Item.setToolTip(item, toolTip);
        return true;
    }

    @Override
    public Map<String, Map<String, Object>> getActionMenu() {
        Map<String, Map<String, Object>> actionMap = super.getActionMenu();
        for (Map map : this.getItemMap().values()) {
            String key = Item.getActionKey(map);
            if (SJctrTopMenuModel.isLaunchMenu((String)key)) continue;
            actionMap.put(key, map);
        }
        return actionMap;
    }

    @Override
    protected HashMap<String, Object> createItem(String name, String label) {
        HashMap<String, Object> item = super.createItem(name, label);
        item.put("enabled", true);
        item.put(KEY_TOOLTIP, 0);
        item.put(KEY_SEL_TYPE, 0);
        return item;
    }

    @Override
    public void clearModelData() {
        this.removeAllItems();
        this.getLogicalPathToNodeDataMap().clear();
    }

    public void addLaunchMenuItem() {
        SJctrDataController dc = this.getDataController();
        if (dc == null) {
            this.getLogUty().putlog("addLaunchMenu", "DC is null", 30000);
            return;
        }
        SJctrTopWindowDC topDc = dc.getTopWindow();
        if (topDc == null) {
            this.getLogUty().putlog("addLaunchMenu", "TopWindowDC is null", 30000);
            return;
        }
        int id = dc.getDisplayId();
        List menuList = topDc.getLaunchMenu(id);
        this.getLogUty().putlog("addLaunchMenu", "add => " + menuList.size());
        if (menuList.isEmpty()) {
            return;
        }
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                String name = (String)event.getChangeObject();
                SJctrActionMenuModel.this.selectLaunchMenu(name);
            }
        });
        for (HashMap menu : menuList) {
            String name = Item.getName(menu);
            String newName = SJctrTopMenuModel.toActionMenuName((String)name);
            if (newName == null) continue;
            menu.put("name", newName);
            Item.setActionKey(menu, newName);
            Item.setEnable(menu, true);
            Item.setToolTip(menu, 0);
            Item.setSelectType(menu, 0);
            this.addItem(menu);
        }
    }

    private void selectLaunchMenu(String name) {
        if (SJctrTopMenuModel.isLaunchMenu((String)name)) {
            this.getLogUty().putlog("Select Launch Menu", name);
            String newName = SJctrTopMenuModel.toTopMenuName((String)name);
            this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.SELECT_MENU, newName);
        }
    }

    public void updateActionMenu() {
        this.clearModelData();
        this.getLogicalPathToNodeDataMap().clear();
        this.initLogicalNode();
        this.initNode();
    }

    @Override
    protected void makeDataObject() {
        this.initLogicalNode();
        this.initNode();
    }

    public static class Item
    extends SJctrNestedListDataModel.Item {
        public static String getActionKey(Map<String, Object> item) {
            String result = SJctrActionMenuModel.NON_ACTION;
            if (item != null && (result = (String)item.get(SJctrActionMenuModel.KEY_ACTION)) == null) {
                result = SJctrActionMenuModel.NON_ACTION;
            }
            return result;
        }

        public static Integer getSelType(Map<String, Object> item) {
            Integer result = 0;
            if (item != null && (result = (Integer)item.get(SJctrActionMenuModel.KEY_SEL_TYPE)) == null) {
                result = 0;
            }
            return result;
        }

        public static int getToolTip(Map<String, Object> item) {
            Integer result = 0;
            if (item != null && (result = (Integer)item.get(SJctrActionMenuModel.KEY_TOOLTIP)) == null) {
                result = 0;
            }
            return result;
        }

        public static boolean setActionKey(Map<String, Object> item, String actionKey) {
            if (item == null) {
                return false;
            }
            Object oldValue = item.put(SJctrActionMenuModel.KEY_ACTION, actionKey);
            if (oldValue == null) {
                return true;
            }
            return !oldValue.equals(actionKey);
        }

        public static boolean setSelectType(Map<String, Object> item, Integer type) {
            if (item == null) {
                return false;
            }
            Object oldValue = item.put(SJctrActionMenuModel.KEY_SEL_TYPE, type);
            if (oldValue == null) {
                return true;
            }
            return !oldValue.equals(type);
        }

        public static boolean setToolTip(Map<String, Object> item, Integer toolTip) {
            if (item == null) {
                return false;
            }
            Object oldValue = item.put(SJctrActionMenuModel.KEY_TOOLTIP, toolTip);
            if (oldValue == null) {
                return true;
            }
            return !oldValue.equals(toolTip);
        }

        public static boolean setNodeType(Map<String, Object> item, int nodeType) {
            Object oldValue;
            String newValue;
            if (item == null) {
                return false;
            }
            if ((nodeType & 1) == 1) {
                newValue = SJctrActionMenuModel.SEPARATOR;
                oldValue = item.put(SJctrActionMenuModel.KEY_NODE_TYPE, newValue);
            } else {
                newValue = null;
                oldValue = item.remove(SJctrActionMenuModel.KEY_NODE_TYPE);
            }
            if (oldValue == null) {
                return true;
            }
            return !oldValue.equals(newValue);
        }

        public Item(Map<String, Object> map) {
            super(map);
        }
    }
}

