/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.model;

import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrItemStateLintener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;

public abstract class SJctrSelectableDataModel
extends SJctrDataObjectModel<SJctrSelectableDataObject> {
    public static boolean isEnable(SJctrSelectableDataObject selectable) {
        if (selectable == null) {
            return false;
        }
        Integer enable = selectable.visible();
        return enable.equals(SJctrSelectableDataObject.VISIBLE_ACTIVE);
    }

    public static boolean isSelect(SJctrSelectableDataObject selectable) {
        if (selectable == null) {
            return false;
        }
        Integer select = selectable.selected();
        return select.equals(SJctrSelectableDataObject.SEL_ON);
    }

    public static boolean isVisible(SJctrSelectableDataObject selectable) {
        if (selectable == null) {
            return false;
        }
        Integer visible = selectable.visible();
        return !visible.equals(SJctrSelectableDataObject.VISIBLE_INVISIBLE);
    }

    public static boolean setEnable(SJctrSelectableDataObject selectable, boolean flg) {
        Integer state = flg ? SJctrSelectableDataObject.VISIBLE_ACTIVE : SJctrSelectableDataObject.VISIBLE_INACTIVE;
        return SJctrSelectableDataModel.setState(selectable, state);
    }

    public static boolean setState(SJctrSelectableDataObject selectable, Integer state) {
        if (selectable == null) {
            return false;
        }
        boolean result = !selectable.visible().equals(state);
        selectable.visible(state);
        return result;
    }

    public static boolean setVisible(SJctrSelectableDataObject selectable, boolean flg) {
        Integer state = flg ? SJctrSelectableDataObject.VISIBLE_ACTIVE : SJctrSelectableDataObject.VISIBLE_INVISIBLE;
        return SJctrSelectableDataModel.setState(selectable, state);
    }

    static boolean setSelect(SJctrSelectableDataObject selectable, boolean flg) {
        if (selectable == null) {
            return false;
        }
        Integer select = flg ? SJctrSelectableDataObject.SEL_ON : SJctrSelectableDataObject.SEL_OFF;
        boolean result = !selectable.selected().equals(select);
        selectable.selected(select);
        return result;
    }

    public SJctrSelectableDataModel() {
        this(null);
    }

    public SJctrSelectableDataModel(String label) {
        SJctrSelectableDataObject selectable = (SJctrSelectableDataObject)this.getManageData();
        SJctrSelectableDataModel.setState(selectable, SJctrSelectableDataObject.VISIBLE_ACTIVE);
        if (label != null) {
            selectable.label(label);
        }
        this.initListener();
    }

    public void addItemSelectListener(SJctrItemSelectListener listener) {
        this.addEventListener(listener);
    }

    @Override
    public void addItemStateChangeLintener(SJctrItemStateLintener listener) {
        super.addItemStateChangeLintener(listener);
    }

    public boolean isEnable() {
        SJctrSelectableDataObject selectable = (SJctrSelectableDataObject)this.getManageData();
        return SJctrSelectableDataModel.isEnable(selectable);
    }

    public boolean isSelect() {
        SJctrSelectableDataObject selectable = (SJctrSelectableDataObject)this.getManageData();
        return SJctrSelectableDataModel.isSelect(selectable);
    }

    public boolean isVisible() {
        SJctrSelectableDataObject selectable = (SJctrSelectableDataObject)this.getManageData();
        return SJctrSelectableDataModel.isVisible(selectable);
    }

    public void setEnable(boolean flg) {
        SJctrSelectableDataObject selectable = (SJctrSelectableDataObject)this.getManageData();
        boolean result = SJctrSelectableDataModel.setEnable(selectable, flg);
        if (result) {
            this.fireItemStateChanged();
        }
    }

    public void setLabel(String label) {
        SJctrSelectableDataObject selectable = (SJctrSelectableDataObject)this.getManageData();
        boolean equal = selectable.label().equals(label);
        if (!equal) {
            selectable.label(label);
            this.fireItemStateChanged();
        }
    }

    public abstract void setSelect(boolean var1);

    public void setVisible(boolean flg) {
        SJctrSelectableDataObject selectable = (SJctrSelectableDataObject)this.getManageData();
        boolean result = SJctrSelectableDataModel.setVisible(selectable, flg);
        if (result) {
            this.fireItemStateChanged();
        }
    }

    @Override
    protected SJctrSelectableDataObject createManageData() {
        return new SJctrSelectableDataObject();
    }

    protected abstract void fireItemSelected();

    @Override
    protected void fireItemStateChanged() {
        super.fireItemStateChanged();
    }

    @Override
    protected void makeDataObject() {
    }

    @Override
    protected void makeModelDirect() {
    }

    private void initListener() {
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrSelectableDataObject) {
                    SJctrSelectableDataModel.this.setSelectAction((SJctrSelectableDataObject)setObject);
                }
            }
        });
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrSelectableDataObject) {
                    SJctrSelectableDataModel.this.setVisibleAction((SJctrSelectableDataObject)setObject);
                }
            }
        });
    }

    private void setSelectAction(SJctrSelectableDataObject setObject) {
        this.setSelect(SJctrSelectableDataModel.isSelect(setObject));
    }

    private void setVisibleAction(SJctrSelectableDataObject setObject) {
        if (!setObject.getDataMap().containsKey("COM_VISIBLE")) {
            return;
        }
        if (SJctrSelectableDataModel.setState((SJctrSelectableDataObject)this.getManageData(), setObject.visible())) {
            this.fireItemStateChanged();
        }
    }
}

