/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.systemcall.mappiniset.com;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.systemcall.mappiniset.com.SJcmdMappDkcSetException;

public class SJcmdMappDkcSetUtility {
    private static final String LOG_MODULE = "MappIniSet";
    private static final String LOG_FUNCTION = SJcmdMappDkcSetUtility.class.getSimpleName();
    public static final int NORMAL_END = 0;
    private static final long DEFAULT_TIMEOUT_MILLIS = 3600000L;

    public static String concatFilePath(String ... pathList) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcmdMappDkcSetUtility.checkNullParameter(pathList);
        if (pathList.length <= 1) {
            SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "pathList element count:" + Integer.toString(pathList.length));
            throw new SJcmdMappDkcSetException("207500");
        }
        String path = pathList[0];
        String pathAdd = "";
        SJcmdMappDkcSetUtility.checkStrFilePathParameter(path);
        for (int i = 1; i < pathList.length; ++i) {
            if (pathList[i].isEmpty()) continue;
            SJcmdMappDkcSetUtility.checkStrFilePathParameter(pathList[i]);
            pathAdd = pathList[i];
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (pathAdd.startsWith(File.separator)) {
                pathAdd = pathAdd.substring(1);
            }
            path = path + File.separator + pathAdd;
        }
        return path;
    }

    private static void makeParentDirectory(File file) throws SJcmdMappDkcSetException {
        File dir;
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcmdMappDkcSetUtility.checkFileParameter(file);
        boolean bChk = true;
        if (!file.exists() && !(dir = (file = file.getAbsoluteFile()).getParentFile()).exists()) {
            bChk = dir.mkdirs();
        }
        if (!bChk) {
            SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "failed:" + file.getAbsolutePath());
            throw new SJcmdMappDkcSetException("207501");
        }
        SJcLogUty.getLogger().info(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "succeeded:" + file.getAbsolutePath());
    }

    public static void deleteFile(String strFilePath) throws SJcmdMappDkcSetException {
        SJcmdMappDkcSetUtility.checkStrFilePathParameter(strFilePath);
        SJcmdMappDkcSetUtility.deleteFile(new File(strFilePath));
    }

    private static void deleteFile(File file) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcmdMappDkcSetUtility.checkFileParameter(file);
        boolean bChk = true;
        if (file.exists()) {
            if (file.isFile()) {
                bChk &= file.delete();
            }
            if (file.isDirectory()) {
                File[] eltFiles;
                for (File eltFile : eltFiles = file.listFiles()) {
                    SJcmdMappDkcSetUtility.deleteFile(eltFile);
                }
                bChk &= file.delete();
            }
        }
        if (!bChk) {
            SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "failed:" + file.getAbsolutePath());
            throw new SJcmdMappDkcSetException("207501");
        }
        SJcLogUty.getLogger().info(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "succeeded:" + file.getAbsolutePath());
    }

    public static void copySingleFile(String strSendFilePath, String strDestFilePath) throws SJcmdMappDkcSetException {
        SJcmdMappDkcSetUtility.checkStrFilePathParameter(strSendFilePath);
        SJcmdMappDkcSetUtility.checkStrFilePathParameter(strDestFilePath);
        SJcmdMappDkcSetUtility.copySingleFile(new File(strSendFilePath), new File(strDestFilePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySingleFile(File sendFile, File destFile) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcmdMappDkcSetUtility.checkFileParameter(sendFile);
        SJcmdMappDkcSetUtility.checkFileParameter(destFile);
        FileChannel fcSrc = null;
        FileChannel fcDst = null;
        FileLock fileLock = null;
        SJcmdMappDkcSetUtility.makeParentDirectory(destFile);
        try {
            SJcLogUty.getLogger().info(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "copy sendFile:" + sendFile.getAbsolutePath());
            fcSrc = new FileInputStream(sendFile).getChannel();
            fcDst = new FileOutputStream(destFile).getChannel();
            fileLock = fcDst.tryLock();
            if (fileLock == null) {
                SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "destFile failed to get fileLock:" + destFile.getAbsolutePath());
                throw new SJcmdMappDkcSetException("207501");
            }
            try {
                fcSrc.transferTo(0L, fcSrc.size(), fcDst);
            }
            finally {
                fileLock.release();
            }
            SJcLogUty.getLogger().info(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "copy destFile:" + destFile.getAbsolutePath());
        }
        catch (IOException e) {
            try {
                SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, IOException.class.getSimpleName() + " is occurred", e);
                throw new SJcmdMappDkcSetException("207501");
            }
            catch (Throwable throwable) {
                SJcmdMappDkcSetUtility.closeIgnoringException(fcDst);
                SJcmdMappDkcSetUtility.closeIgnoringException(fcSrc);
                destFile.setLastModified(sendFile.lastModified());
                throw throwable;
            }
        }
        SJcmdMappDkcSetUtility.closeIgnoringException(fcDst);
        SJcmdMappDkcSetUtility.closeIgnoringException(fcSrc);
        destFile.setLastModified(sendFile.lastModified());
    }

    public static String getPropValue(String strFilePath, String strKey) throws SJcmdMappDkcSetException {
        Properties prop = SJcmdMappDkcSetUtility.loadProperties(strFilePath);
        SJcmdMappDkcSetUtility.checkPropertiesParameter(prop);
        SJcmdMappDkcSetUtility.checkStringParameter(strKey);
        String strRet = "";
        for (String key : prop.stringPropertyNames()) {
            if (!strKey.equals(key)) continue;
            strRet = prop.getProperty(key);
        }
        return strRet;
    }

    public static Properties loadProperties(String strFilePath) throws SJcmdMappDkcSetException {
        SJcmdMappDkcSetUtility.checkStrExistFilePathParameter(strFilePath);
        return SJcmdMappDkcSetUtility.loadProperties(new File(strFilePath));
    }

    private static Properties loadProperties(File file) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcmdMappDkcSetUtility.checkFileParameter(file);
        Properties prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            prop.load(fis);
        }
        catch (IOException e) {
            try {
                SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, IOException.class.getSimpleName() + " is occurred", e);
                throw new SJcmdMappDkcSetException("207501");
            }
            catch (Throwable throwable) {
                SJcmdMappDkcSetUtility.closeIgnoringException(fis);
                throw throwable;
            }
        }
        SJcmdMappDkcSetUtility.closeIgnoringException(fis);
        return prop;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<String> execExtCommand(String strExtCommand) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcmdMappDkcSetUtility.checkStringParameter(strExtCommand);
        Closeable br = null;
        InputStream is = null;
        InputStream errIs = null;
        ArrayList<Object> retLines = new ArrayList();
        try {
            SJcLogUty.getLogger().info(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "External Command Execute Start");
            Process p = Runtime.getRuntime().exec(strExtCommand);
            is = p.getInputStream();
            errIs = p.getErrorStream();
            InputStreamThread inStreamThread = new InputStreamThread(is);
            InputStreamThread errInStreamThread = new InputStreamThread(errIs);
            inStreamThread.start();
            errInStreamThread.start();
            int resultCode = p.waitFor();
            inStreamThread.join();
            errInStreamThread.join();
            SJcmdMappDkcSetException execIsErr = inStreamThread.getException();
            if (execIsErr != null) {
                throw execIsErr;
            }
            SJcmdMappDkcSetException execErrIsErr = errInStreamThread.getException();
            if (execErrIsErr != null) {
                throw execErrIsErr;
            }
            retLines = inStreamThread.getStandardOut();
            retLines.add(0, String.valueOf(resultCode));
            SJcLogUty.getLogger().info(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "External Command Execute End");
        }
        catch (InterruptedException e) {
            try {
                SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, InterruptedException.class.getSimpleName() + " is occurred", e);
                throw new SJcmdMappDkcSetException("207501");
                catch (IOException e2) {
                    SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, IOException.class.getSimpleName() + " is occurred", e2);
                    throw new SJcmdMappDkcSetException("207501");
                }
            }
            catch (Throwable throwable) {
                SJcmdMappDkcSetUtility.closeIgnoringException(br);
                SJcmdMappDkcSetUtility.closeIgnoringException(is);
                SJcmdMappDkcSetUtility.closeIgnoringException(errIs);
                throw throwable;
            }
        }
        SJcmdMappDkcSetUtility.closeIgnoringException(br);
        SJcmdMappDkcSetUtility.closeIgnoringException(is);
        SJcmdMappDkcSetUtility.closeIgnoringException(errIs);
        return retLines;
    }

    public static ArrayList<String> execExtCommandThread(String strExtCommand) throws SJcmdMappDkcSetException {
        ArrayList<String> retLines = SJcmdMappDkcSetUtility.execExtCommandThread(strExtCommand, 3600000L);
        return retLines;
    }

    public static ArrayList<String> execExtCommandThread(String strExtCommand, long timeOut) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcmdMappDkcSetUtility.checkStringParameter(strExtCommand);
        ArrayList<String> retLines = new ArrayList();
        ExecExternalProcessThread processThread = new ExecExternalProcessThread(strExtCommand);
        processThread.start();
        Timer watchTimer = new Timer();
        watchTimer.schedule((TimerTask)new ExecExternalProcessWatchThread(processThread), timeOut);
        try {
            processThread.join();
        }
        catch (InterruptedException e) {
            SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, InterruptedException.class.getSimpleName() + " is occurred", e);
            throw new SJcmdMappDkcSetException("207500");
        }
        finally {
            watchTimer.cancel();
        }
        SJcmdMappDkcSetException execErr = processThread.getException();
        if (execErr != null) {
            throw execErr;
        }
        retLines = processThread.getResultLines();
        return retLines;
    }

    public static void checkExtCommandResult(ArrayList<String> resultLines) throws SJcmdMappDkcSetException {
        boolean result = SJcmdMappDkcSetUtility.checkExtCommandReturnValue(resultLines);
        if (!result) {
            throw new SJcmdMappDkcSetException("207505");
        }
    }

    public static boolean checkExtCommandReturnValue(ArrayList<String> resultLines) {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        int resultCode = SJcmdMappDkcSetUtility.getExtCommandReturnCode(resultLines);
        if (resultCode != 0) {
            SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "Command return code:" + resultCode);
            return false;
        }
        return true;
    }

    public static int getExtCommandReturnCode(ArrayList<String> resultLines) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (resultLines == null || resultLines.size() == 0) {
            SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "Command return code is illegal");
            throw new SJcmdMappDkcSetException("207505");
        }
        int resultCode = 0;
        try {
            resultCode = Integer.parseInt(resultLines.get(0));
        }
        catch (NumberFormatException e) {
            SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "Command return code is illegal");
            throw new SJcmdMappDkcSetException("207505");
        }
        return resultCode;
    }

    public static void closeIgnoringException(Closeable closeable) {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "closeable close is falied", e);
            }
        } else {
            SJcLogUty.getLogger().warn(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "closeable is null");
        }
    }

    public static void checkFileParameter(File file) throws SJcmdMappDkcSetException {
        SJcmdMappDkcSetUtility.checkNullParameter(file);
    }

    public static void checkPropertiesParameter(Properties prop) throws SJcmdMappDkcSetException {
        SJcmdMappDkcSetUtility.checkNullParameter(prop);
    }

    public static void checkStrExistFilePathParameter(String strFilePath) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcmdMappDkcSetUtility.checkStrFilePathParameter(strFilePath);
        if (!new File(strFilePath).exists()) {
            SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "file does not exist:" + strFilePath);
            throw new SJcmdMappDkcSetException("207500");
        }
    }

    private static void checkStrFilePathParameter(String strFilePath) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcmdMappDkcSetUtility.checkStringParameter(strFilePath);
        if (strFilePath.length() == 0) {
            SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "strParam length is zero");
            throw new SJcmdMappDkcSetException("207500");
        }
    }

    private static void checkStringParameter(String strParam) throws SJcmdMappDkcSetException {
        SJcmdMappDkcSetUtility.checkNullParameter(strParam);
    }

    private static void checkNullParameter(Object param) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (param == null) {
            SJcLogUty.getLogger().error(LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "param is null");
            throw new SJcmdMappDkcSetException("207500");
        }
    }

    public static void outputMessage(String strMessage) {
        if (strMessage != null) {
            String[] messageArray;
            for (String message : messageArray = strMessage.split("\\n")) {
                System.out.println(message);
            }
        }
    }

    public static String getFileName(String filePathName) {
        File file = new File(filePathName);
        String fileName = file.getName();
        return fileName;
    }

    static class ExecExternalProcessThread
    extends Thread {
        private static final String LOG_FUNCTION_NAME = ExecExternalProcessThread.class.getSimpleName();
        private String cmd = null;
        private ArrayList<String> resultLines = new ArrayList();
        private SJcmdMappDkcSetException exception = null;
        private boolean isTimeout = false;

        public ExecExternalProcessThread(String cmd) {
            this.cmd = cmd;
        }

        @Override
        public void run() {
            String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
            try {
                this.resultLines = SJcmdMappDkcSetUtility.execExtCommand(this.cmd);
            }
            catch (SJcmdMappDkcSetException e) {
                if (this.isTimeout) {
                    SJcLogUty.getLogger().error(SJcmdMappDkcSetUtility.LOG_MODULE, LOG_FUNCTION_NAME, LOG_METHOD, "Execute external process thread is timeout", e);
                    this.exception = new SJcmdMappDkcSetException("207504", true);
                }
                SJcLogUty.getLogger().error(SJcmdMappDkcSetUtility.LOG_MODULE, LOG_FUNCTION_NAME, LOG_METHOD, IOException.class.getSimpleName() + " is occurred", e);
                this.exception = e;
            }
        }

        public ArrayList<String> getResultLines() {
            return this.resultLines;
        }

        public SJcmdMappDkcSetException getException() {
            return this.exception;
        }

        public void setTimeout(boolean isTimeout) {
            this.isTimeout = isTimeout;
        }
    }

    private static class ExecExternalProcessWatchThread
    extends TimerTask {
        private static final String LOG_FUNCTION_NAME = ExecExternalProcessWatchThread.class.getSimpleName();
        private ExecExternalProcessThread processThread = null;

        public ExecExternalProcessWatchThread(ExecExternalProcessThread processThread) {
            this.processThread = processThread;
        }

        @Override
        public void run() {
            String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
            SJcLogUty.getLogger().info(SJcmdMappDkcSetUtility.LOG_MODULE, LOG_FUNCTION_NAME, LOG_METHOD, "Start");
            this.processThread.setTimeout(true);
            this.processThread.interrupt();
            SJcLogUty.getLogger().info(SJcmdMappDkcSetUtility.LOG_MODULE, LOG_FUNCTION_NAME, LOG_METHOD, "End");
        }
    }

    private static class InputStreamThread
    extends Thread {
        private static final String LOG_FUNCTION_NAME = InputStreamThread.class.getSimpleName();
        private ArrayList<String> retLines = new ArrayList();
        private InputStream is = null;
        private SJcmdMappDkcSetException exception = null;

        public InputStreamThread(InputStream is) {
            this.is = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
            BufferedReader br = null;
            try {
                String line = null;
                br = new BufferedReader(new InputStreamReader(this.is));
                while ((line = br.readLine()) != null) {
                    if (0 < line.length()) {
                        SJcLogUty.getLogger().info(SJcmdMappDkcSetUtility.LOG_MODULE, LOG_FUNCTION, LOG_METHOD, "execute result:" + line);
                    }
                    this.retLines.add(line);
                }
            }
            catch (IOException e) {
                try {
                    SJcLogUty.getLogger().error(SJcmdMappDkcSetUtility.LOG_MODULE, LOG_FUNCTION_NAME, LOG_METHOD, IOException.class.getSimpleName() + " is occurred", e);
                    this.exception = new SJcmdMappDkcSetException("207505");
                }
                catch (Throwable throwable) {
                    SJcmdMappDkcSetUtility.closeIgnoringException(br);
                    throw throwable;
                }
                SJcmdMappDkcSetUtility.closeIgnoringException(br);
            }
            SJcmdMappDkcSetUtility.closeIgnoringException(br);
        }

        public ArrayList<String> getStandardOut() {
            return this.retLines;
        }

        public SJcmdMappDkcSetException getException() {
            return this.exception;
        }
    }
}

