/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.HitachiCacheMangerService;
import com.hitachi.smi.cache.LDEVBranchChecker;
import com.hitachi.smi.cache.PoolBranchChecker;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ThinPool;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.DaemonThreadFactory;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import sanproject.common.Robj_interface_LUNMgetLDEVStatus;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serverux.data.SANRmiException;

public class HealthStateMonitor
implements Runnable {
    private static HealthStateMonitor mMonitor = null;
    private static Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private static int consecutiveLDEVErrors = 0;
    private final ScheduledExecutorService mScheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory());
    private final ExecutorService mWorkerThreadPool;

    public static final boolean isRunning() {
        return null != mMonitor;
    }

    public static final synchronized boolean startHealthStateMonitor() {
        boolean ret;
        block5: {
            ret = true;
            try {
                if (null == mMonitor) {
                    mMonitor = new HealthStateMonitor();
                    int delay = ProviderProperties.getVersionCheckIntervalSeconds();
                    HealthStateMonitor.mMonitor.mScheduler.scheduleWithFixedDelay(mMonitor, delay, delay, TimeUnit.SECONDS);
                } else if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Health state monitor has already been started", new Exception("Trace for calling"));
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Unable to start health state monitor", t);
                ret = false;
                if (null == mMonitor) break block5;
                HealthStateMonitor.stop();
                mMonitor = null;
            }
        }
        return ret;
    }

    public static final synchronized void stop() {
        if (null != mMonitor) {
            mMonitor.terminate();
        }
        mMonitor = null;
    }

    private HealthStateMonitor() {
        int core = 4;
        this.mWorkerThreadPool = Executors.newFixedThreadPool(4, (ThreadFactory)new DaemonThreadFactory());
        ((ThreadPoolExecutor)this.mWorkerThreadPool).setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                mLogger.log(Level.SEVERE, "Failed to process {0} for health state, executor: {1}", new Object[]{r, executor});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHDDStatus(RMIObjectMapping device) {
        String serial = null;
        try {
            serial = device.getSerialNumber();
            Thread.currentThread().setName("Active - HDD Status for " + serial);
            LinkedList<PDEVInfoEntry> added = new LinkedList<PDEVInfoEntry>();
            LinkedList<PDEVInfoEntry> removed = new LinkedList<PDEVInfoEntry>();
            LinkedList<PDEVInfoEntry> modified = new LinkedList<PDEVInfoEntry>();
            if (!HitachiCacheMangerService.isShuttingDown()) {
                PDEVInfoEntry.compareBackEnd2Cache(added, modified, removed, serial);
                CacheUpdater.doCallback((String)serial, (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PDEVINFOENTRY, (Serializable[])modified.toArray(new PDEVInfoEntry[modified.size()]));
            }
        }
        catch (Throwable t) {
            LogRecord record = new LogRecord(Level.SEVERE, "Exception while checking HDD status on {0}, will try again later");
            record.setParameters(new Object[]{serial});
            record.setThrown(t);
            mLogger.log(record);
        }
        finally {
            mLogger.log(Level.INFO, "HDD status for {0} completed.", serial);
            Thread.currentThread().setName("Inactive - HDD status checker for " + serial);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLDEVHealthState(RMIObjectMapping device) {
        String serial = null;
        try {
            Robj_interface_RJiLDEVIndex[] indexes;
            serial = device.getSerialNumber();
            Thread.currentThread().setName("Active LDEV health checker for " + serial);
            mLogger.log(Level.INFO, "Getting LDEV health state for {0}.", serial);
            RMIObjectCache rmiObj = device.getRMIObject();
            TreeMap<Long, DeviceNumber> dnMap = new TreeMap<Long, DeviceNumber>();
            if (consecutiveLDEVErrors > 3) {
                mLogger.log(Level.SEVERE, "Device {0} has failed to get LDEV health data {1} times, using direct RMI call", new Object[]{serial, consecutiveLDEVErrors});
                indexes = rmiObj.getLDEVIndex();
            } else {
                mLogger.log(Level.FINE, "Getting LDEV info from cache for {0} for health check", serial);
                ClosableAddableIteratorCB<DeviceNumber> callback = new ClosableAddableIteratorCB<DeviceNumber>();
                DeviceNumber.getDNs(rmiObj, callback, false, true, null, -1, -1, -1, false);
                CloseableAddableIterator<DeviceNumber> dns = callback.getWrappedCloseableAddableIter();
                ArrayList<Robj_interface_RJiLDEVIndex> tmp = new ArrayList<Robj_interface_RJiLDEVIndex>(Short.MAX_VALUE);
                while (dns.hasNext()) {
                    DeviceNumber dn = (DeviceNumber)dns.next();
                    Robj_interface_RJiLDEVIndex ldev = (Robj_interface_RJiLDEVIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX);
                    ldev.setLDEVIndex(dn.getLdkc(), dn.getCu(), dn.getLdev());
                    tmp.add(ldev);
                    if (null == dnMap.put(dn.getDn(), dn)) continue;
                    mLogger.log(Level.SEVERE, "There is already a DN in the stored for {0}", dn);
                }
                indexes = tmp.toArray(new Robj_interface_RJiLDEVIndex[tmp.size()]);
            }
            mLogger.log(Level.FINE, "There are {0} LDEVs to check on {1}", new Object[]{indexes.length, serial});
            ArrayList<Future<Short[]>> ldevResults = new ArrayList<Future<Short[]>>(indexes.length);
            if (!HitachiCacheMangerService.isShuttingDown() && indexes.length > 0) {
                Robj_interface_LUNMgetLDEVStatus[] statusDetails;
                try {
                    statusDetails = rmiObj.getLDEVStatus(indexes);
                    consecutiveLDEVErrors = 0;
                }
                catch (RemoteException | SANRmiException e) {
                    LogRecord log = new LogRecord(Level.SEVERE, "Error getting LDEVStatus on {0}, it has failed {1} times.");
                    log.setParameters(new Object[]{serial, ++consecutiveLDEVErrors});
                    log.setThrown(e);
                    mLogger.log(log);
                    mLogger.log(Level.INFO, "LDEV health check for {0} done.", serial);
                    Thread.currentThread().setName("Inactive LDEV health checker for " + serial);
                    return;
                }
                for (Robj_interface_LUNMgetLDEVStatus status : statusDetails) {
                    LDEVStatusCheckThread worker = new LDEVStatusCheckThread(device.getSerialNumber(), rmiObj, status, dnMap);
                    ldevResults.add(this.mWorkerThreadPool.submit(worker));
                }
            }
            mLogger.log(Level.FINE, "LDEV health state requests submitted for {0}.", serial);
            LinkedList<Short[]> modifiedDNs = this.getChangedStatuses(serial, ldevResults);
            mLogger.log(Level.FINE, "LDEV health state found {0} modified LDEV on {1}.", new Object[]{modifiedDNs.size(), serial});
            LDEVBranchChecker.processAffectedDNs(null, modifiedDNs, null, device.getSerialNumber());
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Error updating LDEV health status for " + serial + ", will try again later", t);
        }
        finally {
            mLogger.log(Level.INFO, "LDEV health check for {0} done.", serial);
            Thread.currentThread().setName("Inactive LDEV health checker for " + serial);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPoolHealthState(RMIObjectMapping device) {
        String serial = null;
        try {
            serial = device.getSerialNumber();
            Thread.currentThread().setName("Active - pool health checker for " + serial);
            ClosableAddableIteratorCB<ThinPool> cachedPools = new ClosableAddableIteratorCB<ThinPool>();
            ThinPool.getThinPools(device.getRMIObject(), cachedPools, (short)-1);
            CloseableAddableIterator<ThinPool> tps = cachedPools.getWrappedCloseableAddableIter();
            LinkedList<Short> pools2Check = new LinkedList<Short>();
            while (tps.hasNext() && HitachiCacheMangerService.isShuttingDown()) {
                ThinPool tp = (ThinPool)tps.next();
                pools2Check.add(tp.getPoolID());
            }
            this.modifyPoolStatus(serial, pools2Check);
        }
        catch (Throwable t) {
            LogRecord record = new LogRecord(Level.SEVERE, "Exception while checking pool status on {0}, will try again later");
            record.setParameters(new Object[]{serial});
            record.setThrown(t);
            mLogger.log(record);
        }
        finally {
            mLogger.log(Level.INFO, "Pool health state for {0} completed.", serial);
            Thread.currentThread().setName("Inactive - pool health checker for " + serial);
        }
    }

    private LinkedList<Short[]> getChangedStatuses(String serial, List<Future<Short[]>> results) {
        LinkedList<Short[]> modified = new LinkedList<Short[]>();
        do {
            Iterator<Future<Short[]>> iter = results.iterator();
            mLogger.log(Level.FINEST, "Waiting for threads to finish checking ldevs on {0}", serial);
            while (iter.hasNext() && !HitachiCacheMangerService.isShuttingDown()) {
                Future<Short[]> result = iter.next();
                if (!result.isDone()) continue;
                iter.remove();
                Short[] vals = null;
                try {
                    vals = result.get();
                }
                catch (InterruptedException ie) {
                    mLogger.log(Level.FINER, "Iteruppted getting health state result", ie);
                }
                catch (Throwable t) {
                    mLogger.log(Level.SEVERE, "Exception occurred getting LDEV health state result", t);
                }
                if (null == vals || -1 == vals[0]) continue;
                modified.offer(vals);
            }
            int numLeft = results.size();
            if (0 == numLeft || HitachiCacheMangerService.isShuttingDown()) continue;
            try {
                Thread.sleep(numLeft > 20 ? 1000L : 250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (0 != results.size() && !HitachiCacheMangerService.isShuttingDown());
        mLogger.log(Level.FINE, "All threads finished checking ldevs on {0}", serial);
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyPoolStatus(String serial, LinkedList<Short> pools2Check) {
        mLogger.log(Level.INFO, "Checking {0} pool health statuses on {1}", new Object[]{pools2Check.size(), serial});
        try {
            if (pools2Check.size() > 0 && !HitachiCacheMangerService.isShuttingDown()) {
                PoolBranchChecker.processModifiedTPs(serial, pools2Check);
            }
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Caught exception checking pool status on " + serial, t);
        }
        finally {
            mLogger.log(Level.INFO, "Done checking pool health status on {0}", serial);
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("HealthState Checker - Active");
        mLogger.fine("Health state monitor thread starting.");
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        ArrayList runables = new ArrayList();
        for (final RMIObjectMapping device : devices) {
            if (HitachiCacheMangerService.isShuttingDown()) break;
            String serial = null;
            try {
                mLogger.log(Level.FINE, "Submitting LDEV requests for {0}", serial);
                Future<?> temp = this.mWorkerThreadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        HealthStateMonitor.this.checkLDEVHealthState(device);
                    }
                });
                runables.add(temp);
                if (!CacheUpdater.isUpating()) {
                    serial = device.getSerialNumber();
                    mLogger.log(Level.FINE, "Submitting pool requests for {0}", serial);
                    temp = this.mWorkerThreadPool.submit(new Runnable(){

                        @Override
                        public void run() {
                            HealthStateMonitor.this.checkPoolHealthState(device);
                        }
                    });
                    runables.add(temp);
                } else {
                    mLogger.info("Cache update in progress, skipping pool health check");
                }
                if (!CacheUpdater.isUpating()) {
                    mLogger.log(Level.FINE, "Submitting HDD status requests for {0}", serial);
                    temp = this.mWorkerThreadPool.submit(new Runnable(){

                        @Override
                        public void run() {
                            HealthStateMonitor.this.checkHDDStatus(device);
                        }
                    });
                    runables.add(temp);
                    continue;
                }
                mLogger.info("Cache update in progress, skipping HDD health check");
            }
            catch (Throwable t) {
                LogRecord record = new LogRecord(Level.SEVERE, "An error occurred trying to start health state threads for {0}, futures {1}");
                record.setThrown(t);
                record.setParameters(new Object[]{device, runables});
                mLogger.log(record);
            }
        }
        mLogger.fine("Health state requests submitted.");
        Iterator iter = runables.iterator();
        while (!HitachiCacheMangerService.isShuttingDown() && iter.hasNext()) {
            int x;
            mLogger.log(Level.FINE, "Health state status thread waiting for {0} threads", runables.size());
            Future future = (Future)iter.next();
            iter.remove();
            for (x = 0; !HitachiCacheMangerService.isShuttingDown() && x < 7; ++x) {
                try {
                    if (null != future.get(2143L, TimeUnit.MILLISECONDS) || !future.isDone()) continue;
                    break;
                }
                catch (TimeoutException e) {
                    mLogger.log(Level.FINER, "Wait # {0} timed out (this is ok)...", x);
                    continue;
                }
                catch (CancellationException e) {
                    mLogger.finer("Health state status sub thread cacnelled (maybe OK)");
                    continue;
                }
                catch (InterruptedException e) {
                    mLogger.finer("Health state status thread interuptted - expected");
                    continue;
                }
                catch (Throwable t) {
                    mLogger.log(Level.FINER, "Health state status thread unexpected exception", t);
                }
            }
            if (x < 7) continue;
            future.cancel(true);
        }
        if (HitachiCacheMangerService.isShuttingDown()) {
            this.terminate();
        }
        mLogger.fine("Health state requests completed.");
        Thread.currentThread().setName("HealthState Checker - Inactive");
    }

    private final void terminate() {
        if (null != HealthStateMonitor.mMonitor.mWorkerThreadPool) {
            try {
                HealthStateMonitor.mMonitor.mWorkerThreadPool.shutdownNow();
            }
            catch (Throwable t) {
                mLogger.log(Level.WARNING, "Failed to shutdown worker pool properly", t);
            }
        }
        if (null != HealthStateMonitor.mMonitor.mScheduler) {
            try {
                HealthStateMonitor.mMonitor.mScheduler.shutdownNow();
            }
            catch (Throwable t) {
                mLogger.log(Level.WARNING, "Failed to shutdown scheduler properly", t);
            }
        }
    }

    private static class LDEVStatusCheckThread
    implements Callable<Short[]> {
        private final String serialNum;
        private final Robj_interface_LUNMgetLDEVStatus statusDetail;
        private final RMIObjectCache rmiObj;
        private final SortedMap<Long, DeviceNumber> dnMap;

        public LDEVStatusCheckThread(String serialNum, RMIObjectCache rmiObj, Robj_interface_LUNMgetLDEVStatus statusDetail, SortedMap<Long, DeviceNumber> dnMap) {
            this.serialNum = serialNum;
            this.statusDetail = statusDetail;
            this.rmiObj = rmiObj;
            this.dnMap = dnMap;
        }

        @Override
        public Short[] call() {
            if (null != this.statusDetail) {
                return this.processLDEVStatus();
            }
            return null;
        }

        private Short[] processLDEVStatus() {
            Short[] ret = null;
            try {
                Thread.currentThread().setName("Active - checking " + this);
                mLogger.log(Level.FINE, "Checking health state {0}", this);
                DeviceNumber dn = null == this.dnMap || this.dnMap.isEmpty() ? DeviceNumber.find((Robj_interface_RJiLDEVIndex)this.statusDetail, this.rmiObj) : (DeviceNumber)this.dnMap.get(BaseDeviceNumber.makeUniqueDN(this.statusDetail.getSLDKC(), this.statusDetail.getSCU(), this.statusDetail.getSLDEV()));
                if (null != dn && !HitachiCacheMangerService.isShuttingDown()) {
                    if (dn.getRawHealthState() != this.statusDetail.getByLDEVStatus()) {
                        ret = new Short[]{dn.getCu(), dn.getLdev()};
                        mLogger.log(Level.FINE, "Detected changed in health state of {0}", this);
                    }
                } else {
                    mLogger.log(Level.FINE, "Back end had status for {0} but it doesn't exist in the cache, update maybe pending or it's in a restricted RSG, ignoring.", this);
                }
            }
            catch (Throwable e) {
                LogRecord record = new LogRecord(Level.SEVERE, "Exception getting status of {0}");
                record.setParameters(new Object[]{this});
                record.setThrown(e);
                mLogger.log(record);
            }
            mLogger.log(Level.FINE, "Done checking health state {0}", this);
            Thread.currentThread().setName("Inactive checking " + this);
            return ret;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("DN ");
            builder.append(BaseDeviceNumber.makeUniqueDN(this.statusDetail.getSLDKC(), this.statusDetail.getSCU(), this.statusDetail.getSLDEV()));
            builder.append(" on ");
            builder.append(this.serialNum);
            return builder.toString();
        }
    }
}

