/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.RmcpPairInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RMCPVerAllPair;
import sanproject.common.Robj_interface_RMCPVerPairPerCU;
import sanproject.common.Robj_interface_VerLeaf;

public class RCMPBranchChecker
extends AbstractVersionChecker {
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");

    protected RCMPBranchChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.REMOTE_COPY, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        mLogger.info("Change detected in REMOTE COPY branch");
        Robj_interface_RMCPVerAllPair current = (Robj_interface_RMCPVerAllPair)currentChildren[0];
        Robj_interface_RMCPVerAllPair prev = (Robj_interface_RMCPVerAllPair)prevChildren[0];
        if (current.getNVer() != prev.getNVer() || prev.getNSummaryVer() != current.getNSummaryVer()) {
            ArrayList<Robj_interface_RJiCUIndex> cuIndexes = new ArrayList<Robj_interface_RJiCUIndex>();
            try {
                Robj_interface_RJiLDEVIndex[] lDEVIndexes2Get;
                RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber()).getRMIObject();
                mLogger.log(Level.INFO, "Detected change in RMCP version on {0}", new Object[]{this.getSerialNumber()});
                Robj_interface_RMCPVerPairPerCU[] curRMCPData = (Robj_interface_RMCPVerPairPerCU[])current.getObjChildren();
                Robj_interface_RMCPVerPairPerCU[] prevRMCPData = (Robj_interface_RMCPVerPairPerCU[])prev.getObjChildren();
                for (short i = 0; i < curRMCPData.length; i = (short)((short)(i + 1))) {
                    if (curRMCPData[i].getNVer() == prevRMCPData[i].getNVer()) continue;
                    mLogger.log(Level.INFO, "Detected change in CU: {0} on {1}", new Object[]{i, this.getSerialNumber()});
                    Robj_interface_RJiCUIndex temp = (Robj_interface_RJiCUIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJICUINDEX);
                    temp.setSCU(i);
                    temp.setSLDKC((short)0);
                    cuIndexes.add(temp);
                }
                if (cuIndexes.size() > 0) {
                    mLogger.log(Level.FINE, "Convert {0} CU indexes", cuIndexes.size());
                    lDEVIndexes2Get = rmiObj.getLDEVIndex(cuIndexes.toArray(new Robj_interface_RJiCUIndex[cuIndexes.size()]));
                } else {
                    mLogger.warning("Cache update looking for all RmcpPairInfo from back end, informational only");
                    lDEVIndexes2Get = null;
                }
                ArrayList<RmcpPairInfo> added = new ArrayList<RmcpPairInfo>();
                ArrayList<RmcpPairInfo> modified = new ArrayList<RmcpPairInfo>();
                ArrayList<RmcpPairInfo> removed = new ArrayList<RmcpPairInfo>();
                RmcpPairInfo.checkCachedPairs(rmiObj, RmcpPairInfo.PairCheckType.TC, lDEVIndexes2Get, added, modified, removed);
                if (!added.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.REMOTE_COPY, (Serializable[])added.toArray(new RmcpPairInfo[added.size()]));
                }
                if (!modified.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.REMOTE_COPY, (Serializable[])modified.toArray(new RmcpPairInfo[modified.size()]));
                }
                if (!removed.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.REMOTE_COPY, (Serializable[])removed.toArray(new RmcpPairInfo[removed.size()]));
                }
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                mLogger.log(Level.SEVERE, "Exception updating RmcpPairInfo in cache for  " + this.getSerialNumber() + " - " + t, t);
            }
        }
    }
}

