/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.ProviderLibs;
import java.util.Arrays;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger8;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class GoalStorageSettingValues {
    private UnsignedInteger16 mDataRedundancyGoal;
    private UnsignedInteger16 mDataRedundancyMin;
    private UnsignedInteger16 mDataRedundancyMax;
    private UnsignedInteger8 mDeltaReservationGoal;
    private UnsignedInteger8 mDeltaReservationMin;
    private UnsignedInteger8 mDeltaReservationMax;
    private UnsignedInteger16 mExtentStripeLength;
    private UnsignedInteger16 mExtentStripeLengthMin;
    private UnsignedInteger16 mExtentStripeLengthMax;
    private UnsignedInteger16 mPackageRedundancyGoal;
    private UnsignedInteger16 mPackageRedundancyMin;
    private UnsignedInteger16 mPackageRedundancyMax;
    private UnsignedInteger16 mParityLayout;
    private static final String[] supportedSettingsClassNames = new String[]{"HITACHI_GeneratedStorageSetting", "HITACHI_StorageSettingWithDiskLayout", "HITACHI_StorageVolumeSetting", "HITACHI_StorageSettingForThinProvisioning", "HITACHI_ThinProvisioningVolumeSetting", "HITACHI_ThinProvisioningPoolSetting", "HITACHI_StorageSettingForThinProvisioning", "HITACHI_GeneratedThinProvisioningPoolSetting", "HITACHI_SnapshotPoolSetting"};

    private static boolean checkGoalClassName(CIMObjectPath theGoal) {
        boolean ret = false;
        String goalName = theGoal.getObjectName().toUpperCase();
        for (String clz : supportedSettingsClassNames) {
            String upperClz = clz.toUpperCase();
            if (!upperClz.startsWith(goalName)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    protected GoalStorageSettingValues(CIMObjectPath theGoal, ProviderHandle pHandle) throws WBEMException {
        if (theGoal != null) {
            if (!GoalStorageSettingValues.checkGoalClassName(theGoal)) {
                throw new WBEMException(4, "The goal (" + theGoal.getObjectName() + " is not of an exceptable type: " + Arrays.toString(supportedSettingsClassNames));
            }
            CIMObjectPath pathForUpCall = this.validateOP(theGoal);
            CIMInstance goalInst = pHandle.getInstance(pathForUpCall, null);
            this.mDataRedundancyGoal = (UnsignedInteger16)goalInst.getPropertyValue("DataRedundancyGoal");
            this.mDataRedundancyMin = (UnsignedInteger16)goalInst.getPropertyValue("DataRedundancyMin");
            this.mDataRedundancyMax = (UnsignedInteger16)goalInst.getPropertyValue("DataRedundancyMax");
            this.mDeltaReservationGoal = (UnsignedInteger8)goalInst.getPropertyValue("DeltaReservationGoal");
            this.mDeltaReservationMin = (UnsignedInteger8)goalInst.getPropertyValue("DeltaReservationMin");
            this.mDeltaReservationMax = (UnsignedInteger8)goalInst.getPropertyValue("DeltaReservationMax");
            this.mExtentStripeLength = (UnsignedInteger16)goalInst.getPropertyValue("ExtentStripeLength");
            this.mExtentStripeLengthMin = (UnsignedInteger16)goalInst.getPropertyValue("ExtentStripeLengthMin");
            this.mExtentStripeLengthMax = (UnsignedInteger16)goalInst.getPropertyValue("ExtentStripeLengthMax");
            this.mPackageRedundancyGoal = (UnsignedInteger16)goalInst.getPropertyValue("PackageRedundancyGoal");
            this.mPackageRedundancyMin = (UnsignedInteger16)goalInst.getPropertyValue("PackageRedundancyMin");
            this.mPackageRedundancyMax = (UnsignedInteger16)goalInst.getPropertyValue("PackageRedundancyMax");
            this.mParityLayout = (UnsignedInteger16)goalInst.getPropertyValue("ParityLayout");
        }
    }

    public boolean checkDataRedundancy(UnsignedInteger16 target) {
        boolean ret = this.verifyValueLess(target, this.mDataRedundancyMin);
        if (ret) {
            ret = this.verifyValueLess(this.mDataRedundancyMax, target);
        }
        return ret;
    }

    public boolean checkDeltaReservation(UnsignedInteger8 target) {
        boolean ret = this.verifyValueLess(target, this.mDeltaReservationMin);
        if (ret) {
            ret = this.verifyValueLess(this.mDeltaReservationMax, target);
        }
        return ret;
    }

    public boolean checkExtentStripeLength(UnsignedInteger16 target) {
        boolean ret = this.verifyValueLess(target, this.mExtentStripeLengthMin);
        if (ret) {
            ret = this.verifyValueLess(this.mExtentStripeLengthMax, target);
        }
        return ret;
    }

    public boolean checkPackageRedundancy(UnsignedInteger16 target) {
        boolean ret = this.verifyValueLess(target, this.mPackageRedundancyMin);
        if (ret) {
            ret = this.verifyValueLess(this.mPackageRedundancyMax, target);
        }
        return ret;
    }

    public boolean checkParityLayout(UnsignedInteger16 target) {
        return this.verifyValueLess(target, this.mParityLayout);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GoalStorageSettingValues [mDataRedundancyGoal=");
        builder.append(this.mDataRedundancyGoal);
        builder.append(", mDataRedundancyMin=");
        builder.append(this.mDataRedundancyMin);
        builder.append(", mDataRedundancyMax=");
        builder.append(this.mDataRedundancyMax);
        builder.append(", mDeltaReservationGoal=");
        builder.append(this.mDeltaReservationGoal);
        builder.append(", mDeltaReservationMin=");
        builder.append(this.mDeltaReservationMin);
        builder.append(", mDeltaReservationMax=");
        builder.append(this.mDeltaReservationMax);
        builder.append(", mExtentStripeLength=");
        builder.append(this.mExtentStripeLength);
        builder.append(", mExtentStripeLengthMin=");
        builder.append(this.mExtentStripeLengthMin);
        builder.append(", mExtentStripeLengthMax=");
        builder.append(this.mExtentStripeLengthMax);
        builder.append(", mPackageRedundancyGoal=");
        builder.append(this.mPackageRedundancyGoal);
        builder.append(", mPackageRedundancyMin=");
        builder.append(this.mPackageRedundancyMin);
        builder.append(", mPackageRedundancyMax=");
        builder.append(this.mPackageRedundancyMax);
        builder.append(", mParityLayout=");
        builder.append(this.mParityLayout);
        builder.append("]");
        return builder.toString();
    }

    private CIMObjectPath validateOP(CIMObjectPath theGoal) {
        CIMObjectPath ret = null;
        if (theGoal != null) {
            String ns = theGoal.getNamespace();
            ret = ns == null || ns.length() < 1 ? new CIMObjectPath(theGoal.getScheme(), theGoal.getHost(), theGoal.getPort(), ProviderLibs.getImplementationNamespace(), theGoal.getObjectName(), theGoal.getKeys()) : theGoal;
        }
        return ret;
    }

    private boolean verifyValueLess(UnsignedInteger16 p1, UnsignedInteger16 p2) {
        boolean ret = true;
        if (p2 != null && p1 != null && p1.compareTo(p2) < 0) {
            ret = false;
        }
        return ret;
    }

    private boolean verifyValueLess(UnsignedInteger8 p1, UnsignedInteger8 p2) {
        boolean ret = true;
        if (p2 != null && p1 != null && p1.compareTo(p2) < 0) {
            ret = false;
        }
        return ret;
    }
}

