/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_DKCgetPDEVInfo2;

public class PDEVInfo
extends AbstractBaseCommonObject {
    private static final long serialVersionUID = 1L;
    private static final Class<PDEVInfo[]> clz = PDEVInfo[].class;
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    private int dataCount;
    private int reserveCount;
    private int spareCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapping) throws WBEMException {
        RMIObjectCache rmiObj = mapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<PDEVInfo> clazz = PDEVInfo.class;
            synchronized (PDEVInfo.class) {
                if (!cache.isCached(clz)) {
                    CommonClassAsList<PDEVInfo> callback = new CommonClassAsList<PDEVInfo>();
                    PDEVInfo.getUnCachedPDEVInfo(rmiObj, callback);
                    LinkedList<PDEVInfo> pdevInfo = callback.getReturnValue();
                    callback = null;
                    HashMap map = new HashMap();
                    CacheLib.addDataToCache(map, pdevInfo, clz, mapping.getSerialNumber());
                } else {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                    logger.log(Level.FINE, "PDEVInfo was placed in cache{0}", mapping.getSerialNumber());
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.log(Level.WARNING, "PDEVInfo is already in cache {0}", mapping.getSerialNumber());
        }
    }

    public static final PDEVInfo find(RMIObjectCache rmiObj) throws WBEMException {
        PDEVInfo ret = null;
        try {
            FindMethodCallbackHandler<PDEVInfo> callback = new FindMethodCallbackHandler<PDEVInfo>();
            PDEVInfo.getPDEVInfo(rmiObj, callback);
            ret = callback.getReturnValue();
        }
        catch (Exception e) {
            WBEMException we = new WBEMException(1, "Exception finding PDEVInfo on " + rmiObj.getSMISMappingContainer().getSerialNumber(), null, (Throwable)e);
            throw we;
        }
        return ret;
    }

    public static final void getPDEVInfo(IteratorCallback<PDEVInfo> callback) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                PDEVInfo.getPDEVInfo(mapObj.getRMIObject(), callback);
                continue;
            }
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static final void getPDEVInfo(RMIObjectCache rmiObj, IteratorCallback<PDEVInfo> callback) throws WBEMException {
        if (null == rmiObj) {
            PDEVInfo.getPDEVInfo(callback);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            AbstractBaseCommonObject[] pdevInfo = (PDEVInfo[])cache.getCachedObject(clz);
            callback.returnItems(pdevInfo);
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "PDEVInfo not cached on {0}, performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            PDEVInfo.getUnCachedPDEVInfo(rmiObj, callback);
        }
    }

    private static void getUnCachedPDEVInfo(RMIObjectCache rmiObj, IteratorCallback<PDEVInfo> callback) {
        try {
            Robj_interface_DKCgetPDEVInfo2 pdevInfo = rmiObj.getPDEVInfo2();
            PDEVInfo ret = new PDEVInfo(rmiObj.getSMISMappingContainer().getSerialNumber(), pdevInfo);
            callback.returnItem(ret);
            callback.done();
        }
        catch (Exception e) {
            WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
            callback.exceptionOccurred(we);
            callback.done();
        }
    }

    public static PDEVInfo modifyCachedPDEVInfoClass(String serialNumber) throws WBEMException {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        PDEVInfo ret = null;
        logger.log(Level.INFO, "Modifiying cached PDEVInfo on {0}", serialNumber);
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNumber).getRMIObject();
            HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
            PDEVInfo[] pdevInfos = (PDEVInfo[])cache.getCachedObject(null, clz);
            CommonClassAsList<PDEVInfo> callback = new CommonClassAsList<PDEVInfo>();
            PDEVInfo.getUnCachedPDEVInfo(rmiObj, callback);
            LinkedList<PDEVInfo> newPDEVInfos = callback.getReturnValue();
            callback = null;
            if (pdevInfos == null || pdevInfos.length != 1 || newPDEVInfos == null || newPDEVInfos.size() != 1) {
                throw new WBEMException("Error in " + serialNumber + " it must have 1 PDEVInfo, cached:" + (pdevInfos != null ? Integer.valueOf(pdevInfos.length) : "0") + ", new: " + (newPDEVInfos != null ? Integer.valueOf(newPDEVInfos.size()) : "0"));
            }
            PDEVInfo cachedItem = pdevInfos[0];
            PDEVInfo newItem = (PDEVInfo)newPDEVInfos.get(0);
            if (!newItem.equals(cachedItem)) {
                mLogger.log(Level.INFO, "Change detected in PDEVInfo on {0}", serialNumber);
                ret = new PDEVInfo(cachedItem);
                cachedItem.copyPDEVInfo(newItem);
            } else {
                mLogger.log(Level.INFO, "No change detected in PDEVInfo on {0}", serialNumber);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to modify PDEVInfo in cache " + serialNumber, null, t);
        }
        logger.log(Level.INFO, "Done modifiying cached PDEVInfo on {0}", serialNumber);
        return ret;
    }

    private PDEVInfo(PDEVInfo other) {
        super(other.getSerialNumber());
        this.copyPDEVInfo(other);
    }

    private PDEVInfo(String serialNum, Robj_interface_DKCgetPDEVInfo2 pdevInfo) throws WBEMException {
        super(serialNum);
        this.dataCount = pdevInfo.getIDataCount();
        this.reserveCount = pdevInfo.getIReserveCount();
        this.spareCount = pdevInfo.getISpareCount();
    }

    private void copyPDEVInfo(PDEVInfo other) {
        this.dataCount = other.getDataCount();
        this.reserveCount = other.getReserveCount();
        this.spareCount = other.getSpareCount();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PDEVInfo other = (PDEVInfo)obj;
        if (this.dataCount != other.dataCount) {
            return false;
        }
        if (this.reserveCount != other.reserveCount) {
            return false;
        }
        return this.spareCount == other.spareCount;
    }

    public int getDataCount() {
        return this.dataCount;
    }

    public int getReserveCount() {
        return this.reserveCount;
    }

    public int getSpareCount() {
        return this.spareCount;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.dataCount;
        result = 31 * result + this.reserveCount;
        result = 31 * result + this.spareCount;
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PDEVInfo [serialNumber=");
        builder.append(this.getSerialNumber());
        builder.append(", dataCount=");
        builder.append(this.dataCount);
        builder.append(", reserveCount=");
        builder.append(this.reserveCount);
        builder.append(", spareCount=");
        builder.append(this.spareCount);
        builder.append("]");
        return builder.toString();
    }
}

