/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.common.PoolNickname;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.StoragePoolInstrumentation;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PoolNickChanged
implements CacheUpdateNotifier {
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private final StoragePoolInstrumentation thePool;

    public PoolNickChanged(StoragePoolInstrumentation thePool) {
        this.thePool = thePool;
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        PoolNickname changedNick = (PoolNickname)pObj;
        try {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(changedNick.getSerialNumber());
            ThinPool tp = ThinPool.find(device.getRMIObject(), changedNick.getPoolID(), ThinPool.ThinPoolType.ALL);
            if (null != tp) {
                this.thePool.cacheItemModified(tp);
            } else {
                mLogger.log(Level.SEVERE, "Nickname (%s) was changed but the actual pool is not in the cache", pObj);
            }
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Caught exception trying to update pool of nickname change " + pObj, t);
        }
    }
}

