/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import java.io.File;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;

public final class ProviderConstants {
    public static final String SERVICE_STARTMODE_AUTOMATIC = "Automatic";
    public static final String OPEN = "OPEN";
    public static final String THINPOOL_METADATASPACE_CONSTANT_STR = "44040192";
    public static final long THINPOOL_METADATASPACE_CONSTANT = Long.parseLong("44040192");
    public static final String alertLoggerName = "com.hitachi.smis.logger.alert";
    public static final String cacheLoggerName = "com.hitachi.smis.logger.cache";
    public static final String ProviderLoggerName = "com.hitachi.smis.logger.provider";
    public static final String OPEN_V = "OPEN-V";
    public static final int OPEN_V_EMULATION_VALUE = 625;
    public static final String BIN_DIRECTORY = "com.wbemsolutions.jserver.propdir";
    public static final UnsignedInteger8 UINT8_100 = new UnsignedInteger8(100);
    public static final UnsignedInteger16 UINT16_32768 = new UnsignedInteger16(32768);
    public static final UnsignedInteger16 UINT16_32769 = new UnsignedInteger16(32769);
    public static final UnsignedInteger16 UINT16_EIGHT = new UnsignedInteger16(8);
    public static final UnsignedInteger16 UINT16_FIVE = new UnsignedInteger16(5);
    public static final UnsignedInteger16 UINT16_FOUR = new UnsignedInteger16(4);
    public static final UnsignedInteger16 UINT16_NINE = new UnsignedInteger16(9);
    public static final UnsignedInteger16 UINT16_ONE = new UnsignedInteger16(1);
    public static final UnsignedInteger16 UINT16_SEVEN = new UnsignedInteger16(7);
    public static final UnsignedInteger16 UINT16_SIX = new UnsignedInteger16(6);
    public static final UnsignedInteger16 UINT16_TEN = new UnsignedInteger16(10);
    public static final UnsignedInteger16 UINT16_THREE = new UnsignedInteger16(3);
    public static final UnsignedInteger16 UINT16_ELEVEN = new UnsignedInteger16(11);
    public static final UnsignedInteger16 UINT16_TWELVE = new UnsignedInteger16(12);
    public static final UnsignedInteger16 UINT16_TWO = new UnsignedInteger16(2);
    public static final UnsignedInteger16 UINT16_ZED = new UnsignedInteger16(0);
    public static final UnsignedInteger32 UINT32_4097 = new UnsignedInteger32(4097L);
    public static final UnsignedInteger32 UINT32_4096 = new UnsignedInteger32(4096L);
    public static final UnsignedInteger32 UINT32_100 = new UnsignedInteger32(100L);
    public static final UnsignedInteger32 UINT32_SIX = new UnsignedInteger32(6L);
    public static final UnsignedInteger32 UINT32_FIVE = new UnsignedInteger32(5L);
    public static final UnsignedInteger32 UINT32_FOUR = new UnsignedInteger32(4L);
    public static final UnsignedInteger32 UINT32_ONE = new UnsignedInteger32(1L);
    public static final UnsignedInteger32 UINT32_TWO = new UnsignedInteger32(2L);
    public static final UnsignedInteger32 UINT32_THREE = new UnsignedInteger32(3L);
    public static final UnsignedInteger32 UINT32_ZED = new UnsignedInteger32(0L);
    public static final UnsignedInteger64 UINT64_ZED = new UnsignedInteger64(BigInteger.ZERO);
    public static final UnsignedInteger64 UINT64_ONE = new UnsignedInteger64("1");
    public static final UnsignedInteger64 UINT64_512 = new UnsignedInteger64(BigInteger.valueOf(512L));
    public static UnsignedInteger16[] BLOCKSTATISTICS_SUPPORTED = new UnsignedInteger16[]{UINT16_TWO, UINT16_SIX, UINT16_SEVEN, UINT16_EIGHT, UINT16_NINE, UINT16_32768, UINT16_32769};
    public static final String RAID_STRING = "RAID";
    public static final String HITACHI = "HITACHI";
    public static final String SCHEMANAME = "HITACHI_";
    public static final String CCN_SMISERVER = "HITACHI_SMIServerProfile";
    public static final String CLIENT_TYPE = "ClientType";
    public static final String commaSpace = ", ";
    public static final String CPN_CLIENT_TYPES = "ClientTypes";
    public static final String CTR_ID = "CtrID";
    public static final String CDEV_NUM = "CDevNum";
    private static final String CONFIG_DIR_NAME = "conf";
    private static final Object REPOSITORY_DIR_NAME = "repository";
    private static final String DAT_DIR_NAME = "dat";
    public static final String DISABLE = "Disable";
    public static final String DOMAIN_ID = "DomainID";
    public static final String ENABLE = "Enable";
    public static final String EXCLUDED = "Excluded";
    public static final String FB4 = "fb4";
    public static String GENERATE_INSTANCE_ILLEGAL_ARGUMENT = "The wrong number of arguments were passed to the generateInstance method";
    public static String GENERATE_OBJECTPATH_ILLEGAL_ARGUMENT = "The wrong number of arguments were passed to the generateObjectPath method";
    public static final String HOST_MODE = "HostMode";
    public static final String HOSTWWN = "HostWWN";
    public static final String ID_SEPERATOR = ".";
    public static final char ID_SEPERATOR_AS_CHAR = ".".charAt(0);
    public static final String IMPORTED = "Imported";
    public static final String INCLUDED = "Included";
    public static final short MAX_CU_PER_LDKC = 256;
    public static final short MAX_HOSTGROUPS_PER_PORT = 255;
    public static final short MAX_WWNS_PER_HOSTGROUP = 255;
    public static final short MAX_LDEV_PER_CU = 256;
    public static final short MAX_LUNS_PER_HOSTGROUP = 2048;
    public static final short MAX_PORTS = 256;
    public static final int MRV_AUTHORIZATION_ERROR = 16003;
    public static final int MRV_FAILED = 4;
    public static final int MRV_INVALID_INITIATOR_PORT_ID = 4098;
    public static final int MRV_INVALID_LU_ID = 4097;
    public static final int MRV_INVALID_PARAMETER = 5;
    public static final int MRV_INVALID_TARGET_PORT_ID = 4099;
    public static final int MRV_INVALID_PERMISSION = 4100;
    public static final int MRV_JOB_STARTED = 4096;
    public static final int MRV_MAX_MAP_COUNT_EXCEEDED = 4103;
    public static final int MRV_NOT_SUPPORTED = 1;
    public static final int MRV_NULL_NOT_SUPPORTED = 16004;
    public static final int MRV_REQ_LUN_IN_USE = 4102;
    public static final int MRV_SUCCESS = 0;
    public static final int MRV_TARGET_INITIATOR_COMBO_ALREADY_EXPOSED = 4101;
    public static final int MRV_TARGET_INITIATOR_COMBO_NOT_EXPOSED = 4100;
    public static final int MRV_TIMEOUR = 3;
    public static final int MRV_UNSPECIFIED_ERROR = 2;
    public static final int MRV_UNSUPPORTED_PRIVILEGE = 16000;
    public static final int MRV_UNSUPPORTED_SUBJECT = 16000;
    public static final int MRV_UNSUPPORTED_TARGET = 16000;
    public static final String VPD83_ID = "60060E80";
    public static final String OPENVMS_TRU64_FORMAT = "60060E80%1d";
    public static final String OTHER = "Other";
    public static final int KILOBYTES_PER_GIGABYTES = 0x100000;
    public static final String PDEV = "pdev";
    public static final String PG = "pg";
    public static final String PN_ELEMENT_TYPE = "ElementType";
    public static final String PN_PRIMORDIAL = "Primordial";
    public static final String PN_IMPORTED_PRIMORDIAL = "ImportedPrimordial";
    public static final String PORT_ID = "PortID";
    public static final String PRODUCTNAME_HITACHI = "HITACHI SMI-S Provider";
    public static final String PRODUCTNAME_HP = "SVP CLI/SMI-S";
    public static final String LOCALHOST = "127.0.0.1";
    public static final String PROVIDER_PROPERTIES = "provider.properties";
    public static final String CAG_PROPERTIES = "cagProperties.xml";
    public static final String R50 = "50";
    public static final String R502 = "502";
    public static final String R503 = "503";
    public static final String R504 = "504";
    public static final String R500 = "R500";
    public static final String RDEV_NUM = "RDevNum";
    public static final String CHASSIS_LOCATION = "ChassisLocation";
    public static final String SAMPLEINTERVAL = "00000000000500.000000:000";
    public static final String STORAGE_SETTING = "StorageSetting";
    public static final String UNKNOWN = "UNKNOWN";
    private static final String UP_DIR = "..";
    public static final String XML_SCHEMA_NAME = "http://schemas.hitachi.com/wbem/wsman/1/vsp";
    public static final String CPN_EXTENTDISCRIMINATOR = "ExtentDiscriminator";
    public static final String SNIA_Pool_Component = "SNIA:Pool Component";
    public static final String SNIA_Remaining = "SNIA:Remaining";
    public static final String SNIA_Intermediate = "SNIA:Intermediate";
    public static final String SNIA_Composite = "SNIA:Composite";
    public static final String SNIA_DiskDrive = "SNIA:DiskDrive";
    public static final String SNIA_Imported = "SNIA:Imported";
    public static final String SNIA_Allocated = "SNIA:Allocated";
    public static final String SNIA_Shadow = "SNIA:Shadow";
    public static final String SNIA_Spare = "SNIA:Spare";
    public static final String SNIA_Reserved = "SNIA:Reserved";
    public static final String HITACHI_CacheMemory = "HITACHI:CacheMemory";
    public static final String THINPROVISIONINGPOOL = "ThinProvisioningPool";
    public static final String CCN_HITACHI_THINPROVISIONINGPOOL = "HITACHI_ThinProvisioningPool";
    public static final String CV_STORAGECAPABILITIESOFTHINPROVISIONINGPOOL = "StorageCapabilitiesOfThinProvisioningPool";
    public static final String CCN_HITACHI_STORAGECAPABILITIESOFTHINPROVISIONINGPOOL = "HITACHI_StorageCapabilitiesOfThinProvisioningPool";
    public static final String CV_STORAGECAPABILITIESOFSNAPSHOTPOOL = "StorageCapabilitiesOfSnapshotPool";
    public static final String CCN_HITACHI_THINPROVISIONINGVOLUMECOMPOSITEEXTENT = "HITACHI_ThinProvisioningVolumeCompositeExtent";
    public static final String CAN_GETSUPPORTEDSIZERANGE_GOAL = "Goal";
    public static final String CAN_GETSUPPORTEDSIZERANGE_MAX_SIZE = "MaximumVolumeSize";
    public static final String CAN_GETSUPPORTEDSIZERANGE_MIN_SIZE = "MinimumVolumeSize";
    public static final String CMN_GETSUPPORTEDSIZERANGE = "GetSupportedSizeRange";
    public static final String CMN_GETSUPPORTEDSIZES = "GetSupportedSizes";
    public static final String CAN_GETSUPPORTEDSIZERANGE_VOLUME_DIVISOR_SIZE = "VolumeSizeDivisor";
    public static final int ONE_MINUTE_IN_MILLIS = 60000;
    public static UnsignedInteger64 THIN_VOLUME_MAX_ALLOWED_SIZE = new UnsignedInteger64(BigInteger.valueOf(65970693734400L));
    public static final UnsignedInteger64 THIN_VOLUME_MIN_ALLOWED_SIZE = new UnsignedInteger64(BigInteger.valueOf(0x2EE0000L));
    public static final Short VOLUME_KIND_SHADOW_IMAGE = 1;
    public static final Short VOLUME_KIND_SNAPSHOT = 2;
    public static final String AUTOMATIC = "Automatic";
    protected static final String USERDEF_SNAPGROUP = "ResourceGroupForSnapshot";
    protected static final String USERDEF_RESTRICTSNAPVVOL = "RestrictVVolForSnapshot";
    public static final String USERDEF_SNAPVVOL = "VVolForSnapshot";
    public static final String USERDEF_SNAPPOOLID = "PoolIDForSnapshot";
    public static final String USERDEF_USELEGACYVOL = "ReportLegacyVolumeName";
    protected static final String USERDEF_RESTRICTSNAPPOOLID = "RestrictPoolIDForSnapshot";
    public static final String USERDEF_DEFAULTSNAPSHOTFUNCTION = "DefaultSnapshotFunction";
    public static final String CV_T10TARGETNAMETYPE1 = "T10 Target Name Type 1";
    public static final String RAID500 = "Raid500";
    public static final String RAID600 = "Raid600";
    public static final String RAID700 = "Raid700";
    public static final String HM700 = "HM700";
    public static final String RAID800 = "Raid800";
    public static final String HM800 = "HM800";
    public static final String HM800s = "HM800 (S Model)";
    public static final String HM800m = "HM800 (M Model)";
    public static final String HM800h = "HM800 (H Model)";
    protected static final String USERDEF_PARITYGROUPS = "ParityGroups";
    public static final String USERDEF_RESOURCEGROUPS = "ResourceGroup";

    public static StringBuilder getBaseDir() {
        String propDir = System.getProperty("com.ws.jserver.basedir");
        StringBuilder sb = new StringBuilder(propDir == null ? ID_SEPERATOR : propDir);
        sb.append(File.separatorChar);
        sb.append(UP_DIR);
        sb.append(File.separatorChar);
        sb.append(UP_DIR);
        sb.append(File.separatorChar);
        return sb;
    }

    public static final String getConfigDirectory() {
        StringBuilder sb = ProviderConstants.getBaseDir();
        sb.append(CONFIG_DIR_NAME);
        sb.append(File.separatorChar);
        return sb.toString();
    }

    public static final String getDatDirectory() {
        StringBuilder sb = ProviderConstants.getBaseDir();
        sb.append(DAT_DIR_NAME);
        sb.append(File.separatorChar);
        return sb.toString();
    }

    public static final String getOpStatusDescription(int pOpStatus) {
        String ret = "";
        OP_STATUS_INDEX[] values = OP_STATUS_INDEX.values();
        if (pOpStatus >= 0 && pOpStatus < values.length) {
            for (OP_STATUS_INDEX cur : OP_STATUS_INDEX.values()) {
                if (cur.mVal != pOpStatus) continue;
                ret = cur.toString();
            }
        }
        return ret;
    }

    public static final String getOpStatusDescription(OP_STATUS_INDEX pOpStatus) {
        return ProviderConstants.getOpStatusDescription(pOpStatus.getStatusValue());
    }

    public static final String getOpStatusDescription(UnsignedInteger16 pOpStatus) {
        return ProviderConstants.getOpStatusDescription(pOpStatus.intValue());
    }

    public static final String[] getOpStatusDescriptions(UnsignedInteger16[] pOpStatus) {
        String[] ret = null;
        if (null != pOpStatus && pOpStatus.length > 0) {
            ret = new String[pOpStatus.length];
            OP_STATUS_INDEX[] values = OP_STATUS_INDEX.values();
            for (int i = 0; i < pOpStatus.length; ++i) {
                int currentValue = pOpStatus[i].intValue();
                if (null != pOpStatus[i] && currentValue < values.length) {
                    ret[i] = ProviderConstants.getOpStatusDescription(currentValue);
                    continue;
                }
                Exception e = new Exception("Invalid status value" + pOpStatus[i]);
                Logger logger = Logger.getLogger(ProviderLoggerName);
                logger.log(Level.SEVERE, e.toString(), e);
            }
            return ret;
        }
        ret = new String[]{};
        return ret;
    }

    public static String getRepositoryDirectory() {
        StringBuilder sb = ProviderConstants.getBaseDir();
        sb.append(REPOSITORY_DIR_NAME);
        sb.append(File.separatorChar);
        return sb.toString();
    }

    private ProviderConstants() {
    }

    public static enum RAID_Level {
        RAID0,
        RAID0_1{

            public String toString() {
                return "RAID0+1";
            }
        }
        ,
        RAID1,
        RAID1_0{

            public String toString() {
                return "RAID1+0";
            }
        }
        ,
        RAID10,
        RAID3,
        RAID5,
        RAID6,
        UNKNOWN;

    }

    public static enum OP_STATUS_INDEX {
        Aborted(14),
        Completed(17),
        DEGRADED(3),
        DMTFReserved(19),
        Dormant(15),
        Error(6),
        InService(11),
        LostCommunication(13),
        NoContact(12),
        NonRecoverableError(7),
        OK(2),
        OTHER(1),
        PowerMode(18),
        PredictiveFailure(5),
        Starting(8),
        Stopped(10),
        Stopping(9),
        STRESSED(4),
        SupportingEntityinError(16),
        UNKNOWN(0),
        VendorReserved(20);

        private int mVal;

        private OP_STATUS_INDEX(int val) {
            this.mVal = val;
        }

        public int getStatusValue() {
            return this.mVal;
        }

        public String toString() {
            String ret;
            switch (this) {
                case OTHER: {
                    ret = ProviderConstants.OTHER;
                    break;
                }
                case OK: {
                    ret = "OK";
                    break;
                }
                case DEGRADED: {
                    ret = "Degraded";
                    break;
                }
                case STRESSED: {
                    ret = "Stressed";
                    break;
                }
                case PredictiveFailure: {
                    ret = "Predictive Failure";
                    break;
                }
                case Error: {
                    ret = "Error";
                    break;
                }
                case NonRecoverableError: {
                    ret = "Non-Recoverable Error";
                    break;
                }
                case Starting: {
                    ret = "Starting";
                    break;
                }
                case Stopping: {
                    ret = "Stopping";
                    break;
                }
                case Stopped: {
                    ret = "Stopped";
                    break;
                }
                case InService: {
                    ret = "In Service";
                    break;
                }
                case NoContact: {
                    ret = "No Contact";
                    break;
                }
                case LostCommunication: {
                    ret = "Lost Communication";
                    break;
                }
                case Aborted: {
                    ret = "Aborted";
                    break;
                }
                case Dormant: {
                    ret = "Dormant";
                    break;
                }
                case SupportingEntityinError: {
                    ret = "Supporting Entity in Error";
                    break;
                }
                case Completed: {
                    ret = "Completed";
                    break;
                }
                case PowerMode: {
                    ret = "Power Mode";
                    break;
                }
                case DMTFReserved: {
                    ret = "DMTF Reserved";
                    break;
                }
                case VendorReserved: {
                    ret = "Vendor Reserved";
                    break;
                }
                default: {
                    ret = ProviderConstants.UNKNOWN;
                }
            }
            return ret;
        }
    }
}

