/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.PGInfo;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceGroupInfo;
import com.hitachi.smi.common.ThinPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class ResourceRestriction
extends AbstractBaseCommonObject {
    private static final long serialVersionUID = 1L;
    private static Map<String, ResourceRestriction> singleton = new HashMap<String, ResourceRestriction>();
    private static final String MULTIPLE_SEPERATOR = "to";
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    private final Set<Short> usableThinPools;
    private final Set<Short> usableSnapPools;
    private final Set<Long> usableSnapshotVolumes;
    private boolean useRSGs;
    private final Set<Short> usableRSGs = new TreeSet<Short>();

    private static long getDevNumFromString(String txt) throws WBEMException {
        long ret = -1L;
        StringTokenizer toker = new StringTokenizer(txt, ":");
        short dkc = -1;
        short cu = -1;
        short ldev = -1;
        if (3 == toker.countTokens()) {
            try {
                dkc = Short.decode("0x" + toker.nextToken());
                cu = Short.decode("0x" + toker.nextToken());
                ldev = Short.decode("0x" + toker.nextToken());
            }
            catch (NumberFormatException nfe) {
                throw new WBEMException(1, "Failed to parse LDEV: " + txt, null, (Throwable)nfe);
            }
            if (dkc < 0 || cu < 0 || ldev < 0) {
                throw new WBEMException("Failed to get DKC, CU or LDEV " + txt);
            }
        } else {
            throw new WBEMException("incorrect format for passed in string: " + txt);
        }
        ret = BaseDeviceNumber.makeUniqueDN(dkc, cu, ldev);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourceRestriction getResourceRestriction(String serialNumber) {
        ResourceRestriction ret = singleton.get(serialNumber);
        if (null == ret) {
            Map<String, ResourceRestriction> map = singleton;
            synchronized (map) {
                ret = singleton.get(serialNumber);
                if (null == ret) {
                    ret = new ResourceRestriction(serialNumber);
                    singleton.put(serialNumber, ret);
                }
            }
        }
        return ret;
    }

    public static boolean isFCPortUsable(FCPort port) throws WBEMException {
        boolean ret = true;
        if (null == port) {
            ret = false;
        } else if (ResourceRestriction.isUsingResourceRestriction(port.getSerialNumber())) {
            ResourceGroupInfo rsg = ResourceGroupInfo.find(port);
            mLogger.log(Level.FINE, "FCPort {0} is in RSG {1}", new Object[]{port.getPort(), rsg});
            ret = null != rsg ? ResourceRestriction.isResourceGroupUsable(port.getSerialNumber(), rsg.getId()) : true;
        }
        return ret;
    }

    public static boolean isISCSITargetUsable(ISCSITargetPort.ISCSITarget target) throws WBEMException {
        boolean ret = true;
        if (null == target) {
            ret = false;
        } else if (ResourceRestriction.isUsingResourceRestriction(target.getSerialNumber())) {
            ResourceGroupInfo rsg = ResourceGroupInfo.find(target);
            mLogger.log(Level.FINE, "iSCSI Target {0} is in RSG {1}", new Object[]{target.getId(), rsg});
            ret = null != rsg ? ResourceRestriction.isResourceGroupUsable(target.getSerialNumber(), rsg.getId()) : true;
        }
        return ret;
    }

    public static boolean isPHGIUsable(PortandHostGroupInfo phgi) throws WBEMException {
        boolean ret = true;
        if (null == phgi) {
            ret = false;
        } else if (ResourceRestriction.isUsingResourceRestriction(phgi.getSerialNumber())) {
            ResourceGroupInfo rsg = ResourceGroupInfo.find(phgi);
            mLogger.log(Level.FINE, "PHGI {0} is in RSG {1}", new Object[]{phgi.getHostGroupNickName(), rsg});
            ret = null != rsg ? ResourceRestriction.isResourceGroupUsable(phgi.getSerialNumber(), rsg.getId()) : true;
        }
        return ret;
    }

    public static boolean isPoolUsable(ChassisArrayGroup cag) {
        return ResourceRestriction.isPoolUsable(cag.getSerialNumber(), cag.getFb4(), cag.getPg());
    }

    public static boolean isPoolUsable(PGInfo pgInfo) throws WBEMException {
        boolean ret = true;
        if (null == pgInfo) {
            mLogger.log(Level.FINE, "PG is null, return restricted");
            ret = false;
        } else if (ResourceRestriction.isUsingResourceRestriction(pgInfo.getSerialNumber())) {
            ResourceGroupInfo rsg = ResourceGroupInfo.find(pgInfo);
            mLogger.log(Level.FINE, "PG {0} is in RSG {1}", new Object[]{pgInfo.getPG(), rsg});
            ret = null != rsg ? ResourceRestriction.isResourceGroupUsable(pgInfo.getSerialNumber(), rsg.getId()) : true;
        }
        return ret;
    }

    public static boolean isPoolUsable(String serialNum, int fb4, int pg) {
        boolean ret = true;
        try {
            if (ResourceRestriction.isUsingResourceRestriction(serialNum)) {
                PGInfo pgInfo = PGInfo.find(serialNum, fb4, pg);
                ret = ResourceRestriction.isPoolUsable(pgInfo);
            }
        }
        catch (Throwable t) {
            ret = false;
            mLogger.log(Level.SEVERE, "Error getting ParityGroups", t);
        }
        return ret;
    }

    public static boolean isPoolUsable(String serialNum, short poolID, boolean isThin) {
        boolean ret = true;
        ResourceRestriction rr = ResourceRestriction.getResourceRestriction(serialNum);
        try {
            if (rr.useRSGs) {
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
                RMIObjectCache rmiObj = device.getRMIObject();
                ThinPool tp = ThinPool.find(rmiObj, poolID, ThinPool.ThinPoolType.ALL);
                if (null != tp) {
                    ret = ResourceRestriction.isPoolVolUsable(tp);
                } else {
                    mLogger.log(Level.FINE, "ThinPool {0} is available", poolID);
                    ret = true;
                }
            } else if (isThin) {
                if (!rr.usableThinPools.isEmpty()) {
                    ret = rr.usableThinPools.contains(poolID);
                }
            } else if (!rr.usableSnapPools.isEmpty()) {
                ret = rr.usableSnapPools.contains(poolID);
            }
        }
        catch (Throwable t) {
            ret = false;
            mLogger.log(Level.SEVERE, "Error getting Thin/Snapshot pool data", t);
        }
        return ret;
    }

    public static boolean isPoolUsable(ThinPool tp, boolean isThin) {
        boolean ret = true;
        try {
            ret = null == tp ? false : (ResourceRestriction.isUsingResourceRestriction(tp.getSerialNumber()) ? ResourceRestriction.isPoolVolUsable(tp) : ResourceRestriction.isPoolUsable(tp.getSerialNumber(), tp.getPoolID(), tp.isAOUPool()));
        }
        catch (Throwable t) {
            ret = false;
            mLogger.log(Level.SEVERE, "Error getting pool data", t);
        }
        return ret;
    }

    private static boolean isPoolVolUsable(ThinPool tp) throws WBEMException {
        boolean ret = true;
        ArrayList<String> poolVols = new ArrayList<String>(tp.getContainingLDEVs());
        if (!poolVols.isEmpty()) {
            Collections.sort(poolVols);
            String dnStr = (String)poolVols.get(0);
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
            RMIObjectCache rmiObj = device.getRMIObject();
            DeviceNumber dn = DeviceNumber.find(dnStr, rmiObj);
            if (null != dn) {
                ret = ResourceRestriction.isVolumeUsable(dn);
            } else {
                mLogger.log(Level.INFO, "DN {0} is a Pool vol for ThinPool {1} but it could not be found, defaulting to restricted", new Object[]{dnStr, tp.getPoolID()});
                ret = false;
            }
        } else {
            mLogger.log(Level.SEVERE, "ThinPool {1} has no pool volumes", tp.getPoolID());
            ret = false;
        }
        return ret;
    }

    public static boolean isPortUsable(String serialNumber, Short portID) throws WBEMException {
        boolean ret = true;
        if (null == portID) {
            ret = false;
        } else if (ResourceRestriction.isUsingResourceRestriction(serialNumber)) {
            ResourceGroupInfo rsg = ResourceGroupInfo.find(serialNumber, portID);
            mLogger.log(Level.FINE, "portID: {0} is in RSG {1}", new Object[]{portID, rsg});
            ret = null != rsg ? ResourceRestriction.isResourceGroupUsable(serialNumber, rsg.getId()) : true;
        }
        return ret;
    }

    public static boolean isResourceGroupUsable(String serialNumber, int rsg) throws WBEMException {
        boolean ret;
        if (ResourceRestriction.isUsingResourceRestriction(serialNumber)) {
            ResourceRestriction rr = ResourceRestriction.getResourceRestriction(serialNumber);
            ret = rr.isResourceGroupUsable(rsg);
        } else {
            ret = true;
        }
        return ret;
    }

    public static boolean isUsingResourceRestriction(String serialNumber) {
        return ResourceRestriction.getResourceRestriction((String)serialNumber).useRSGs;
    }

    public static boolean isVolumeUsable(DeviceNumber dn) throws WBEMException {
        boolean ret = true;
        if (null == dn) {
            ret = false;
        } else if (ResourceRestriction.isUsingResourceRestriction(dn.getSerialNumber())) {
            ResourceRestriction rr = ResourceRestriction.getResourceRestriction(dn.getSerialNumber());
            if (null != rr) {
                ResourceGroupInfo rsg = ResourceGroupInfo.find(dn);
                mLogger.log(Level.FINE, "DN {0} is in RSG {1}", new Object[]{dn.getDn(), rsg});
                if (null != rsg) {
                    if (!rr.isResourceGroupUsable(rsg.getId())) {
                        mLogger.log(Level.FINE, "Volume({0} is in a non-usable resource group {1}", new Object[]{dn.getDn(), rsg.getId()});
                        ret = false;
                    } else {
                        ret = true;
                    }
                } else {
                    mLogger.log(Level.SEVERE, "Could not find resource group for Volume({0}), marking it usable", dn.getDn());
                    ret = true;
                }
            } else {
                mLogger.log(Level.SEVERE, "Unable to find resource group data");
                ret = false;
            }
        }
        return ret;
    }

    public static boolean isVolumeUsageUsable(DeviceNumber dn) throws WBEMException {
        boolean ret = ResourceRestriction.isVolumeUsable(dn);
        if (ret) {
            UnsignedInteger16 usage = dn.getUsageValue();
            ret = ProviderConstants.UINT16_THREE.intValue() != usage.intValue();
        }
        return ret;
    }

    private ResourceRestriction(String serialNumber) {
        super(serialNumber);
        this.usableSnapshotVolumes = new HashSet<Long>();
        this.usableThinPools = new HashSet<Short>();
        this.usableSnapPools = new HashSet<Short>();
        this.parseRestrictionData();
    }

    private boolean isResourceGroupUsable(int rsg) {
        boolean ret = true;
        ret = this.usableRSGs.contains((short)rsg);
        return ret;
    }

    private void parseLDEVStr(String txt2Parse) throws WBEMException {
        if (null != txt2Parse) {
            String[] split;
            for (String txt : split = txt2Parse.split(",")) {
                long max;
                long min;
                int index = txt.indexOf(MULTIPLE_SEPERATOR);
                if (-1 != index) {
                    String minStr = txt.substring(0, index);
                    String maxStr = txt.substring(index + MULTIPLE_SEPERATOR.length());
                    min = ResourceRestriction.getDevNumFromString(minStr);
                    max = ResourceRestriction.getDevNumFromString(maxStr);
                } else {
                    min = max = ResourceRestriction.getDevNumFromString(txt);
                }
                for (long val = min; val <= max; ++val) {
                    this.usableSnapshotVolumes.add(val);
                }
            }
        }
    }

    private void parseResourceRestriction(String txt2Parse) {
        if (null != txt2Parse) {
            this.usableRSGs.addAll(this.parseShortFormatStr(txt2Parse));
        }
    }

    private void parseRestrictionData() {
        block9: {
            try {
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber());
                RMIObjectCache rmiObj = device.getRMIObject();
                String rsgTxt2Parse = rmiObj.getSMISDeviceUsableResourceGroups();
                if (null != rsgTxt2Parse) {
                    this.parseResourceRestriction(rsgTxt2Parse);
                    this.useRSGs = true;
                    break block9;
                }
                this.useRSGs = false;
                mLogger.finer("No resource group entry in properties file");
                try {
                    this.parseSnapshotPoolIDStr(rmiObj.getSMISDeviceRestrictedPoolString());
                }
                catch (WBEMException we) {
                    throw we;
                }
                catch (Throwable t) {
                    throw new WBEMException(1, "Error getting PoolIDForSnapshot", null, t);
                }
                try {
                    this.parseLDEVStr(rmiObj.getSMISDeviceRestrictedVVolForSnapshot());
                }
                catch (WBEMException we) {
                    throw we;
                }
                catch (Throwable t) {
                    throw new WBEMException(1, "Error getting VVolForSnapshot", null, t);
                }
            }
            catch (Throwable t) {
                this.useRSGs = false;
                mLogger.log(Level.SEVERE, "Unable to determine is resource restrictions are enabled, defaulting to disabled", t);
            }
        }
    }

    private Set<Short> parseShortFormatStr(String txt2Parse) {
        HashSet<Short> ret = new HashSet<Short>();
        if (null != txt2Parse) {
            String[] split;
            for (String txt : split = txt2Parse.split(",")) {
                short max;
                short min;
                int index = txt.indexOf(MULTIPLE_SEPERATOR);
                if (-1 != index) {
                    String minStr = txt.substring(0, index);
                    String maxStr = txt.substring(index + MULTIPLE_SEPERATOR.length());
                    min = Short.parseShort(minStr);
                    max = Short.parseShort(maxStr);
                } else {
                    min = max = Short.parseShort(txt);
                }
                for (short val = min; val <= max; val = (short)(val + 1)) {
                    ret.add(val);
                }
            }
        }
        return ret;
    }

    private void parseSnapshotPoolIDStr(String txt2Parse) throws WBEMException {
        if (null != txt2Parse) {
            this.usableSnapPools.addAll(this.parseShortFormatStr(txt2Parse));
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceRestriction [usableRSGs=");
        builder.append(this.usableRSGs);
        builder.append("]");
        return builder.toString();
    }
}

