/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.LDEVStats;
import com.hitachi.smi.common.ProviderConstants;
import com.ws.wbem.CloseableAddableIterator;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJSetGettingParamDevice;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiVDEVIndex;
import sanproject.common.Robj_interface_RJiVDEVInfoDetail;
import sanproject.common.Robj_interface_RJiVDEVLDEVInfoDetail;
import sanproject.serverux.data.SANRmiException;

public class VDEVStats {
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    private UnsignedInteger64 mReadIOs;
    private UnsignedInteger64 mReadHits;
    private UnsignedInteger64 mReadTrans;
    private UnsignedInteger64 mWriteIOs;
    private UnsignedInteger64 mWriteHits;
    private UnsignedInteger64 mWriteTrans;
    private Date mTargetTime;
    private UnsignedInteger64 mTotalIOs;
    private final int fb4;
    private final int pg;

    public static void getAllStats(RMIObjectCache rmiObj, CloseableAddableIterator<VDEVStats> callback) throws RemoteException, SANRmiException, WBEMException {
        Robj_interface_RJSetGettingParamDevice param = (Robj_interface_RJSetGettingParamDevice)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.SetGettingParam);
        param.setBAllDevice(true);
        ClosableAddableIteratorCB<ChassisArrayGroup> cagCB = new ClosableAddableIteratorCB<ChassisArrayGroup>();
        ChassisArrayGroup.getChassisArrayGroup(rmiObj, cagCB, false);
        CloseableAddableIterator<ChassisArrayGroup> cagIter = cagCB.getWrappedCloseableAddableIter();
        ArrayList<Robj_interface_RJiVDEVIndex> vdevs = new ArrayList<Robj_interface_RJiVDEVIndex>();
        while (cagIter.hasNext()) {
            ChassisArrayGroup cag = (ChassisArrayGroup)cagIter.next();
            Robj_interface_RJiVDEVIndex vdev = (Robj_interface_RJiVDEVIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJIVDEVINDEX);
            vdev.setIFB4(cag.getFb4());
            vdev.setIPG(cag.getPg());
            vdev.setIVDEV(cag.getVdev());
            vdevs.add(vdev);
        }
        VDEVStats.getVDEVStats(rmiObj, callback, vdevs.toArray(new Robj_interface_RJiVDEVIndex[vdevs.size()]));
    }

    public static VDEVStats getVDEVStats(RMIObjectCache rmiObj, ChassisArrayGroup cag) throws RemoteException, SANRmiException, WBEMException {
        Robj_interface_RJiVDEVIndex vdev = (Robj_interface_RJiVDEVIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJIVDEVINDEX);
        vdev.setIFB4(cag.getFb4());
        vdev.setIPG(cag.getPg());
        vdev.setIVDEV(cag.getVdev());
        CloseableAddableIterator callback = new CloseableAddableIterator();
        VDEVStats.getVDEVStats(rmiObj, (CloseableAddableIterator<VDEVStats>)callback, new Robj_interface_RJiVDEVIndex[]{vdev});
        VDEVStats ret = callback.hasNext() ? (VDEVStats)callback.next() : new VDEVStats(vdev.getIFB4(), vdev.getIPG());
        if (callback.hasNext()) {
            throw new WBEMException(String.format("ChassssArrayGroup(%s) has more then 1 statistic object! Found %s and %s", cag.getChassisArrayID(), ret, callback.next()));
        }
        return ret;
    }

    public static void getVDEVStats(RMIObjectCache rmiObj, CloseableAddableIterator<VDEVStats> callback, Robj_interface_RJiVDEVIndex vdev) throws RemoteException, SANRmiException, WBEMException {
        VDEVStats.getVDEVStats(rmiObj, callback, new Robj_interface_RJiVDEVIndex[]{vdev});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getVDEVStats(RMIObjectCache rmiObj, CloseableAddableIterator<VDEVStats> callback, Robj_interface_RJiVDEVIndex[] vdevs) throws RemoteException, SANRmiException, WBEMException {
        Robj_interface_RJiVDEVInfoDetail[] details = rmiObj.getVDEVInfoDetail(vdevs);
        try {
            for (Robj_interface_RJiVDEVInfoDetail vdevInfo : details) {
                if (-1 == ChassisArrayGroup.makeArrayGroup(vdevInfo.getIFB4(), vdevInfo.getIPG(), vdevInfo.getIVDEV())) continue;
                VDEVStats statObj = null;
                CloseableAddableIterator stats = new CloseableAddableIterator();
                ArrayList<Robj_interface_RJiVDEVLDEVInfoDetail> vdevLDEVInfo = new ArrayList<Robj_interface_RJiVDEVLDEVInfoDetail>();
                for (Robj_interface_RJiVDEVLDEVInfoDetail vdevLDEVInf : vdevInfo.getObjVDEVLDEVInfo()) {
                    if (3 == vdevLDEVInf.getByLDEVStatus()) continue;
                    vdevLDEVInfo.add(vdevLDEVInf);
                }
                LDEVStats.getLDEVStats(rmiObj, (Robj_interface_RJiLDEVIndex[])vdevLDEVInfo.toArray(new Robj_interface_RJiVDEVLDEVInfoDetail[vdevLDEVInfo.size()]), (CloseableAddableIterator<LDEVStats>)stats);
                while (stats.hasNext()) {
                    LDEVStats stat = (LDEVStats)stats.next();
                    if (null == statObj) {
                        mLogger.log(Level.FINE, "Creating new VDEV stat for FB4: {0}, PG {1}, VDEV: {2} using LDEV: {3}", new Object[]{vdevInfo.getIFB4(), vdevInfo.getIPG(), vdevInfo.getIVDEV(), stat});
                        statObj = new VDEVStats(vdevInfo.getIFB4(), vdevInfo.getIPG(), stat);
                        continue;
                    }
                    mLogger.log(Level.FINE, "Adding to VDEV stat for FB4: {0}, PG {1}, VDEV: {2} using LDEV: {3}", new Object[]{vdevInfo.getIFB4(), vdevInfo.getIPG(), vdevInfo.getIVDEV(), stat});
                    super.add2VDEVStats(stat);
                }
                if (null != statObj) {
                    callback.add(statObj);
                    continue;
                }
                mLogger.log(Level.INFO, "VDEV for FB4: {0}, PG {1}, VDEV: {2} has no volumes", new Object[]{vdevInfo.getIFB4(), vdevInfo.getIPG(), vdevInfo.getIVDEV()});
            }
        }
        finally {
            if (null != callback && !callback.isDone()) {
                callback.done();
            }
        }
    }

    private VDEVStats(int fb4, int pg) {
        this.fb4 = fb4;
        this.pg = pg;
        this.mReadHits = this.mReadTrans = ProviderConstants.UINT64_ZED;
        this.mReadIOs = this.mReadTrans;
        this.mWriteHits = this.mWriteTrans = ProviderConstants.UINT64_ZED;
        this.mWriteIOs = this.mWriteTrans;
        this.mTotalIOs = ProviderConstants.UINT64_ZED;
        this.mTargetTime = null;
    }

    private VDEVStats(int fb4, int pg, LDEVStats stat) throws WBEMException {
        this(fb4, pg);
        this.mReadHits = stat.getReadHitStatistic();
        this.mReadIOs = stat.getReadIOStatistic();
        this.mReadTrans = stat.getReadTransRateStatistic();
        this.mWriteHits = stat.getWriteHitStatistic();
        this.mWriteIOs = stat.getWriteIOStatistic();
        this.mWriteTrans = stat.getWriteTransRateStatistic();
        this.mTotalIOs = stat.getGetTotalIOs();
        this.mTargetTime = stat.getTargetTime();
    }

    private void add2VDEVStats(LDEVStats stat) throws WBEMException {
        BigInteger tempVal = this.mReadHits.bigIntegerValue();
        BigInteger tempStatVal = stat.getReadHitStatistic().bigIntegerValue();
        this.mReadHits = new UnsignedInteger64(tempVal.add(tempStatVal));
        tempVal = this.mReadIOs.bigIntegerValue();
        tempStatVal = stat.getReadIOStatistic().bigIntegerValue();
        this.mReadIOs = new UnsignedInteger64(tempVal.add(tempStatVal));
        tempVal = this.mReadTrans.bigIntegerValue();
        tempStatVal = stat.getReadTransRateStatistic().bigIntegerValue();
        this.mReadTrans = new UnsignedInteger64(tempVal.add(tempStatVal));
        tempVal = this.mWriteIOs.bigIntegerValue();
        tempStatVal = stat.getWriteIOStatistic().bigIntegerValue();
        this.mWriteIOs = new UnsignedInteger64(tempVal.add(tempStatVal));
        tempVal = this.mWriteHits.bigIntegerValue();
        tempStatVal = stat.getWriteHitStatistic().bigIntegerValue();
        this.mWriteHits = new UnsignedInteger64(tempVal.add(tempStatVal));
        tempVal = this.mWriteTrans.bigIntegerValue();
        tempStatVal = stat.getWriteTransRateStatistic().bigIntegerValue();
        this.mWriteTrans = new UnsignedInteger64(tempVal.add(tempStatVal));
        tempVal = this.mTotalIOs.bigIntegerValue();
        tempStatVal = stat.getGetTotalIOs().bigIntegerValue();
        this.mTotalIOs = new UnsignedInteger64(tempVal.add(tempStatVal));
        if (null == this.mTargetTime) {
            this.mTargetTime = stat.getTargetTime();
        }
    }

    public int getArrayGroup() {
        return ChassisArrayGroup.makeArrayGroup(this.fb4, this.pg, -1);
    }

    public int getFb4() {
        return this.fb4;
    }

    public UnsignedInteger64 getGetTotalIOs() {
        return this.mTotalIOs;
    }

    public int getPg() {
        return this.pg;
    }

    public UnsignedInteger64 getReadHitStatistic() {
        return this.mReadHits;
    }

    public UnsignedInteger64 getReadIOStatistic() throws WBEMException, RemoteException, SANRmiException {
        return this.mReadIOs;
    }

    public UnsignedInteger64 getReadTransRateStatistic() {
        return this.mReadTrans;
    }

    public Date getTargetTime() {
        return this.mTargetTime;
    }

    public UnsignedInteger64 getWriteHitStatistic() {
        return this.mWriteHits;
    }

    public UnsignedInteger64 getWriteIOStatistic() {
        return this.mWriteIOs;
    }

    public UnsignedInteger64 getWriteTransRateStatistic() {
        return this.mWriteTrans;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VDEVStats [AG=");
        builder.append(this.getArrayGroup());
        builder.append(", mReadIOs=");
        builder.append(this.mReadIOs);
        builder.append(", mReadHits=");
        builder.append(this.mReadHits);
        builder.append(", mReadTrans=");
        builder.append(this.mReadTrans);
        builder.append(", mWriteIOs=");
        builder.append(this.mWriteIOs);
        builder.append(", mWriteHits=");
        builder.append(this.mWriteHits);
        builder.append(", mWriteTrans=");
        builder.append(this.mWriteTrans);
        builder.append(", mTargetTime=");
        builder.append(this.mTargetTime);
        builder.append(", mTotalIOs=");
        builder.append(this.mTotalIOs);
        builder.append("]");
        return builder.toString();
    }
}

