/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common.keyvalueapis;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.keyvalueapis.KeyValueAPIBaseObject;
import java.rmi.RemoteException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class MNTreadDriveBoxInfo
extends KeyValueAPIBaseObject {
    private static final String MN_TREAD_DRIVE_BOX_INFO = "MNTreadDriveBoxInfo";
    private final SortedMap<MNTreadDriveBoxInfoDrivesID, UnsignedInteger16> sortedMap = this.getMNTreadDriveBoxInfo();

    public MNTreadDriveBoxInfo(RMIObjectCache rmi, String clientIP) throws WBEMException {
        super(rmi, clientIP, MN_TREAD_DRIVE_BOX_INFO, false);
    }

    private SortedMap<MNTreadDriveBoxInfoDrivesID, UnsignedInteger16> getMNTreadDriveBoxInfo() {
        TreeMap<MNTreadDriveBoxInfoDrivesID, UnsignedInteger16> ret = new TreeMap<MNTreadDriveBoxInfoDrivesID, UnsignedInteger16>();
        try {
            this.getRmiObject().addAccountInfo(this.getGeneralParameter());
            SanResponse resp = this.getRmiObject().keyValueAPI_Invoke(MN_TREAD_DRIVE_BOX_INFO, this.getSanRemote(), this.getGeneralParameter(), this.getRequest(), true);
            SanList driveBoxes = resp.getList("DriveBoxes");
            if (null != driveBoxes && !driveBoxes.isEmpty()) {
                for (SanObject driveBox : driveBoxes) {
                    UnsignedInteger16 type = this.getType(driveBox);
                    SanList drives = driveBox.getList("Drives");
                    for (SanObject drive : drives) {
                        int[] cdevandrdev = drive.getIntArray("Id");
                        MNTreadDriveBoxInfoDrivesID driveID = new MNTreadDriveBoxInfoDrivesID(cdevandrdev[0], cdevandrdev[1]);
                        ret.put(driveID, type);
                    }
                }
            }
        }
        catch (SanDataException | SanRmiException | RemoteException | WBEMException e) {
            logger.log(Level.SEVERE, "Error invoking MNTreadDriveBoxInfo", e);
        }
        return ret;
    }

    public UnsignedInteger16 getType(int cdev, int rdev) {
        MNTreadDriveBoxInfoDrivesID t = new MNTreadDriveBoxInfoDrivesID(cdev, rdev);
        return (UnsignedInteger16)this.sortedMap.get(t);
    }

    private UnsignedInteger16 getType(SanObject driveBox) {
        int type;
        UnsignedInteger16 ret = ProviderConstants.UINT16_ZED;
        try {
            type = driveBox.getInt("Type");
        }
        catch (SanDataException e) {
            logger.log(Level.SEVERE, "Error getting 'type' from MNTreadDriveBoxInfo", e);
            type = 0;
        }
        switch (type) {
            case 1: 
            case 7: {
                ret = ProviderConstants.UINT16_FOUR;
                break;
            }
            case 2: {
                ret = ProviderConstants.UINT16_FIVE;
                break;
            }
            case 0: {
                ret = ProviderConstants.UINT16_ZED;
                break;
            }
            default: {
                logger.log(Level.WARNING, "{0} returned boxtype {1}, which is unknown", new Object[]{MN_TREAD_DRIVE_BOX_INFO, type});
            }
        }
        return ret;
    }

    private class MNTreadDriveBoxInfoDrivesID
    implements Comparable<MNTreadDriveBoxInfoDrivesID> {
        int cdev;
        int rdev;

        public MNTreadDriveBoxInfoDrivesID(int cdev, int rdev) {
            this.cdev = cdev;
            this.rdev = rdev;
        }

        @Override
        public int compareTo(MNTreadDriveBoxInfoDrivesID other) {
            int ret;
            int n = this.getCDev() == other.getCDev() ? 0 : (ret = this.getCDev() < other.getCDev() ? -1 : 1);
            if (ret == 0) {
                ret = this.getRDev() == other.getRDev() ? 0 : (this.getRDev() < other.getRDev() ? -1 : 1);
            }
            return ret;
        }

        int getCDev() {
            return this.cdev;
        }

        int getRDev() {
            return this.rdev;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MNTreadDriveBoxInfoDrivesID [cdev=");
            builder.append(this.cdev);
            builder.append(", rdev=");
            builder.append(this.rdev);
            builder.append("]");
            return builder.toString();
        }
    }
}

