/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common.keyvalueapis;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.keyvalueapis.KeyValueAPIBaseObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiLDEVIndex;

public class MRCFreadSnapshotRootLdevInfo
extends KeyValueAPIBaseObject {
    public static final String ROOT_LDEVS = "RootLdevs";
    public static final String LDEV = "Ldev";
    private static String KeyValueFuncName = "MRCFreadSnapshotRootLdevInfo";

    public MRCFreadSnapshotRootLdevInfo(RMIObjectCache rmi, String clientIP) throws WBEMException {
        super(rmi, clientIP, KeyValueFuncName, true);
    }

    public void addDN(BaseDeviceNumber dn) throws WBEMException {
        this.addToRequest(dn.getLdkc(), dn.getCu(), dn.getLdev());
    }

    public void addDNs(List<? extends BaseDeviceNumber> dns) throws WBEMException {
        for (BaseDeviceNumber baseDeviceNumber : dns) {
            this.addDN(baseDeviceNumber);
        }
    }

    public void addLDEV(Robj_interface_RJiLDEVIndex ldevIndex) throws WBEMException {
        this.addToRequest(ldevIndex.getSLDKC(), ldevIndex.getSCU(), ldevIndex.getSLDEV());
    }

    public void addLDEVs(Robj_interface_RJiLDEVIndex[] ldevIndexArray) throws WBEMException {
        for (Robj_interface_RJiLDEVIndex ldevIdx : ldevIndexArray) {
            this.addLDEV(ldevIdx);
        }
    }

    private void addToRequest(int dkc, int cu, int ldev) throws WBEMException {
        try {
            SanRequest request = this.getRequest();
            SanList rootLDevs = request.getList(ROOT_LDEVS);
            if (null == rootLDevs) {
                logger.finer("Creating 'RootLdevs' list");
                rootLDevs = request.newList(ROOT_LDEVS);
            } else {
                logger.finer("Got 'RootLdevs' list");
            }
            SanObject ldevObj = rootLDevs.addObj();
            logger.log(Level.FINER, "Adding Volume {0}:{1}:{2} to request", new Object[]{dkc, cu, ldev});
            ldevObj.putIntArray("Id", new int[]{dkc, cu, ldev});
        }
        catch (SanDataException e) {
            throw new WBEMException(1, "An error occured adding key value data", null, (Throwable)e);
        }
    }

    public List<RootLDEVInfo> getData() {
        return this.getData(-1);
    }

    public List<RootLDEVInfo> getData(int poolID) {
        ArrayList<RootLDEVInfo> ret = new ArrayList<RootLDEVInfo>();
        SanList results = this.processKeyValueApi();
        if (null == results || results.isEmpty()) {
            return ret;
        }
        for (SanObject rootLDEVs : results) {
            try {
                int[] dkcfb4 = rootLDEVs.getIntArray("Id");
                long bdn = BaseDeviceNumber.makeUniqueDN((short)dkcfb4[0], (short)dkcfb4[1], (short)dkcfb4[2]);
                SanObject errorInf = rootLDEVs.getObj("ErrorInfo");
                int errorVal = errorInf.getInt("ErrorCode");
                if (0 != errorVal) {
                    logger.log(Level.SEVERE, "DN {0} has error code {1}, message ID {2}, skipping to next one", new Object[]{bdn, errorVal, Arrays.toString(errorInf.getIntArray("MessageId"))});
                    continue;
                }
                SanObject rootLDevInfo = rootLDEVs.getObj("RootLdevInfo");
                if (null == rootLDevInfo) {
                    logger.log(Level.FINE, "Volume {0} is P-VOL is not a pair, skipping", bdn);
                    continue;
                }
                int pairnum = rootLDevInfo.getInt("PairNum");
                int suspendErrPrNum = rootLDevInfo.getInt("SuspendErrorPairNum");
                boolean cascade = rootLDevInfo.getBoolean("Cascade");
                SanObject poolObj = rootLDevInfo.getObj("Pool");
                int tiPoolID = poolObj.getInt("Id");
                long tiPoolUsed = poolObj.getLong("UsedCapacity");
                if (-1 != poolID && poolID != tiPoolID) continue;
                ret.add(new RootLDEVInfo(bdn, pairnum, suspendErrPrNum, cascade, tiPoolID, tiPoolUsed));
            }
            catch (SanDataException e) {
                logger.log(Level.SEVERE, "Error getting DKC:CU:LDEV, skipping to next one", e);
            }
        }
        return ret;
    }

    public List<DeviceNumber> getUsableNonRootLDEVs() throws WBEMException {
        ArrayList<DeviceNumber> ret = new ArrayList<DeviceNumber>();
        SanList results = this.processKeyValueApi();
        for (SanObject rootLDEVs : results) {
            try {
                int[] dkcfb4 = rootLDEVs.getIntArray("Id");
                long bdn = BaseDeviceNumber.makeUniqueDN((short)dkcfb4[0], (short)dkcfb4[1], (short)dkcfb4[2]);
                SanObject errorInf = rootLDEVs.getObj("ErrorInfo");
                int errorVal = errorInf.getInt("ErrorCode");
                if (0 != errorVal) {
                    logger.log(Level.SEVERE, "DN {0} has error code {1}, message ID {2}, skipping to next one", new Object[]{bdn, errorVal, Arrays.toString(errorInf.getIntArray("MessageId"))});
                    continue;
                }
                SanObject rootLDevInfo = rootLDEVs.getObj("RootLdevInfo");
                if (null != rootLDevInfo) {
                    logger.log(Level.FINE, "Volume {0} is P-VOL of another pair, skipping", bdn);
                    continue;
                }
                DeviceNumber dn = DeviceNumber.find(Long.toString(bdn), this.getRmiObject());
                if (null != dn && 0L == dn.getSpaceConsumed()) {
                    logger.log(Level.FINER, "Volume {0} is available", dn.getDn());
                    ret.add(dn);
                    continue;
                }
                logger.log(Level.WARNING, "Volume {0} was returned from Key Value call but {1}", new Object[]{bdn, null == dn ? "it is not in the cache" : "space is being used"});
            }
            catch (SanDataException e) {
                logger.log(Level.SEVERE, "Error getting DKC:CU:LDEV, skipping to next one", e);
            }
        }
        return ret;
    }

    private SanList processKeyValueApi() {
        SanList ret = null;
        try {
            SanList rootLDevs = this.getRequest().getList(ROOT_LDEVS);
            if (null == rootLDevs || rootLDevs.size() == 0) {
                logger.log(Level.FINE, "No LDEVs, skipping " + this.getClass().getSimpleName());
                return ret;
            }
            this.getRmiObject().addAccountInfo(this.getGeneralParameter());
            SanResponse resp = this.getRmiObject().keyValueAPI_Invoke(KeyValueFuncName, this.getSanRemote(), this.getGeneralParameter(), this.getRequest(), true);
            ret = resp.getList(ROOT_LDEVS);
        }
        catch (SanDataException | SanRmiException | RemoteException | WBEMException e) {
            logger.log(Level.SEVERE, "Error invoking " + KeyValueFuncName, e);
        }
        return ret;
    }

    public static class RootLDEVInfo
    implements Comparable<RootLDEVInfo> {
        long rootDN;
        int pairNum;
        int suspendErrorPairNum;
        boolean cascade;
        int tiPoolID;
        long tiPoolUsedCapacity;

        public RootLDEVInfo(long bdn) {
            this(bdn, -1, -1, false, -1, -1L);
        }

        public RootLDEVInfo(long bdn, int pairnum2, int suspendErrPrNum, boolean cascade2, int tiPoolID2, long tiPoolUsed) {
            this.rootDN = bdn;
            this.pairNum = pairnum2;
            this.suspendErrorPairNum = suspendErrPrNum;
            this.cascade = cascade2;
            this.tiPoolID = tiPoolID2;
            this.tiPoolUsedCapacity = tiPoolUsed;
        }

        @Override
        public int compareTo(RootLDEVInfo o) {
            return this.rootDN < o.rootDN ? -1 : (this.rootDN == o.rootDN ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RootLDEVInfo other = (RootLDEVInfo)obj;
            if (this.rootDN != other.rootDN) {
                return false;
            }
            if (this.tiPoolID != other.tiPoolID) {
                return false;
            }
            if (this.tiPoolUsedCapacity != other.tiPoolUsedCapacity) {
                return false;
            }
            if (this.cascade != other.cascade) {
                return false;
            }
            if (this.pairNum != other.pairNum) {
                return false;
            }
            return this.suspendErrorPairNum == other.suspendErrorPairNum;
        }

        public int getPairNum() {
            return this.pairNum;
        }

        public long getRootDN() {
            return this.rootDN;
        }

        public int getSuspendErrorPairNum() {
            return this.suspendErrorPairNum;
        }

        public int getTiPoolID() {
            return this.tiPoolID;
        }

        public long getTiPoolUsedCapacity() {
            return this.tiPoolUsedCapacity;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cascade ? 1231 : 1237);
            result = 31 * result + this.pairNum;
            result = 31 * result + (int)(this.rootDN ^ this.rootDN >>> 32);
            result = 31 * result + this.suspendErrorPairNum;
            result = 31 * result + this.tiPoolID;
            result = 31 * result + (int)(this.tiPoolUsedCapacity ^ this.tiPoolUsedCapacity >>> 32);
            return result;
        }

        public boolean isCascade() {
            return this.cascade;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RootLDEVInfo [rootDN=");
            builder.append(this.rootDN);
            builder.append(", pairNum=");
            builder.append(this.pairNum);
            builder.append(", tiPoolID=");
            builder.append(this.tiPoolID);
            builder.append(", tiPoolUsedCapacity=");
            builder.append(this.tiPoolUsedCapacity);
            builder.append("]");
            return builder.toString();
        }
    }
}

