/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public final class AllocatedFromSnapshotPoolInstrumentation
extends BaseAssocInstrumentation {
    private static final String CCN_HITACHI_ALLOCATEDFROMSNAPSHOTPOOL = "HITACHI_AllocatedFromSnapshotPool";
    private static final String CCN_ANTECEDENT = "HITACHI_SnapshotPool";
    private static final String CCN_DEPENDENT = "HITACHI_StorageVolume";

    protected AllocatedFromSnapshotPoolInstrumentation() {
        super(CCN_HITACHI_ALLOCATEDFROMSNAPSHOTPOOL, CCN_ANTECEDENT, "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SnapshotPoolInstrumentation"), CCN_DEPENDENT, "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && CCN_HITACHI_ALLOCATEDFROMSNAPSHOTPOOL.equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (!shouldTestInst || this.getReference1Instrumentation().instanceExists(objectName)) {
                        CIMProperty cpPoolID = objectName.getKey("InstanceID");
                        String strPoolID = (String)cpPoolID.getValue();
                        String deviceSerial = ProviderLibs.getAllButEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                        this.getStorageVolumesFromSnapshotPool(iter, objectName, propertyList, isObjectPath, poolID, true, ProviderLibs.getSerialFromString(deviceSerial));
                    }
                } else if (!(!objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) || null != role && !role.equalsIgnoreCase(this.getReference2PropertyName()) || null != resultRole && !resultRole.equalsIgnoreCase(this.getReference1PropertyName()) || shouldTestInst && !this.getReference2Instrumentation().instanceExists(objectName))) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDevID = objectName.getKey("DeviceID");
                    String strDevID = (String)cpDevID.getValue();
                    DeviceNumber dn = DeviceNumber.find(strDevID, device.getRMIObject());
                    if (dn != null) {
                        if (dn.isQSVvol()) {
                            ClosableAddableIteratorCB<SnapshotInfo2> callback = new ClosableAddableIteratorCB<SnapshotInfo2>();
                            SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, dn.getDNAsString(), Boolean.FALSE);
                            CloseableAddableIterator<SnapshotInfo2> pairDataList = callback.getWrappedCloseableAddableIter();
                            if (pairDataList.hasNext()) {
                                SnapshotInfo2 pairData = (SnapshotInfo2)pairDataList.next();
                                ThinPool tp = ThinPool.find(device.getRMIObject(), (short)pairData.getTiPoolID(), ThinPool.ThinPoolType.QS);
                                if (tp != null) {
                                    if (isObjectPath) {
                                        CIMObjectPath retOP = this.getReference1Instrumentation().generateObjectPath(objectName, tp);
                                        if (retOP != null) {
                                            iter.add(retOP);
                                        }
                                    } else {
                                        CIMInstance ret = this.getReference1Instrumentation().generateInstance(objectName, propertyList, tp);
                                        if (ret != null) {
                                            iter.add(ret);
                                        }
                                    }
                                } else {
                                    mLogger.info("Could not find a snapshot pool with ID: " + pairData.getTiPoolID());
                                }
                            }
                        } else {
                            mLogger.info("Specified StorageVolume is not a QSVVol: " + objectName);
                        }
                    } else {
                        mLogger.info("Could not find a DeviceNumber with ID: " + strDevID);
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private UnsignedInteger64 calcCTPSpaceConsumed(CIMObjectPath objectName) throws WBEMException {
        CIMProperty cpPoolID = objectName.getKey("InstanceID");
        String strPoolID = (String)cpPoolID.getValue();
        short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
        ThinPool tp = ThinPool.find(device.getRMIObject(), poolID, ThinPool.ThinPoolType.QS);
        if (null == tp) {
            throw new WBEMException("No QS pool with ID: " + poolID);
        }
        return ProviderLibs.calcCTPRMS4Snapshot(tp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ThinPool> callback = new CallbackHandler<ThinPool>(deviceIter, isObjectPath, refInfo, op, propertyList);
                ThinPool.getThinPools(device.getRMIObject(), callback, (short)-1, false);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath opObjectName, String[] propertyList, Object ... o) throws Exception {
        CIMInstance ret = null;
        CIMObjectPath opAssoc = this.generateObjectPath(opObjectName, o);
        CIMProperty[] keys = opAssoc.getKeys();
        UnsignedInteger64 spaceConsumed = this.calcCTPSpaceConsumed((CIMObjectPath)o[0]);
        CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], new CIMProperty("SpaceConsumed", CIMDataType.UINT64_T, (Object)spaceConsumed, false)};
        ret = new CIMInstance(opAssoc, props).filterProperties(propertyList);
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block11: {
            try {
                String pnStorageVolume = this.getReference2PropertyName();
                CIMObjectPath opStorageVolume = opObjectName.getKey(pnStorageVolume) != null ? (CIMObjectPath)opObjectName.getKey(pnStorageVolume).getValue() : null;
                CIMInstance instStorageVolume = null;
                try {
                    instStorageVolume = this.getReference2Instrumentation().getInstance(opStorageVolume, null);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null == instStorageVolume) break block11;
                String pnSnapshotPool = this.getReference1PropertyName();
                CIMObjectPath opSnapshotPool = opObjectName.getKey(pnSnapshotPool) != null ? (CIMObjectPath)opObjectName.getKey(pnSnapshotPool).getValue() : null;
                CIMInstance instSnapshotPool = null;
                try {
                    instSnapshotPool = this.getReference1Instrumentation().getInstance(opSnapshotPool, null);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instSnapshotPool) {
                    opStorageVolume = instStorageVolume.getObjectPath();
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageVolume, "SystemName");
                    String cpvDeviceID = (String)instStorageVolume.getPropertyValue("DeviceID");
                    CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                    SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, cpvDeviceID, Boolean.FALSE);
                    LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                    if (pairDataList.size() == 1) {
                        String poolID;
                        SnapshotInfo2 pd = (SnapshotInfo2)pairDataList.poll();
                        String pairDataPoolID = String.valueOf(pd.getTiPoolID());
                        String cpvInstanceID = (String)instSnapshotPool.getPropertyValue("InstanceID");
                        String string = poolID = null != cpvInstanceID ? ProviderLibs.getEndString(cpvInstanceID) : null;
                        if (pairDataPoolID.equals(poolID)) {
                            return this.generateInstance(opObjectName, propertyList, instSnapshotPool.getObjectPath(), instStorageVolume.getObjectPath());
                        }
                    } else {
                        mLogger.log(Level.SEVERE, "There is more then 1  PairData for sync'd DN: ", cpvDeviceID);
                    }
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    private void getStorageVolumesFromSnapshotPool(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, boolean isObjectPath, short tPoolID, boolean isAssocCall, String deviceSerial) throws Exception {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(deviceSerial);
        if (null == device) {
            throw new WBEMException("Could not get managed device with serial: " + deviceSerial);
        }
        ThinPool tp = ThinPool.find(device.getRMIObject(), tPoolID, ThinPool.ThinPoolType.QS);
        if (tp != null) {
            SnapshotInfo2 pairData;
            CIMObjectPath opSnapshotPool = this.getReference1Instrumentation().generateObjectPath(op, tp);
            CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
            SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, tp.getPoolID(), (boolean)Boolean.FALSE);
            LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
            while ((pairData = (SnapshotInfo2)pairDataList.poll()) != null) {
                CIMInstance ret;
                DeviceNumber sVolDN = pairData.getSVol();
                if (null == sVolDN) continue;
                CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(op, sVolDN);
                if (isObjectPath) {
                    CIMObjectPath retOP = !isAssocCall ? this.generateObjectPath(op, opSnapshotPool, opStorageVolume) : opStorageVolume;
                    if (retOP == null) continue;
                    iter.add(retOP);
                    continue;
                }
                if (!isAssocCall) {
                    ret = this.generateInstance(op, propertyList, opSnapshotPool, opStorageVolume);
                } else {
                    DeviceNumber dn = DeviceNumber.find(sVolDN.getDNAsString(), device.getRMIObject());
                    ret = this.getReference2Instrumentation().generateInstance(op, propertyList, dn);
                }
                if (ret == null) continue;
                iter.add(ret);
            }
        } else {
            mLogger.info("Could not find a Snapshot pool with ID: " + tPoolID);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && CCN_HITACHI_ALLOCATEDFROMSNAPSHOTPOOL.equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        CIMProperty cpPoolID = objectName.getKey("InstanceID");
                        String strPoolID = (String)cpPoolID.getValue();
                        String deviceSerial = ProviderLibs.getSerialFromString(strPoolID);
                        short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                        this.getStorageVolumesFromSnapshotPool(iter, objectName, propertyList, isObjectPath, poolID, false, deviceSerial);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDevID = objectName.getKey("DeviceID");
                    String strDevID = (String)cpDevID.getValue();
                    DeviceNumber dn = DeviceNumber.find(strDevID, device.getRMIObject());
                    if (dn != null) {
                        if (dn.isQSVvol()) {
                            CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                            SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, dn.getDNAsString(), Boolean.FALSE);
                            LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                            if (!pairDataList.isEmpty()) {
                                SnapshotInfo2 pairData = (SnapshotInfo2)pairDataList.get(0);
                                ThinPool tp = ThinPool.find(device.getRMIObject(), (short)pairData.getTiPoolID(), ThinPool.ThinPoolType.QS);
                                if (tp != null) {
                                    CIMObjectPath depOp = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                                    CIMObjectPath antOp = this.getReference1Instrumentation().generateObjectPath(objectName, tp);
                                    if (isObjectPath) {
                                        CIMObjectPath retOP = this.generateObjectPath(objectName, antOp, depOp);
                                        if (retOP != null) {
                                            iter.add(retOP);
                                        }
                                    } else {
                                        CIMInstance ret = this.generateInstance(objectName, propertyList, antOp, depOp);
                                        if (ret != null) {
                                            iter.add(ret);
                                        }
                                    }
                                } else {
                                    mLogger.info("Could not find a snapshot pool with ID: " + pairData.getTiPoolID());
                                }
                            }
                        } else {
                            mLogger.info("Specified StorageVolume is not a QSVVol: " + objectName);
                        }
                    } else {
                        mLogger.info("Could not find a DeviceNumber with ID: " + strDevID);
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }

    private class CallbackHandler<E extends ThinPool>
    extends IteratorCallbackIMPL<E> {
        private CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    E tp = item;
                    AllocatedFromSnapshotPoolInstrumentation.this.getStorageVolumesFromSnapshotPool(this.mIter, this.mOP, this.mPropertyList, this.mIsObjectPath, ((ThinPool)tp).getPoolID(), false, ((AbstractBaseCommonObject)tp).getSerialNumber());
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            } else {
                ret = false;
            }
            return ret;
        }
    }
}

