/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class ArrayGroupDiskDriveViewInstrumentation
extends BaseAssocInstrumentation {
    protected ArrayGroupDiskDriveViewInstrumentation() {
        super("HITACHI_ArrayGroupDiskDriveView", "HITACHI_ArrayGroup", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ArrayGroupInstrumentation"), "HITACHI_DiskDriveView", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskDriveViewInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ArrayGroupDiskDriveView".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance instArrayGroup;
                    block21: {
                        instArrayGroup = null;
                        try {
                            instArrayGroup = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                        }
                        catch (WBEMException e) {
                            if (e.getID() == 6) break block21;
                            throw e;
                        }
                    }
                    if (null != instArrayGroup) {
                        String cpvDeviceID;
                        CIMObjectPath opArrayGroup = instArrayGroup.getObjectPath();
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opArrayGroup, "SystemName");
                        String string = cpvDeviceID = opArrayGroup.getKey("DeviceID") != null ? (String)opArrayGroup.getKey("DeviceID").getValue() : null;
                        if (null != cpvDeviceID) {
                            Integer[] fbpg = ProviderLibs.getFBPGFromDeviceID(cpvDeviceID);
                            int fb4 = fbpg[0];
                            int pg = fbpg[1];
                            if (-1 != fb4 && -1 != pg) {
                                PDEVInfoEntry pdev;
                                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                                callback = null;
                                while (null != (pdev = pdevs.poll())) {
                                    if (fb4 != pdev.getFb4() || pg != pdev.getPg()) continue;
                                    if (isObjectPath) {
                                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, pdev));
                                        continue;
                                    }
                                    iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, pdev));
                                }
                            }
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    ChassisArrayGroup cag;
                    PDEVInfoEntry entry;
                    int[] deviceIDValues;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "DDSystemName");
                    CIMProperty ddvID = objectName.getKey("DDDeviceID");
                    if (null != ddvID && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID((String)ddvID.getValue())) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && -1 != entry.getFb4() && -1 != entry.getPg() && null != (cag = ChassisArrayGroup.find(device.getRMIObject(), entry.getFb4(), entry.getPg(), isObjectPath))) {
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, cag));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, cag));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                PDEVInfoEntry pdev;
                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                callback = null;
                while (null != (pdev = pdevs.poll())) {
                    ChassisArrayGroup cag;
                    int fb4 = pdev.getFb4();
                    int pg = pdev.getPg();
                    if (-1 == fb4 || -1 == pg || null == (cag = ChassisArrayGroup.find(device.getRMIObject(), fb4, pg, true))) continue;
                    CIMObjectPath opDDView = this.getReference2Instrumentation().generateObjectPath(op, pdev);
                    CIMObjectPath opArrayGroup = this.getReference1Instrumentation().generateObjectPath(op, cag);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opArrayGroup, opDDView));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, opArrayGroup, opDDView));
                }
            }
        }
        catch (WBEMException we) {
            iter.setException(we);
            iter.close();
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, "Exception during enum operation: " + th, null, th);
            iter.setException(we);
            iter.close();
        }
        finally {
            if (iter != null && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMProperty<?>[] getAdditionalProperties() {
        CIMProperty[] ret = new CIMProperty[]{new CIMProperty("BOStartingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("BOEndingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("BOOrderIndex", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false)};
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDDView;
            String agPropName = this.getReference1PropertyName();
            CIMObjectPath opAG = op.getKey(agPropName) != null ? (CIMObjectPath)op.getKey(agPropName).getValue() : null;
            String ddvPropName = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opDDView = op.getKey(ddvPropName) != null ? (CIMObjectPath)op.getKey(ddvPropName).getValue() : null;
            if (null != opAG && null != opDDView) {
                String agSystemName;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opAG, "SystemName");
                String ddvDeviceID = opDDView.getKey("DDDeviceID") != null ? (String)opDDView.getKey("DDDeviceID").getValue() : null;
                String ddvSystemName = opDDView.getKey("DDSystemName") != null && opDDView.getKey("DDSystemName").getValue() != null ? (String)opDDView.getKey("DDSystemName").getValue() : null;
                String agDeviceID = null != opAG.getKey("DeviceID") ? (String)opAG.getKey("DeviceID").getValue() : null;
                String string = agSystemName = null != opAG.getKey("SystemName") ? (String)opAG.getKey("SystemName").getValue() : null;
                if (ddvDeviceID != null && null != agDeviceID && null != ddvSystemName && null != agSystemName && agSystemName.equals(ddvSystemName) && ddvSystemName.equals(device.getStorageSystemName())) {
                    PDEVInfoEntry entry;
                    int[] deviceIDValues;
                    Integer[] fbpg = ProviderLibs.getFBPGFromDeviceID(agDeviceID);
                    int fb4 = fbpg[0];
                    int pg = fbpg[1];
                    if (-1 != fb4 && -1 != pg && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(ddvDeviceID)) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && fb4 == entry.getFb4() && pg == entry.getPg()) {
                        return this.generateInstance(op, propertyList, opAG, opDDView);
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        block31: {
            try {
                if (null == assocName || !"HITACHI_ArrayGroupDiskDriveView".equalsIgnoreCase(assocName.getObjectName())) break block31;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    String cpvDeviceID;
                    CIMInstance instArrayGroup = null;
                    try {
                        instArrayGroup = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                    }
                    catch (WBEMException e) {
                        if (e.getID() != 6) {
                            throw e;
                        }
                        mLogger.log(Level.SEVERE, "Unexpected exception getting instance of " + objectName, e);
                        if (null != iter && !iter.isDone()) {
                            iter.done();
                        }
                        return;
                    }
                    if (null != instArrayGroup && null != (cpvDeviceID = (String)objectName.getKeyValue("DeviceID"))) {
                        Integer[] fbpg = ProviderLibs.getFBPGFromDeviceID(cpvDeviceID);
                        int fb4 = fbpg[0];
                        int pg = fbpg[1];
                        if (-1 != fb4 && -1 != pg) {
                            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                            ClosableAddableIteratorCB<PDEVInfoEntry> callback = new ClosableAddableIteratorCB<PDEVInfoEntry>();
                            PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                            CloseableAddableIterator<PDEVInfoEntry> pdevsIter = callback.getWrappedCloseableAddableIter();
                            callback = null;
                            while (pdevsIter.hasNext()) {
                                PDEVInfoEntry pdev = (PDEVInfoEntry)pdevsIter.next();
                                if (fb4 != pdev.getFb4() || pg != pdev.getPg()) continue;
                                CIMObjectPath opDDView = this.getReference2Instrumentation().generateObjectPath(objectName, pdev);
                                if (isObjectPath) {
                                    iter.add(this.generateObjectPath(objectName, instArrayGroup.getObjectPath(), opDDView));
                                    continue;
                                }
                                iter.add(this.generateInstance(objectName, propertyList, instArrayGroup.getObjectPath(), opDDView));
                            }
                        }
                    }
                    break block31;
                }
                if (!objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) || null != role && !role.equalsIgnoreCase(this.getReference2PropertyName()) || !this.getReference2Instrumentation().instanceExists(objectName)) break block31;
                CIMInstance instDDView = null;
                try {
                    instDDView = this.getReference2Instrumentation().getInstance(objectName, new String[0]);
                }
                catch (WBEMException e) {
                    if (e.getID() != 6) {
                        throw e;
                    }
                    mLogger.log(Level.SEVERE, "Unexpected exception getting instance of " + objectName, e);
                    if (null != iter && !iter.isDone()) {
                        iter.done();
                    }
                    return;
                }
                int[] deviceIDValues = PDEVInfoEntry.parseDeviceID((String)objectName.getKeyValue("DDDeviceID"));
                if (null != deviceIDValues) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "DDSystemName");
                    PDEVInfoEntry entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1]);
                    if (null != entry && -1 != entry.getFb4() && -1 != entry.getPg()) {
                        ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), entry.getFb4(), entry.getPg(), isObjectPath);
                        if (null != cag) {
                            CIMObjectPath opArrayGroup = this.getReference1Instrumentation().generateObjectPath(objectName, cag);
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, opArrayGroup, instDDView.getObjectPath()));
                            } else {
                                iter.add(this.generateInstance(objectName, propertyList, opArrayGroup, instDDView.getObjectPath()));
                            }
                        } else {
                            mLogger.log(Level.WARNING, "Unable to find CAG {0}-{1} on {2}", new Object[]{entry.getFb4(), entry.getPg(), device.getSerialNumber()});
                        }
                    }
                } else {
                    mLogger.log(Level.WARNING, "Objectpath is missing property {0}: {1} ", new Object[]{"DDDeviceID", objectName});
                }
            }
            catch (WBEMException we) {
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            catch (Throwable th) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            finally {
                if (null != iter && !iter.isDone()) {
                    iter.done();
                }
            }
        }
    }
}

