/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class AuthorizedTargetInstrumentation
extends BaseAssocInstrumentation {
    protected AuthorizedTargetInstrumentation() {
        super("HITACHI_AuthorizedTarget", "HITACHI_AuthorizedPrivilege", "Privilege", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.AuthorizedPrivilegeInstrumentation"), "HITACHI_SCSIProtocolController", "TargetElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation"));
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opSCSIProtocolController) {
        String cvDeviceID;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        CIMProperty cpSysName = opSCSIProtocolController.getKey("SystemName");
        String cvSysName = null != cpSysName ? (String)cpSysName.getValue() : null;
        hTable.put("ElementName", cvSysName);
        CIMProperty cpDeviceID = opSCSIProtocolController.getKey("DeviceID");
        String string = cvDeviceID = null != cpDeviceID ? (String)cpDeviceID.getValue() : null;
        if (null != cvDeviceID) {
            String portID = ProviderLibs.getAllButEndString(cvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            String domainID = ProviderLibs.getEndString(cvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            try {
                String serial = ProviderLibs.getSerialFromString(cvSysName);
                short sPortID = Short.parseShort(portID);
                short ctrlID = PortandHostGroupInfo.getCtrIDUsingPortID(sPortID, serial);
                hTable.put("CtrID", String.valueOf(ctrlID));
                hTable.put("PortID", portID);
                hTable.put("DomainID", domainID);
            }
            catch (WBEMException we) {
                mLogger.log(Level.SEVERE, "Unable to convert:" + portID, we);
            }
        }
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opAuthorizedPrivilege) {
        String cvInstanceID;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        CIMProperty cpInstanceID = opAuthorizedPrivilege.getKey("InstanceID");
        String string = cvInstanceID = null != cpInstanceID ? (String)cpInstanceID.getValue() : null;
        if (null != cvInstanceID) {
            hTable.put("ElementName", cvInstanceID);
            String[] instIDVals = PortandHostGroupInfo.parseInstanceID(cvInstanceID);
            hTable.put("PortID", instIDVals[2]);
            hTable.put("DomainID", instIDVals[3]);
        }
        return hTable;
    }
}

