/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.AssocInstrumentationInterface;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.ReferenceInterface;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public abstract class BaseAssocInstrumentation
extends BaseInstrumentation
implements AssocInstrumentationInterface,
ReferenceInterface {
    private final BaseInstrumentation mReference1;
    private final BaseInstrumentation mReference2;
    private final String mClassName;
    private final String mReference1PropertyName;
    private final String mReference2PropertyName;
    private final String mReference1ClassName;
    private final String mReference2ClassName;

    protected BaseAssocInstrumentation(String className, String ref1ClassName, String ref1PropertyName, BaseInstrumentation reference1, String ref2ClassName, String ref2PropertyName, BaseInstrumentation reference2) {
        this.mClassName = className;
        this.mReference1 = reference1;
        this.mReference2 = reference2;
        this.mReference1ClassName = ref1ClassName;
        this.mReference2ClassName = ref2ClassName;
        this.mReference1PropertyName = ref1PropertyName;
        this.mReference2PropertyName = ref2PropertyName;
    }

    @Override
    public void AddReference(CustomCloseableIterator<?> iter, CIMObjectPath op, ReferenceInfo refInfo) {
        if (null != refInfo) {
            CIMObjectPath ref1 = refInfo.getReference1();
            CIMObjectPath ref2 = refInfo.getReference2();
            String classname1 = null != ref1 ? ref1.getObjectName() : null;
            String classname2 = null != ref2 ? ref2.getObjectName() : null;
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty(refInfo.getReference1Role(), new CIMDataType(classname1), (Object)ref1, true), new CIMProperty(refInfo.getReference2Role(), new CIMDataType(classname2), (Object)ref2, true)};
            CIMObjectPath retOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.mClassName, keys, op.getXmlSchemaName());
            if (refInfo.isObjectPath()) {
                iter.add(retOP);
            } else {
                CIMProperty<?>[] addProps = this.getAdditionalProperties();
                int newPropsLen = null != addProps ? addProps.length : 0;
                CIMProperty[] props = new CIMProperty[newPropsLen + 2];
                props[0] = keys[0];
                props[1] = keys[1];
                for (int i = 0; i < newPropsLen && null != addProps; ++i) {
                    props[i + 2] = addProps[i];
                }
                CIMInstance ci = new CIMInstance(retOP, props);
                iter.add(ci.filterProperties(refInfo.getPropertyList()));
            }
        }
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        this.assocEnumerate(iter, assocName, objectName, resultClass, role, resultRole, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, true);
    }

    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && this.mClassName.equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.mReference1ClassName) && (null == role || role.equalsIgnoreCase(this.mReference1PropertyName)) && (null == resultRole || resultRole.equalsIgnoreCase(this.mReference2PropertyName))) {
                    if (!shouldTestInst || this.mReference1.instanceExists(objectName)) {
                        Hashtable<String, Object> ref2SearchProps = this.getReference2SearchProperties(objectName);
                        CIMObjectPath opReference2 = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.mReference2ClassName, null);
                        this.mReference2.enumerate(iter, opReference2, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, ref2SearchProps, null);
                        needToCloseIter = false;
                    }
                } else if (!(!objectName.getObjectName().equalsIgnoreCase(this.mReference2ClassName) || null != role && !role.equalsIgnoreCase(this.mReference2PropertyName) || null != resultRole && !resultRole.equalsIgnoreCase(this.mReference1PropertyName) || shouldTestInst && !this.mReference2.instanceExists(objectName))) {
                    Hashtable<String, Object> ref1SearchProps = this.getReference1SearchProperties(objectName);
                    CIMObjectPath opReference1 = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.mReference1ClassName, null);
                    this.mReference1.enumerate(iter, opReference1, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, ref1SearchProps, null);
                    needToCloseIter = false;
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            CustomCloseableIterator iterReference1 = new CustomCloseableIterator();
            CIMObjectPath opReference1 = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.mReference1ClassName, null);
            this.mReference1.enumerate(iterReference1, opReference1, propertyList, filterQueryLanguage, filterQuery, continueOnError, true, null, null);
            CIMObjectPath opReference2 = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.mReference2ClassName, null);
            while (iterReference1.hasNext()) {
                opReference1 = (CIMObjectPath)iterReference1.next();
                Hashtable<String, Object> expValues = this.getReference2SearchProperties(opReference1);
                CustomCloseableIterator iterReference2 = new CustomCloseableIterator();
                this.mReference2.enumerate(iterReference2, opReference2, new String[0], null, null, continueOnError, true, expValues, null);
                while (iterReference2.hasNext()) {
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opReference1, iterReference2.next()));
                        continue;
                    }
                    CIMInstance instAssoc = this.generateInstance(objectName, propertyList, opReference1, iterReference2.next());
                    if (null == instAssoc) continue;
                    iter.add(instAssoc.filterProperties(propertyList));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath objectName, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath opAssoc = this.generateObjectPath(objectName, o);
        CIMProperty key1 = opAssoc.getKey(this.mReference1PropertyName);
        CIMProperty key2 = opAssoc.getKey(this.mReference2PropertyName);
        CIMProperty<?>[] addProps = this.getAdditionalProperties();
        int newPropsLen = null != addProps ? addProps.length : 0;
        CIMProperty[] props = new CIMProperty[newPropsLen + 2];
        props[0] = key1;
        props[1] = key2;
        for (int i = 0; i < newPropsLen && null != addProps; ++i) {
            props[i + 2] = addProps[i];
        }
        return new CIMInstance(opAssoc, props).filterProperties(propertyList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath objectPath, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{CIMObjectPath.class, CIMObjectPath.class}, o, this.mClassName);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty(this.mReference1PropertyName, new CIMDataType(this.mReference1ClassName), (Object)((CIMObjectPath)o[0]), true), new CIMProperty(this.mReference2PropertyName, new CIMDataType(this.mReference2ClassName), (Object)((CIMObjectPath)o[1]), true)};
        return new CIMObjectPath(objectPath.getScheme(), objectPath.getHost(), objectPath.getPort(), objectPath.getNamespace(), this.mClassName, keys, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
    }

    public CIMProperty<?>[] getAdditionalProperties() {
        return new CIMProperty[0];
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block9: {
            try {
                String pnReference1 = this.mReference1PropertyName;
                CIMObjectPath opReference1 = opObjectName.getKey(pnReference1) != null ? (CIMObjectPath)opObjectName.getKey(pnReference1).getValue() : null;
                CIMInstance instReference1 = null;
                try {
                    instReference1 = this.mReference1.getInstance(opReference1, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instReference1) {
                    String pnReference2 = this.mReference2PropertyName;
                    CIMObjectPath opReference2 = opObjectName.getKey(pnReference2) != null ? (CIMObjectPath)opObjectName.getKey(pnReference2).getValue() : null;
                    CIMInstance instReference2 = null;
                    try {
                        instReference2 = this.mReference2.getInstance(opReference2, new String[0]);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instReference2) {
                        opReference1 = instReference1.getObjectPath();
                        opReference2 = instReference2.getObjectPath();
                        CIMInstance instReturn = this.generateInstance(opObjectName, propertyList, instReference1.getObjectPath(), instReference2.getObjectPath());
                        return instReturn.filterProperties(propertyList);
                    }
                    mLogger.finest("Unable to find instance: " + opReference2);
                    break block9;
                }
                mLogger.finest("Unable to find instance: " + opReference1);
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    public String getReference1ClassName() {
        return this.mReference1ClassName;
    }

    public BaseInstrumentation getReference1Instrumentation() {
        return this.mReference1;
    }

    public String getReference1PropertyName() {
        return this.mReference1PropertyName;
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opRef2) {
        return null;
    }

    public String getReference2ClassName() {
        return this.mReference2ClassName;
    }

    public BaseInstrumentation getReference2Instrumentation() {
        return this.mReference2;
    }

    public String getReference2PropertyName() {
        return this.mReference2PropertyName;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        return null;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && this.mClassName.equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.mReference1ClassName) && (null == role || role.equalsIgnoreCase(this.mReference1PropertyName))) {
                    if (this.mReference1.instanceExists(objectName)) {
                        Hashtable<String, Object> ref2SearchProps = this.getReference2SearchProperties(objectName);
                        CIMObjectPath opReference2 = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.mReference2ClassName, null);
                        CIMObjectPath opObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                        ReferenceInfo refInfo = new ReferenceInfo(opObjectName, null, this.mReference1PropertyName, this.mReference2PropertyName, propertyList, isObjectPath, this);
                        this.mReference2.enumerate(iter, opReference2, new String[0], null, null, continueOnError, true, ref2SearchProps, refInfo);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.mReference2ClassName) && (null == role || role.equalsIgnoreCase(this.mReference2PropertyName)) && this.mReference2.instanceExists(objectName)) {
                    Hashtable<String, Object> ref2SearchProps = this.getReference1SearchProperties(objectName);
                    CIMObjectPath opReference2 = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.mReference2ClassName, null);
                    CIMObjectPath opPassedIn = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo refInfo = new ReferenceInfo(null, opPassedIn, this.mReference1PropertyName, this.mReference2PropertyName, propertyList, isObjectPath, this);
                    this.mReference1.enumerate(iter, opReference2, new String[0], null, null, continueOnError, true, ref2SearchProps, refInfo);
                    needToCloseIter = false;
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }
}

